
/*
 * Camel EndpointConfiguration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.box;

import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

/**
 * Camel endpoint configuration for {@link org.apache.camel.component.box.api.BoxCommentsManager}.
 */
@ApiParams(apiName = "comments", producerOnly = true,
           description = "Provides operations to manage Box comments",
           apiMethods = {@ApiMethod(methodName = "addFileComment", description="Add comment to file", signatures={"com.box.sdk.BoxFile addFileComment(String fileId, String message)"}), @ApiMethod(methodName = "changeCommentMessage", description="Change comment message", signatures={"com.box.sdk.BoxComment changeCommentMessage(String commentId, String message)"}), @ApiMethod(methodName = "deleteComment", description="Delete comment", signatures={"void deleteComment(String commentId)"}), @ApiMethod(methodName = "getCommentInfo", description="Get comment information", signatures={"com.box.sdk.BoxComment$Info getCommentInfo(String commentId)"}), @ApiMethod(methodName = "getFileComments", description="Get a list of any comments on this file", signatures={"java.util.List<com.box.sdk.BoxComment$Info> getFileComments(String fileId)"}), @ApiMethod(methodName = "replyToComment", description="Reply to a comment", signatures={"com.box.sdk.BoxComment replyToComment(String commentId, String message)"})}, aliases = {"addFileComment=add", "changeCommentMessage=updateMessage", "deleteComment=delete", "getCommentInfo=info", "getFileComments=comments", "replyToComment=reply"})
@UriParams
@Configurer(extended = true)
public final class BoxCommentsManagerEndpointConfiguration extends BoxConfiguration {
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "changeCommentMessage", description="The id of comment to change"), @ApiMethod(methodName = "deleteComment", description="The id of comment to delete"), @ApiMethod(methodName = "getCommentInfo", description="The id of comment"), @ApiMethod(methodName = "replyToComment", description="The id of comment to reply to")})
    private String commentId;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "addFileComment", description="The id of file"), @ApiMethod(methodName = "getFileComments", description="The id of file")})
    private String fileId;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "addFileComment", description="The comment's message"), @ApiMethod(methodName = "changeCommentMessage", description="The new message for the comment"), @ApiMethod(methodName = "replyToComment", description="The message for the reply")})
    private String message;

    public String getCommentId() {
        return commentId;
    }

    public void setCommentId(String commentId) {
        this.commentId = commentId;
    }

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
