#include <syscall.h>
#include <signal.h>
#include <errno.h>

extern void ___sig_restore(void);
extern void ___masksig_restore(void);

#ifdef PTHREAD_KERNEL

#pragma weak machdep_sys_sigaction = __machdep_sys_sigaction

int __sigaction  (int, struct sigaction *, struct sigaction *);
int __machdep_sys_sigaction(int, struct sigaction *, struct sigaction *);

int
__machdep_sys_sigaction(int sig,struct sigaction * new, struct sigaction * old)
{
	if (new) {
		if (new->sa_flags & SA_NOMASK)
			new->sa_restorer=___sig_restore;
		else
			new->sa_restorer=___masksig_restore;
	}

#if defined(__PIC__) || defined (__pic__)
	__asm__ volatile ("pushl %%ebx\n\t"
			  "movl %%edi,%%ebx\n\t"
			  "int $0x80\n\t"
			  "popl %%ebx"
		:"=a" (sig)
		:"0" (SYS_sigaction),"D" (sig),"c" (new),"d" (old));
#else
	__asm__("int $0x80":"=a" (sig)
		:"0" (SYS_sigaction),"b" (sig),"c" (new),"d" (old));
#endif
	return sig;
}

#else /* PTHREAD_KERNEL */

#ifdef _POSIX_THREADS
#pragma weak __sigaction
#endif

int
__sigaction(int sig,struct sigaction * new, struct sigaction * old)
{
	if (new) {
		if (new->sa_flags & SA_NOMASK)
			new->sa_restorer=___sig_restore;
		else
			new->sa_restorer=___masksig_restore;
	}

#if defined(__PIC__) || defined (__pic__)
	__asm__ volatile ("pushl %%ebx\n\t"
			  "movl %%edi,%%ebx\n\t"
			  "int $0x80\n\t"
			  "popl %%ebx"
		:"=a" (sig)
		:"0" (SYS_sigaction),"D" (sig),"c" (new),"d" (old));
#else
	__asm__("int $0x80":"=a" (sig)
		:"0" (SYS_sigaction),"b" (sig),"c" (new),"d" (old));
#endif
	if (sig>=0)
		return 0;
	errno = -sig;
	return -1;
}

#include <gnu-stabs.h>
#ifdef weak_alias
weak_alias (__sigaction, sigaction);
#endif

#endif /* PTHREAD_KERNEL */
