#ifndef _MULTILINEEDIT_H_
#define _MULTILINEEDIT_H_

#include "qmlined.h"
#include "Baseobject.h"

class MultiLineEdit : public QMultiLineEdit, BaseObject
{
  Q_OBJECT
  
  public:

    MultiLineEdit(QWidget *parent=0, const char *name=0) : QMultiLineEdit(parent,name), BaseObject() {
      connect(this, SIGNAL(returnPressed()), this, SLOT(sigReturnPressed()));
      connect(this, SIGNAL(textChanged()), this, SLOT(sigTextChanged()));
    };
    ~MultiLineEdit() {};

  protected slots:

    void sigReturnPressed() {
      _emit("pressed", 0);
    };
    
    void sigTextChanged() {
      _emit("changed", 0);
    };
    
  
};


#endif
