#ifndef _LISTBOX_H_
#define _LISTBOX_H_

#include <Python.h>
#include <qlistbox.h>
#include "Baseobject.h"

class ListBox : public QListBox, public BaseObject
{
  Q_OBJECT
  
public:

  ListBox(QWidget *parent=0, const char *name=0, WFlags f=0) 
    : QListBox(parent,name,f), BaseObject() 
  {
    connect(this,SIGNAL(highlighted(int)),this,SLOT(sigHighlighted(int)));
    connect(this,SIGNAL(selected(int)),this,SLOT(sigSelected(int)));
    connect(this,SIGNAL(selectionChanged()),this,SLOT(sigSelectionChanged()));
  };

  ~ListBox() {};

protected slots:

    void sigSelectionChanged() {
      _emit("selectionChanged",0);
    };
    
    void sigHighlighted(int index) {
       PyObject *arg = Py_BuildValue("(i)",index);
       _emit("highlighted", arg);  
       Py_DECREF(arg);
    };
  
    void sigSelected(int index) {
       PyObject *arg = Py_BuildValue("(i)",index);
       _emit("selected", arg);  
       Py_DECREF(arg);
    };
  
};


#endif