%module Lineedit


%{
#include "Object.h"
#include "Lineedit.h"
%}


%include Types.i
%include Constants.i
%import Object.i
%import Widget.i


class LineEdit : public QWidget
{
public:
    LineEdit(QWidget *parent=0, const char *name=0 );
   ~LineEdit();

    const char *text() const;
    int		maxLength()	const;
    void	setMaxLength( int );

    void	setFrame( bool );
    bool	frame() const;

    enum	EchoMode { Normal, NoEcho, Password };
    void	setEchoMode( EchoMode );
    EchoMode 	echoMode() const;

    void	setText( const char * );
    void	selectAll();
    void	deselect();

/*
signals:
    void	textChanged( const char * );
    void	returnPressed();
*/

};

