import libqtpythonc
from baseobject import *


class RegionPtr(BaseObjectPtr):

    Rectangle = libqtpythonc.QRegion_Rectangle
    Ellipse = libqtpythonc.QRegion_Ellipse

    def __init__(self,this,name=""):
        BaseObjectPtr.__init__(self,name)
        self.this = this
        self.thisown = 0

    def __del__(self):
        if self.thisown == 1 :
            libqtpythonc.delete_QRegion(self.this)

    def isNull(self):
        val = libqtpythonc.QRegion_isNull(self.this)
        return val

    def isEmpty(self):
        val = libqtpythonc.QRegion_isEmpty(self.this)
        return val

    def contains(self,arg0):
        val = libqtpythonc.QRegion_contains(self.this,arg0)
        return val

    def containsRect(self,arg0):
        val = libqtpythonc.QRegion_containsRect(self.this,arg0)
        return val

    def translate(self,arg0,arg1):
        val = libqtpythonc.QRegion_translate(self.this,arg0,arg1)
        return val

    def unite(self,arg0):
        val = libqtpythonc.QRegion_unite(self.this,arg0.this)
        val = QRegionPtr(val)
        val.thisown = 1
        return val

    def intersect(self,arg0):
        val = libqtpythonc.QRegion_intersect(self.this,arg0.this)
        val = QRegionPtr(val)
        val.thisown = 1
        return val

    def subtract(self,arg0):
        val = libqtpythonc.QRegion_subtract(self.this,arg0.this)
        val = QRegionPtr(val)
        val.thisown = 1
        return val

    def eor(self,arg0):
        val = libqtpythonc.QRegion_eor(self.this,arg0.this)
        val = QRegionPtr(val)
        val.thisown = 1
        return val

    def __repr__(self):
        return "<Region instance at %s>" % self.this

class Region(RegionPtr):
    def __init__(self,name="") :
        RegionPtr.__init__(self,"NULL",name)
        self.this = libqtpythonc.new_QRegion()
        self.thisown = 1



def RegionRect(rect,type=RegionPtr.Rectangle,name="") :
    val = RegionPtr(libqtpythonc.new_QRegionRect(rect,type),name)
    val.thisown = 1
    return val

def RegionPoints(points,winding=1) :
    val = RegionPtr(libqtpythonc.new_QRegionPoints(points,winding),name)
    val.thisown = 1
    return val

def RegionCopy(arg0,name="") :
    val = RegionPtr(libqtpythonc.new_QRegionCopy(arg0.this),name)
    val.thisown = 1
    return val

