from object import *
from color import *
from paintdevice import *
import libqtpythonc


class PixmapPtr(PaintDevicePtr):
  
    cmAuto = 0
    cmColor = 1
    cmMono = 2

    def __init__(self,this,name=""):
	PaintDevicePtr.__init__(self,this,name)
        self.this = this
        self.thisown = 0

    def __del__(self):
        if self.thisown == 1 :
            libqtpythonc.delete_QPixmap(self.this)

    def isNull(self):
        return libqtpythonc.QPixmap_isNull(self.this)

    def width(self):
        return libqtpythonc.QPixmap_width(self.this)

    def height(self):
        return libqtpythonc.QPixmap_height(self.this)

    def size(self):
        return libqtpythonc.QPixmap_size(self.this)

    def rect(self):
        return libqtpythonc.QPixmap_rect(self.this)
      
    def depth(self):
        return libqtpythonc.QPixmap_depth(self.this)

    def fill(self,color=white):
        libqtpythonc.QPixmap_fill(self.this,color.this)

    def fillWidget(self,widget,size):
        libqtpythonc.QPixmap_fillWidget(self.this,widget.this,size)

    def resize(self,size):
        libqtpythonc.QPixmap_resize(self.this,size)

    def mask(self):
        return libqtpythonc.QPixmap_mask(self.this)

    def setMask(self,mask):
        libqtpythonc.QPixmap_setMask(self.this,mask)

    def selfMask(self):
        return libqtpythonc.QPixmap_selfMask(self.this)

    def createHeuristicMask(self,clipTight=1):
        return libqtpythonc.QPixmap_createHeuristicMask(self.this,clipTight)

    def xForm(self,matrix):
        val = PixmapPtr(libqtpythonc.QPixmap_xForm(self.this,matrix))
        val.thisown = 1
        return val

    def convertToImage(self):
        return libqtpythonc.QPixmap_convertToImage(self.this)

    def convertFromImageAuto(self,image,colormode):
        return apply(libqtpythonc.QPixmap_convertFromImageAuto(self.this,image,colormode))

    def convertFromImage(self,image,floags):
        return libqtpythonc.QPixmap_convertFromImage(self.this,image,flags)

    def load(self,filename,format="",mode=0):
        return libqtpythonc.QPixmap_load(self.this,filename,format,mode)

    def loadConversion(self,filename,format,flags):
        return libqtpythonc.QPixmap_loadConversion(self.this,filename,format,flags)

    def loadFromData(self,buf,len,format="",mode=0):
        return libqtpythonc.QPixmap_loadFromData(self.this,buf,len,format,mode)

    def loadFromDataConversion(self,arg0,arg1,arg2,arg3):
        val = libqtpythonc.QPixmap_loadFromDataConversion(self.this,arg0,arg1,arg2,arg3)
        return val

    def save(self,filename,format):
        return libqtpythonc.QPixmap_save(self.this,filename,format)

    def serialNumber(self):
        return libqtpythonc.QPixmap_serialNumber(self.this)

    def isOptimized(self):
        return libqtpythonc.QPixmap_isOptimized(self.this)

    def optimize(self,flag):
        libqtpythonc.QPixmap_optimize(self.this,flag)

    def detach(self):
        libqtpythonc.QPixmap_detach(self.this)

    def isQBitmap(self):
        return libqtpythonc.QPixmap_isQBitmap(self.this)

    def __repr__(self):
        return "<Pixmap instance at %s>" % self.this


class Pixmap(PixmapPtr):
    def __init__(self,size,depth=-1,name="") :
        PixmapPtr.__init__(self,"NULL",name)
        self.this = libqtpythonc.new_QPixmap(size,depth)
        self.thisown = 1

def PixmapFile(filename,format="",mode=0,name=""):
    val = PixmapPtr(libqtpythonc.new_QPixmapFile(filename,format,mode),name)
    val.thisown = 1
    return val


def PixmapFileConvert(filename,format,flags,name=""):
    val = PixmapPtr(libqtpythonc.new_QPixmapFileConvert(filename,format,flags),name)
    val.thisown = 1
    return val


def PixmapCopy(pixmap,name=""):
    val = PixmapPtr(libqtpythonc.new_QPixmapCopy(pixmap.this),name)
    val.thisown = 1
    return val

