import libqtpythonc
from baseobject import *


class FontPtr(BaseObject) :

    Helvetica = libqtpythonc.QFont_Helvetica
    Times = libqtpythonc.QFont_Times
    Courier = libqtpythonc.QFont_Courier
    OldEnglish = libqtpythonc.QFont_OldEnglish
    System = libqtpythonc.QFont_System

    AnyStyle = libqtpythonc.QFont_AnyStyle
    SansSerif = libqtpythonc.QFont_SansSerif
    Serif = libqtpythonc.QFont_Serif
    TypeWriter = libqtpythonc.QFont_TypeWriter
    Decorative = libqtpythonc.QFont_Decorative

    Light = libqtpythonc.QFont_Light
    Normal = libqtpythonc.QFont_Normal
    DemiBold = libqtpythonc.QFont_DemiBold
    Bold = libqtpythonc.QFont_Bold
    Black = libqtpythonc.QFont_Black

    Latin1 = libqtpythonc.QFont_Latin1
    ISO_8859_1 = libqtpythonc.QFont_ISO_8859_1
    AnyCharSet = libqtpythonc.QFont_AnyCharSet
    Latin2 = libqtpythonc.QFont_Latin2
    ISO_8859_2 = libqtpythonc.QFont_ISO_8859_2
    Latin3 = libqtpythonc.QFont_Latin3
    ISO_8859_3 = libqtpythonc.QFont_ISO_8859_3
    Latin4 = libqtpythonc.QFont_Latin4
    ISO_8859_4 = libqtpythonc.QFont_ISO_8859_4
    Latin5 = libqtpythonc.QFont_Latin5
    ISO_8859_5 = libqtpythonc.QFont_ISO_8859_5
    Latin6 = libqtpythonc.QFont_Latin6
    ISO_8859_6 = libqtpythonc.QFont_ISO_8859_6
    Latin7 = libqtpythonc.QFont_Latin7
    ISO_8859_7 = libqtpythonc.QFont_ISO_8859_7
    Latin8 = libqtpythonc.QFont_Latin8
    ISO_8859_8 = libqtpythonc.QFont_ISO_8859_8
    Latin9 = libqtpythonc.QFont_Latin9
    ISO_8859_9 = libqtpythonc.QFont_ISO_8859_9

    def __init__(self,this,name=""):
        BaseObjectPtr.__init__(self,name)
        self.this = this
        self.thisown = 0

    def __del__(self):
        if self.thisown == 1 :
            libqtpythonc.delete_QFont(self.this)

    def family(self):
        return libqtpythonc.QFont_family(self.this)

    def setFamily(self,arg0):
        libqtpythonc.QFont_setFamily(self.this,arg0)

    def pointSize(self):
        return libqtpythonc.QFont_pointSize(self.this)

    def setPointSize(self,arg0):
        libqtpythonc.QFont_setPointSize(self.this,arg0)

    def weight(self):
        return libqtpythonc.QFont_weight(self.this)

    def setWeight(self,arg0):
        libqtpythonc.QFont_setWeight(self.this,arg0)

    def bold(self):
        return libqtpythonc.QFont_bold(self.this)

    def setBold(self,arg0):
        libqtpythonc.QFont_setBold(self.this,arg0)

    def italic(self):
        return libqtpythonc.QFont_italic(self.this)

    def setItalic(self,arg0):
        libqtpythonc.QFont_setItalic(self.this,arg0)

    def underline(self):
        return libqtpythonc.QFont_underline(self.this)

    def setUnderline(self,arg0):
        libqtpythonc.QFont_setUnderline(self.this,arg0)

    def strikeOut(self):
        return libqtpythonc.QFont_strikeOut(self.this)

    def setStrikeOut(self,arg0):
        libqtpythonc.QFont_setStrikeOut(self.this,arg0)

    def fixedPitch(self):
        return libqtpythonc.QFont_fixedPitch(self.this)

    def setFixedPitch(self,arg0):
        libqtpythonc.QFont_setFixedPitch(self.this,arg0)

    def styleHint(self):
        return libqtpythonc.QFont_styleHint(self.this)

    def setStyleHint(self,arg0):
        libqtpythonc.QFont_setStyleHint(self.this,arg0)

    def charSet(self):
        return libqtpythonc.QFont_charSet(self.this)

    def setCharSet(self,arg0):
        libqtpythonc.QFont_setCharSet(self.this,arg0)

    def rawMode(self):
        return libqtpythonc.QFont_rawMode(self.this)

    def setRawMode(self,arg0):
        libqtpythonc.QFont_setRawMode(self.this,arg0)

    def exactMatch(self):
        return libqtpythonc.QFont_exactMatch(self.this)

    def key(self):
        return libqtpythonc.QFont_key(self.this)

    def __repr__(self):
        return "<Font instance at %s>" % self.this


class Font(FontPtr):
    def __init__(self,family,pointSize=12,weight=FontPtr.Normal,italic=0,name="") :
        FontPtr.__init__(self,"NULL",name)
        self.this = libqtpythonc.new_QFont(family,pointSize,weight,italic)
        self.thisown = 1

def FontCharset(familiy,pointSize,weight,italic,charset,name="") :
    val = FontPtr(libqtpythonc.new_QFontCharset(familiy,pointSize,weight,italic,charset),name)
    val.thisown = 1
    return val

def FontCopy(font,name=""):
    val = FontPtr(libqtpythonc.new_QFontCopy(font.this),name)
    val.thisown = 1
    return val



def Font_defaultFont():
    val = FontPtr(libqtpythonc.QFont_defaultFont())
    val.thisown = 0
    return val

def Font_setDefaultFont(font):
    libqtpythonc.QFont_setDefaultFont(font.this)



Font_substitute = libqtpythonc.QFont_substitute

Font_insertSubstitution = libqtpythonc.QFont_insertSubstitution

Font_removeSubstitution = libqtpythonc.QFont_removeSubstitution

Font_listSubstitutions = libqtpythonc.QFont_listSubstitutions

Font_initialize = libqtpythonc.QFont_initialize

Font_cleanup = libqtpythonc.QFont_cleanup

Font_cacheStatistics = libqtpythonc.QFont_cacheStatistics

