#ifndef _KTOOLBAR_H_
#define _KTOOLBAR_H_

#include <Python.h>
#include <ktoolbar.h>
#include <qlist.h>
#include <qintdict.h>

#include "Baseobject.h"
#include "KCombobox.h"


class _ToolBarButton : public KToolBarButton, public BaseObject
{
  Q_OBJECT
  
public:
   _ToolBarButton(const QPixmap& pixmap, int id, QWidget *parent,
                  const char *name=0L, int item_size = 26, const char *txt=0) 
     : KToolBarButton(pixmap,id,parent,name,item_size,txt) {
      connect(this, SIGNAL(pressed(int)), this, SLOT(sigPressed(int)));
      connect(this, SIGNAL(released(int)), this, SLOT(sigReleased(int)));
      connect(this, SIGNAL(clicked(int)), this, SLOT(sigClicked(int)));
      connect(this, SIGNAL(toggled(int)), this, SLOT(sigToggled(int)));
   };
   _ToolBarButton(QWidget *parent=0L, const char *name=0L) : KToolBarButton(parent,name) {
      connect(this, SIGNAL(pressed(int)), this, SLOT(sigPressed(int)));
      connect(this, SIGNAL(released(int)), this, SLOT(sigReleased(int)));
      connect(this, SIGNAL(clicked(int)), this, SLOT(sigClicked(int)));
      connect(this, SIGNAL(toggled(int)), this, SLOT(sigToggled(int)));
   };
   ~_ToolBarButton() {};

protected slots:

    void sigPressed(int id) {
       PyObject *arg = Py_BuildValue("(i)",id);
       _emit("pressed", arg);  
       Py_DECREF(arg);
    };
    
    void sigReleased(int id) {
       PyObject *arg = Py_BuildValue("(i)",id);
       _emit("released", arg);  
       Py_DECREF(arg);
    };
    
    void sigClicked(int id) {
       PyObject *arg = Py_BuildValue("(i)",id);
       _emit("clicked", arg);  
       Py_DECREF(arg);
    };
    
    void sigToggled(int id) {
       PyObject *arg = Py_BuildValue("(i)",id);
       _emit("toggled", arg);  
       Py_DECREF(arg);
    };
};


class _ToolBar : public KToolBar, public BaseObject
{
  Q_OBJECT

public:

  _ToolBar(QWidget *parent=0L, const char *name=0L, int _item_size = 26) 
    : KToolBar(parent,name,_item_size), BaseObject() {};
  virtual ~_ToolBar() {};

  void addConnection (int id, const char *signal, PyObject *slot);

protected slots:

    void sigPressed(int id);
    void sigReleased(int id);
    void sigClicked(int id);
    void sigToggled(int id);
        
    void sigMoved(BarPosition pos) {
       PyObject *arg = Py_BuildValue("(i)",pos);
       _emit("moved", arg);  
       Py_DECREF(arg);
    };

public: 

  int addButton(const QPixmap& pixmap, int ID, 
			  const char *signal, PyObject *slot, 
			  bool enabled=true, const char *ToolTopText=0,int index=-1);

  int addLined(const char *text, int ID,
                   const char *signal, PyObject *slot,
                   bool enabled = true,
                   const char *toolTipText = 0L, int size = 70, int index =-1);

  int addComboList(QStrList *list, int id, bool writable,
                   const char *signal, PyObject *slot,
                   bool enabled=true,
                   const char *tooltiptext=0L,
                   int size=70, int index=-1,
                   _ComboBox::Policy policy = _ComboBox::AtBottom);

  int addComboText(const char *text, int id, bool writable,
                   const char *signal, PyObject *slot,
                   bool enabled=true,
                   const char *tooltiptext=0L,
                   int size=70, int index=-1,
                   _ComboBox::Policy policy = _ComboBox::AtBottom);

};


#endif