#ifndef _KCOLORDIALOG_H_
#define _KCOLORDIALOG_H_

#include <Python.h>
#include <kcolordlg.h>
#include "Baseobject.h"


extern "C" void SWIG_MakePtr(char *, void *, char *);


class _ColorDialog : public KColorDialog, public BaseObject
{
  Q_OBJECT
public:

  _ColorDialog(QWidget *parent=0, const char *name=0L, bool modal=FALSE) : KColorDialog(parent,name,modal) {
    connect(this, SIGNAL(colorSelected(const QColor&)), this, SLOT(sigColorSelected(const QColor&)));
  };
  ~_ColorDialog() {};

protected slots:

    void sigColorSelected(const QColor &newColor ){
       char temp[128];
       SWIG_MakePtr(temp, (char *) &newColor, "_Color_p");
       PyObject *arg = Py_BuildValue("s",temp);
       _emit("colorSelected", arg);  
       Py_DECREF(arg);
    };
};

#endif