%module Url

%{
#include <kurl.h>
#include "Baseobject.h"
#include "Object.h"
%}

%include Types.i
%include Constants.i

class KURL : public BaseObject
{ 
public:
    KURL();
%name(KURLInit)    KURL( const char* _url);
%name(KURLProtocol)    KURL( const char* _protocol, const char* _host, 
	  const char* _path, const char* _ref);
%name(KURLBase)    KURL( KURL & _base_url, const char* _rel_url );
    ~KURL();
    
    bool isMalformed();

    static void encodeURL( QString& url );
    static void decodeURL( QString& url );
    
    QString url() const;

    const char* protocol() const;
    
    const char* host() const;
    const char* path() const;

    bool hasPath();
    const char* reference() const;
    
    const char* user();
    const char* passwd();
    
    unsigned int port() const;
    const char * directory( bool _trailing = TRUE );
    const char * directoryURL( bool _trailing = TRUE );
    
    bool hasSubProtocol();

    QString parentURL();
    QString childURL();
    QString nestedURL();

    void parse( const char *_url );
    
    void setProtocol( const char* newProto) ;
    void setPassword( const char *password );

    bool setReference( const char* _ref);

    bool cd( const char* _dir, bool zapRef = true);
    bool cdUp( bool zapRef = true);
    const char *filename();
    
    bool isLocalFile();
};
