%module Pixmap

%{
#include <kpixmap.h>
%}

%include Types.i
%include Constants.i

%import Object.i


class KPixmap : public QPixmap
{
public:
	enum ColorMode { Auto, Color, Mono, LowColor, WebColor };

	KPixmap() {};
	~KPixmap() {};
    
	void gradientFill( QColor ca, QColor cb, bool upDown = TRUE, int ncols = 3 );
	void patternFill( QColor ca, QColor cb, uint pattern[8] );

	bool convertFromImage( const QImage &img, int conversion_flags );
%name(convertFromImageMode)	bool convertFromImage( const QImage &img, ColorMode mode = WebColor );
	
	bool load( const char *fileName, const char *format, int conversion_flags );
%name(loadMode)	bool load( const char *fileName, const char *format = 0,
		ColorMode mode = WebColor );

	bool checkColorTable(const QImage &image);	
};
