/* GAIL - The GNOME Accessibility Implementation Library
 * Copyright 2001 Sun Microsystems Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtkscrolledwindow.h>
#include <gtk/gtkaccessible.h>
#include "gailscrolledwindowfactory.h"
#include "gailscrolledwindow.h"

static void gail_scrolled_window_factory_class_init (GailScrolledWindowFactoryClass       *klass);

static AtkObject* gail_scrolled_window_factory_create_accessible (
                               GObject                              *obj);

static GType gail_scrolled_window_factory_get_accessible_type (void);

GType
gail_scrolled_window_factory_get_type ()
{
  static GType type = 0;

  if (!type) 
  {
    static const GTypeInfo tinfo =
    {
      sizeof (GailScrolledWindowFactoryClass),
      (GBaseInitFunc) NULL, /* base init */
      (GBaseFinalizeFunc) NULL, /* base finalize */
      (GClassInitFunc) gail_scrolled_window_factory_class_init, /* class init */
      (GClassFinalizeFunc) NULL, /* class finalize */
      NULL, /* class data */
      sizeof (GailScrolledWindowFactory), /* instance size */
      0, /* nb preallocs */
      (GInstanceInitFunc) NULL, /* instance init */
      NULL /* value entry */
    };
    type = g_type_register_static (ATK_TYPE_OBJECT_FACTORY, 
                           "GailScrolledWindowFactory" , &tinfo, 0);
  }

  return type;
}

static void 
gail_scrolled_window_factory_class_init (GailScrolledWindowFactoryClass *klass)
{
  AtkObjectFactoryClass *class = ATK_OBJECT_FACTORY_CLASS (klass);

  class->create_accessible = gail_scrolled_window_factory_create_accessible;
  class->get_accessible_type = gail_scrolled_window_factory_get_accessible_type;
}

AtkObjectFactory*
gail_scrolled_window_factory_new ()
{
  GObject *factory;

  factory = g_object_new (GAIL_TYPE_SCROLLED_WINDOW_FACTORY, NULL);

  return ATK_OBJECT_FACTORY (factory);
} 

static AtkObject* 
gail_scrolled_window_factory_create_accessible (GObject     *obj)
{
  GtkWidget     *widget;

  g_return_val_if_fail (GTK_IS_WIDGET (obj), NULL);

  widget = GTK_WIDGET (obj);

  return gail_scrolled_window_new (widget);
}

static GType
gail_scrolled_window_factory_get_accessible_type (void)
{
  return GAIL_TYPE_SCROLLED_WINDOW;
}
