---
title: 0.288.0 Breaking Changes
slug: breaking-changes/0.288.0
---

# v0.288.0 Breaking Changes

This release deprecates passing a class (or type) to `strawberry.scalar()`. Use
`scalar_map` in `StrawberryConfig` instead.

## Deprecated: `strawberry.scalar(cls, ...)`

The pattern of wrapping a type with `strawberry.scalar()` is deprecated:

```python
# Deprecated
Base64 = strawberry.scalar(
    NewType("Base64", bytes),
    serialize=lambda v: base64.b64encode(v).decode(),
    parse_value=lambda v: base64.b64decode(v),
)
```

Instead, use `scalar_map` in `StrawberryConfig`:

```python
# Recommended
from typing import NewType
from strawberry.schema.config import StrawberryConfig

Base64 = NewType("Base64", bytes)

schema = strawberry.Schema(
    query=Query,
    config=StrawberryConfig(
        scalar_map={
            Base64: strawberry.scalar(
                name="Base64",
                serialize=lambda v: base64.b64encode(v).decode(),
                parse_value=lambda v: base64.b64decode(v),
            )
        }
    ),
)
```

This approach provides better type checking support because your custom scalar
stays a proper type that type checkers (mypy, pyright, ty) can understand. The
previous pattern of wrapping types with `strawberry.scalar()` returned a
`ScalarWrapper` object, which type checkers could not use as a valid type
annotation, causing errors like "Variable not allowed in type expression".

## Removed: Scalar wrapper exports

The scalar wrapper exports (`Date`, `DateTime`, `Time`, `Decimal`, `UUID`,
`Void`) from `strawberry.schema.types.base_scalars` have been removed. Use
standard Python types directly instead (`datetime.date`, `datetime.datetime`,
etc.).

A codemod is available: `strawberry upgrade replace-scalar-wrappers .`
