---
layout: post
title: Polyglot 1.12 - Weiterleitungsverbesserungen und Community-Beiträge
lang: de
description: Jekyll Polyglot 1.12.0 bringt verbesserte Weiterleitungsunterstützung für Untersprachen, Fallback-Seitenerkennung und neue Website-Sprachunterstützung
---

Jekyll-Polyglot `1.12.0` wurde veröffentlicht! Diese Version konzentriert sich auf die Verbesserung der Weiterleitungsbehandlung und enthält mehrere Community-Beiträge.

## Weiterleitungsverbesserungen

Diese Version enthält wichtige Verbesserungen bei der Funktionsweise von Weiterleitungen mit Polyglot:

- **PR #275**: Anker-Tag-Erhaltung bei Weiterleitungen - dank einer Lösung von [@GruberMarkus](https://github.com/GruberMarkus) erhalten Weiterleitungs-URLs jetzt korrekt Anker-Tags, sodass Benutzer genau dort landen, wo sie hinwollten.

- **PR #293**: Untersprachen-Weiterleitungsunterstützung für das jekyll-redirect-from Plugin - vorgeschlagen von [@rathboma](https://github.com/rathboma), begrenzt Polyglot jetzt korrekt `redirect_from` Frontmatter über Untersprachen hinweg, verhindert doppelte Weiterleitungen und stellt korrektes Routing für Nicht-Standard-Sprachseiten sicher.

## Fallback-Seiten mit page.rendered_lang erkennen

- **PR #283**: Neue `page.rendered_lang` Variable - beigetragen von [@rathboma](https://github.com/rathboma), ermöglicht diese neue Liquid-Variable zu erkennen, wenn eine Seite als Fallback gerendert wird. Wenn `page.rendered_lang != site.active_lang`, wissen Sie, dass der Seiteninhalt noch nicht übersetzt wurde.

Die [/about](/about) Seite wurde mit Anweisungen aktualisiert, wie diese `page.rendered_lang` Komfort-Liquid-Variable am besten verwendet wird.

## neue Sprachunterstützung

- **PR #280**: Italienische und türkische Sprachunterstützung wurde zur Polyglot-Dokumentationsseite hinzugefügt und erweitert unsere mehrsprachige Reichweite.

## Community-Beiträge

Mehrere Community-Mitglieder haben Verbesserungen zum Projekt beigetragen:

- **PR #277**: Aktualisierte Seitenleisten-Rich-Text-Definitionen, die die mehrsprachige Präsentation der Website verbessern.

- **PR #288**: Japanische Rich-Text-Strings beigetragen von [@manabu-nakamura](https://github.com/manabu-nakamura), die das japanische Spracherlebnis verbessern.

Ein besonderer Dank geht an [@PanderMusubi](https://github.com/PanderMusubi) für die [jekyll-minimal-mistakes-polyglot](https://github.com/PanderMusubi/jekyll-minimal-mistakes-polyglot) Demo, die zeigt, wie Polyglot mit dem beliebten Minimal Mistakes Theme integriert werden kann.

Vielen Dank an alle Mitwirkenden, die diese Version möglich gemacht haben!
