# frozen_string_literal: true

module Gitlab
  module BackgroundMigration
    # Change the vulnerability state to `dismissed` if `dismissed_at` field is not null
    class SetCorrectVulnerabilityState < BatchedMigrationJob
      DISMISSED_STATE = 2

      scope_to ->(relation) { relation.where.not(dismissed_at: nil) }
      operation_name :update_vulnerabilities_state
      feature_category :database

      def perform
        each_sub_batch do |sub_batch|
          sub_batch.update_all(state: DISMISSED_STATE)
        end
      end
    end
  end
end
