/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include "stamp-pdbgen.h"

#include <cairo.h>

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpbase/gimpbase.h"
#include "libgimpcolor/gimpcolor.h"

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimpchannel-select.h"
#include "core/gimpdrawable.h"
#include "core/gimpimage.h"
#include "core/gimpitem.h"
#include "core/gimpparamspecs.h"

#include "gimppdb.h"
#include "gimppdb-utils.h"
#include "gimppdbcontext.h"
#include "gimpprocedure.h"
#include "internal-procs.h"

#include "gimp-intl.h"


static GimpValueArray *
image_select_color_invoker (GimpProcedure         *procedure,
                            Gimp                  *gimp,
                            GimpContext           *context,
                            GimpProgress          *progress,
                            const GimpValueArray  *args,
                            GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint operation;
  GimpDrawable *drawable;
  GeglColor *color;

  image = g_value_get_object (gimp_value_array_index (args, 0));
  operation = g_value_get_enum (gimp_value_array_index (args, 1));
  drawable = g_value_get_object (gimp_value_array_index (args, 2));
  color = g_value_get_object (gimp_value_array_index (args, 3));

  if (success)
    {
      GimpPDBContext *pdb_context = GIMP_PDB_CONTEXT (context);

      if (pdb_context->sample_merged ||
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), image, 0, error))
        {
          GList *drawables = g_list_prepend (NULL, drawable);
          gimp_channel_select_by_color (gimp_image_get_mask (image), drawables,
                                        pdb_context->sample_merged,
                                        color,
                                        pdb_context->sample_threshold,
                                        pdb_context->sample_transparent,
                                        pdb_context->sample_criterion,
                                        operation,
                                        pdb_context->antialias,
                                        pdb_context->feather,
                                        pdb_context->feather_radius_x,
                                        pdb_context->feather_radius_y);
          g_list_free (drawables);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_select_contiguous_color_invoker (GimpProcedure         *procedure,
                                       Gimp                  *gimp,
                                       GimpContext           *context,
                                       GimpProgress          *progress,
                                       const GimpValueArray  *args,
                                       GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint operation;
  GimpDrawable *drawable;
  gdouble x;
  gdouble y;

  image = g_value_get_object (gimp_value_array_index (args, 0));
  operation = g_value_get_enum (gimp_value_array_index (args, 1));
  drawable = g_value_get_object (gimp_value_array_index (args, 2));
  x = g_value_get_double (gimp_value_array_index (args, 3));
  y = g_value_get_double (gimp_value_array_index (args, 4));

  if (success)
    {
      GimpPDBContext *pdb_context = GIMP_PDB_CONTEXT (context);

      if (pdb_context->sample_merged ||
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), image, 0, error))
        {

          gimp_channel_select_fuzzy (gimp_image_get_mask (image),
                                     drawable,
                                     pdb_context->sample_merged,
                                     x, y,
                                     pdb_context->sample_threshold,
                                     pdb_context->sample_transparent,
                                     pdb_context->sample_criterion,
                                     pdb_context->diagonal_neighbors,
                                     operation,
                                     pdb_context->antialias,
                                     pdb_context->feather,
                                     pdb_context->feather_radius_x,
                                     pdb_context->feather_radius_y);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_select_rectangle_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint operation;
  gdouble x;
  gdouble y;
  gdouble width;
  gdouble height;

  image = g_value_get_object (gimp_value_array_index (args, 0));
  operation = g_value_get_enum (gimp_value_array_index (args, 1));
  x = g_value_get_double (gimp_value_array_index (args, 2));
  y = g_value_get_double (gimp_value_array_index (args, 3));
  width = g_value_get_double (gimp_value_array_index (args, 4));
  height = g_value_get_double (gimp_value_array_index (args, 5));

  if (success)
    {
      GimpPDBContext *pdb_context = GIMP_PDB_CONTEXT (context);

      gimp_channel_select_rectangle (gimp_image_get_mask (image),
                                     (gint) x, (gint) y,
                                     (gint) width, (gint) height,
                                     operation,
                                     pdb_context->feather,
                                     pdb_context->feather_radius_x,
                                     pdb_context->feather_radius_y,
                                     TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_select_round_rectangle_invoker (GimpProcedure         *procedure,
                                      Gimp                  *gimp,
                                      GimpContext           *context,
                                      GimpProgress          *progress,
                                      const GimpValueArray  *args,
                                      GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint operation;
  gdouble x;
  gdouble y;
  gdouble width;
  gdouble height;
  gdouble corner_radius_x;
  gdouble corner_radius_y;

  image = g_value_get_object (gimp_value_array_index (args, 0));
  operation = g_value_get_enum (gimp_value_array_index (args, 1));
  x = g_value_get_double (gimp_value_array_index (args, 2));
  y = g_value_get_double (gimp_value_array_index (args, 3));
  width = g_value_get_double (gimp_value_array_index (args, 4));
  height = g_value_get_double (gimp_value_array_index (args, 5));
  corner_radius_x = g_value_get_double (gimp_value_array_index (args, 6));
  corner_radius_y = g_value_get_double (gimp_value_array_index (args, 7));

  if (success)
    {
      GimpPDBContext *pdb_context = GIMP_PDB_CONTEXT (context);

      gimp_channel_select_round_rect (gimp_image_get_mask (image),
                                      (gint) x, (gint) y,
                                      (gint) width, (gint) height,
                                      corner_radius_x,
                                      corner_radius_y,
                                      operation,
                                      pdb_context->antialias,
                                      pdb_context->feather,
                                      pdb_context->feather_radius_x,
                                      pdb_context->feather_radius_y,
                                      TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_select_ellipse_invoker (GimpProcedure         *procedure,
                              Gimp                  *gimp,
                              GimpContext           *context,
                              GimpProgress          *progress,
                              const GimpValueArray  *args,
                              GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint operation;
  gdouble x;
  gdouble y;
  gdouble width;
  gdouble height;

  image = g_value_get_object (gimp_value_array_index (args, 0));
  operation = g_value_get_enum (gimp_value_array_index (args, 1));
  x = g_value_get_double (gimp_value_array_index (args, 2));
  y = g_value_get_double (gimp_value_array_index (args, 3));
  width = g_value_get_double (gimp_value_array_index (args, 4));
  height = g_value_get_double (gimp_value_array_index (args, 5));

  if (success)
    {
      GimpPDBContext *pdb_context = GIMP_PDB_CONTEXT (context);

      gimp_channel_select_ellipse (gimp_image_get_mask (image),
                                   (gint) x, (gint) y,
                                   (gint) width, (gint) height,
                                   operation,
                                   pdb_context->antialias,
                                   pdb_context->feather,
                                   pdb_context->feather_radius_x,
                                   pdb_context->feather_radius_y,
                                   TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_select_polygon_invoker (GimpProcedure         *procedure,
                              Gimp                  *gimp,
                              GimpContext           *context,
                              GimpProgress          *progress,
                              const GimpValueArray  *args,
                              GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint operation;
  gsize num_segs;
  const gdouble *segs;

  image = g_value_get_object (gimp_value_array_index (args, 0));
  operation = g_value_get_enum (gimp_value_array_index (args, 1));
  segs = gimp_value_get_double_array (gimp_value_array_index (args, 2), &num_segs);

  if (success)
    {
      GimpPDBContext *pdb_context = GIMP_PDB_CONTEXT (context);

      gimp_channel_select_polygon (gimp_image_get_mask (image),
                                   _("Free Select"),
                                   num_segs / 2,
                                   (GimpVector2 *) segs,
                                   operation,
                                   pdb_context->antialias,
                                   pdb_context->feather,
                                   pdb_context->feather_radius_x,
                                   pdb_context->feather_radius_y,
                                   TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_select_item_invoker (GimpProcedure         *procedure,
                           Gimp                  *gimp,
                           GimpContext           *context,
                           GimpProgress          *progress,
                           const GimpValueArray  *args,
                           GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint operation;
  GimpItem *item;

  image = g_value_get_object (gimp_value_array_index (args, 0));
  operation = g_value_get_enum (gimp_value_array_index (args, 1));
  item = g_value_get_object (gimp_value_array_index (args, 2));

  if (success)
    {
      if (gimp_pdb_item_is_attached (item, image, 0, error))
        {
          GimpPDBContext *pdb_context = GIMP_PDB_CONTEXT (context);

          gimp_item_to_selection (item, operation,
                                  pdb_context->antialias,
                                  pdb_context->feather,
                                  pdb_context->feather_radius_x,
                                  pdb_context->feather_radius_y);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_image_select_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-image-select-color
   */
  procedure = gimp_procedure_new (image_select_color_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-select-color");
  gimp_procedure_set_static_help (procedure,
                                  "Create a selection by selecting all pixels (in the specified drawable) with the same (or similar) color to that specified.",
                                  "This tool creates a selection over the specified image. A by-color selection is determined by the supplied color under the constraints of the current context settings. Essentially, all pixels (in the drawable) that have color sufficiently close to the specified color (as determined by the threshold and criterion context values) are included in the selection. To select transparent regions, the color specified must also have minimum alpha.\n"
                                  "\n"
                                  "This procedure is affected by the following context setters: 'gimp-context-set-antialias', 'gimp-context-set-feather', 'gimp-context-set-feather-radius', 'gimp-context-set-sample-merged', 'gimp-context-set-sample-criterion', 'gimp-context-set-sample-threshold', 'gimp-context-set-sample-transparent'.\n"
                                  "\n"
                                  "In the case of a merged sampling, the supplied drawable is ignored.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "David Gowers",
                                         "David Gowers",
                                         "2010");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The affected image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("operation",
                                                  "operation",
                                                  "The selection operation",
                                                  GIMP_TYPE_CHANNEL_OPS,
                                                  GIMP_CHANNEL_OP_ADD,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "The affected drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_color ("color",
                                                      "color",
                                                      "The color to select",
                                                      FALSE,
                                                      NULL,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-select-contiguous-color
   */
  procedure = gimp_procedure_new (image_select_contiguous_color_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-select-contiguous-color");
  gimp_procedure_set_static_help (procedure,
                                  "Create a selection by selecting all pixels around specified coordinates with the same (or similar) color to that at the coordinates.",
                                  "This tool creates a contiguous selection over the specified image. A contiguous color selection is determined by a seed fill under the constraints of the current context settings. Essentially, the color at the specified coordinates (in the drawable) is measured and the selection expands outwards from that point to any adjacent pixels which are not significantly different (as determined by the threshold and criterion context settings). This process continues until no more expansion is possible. If antialiasing is turned on, the final selection mask will contain intermediate values based on close misses to the threshold bar at pixels along the seed fill boundary.\n"
                                  "\n"
                                  "This procedure is affected by the following context setters: 'gimp-context-set-antialias', 'gimp-context-set-feather', 'gimp-context-set-feather-radius', 'gimp-context-set-sample-merged', 'gimp-context-set-sample-criterion', 'gimp-context-set-sample-threshold', 'gimp-context-set-sample-transparent', 'gimp-context-set-diagonal-neighbors'.\n"
                                  "\n"
                                  "In the case of a merged sampling, the supplied drawable is ignored. If the sample is merged, the specified coordinates are relative to the image origin; otherwise, they are relative to the drawable's origin.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "David Gowers",
                                         "David Gowers",
                                         "2010");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The affected image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("operation",
                                                  "operation",
                                                  "The selection operation",
                                                  GIMP_TYPE_CHANNEL_OPS,
                                                  GIMP_CHANNEL_OP_ADD,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "The affected drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x",
                                                    "x",
                                                    "x coordinate of initial seed fill point: (image coordinates)",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y",
                                                    "y",
                                                    "y coordinate of initial seed fill point: (image coordinates)",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-select-rectangle
   */
  procedure = gimp_procedure_new (image_select_rectangle_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-select-rectangle");
  gimp_procedure_set_static_help (procedure,
                                  "Create a rectangular selection over the specified image;",
                                  "This tool creates a rectangular selection over the specified image. The rectangular region can be either added to, subtracted from, or replace the contents of the previous selection mask.\n"
                                  "\n"
                                  "This procedure is affected by the following context setters: 'gimp-context-set-feather', 'gimp-context-set-feather-radius'.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2010");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("operation",
                                                  "operation",
                                                  "The selection operation",
                                                  GIMP_TYPE_CHANNEL_OPS,
                                                  GIMP_CHANNEL_OP_ADD,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x",
                                                    "x",
                                                    "x coordinate of upper-left corner of rectangle",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y",
                                                    "y",
                                                    "y coordinate of upper-left corner of rectangle",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("width",
                                                    "width",
                                                    "The width of the rectangle",
                                                    0, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("height",
                                                    "height",
                                                    "The height of the rectangle",
                                                    0, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-select-round-rectangle
   */
  procedure = gimp_procedure_new (image_select_round_rectangle_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-select-round-rectangle");
  gimp_procedure_set_static_help (procedure,
                                  "Create a rectangular selection with round corners over the specified image;",
                                  "This tool creates a rectangular selection with round corners over the specified image. The rectangular region can be either added to, subtracted from, or replace the contents of the previous selection mask.\n"
                                  "\n"
                                  "This procedure is affected by the following context setters: 'gimp-context-set-antialias', 'gimp-context-set-feather', 'gimp-context-set-feather-radius'.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Martin Nordholts",
                                         "Martin Nordholts",
                                         "2010");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("operation",
                                                  "operation",
                                                  "The selection operation",
                                                  GIMP_TYPE_CHANNEL_OPS,
                                                  GIMP_CHANNEL_OP_ADD,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x",
                                                    "x",
                                                    "x coordinate of upper-left corner of rectangle",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y",
                                                    "y",
                                                    "y coordinate of upper-left corner of rectangle",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("width",
                                                    "width",
                                                    "The width of the rectangle",
                                                    0, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("height",
                                                    "height",
                                                    "The height of the rectangle",
                                                    0, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("corner-radius-x",
                                                    "corner radius x",
                                                    "The corner radius in X direction",
                                                    0, GIMP_MAX_IMAGE_SIZE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("corner-radius-y",
                                                    "corner radius y",
                                                    "The corner radius in Y direction",
                                                    0, GIMP_MAX_IMAGE_SIZE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-select-ellipse
   */
  procedure = gimp_procedure_new (image_select_ellipse_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-select-ellipse");
  gimp_procedure_set_static_help (procedure,
                                  "Create an elliptical selection over the specified image.",
                                  "This tool creates an elliptical selection over the specified image. The elliptical region can be either added to, subtracted from, or replace the contents of the previous selection mask.\n"
                                  "\n"
                                  "This procedure is affected by the following context setters: 'gimp-context-set-antialias', 'gimp-context-set-feather', 'gimp-context-set-feather-radius'.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2010");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("operation",
                                                  "operation",
                                                  "The selection operation",
                                                  GIMP_TYPE_CHANNEL_OPS,
                                                  GIMP_CHANNEL_OP_ADD,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x",
                                                    "x",
                                                    "x coordinate of upper-left corner of ellipse bounding box",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y",
                                                    "y",
                                                    "y coordinate of upper-left corner of ellipse bounding box",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("width",
                                                    "width",
                                                    "The width of the ellipse",
                                                    0, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("height",
                                                    "height",
                                                    "The height of the ellipse",
                                                    0, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-select-polygon
   */
  procedure = gimp_procedure_new (image_select_polygon_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-select-polygon");
  gimp_procedure_set_static_help (procedure,
                                  "Create a polygonal selection over the specified image.",
                                  "This tool creates a polygonal selection over the specified image. The polygonal region can be either added to, subtracted from, or replace the contents of the previous selection mask. The polygon is specified through an array of floating point numbers and its length. The length of array must be 2n, where n is the number of points. Each point is defined by 2 floating point values which correspond to the x and y coordinates. If the final point does not connect to the starting point, a connecting segment is automatically added.\n"
                                  "\n"
                                  "This procedure is affected by the following context setters: 'gimp-context-set-antialias', 'gimp-context-set-feather', 'gimp-context-set-feather-radius'.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2010");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("operation",
                                                  "operation",
                                                  "The selection operation",
                                                  GIMP_TYPE_CHANNEL_OPS,
                                                  GIMP_CHANNEL_OP_ADD,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_double_array ("segs",
                                                             "segs",
                                                             "Array of points: { p1.x, p1.y, p2.x, p2.y, ..., pn.x, pn.y}",
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-select-item
   */
  procedure = gimp_procedure_new (image_select_item_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-select-item");
  gimp_procedure_set_static_help (procedure,
                                  "Transforms the specified item into a selection",
                                  "This procedure renders the item's outline into the current selection of the image the item belongs to. What exactly the item's outline is depends on the item type: for layers, it's the layer's alpha channel, for vectors the vector's shape.\n"
                                  "\n"
                                  "This procedure is affected by the following context setters: 'gimp-context-set-antialias', 'gimp-context-set-feather', 'gimp-context-set-feather-radius'.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2010");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("operation",
                                                  "operation",
                                                  "The desired operation with current selection",
                                                  GIMP_TYPE_CHANNEL_OPS,
                                                  GIMP_CHANNEL_OP_ADD,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_item ("item",
                                                     "item",
                                                     "The item to render to the selection",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
