/**
 * IPC Message Handling
 * Library: joedog
 * 
 * Copyright (C) 2000 Jeffrey Fulmer <jdfulmer@armstrong.com>
 * This file is part of Siege
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 * 
 * $Log: ipcmsg.c,v $
 * Revision 1.2  2001/01/25 18:30:27  jfulmer
 * changed function parameter to accomodate new data type.
 *
 * Revision 1.1  2001/01/17 20:19:59  jfulmer
 * Initial revision in lib/joedog
 *
 * Revision 1.1.1.1  2001/01/15 14:56:58  jfulmer
 * initial import
 *
 * Revision 1.1.1.1  2001/01/15 14:26:02  jfulmer
 * initial import
 *
 * Revision 1.0.1.1  2001/01/12 13:39:49  jfulmer
 * siege repository
 *
 * Revision 1.0.1.1  2001/01/11 20:58:29  jfulmer
 * Initial Version
 *
 * Revision 1.2  2000/12/19 01:18:25  jfulmer
 * 1.00 Final Release
 *
 * Revision 1.1  2000/12/14 15:05:05  jfulmer
 * Initial revision
 *
 */
#include "ipcmsg.h"

/**
 * create_queue     create SYSV IPC message queue
 * @param           void
 * @return          int ( message queue ID )
 */
int 
create_queue( void )
{
  int   qid;	
  key_t key;

  key = MSQKEY; 
  /* IPC_EXCL ensures that nobody else can use this queue, 
     the problems that this caused are detailed in siege.c
     and rememdied there as well.                         */
  if(( qid = msgget(key, IPC_CREAT | IPC_EXCL | IPC_NOWAIT | 0666 )) < 0 ) {
    joe_error("Unable to create IPC message queue");
  }
  return qid;
}

/**
 * get_queue        returns the qid of an existing queue
 *                  we need it in order to remove it.
 * @param           void
 * @return          int
 */      
int
get_queue( void )
{
  int   qid;
  key_t key;
 
  key = MSQKEY;
  if(( qid = msgget( key, IPC_EXCL | IPC_NOWAIT | 0666 )) > 0 )
    return qid;
  else
    return 0;
} 

/**
 * remove_queue     Remove SYSV IPC message queue
 *
 * @param           int QID
 * @return          void
 */
void 
remove_queue( int qid )
{
  key_t key;

  key = MSQKEY;
  if( msgctl( qid, IPC_RMID, (struct msqid_ds *) 0) < 0) {
    joe_fatal("Unable to remove IPC message queue, \"man ipcrm\"");
  }
  return;
} /** end remove_queue **/

/**
 * send_message     Send message of type 1 via an 
 *                  existing IPC message queue
 * @param           int QID
 * @param           char *message_text
 * @return          void
 */
void 
send_message( int qid, unsigned long int b, int c, float t )
{
  key_t  key;
  struct joemsg message;
  int    size = sizeof(message)+ (sizeof(int)*3) + sizeof(float);
		
  key =  MSQKEY;

  memset( &message, 0, sizeof( message ));	
  message.type   = 1;
  message.bytes  = b;
  message.code   = c;
  message.time   = t; 
  if(( msgsnd( qid, &message, size, 0 ) < 0 )) {
    joe_fatal("Unable to send IPC messages");
  } 
  
  return;
} /** end send_message **/

/**
 * send_message2    Send  message  of  type 2  via an 
 *                  existing IPC message queue.  This
 *                  type indicates the child is done. 
 * @param           int QID
 * @return          void
 */
void 
send_message2( int qid )
{
  key_t key;
  struct joemsg message;
  int    size = sizeof(message)+ (sizeof(int)*3) + sizeof(float);

  key = MSQKEY;
  memset( &message, 0, sizeof( message ));
  message.type = 2;
  if(( msgsnd( qid, &message, size, 0 ) < 0 )){	
    joe_fatal( "Unable to send IPC messages" );
  }

  return;
} /** end send_message2 **/


		
