/*
 * Multicast receiver thread for OpenGate
 * 
 * Copyright (c) Egoboo Ltd. 1999-2000
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Open Gatekeeper
 *
 * The Initial Developer of the Original Code is Egoboo Ltd.
 *
 * $Log: MulticastThread.h,v $
 * Revision 1.4  2000/04/10 19:17:14  aunitt
 * Moved environment to new environment object to tidy things up and to make
 * adding new things easier.
 *
 * Revision 1.3  2000/04/05 15:17:08  aunitt
 * Added RasLog object.
 *
 * Revision 1.2  2000/02/27 20:46:29  aunitt
 * Fixed problems with replying to wrong RAS address
 *
 * Revision 1.1.1.1  2000/02/01 22:25:40  aunitt
 * Initial revision
 *
 *
 */

#ifndef _MULTICASTTHREAD_H
#define _MULTICASTTHREAD_H

#include <ptlib.h>
#include <ptlib/sockets.h>
#include <h225.h>
#include "Defaults.h"
#include "Environ.h"
#include "EndpointTabl.h"
#include "CallTabl.h"
#include "RasServer.h"

class MulticastThread : public PThread
{
	PCLASSINFO(MulticastThread, PThread)
	public:
		MulticastThread( const Environ &    AkaEnviron,
                               WORD         MultiPort = GKDefaults::MulticastPort,
		                       WORD         RasPort = GKDefaults::RASPort
		               );
		virtual ~MulticastThread();

		void Close();	

	protected:
		MulticastThread();               // Stop clients calling default cons
		MulticastThread( const MulticastThread & ); // ...or copy constructor

		virtual void Main();	
		
		BOOL ReadRasReq( H225_RasMessage &  Mesg );
		BOOL WriteRasReply( const H225_TransportAddress & ReplyTo,
                                          H225_RasMessage &       Mesg 
                                  );
	
		const Environ & MyEnviron;
		PUDPSocket      MultiSocket;
		RasServer *     RasServ;
};

#endif // _MULTICASTTHREAD_H
