/* -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * CgiForm.cc
 *   Class that outputs the appropriate forms for the
 *   CGI's.
 *
 * $Id: CgiForm.cc,v 1.11 2000/12/29 05:35:05 rex Exp $
 *
 * Copyright (c) 2000 Remi Lefebvre <remi@dhis.net>
 *                and Benoit Joly <benoit@dhis.net>
 *
 * Licensed under the GPLv2
 */

#include <iostream.h>
#include <fstream.h>
extern "C" {
#include <cgi.h>
}

#include "CgiForm.h"

char *CgiForm::arch[] = { "x86", "sparc", "ultrasparc", "m68k",
                           "risc", "other", NULL };
char *CgiForm::OS[] = { "Linux", "OpenBSD", "NetBSD", "FreeBSD", "Hurd",
                         "BSDI", "Solaris", "SunOS", "Ultrix",
                         "Digital OSF", "IRIX", "NeXTstep", "HP-UX",
                         "SCO Openserver", "SCO Unixware", "AIX",
                         "Windows", "other", NULL };

CgiForm::CgiForm (char *templatePath, char *foot)
{
#ifdef DDT_DEBUG
    cout << "Content-type: text/html\n\n";
    cgiDebug (1, 1);
    cout << "<br>method: " << getenv("REQUEST_METHOD") << "<br>\n";
    cout << "length: " << getenv("CONTENT_LENGTH") << "<br>\n";
#endif
    cgi = cgiInit ();
    cgiHeader ();
    this->foot = foot;
    this->templatePath = templatePath;
}

CgiForm::~CgiForm () {}

void CgiForm::display (char *file)
{
    // c++ solution
    char filePath[256];
    sprintf(filePath, "%s/%s", templatePath, file);
    
    ifstream ifs(filePath);
    char buf[200];

    if (!ifs)
    {
        cout << "display(): no file " << filePath << " not found. Aborting.<br>\n";
        exit (1);
    }

    while(!ifs.eof() && !ifs.bad())
    {
      ifs.getline(buf,200);
      cout << buf << endl;
    }
}

void CgiForm::display (char *file, MacroSystem &macro)
{
    char filePath[256];
    sprintf(filePath, "%s/%s", templatePath, file);
    
    ifstream ifs(filePath);
    if(!ifs)
    {
      cout << "file " << filePath << " not found" << endl;
    }

    ifs >> macro["file"];
    cout << macro["file"].parse() << endl;
}

void CgiForm::quit (int status, char *msg)
{
    if (msg[0] != '\0')
    {
        cout << "<font color=red>" << msg << "</font><br>" << endl;
    }
    display (foot);
    exit (status);
}

void CgiForm::printRegForm (char *domain)
{ 
    MacroSystem macro;
    char dom[256];
    snprintf(dom, 256, ".%s", domain);
    macro["domain"] = dom;
    macro["arch"] = genDropDown("arch", arch, "").c_str();
    macro["OS"] = genDropDown("OS", OS,"").c_str();
    display("register.html", macro);
}

void CgiForm::printRegisteredInfoPage (int accountId, char *uPassword, char *aPassword)
{
  MacroSystem macro;
  char id[20];
  sprintf(id, "%d", accountId);
  macro["accountId"] = id;
  macro["uPassword"] = uPassword;
  macro["aPassword"] = aPassword;
  display("registered.html", macro);
}


void CgiForm::printAuthForm ()
{
    display("login.html");
}

void CgiForm::printAcctForm (char *md5hash, userAccount *acct)
{
    MacroSystem macro;

    macro["contactName"] = acct->contactName;
    macro["contactEmail"] = acct->contactEmail;
    macro["arch"] = genDropDown("arch", arch, acct->arch).c_str();
    macro["OS"] = genDropDown("OS", OS, acct->os).c_str();
    macro["userAccountId"] = acct->userAccountId;
    macro["fqdn"] = acct->fqdn;
    macro["md5hash"] = md5hash;

    display("editAccount.html", macro);
}

void CgiForm::printDnsForm (char *md5hash, int hostId)
{
    MacroSystem macro;

    macro["mx"] = MX;
    macro["cname"] = CNAME;
    macro["hostId"] = hostId;
    macro["md5hash"] = md5hash;

    display("editDNS.html", macro);
}

void CgiForm::printDeleteForm (char *md5hash, int hostId)
{
//    int i = 0;
    MacroSystem macro;
    macro["hostId"] = hostId;
    macro["md5hash"] = md5hash;

    display("deleteAccount.html", macro);
}

string CgiForm::genDropDown(char *inputName, char *values[], char *selectedValue)
{
  strstream ss;
  string str;
  ss << "<select name='" << inputName << "'>" << endl;

  for (int i = 0; values[i] != NULL; i++)
  {
    if(strcmp(selectedValue, values[i]) == 0)
    {
      ss << "<option value='" << values[i] << "' selected>" << values[i] << endl;
    }
    else
    {
      ss << "<option value='" << values[i] << "'>" << values[i] << endl;
    }

  }
  ss << "</select>" << endl;

  str = ss.str();
  return str;
}

