/***************************************************************************/
/* 		This code is part of WWW grabber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#ifdef HAVE_FLOCK
#include <sys/file.h>
#endif
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <netdb.h>
#include <fcntl.h>
#include <limits.h>
#include <ctype.h>
#include <time.h>
#include <utime.h>
#include <dirent.h>
#include <signal.h>


#ifdef HAVE_SYS_MODE_H
#include <sys/mode.h>
#endif

#ifdef HAVE_TERMIOS
#include <termios.h>
#endif

#include "config.h"
#include "url.h"
#include "doc.h"
#include "ftp.h"
#include "dinfo.h"
#include "log.h"
#include "dns.h"
#include "ainterface.h"
#include "stats.h"
#include "myssl.h"

void strip_nl(str)
char *str;
{
	char *p;

	p = strchr(str , '\n');
	if (p) *p = '\0';
	p = strchr(str , '\r');
	if (p) *p = '\0';
}

void omit_chars(str , chars)
char *str;
char *chars;
{
	int src,dst;

	for (src = 0 , dst = 0; str[src]; src++)
	{
		if (strchr(chars , str[src]))
			continue;
		str[dst] = str[src];
		dst++;
	}
	str[dst] = '\0';
}

#ifdef NO_SETENV
int my_setenv(var , val , ovr)
char *var;
char *val;
int ovr;
{
	char *pom=_malloc(strlen(var) + strlen(val) + 2);

	sprintf(pom , "%s=%s" , var , val);
	return putenv(pom);
}
#endif

static char *xstrherror(enr)
int enr;
{
	char *p;

	switch (enr)
	{
#ifdef NETDB_INTERNAL
		case NETDB_INTERNAL:
			p = strerror(errno);
			break;
#endif
#ifdef NETDB_SUCCESS
		case NETDB_SUCCESS:
			p = gettext("no error");
			break;
#endif
#ifdef HOST_NOT_FOUND
		case HOST_NOT_FOUND:
			p = gettext("host not found");
			break;
#endif
#ifdef TRY_AGAIN
		case TRY_AGAIN:
			p = gettext("temporary error (try again later)");
			break;
#endif
#ifdef NO_RECOVERY
		case NO_RECOVERY:
			p = gettext("non recoverable error");
			break;
#endif
#ifdef NO_ADDRESS
		case NO_ADDRESS:
			p = gettext("name is valid, but doesn't have an IP address");
			break;
#endif
		default:
			p = gettext("unknown hostname translation error");
	}
	return p;
}

void xherror(str)
char *str;
{
	xprintf(1 , "%s: %s\n" , str , xstrherror(h_errno));
} 
void xperror(str)
char *str;
{
	xprintf(1 , "%s: %s\n" , str , strerror(errno));
} 


static void xvaprintf(log, strs, args)
int log;
char *strs;
va_list *args;
{
#ifdef I_FACE
	if (cfg.xi_face && cfg.done && !cfg.quiet)
	{
		char buf[8192];
		char *p;

		buf[0] = '\0';

		vsprintf(buf , strs , *args);

#ifdef X_FACE
		{
			bool last = 1;
			int ilen;

			p = buf;
			while(*p)
			{
				ilen = strcspn(p , "\r\n");
				if (*(p+ilen)) *(p+ilen) = '\0';
				else last = 0;
 
				LogAppendLine(cfg.X.logw , p);

				p += ilen+last;
				p += strspn(p , "\r\n");
			}
		}
#endif

#ifdef GTK_FACE
		{
			bool last = 1;
			int ilen;

			gtk_clist_freeze(GTK_CLIST (cfg.gtk.logw));
			p = buf;
			while(*p)
			{
				ilen = strcspn(p , "\r\n");
				if (*(p+ilen)) *(p+ilen) = '\0';
				else last = 0;
 
				gtk_clist_append(GTK_CLIST(cfg.gtk.logw) , &p);

				p += ilen+last;
				p += strspn(p , "\r\n");
			}

			if (cfg.xlogsize)
			{
				while (cfg.xlogsize < GTK_CLIST(cfg.gtk.logw)->rows)
					gtk_clist_remove(GTK_CLIST(cfg.gtk.logw) , 0);
			}

			gtk_clist_thaw(GTK_CLIST(cfg.gtk.logw));
			if (cfg.log_autoscroll)
			{
				cfg.gtk.logvadj->value = cfg.gtk.logvadj->upper >  
					cfg.gtk.logvadj->page_size ?  cfg.gtk.logvadj->upper -  
					cfg.gtk.logvadj->page_size : 0;
				gtk_signal_emit_by_name (GTK_OBJECT(cfg.gtk.logvadj), "value_changed");
			}
		}
#endif


	}
	else	
#endif
		if (!cfg.quiet && !cfg.bgmode)
		{
			bool wout = TRUE;
#ifdef HAVE_TERMIOS
			if (cfg.tccheck)
			{
				static int _istty = -1;
				static pid_t _pgrp;

				if (_istty == -1)
				{
					_istty = isatty(1);
#ifdef GETPGRP_NEED_PID
					_pgrp = getpgrp(getpid());
#else
					_pgrp = getpgrp();
#endif
				}

				if (_istty && tcgetpgrp(1) != _pgrp)
					wout = FALSE;
			}
#endif
			if (wout)
			{
				vprintf(strs , *args);
				fflush(stdout);
			}
		}

	if (log && cfg.logfile)
	{
		char buf[8192];

		buf[0] = '\0';

		vsprintf(buf , strs , *args);
		log_str(buf);
	}

}

void xprintf(int log ,char *strs , ... ) 
{
	va_list args;

	va_start(args , strs);
	xvaprintf(log, strs, &args);
	va_end(args);
}

void xdebug(int level, char *strs , ...)
{
#ifdef DEBUG
	if (cfg.debug && (level & cfg.debug_level))
	{
		va_list args;
		va_start(args , strs);
		xvaprintf(1, strs, &args);
		va_end(args);
	}
#endif
}

void xvadebug(int level, char *strs, va_list *args)
{
#ifdef DEBUG
	if (cfg.debug && (level & cfg.debug_level))
	{
		xvaprintf(1, strs, args);
	}
#endif
}

unsigned int hash_func(str,num)
char *str;
int num;
{
	char *p = str;
	unsigned int rv = 0;

	while(*p)
	{
		rv = (rv + (unsigned char)*p) % num;
		p++;
	}
	rv = rv % num;
	return rv;
}

int my_flock(fd , filename , opt , b_lock)
int *fd;
char *filename;
int opt;
int b_lock;
{

	int i = 0;

	DEBUG_LOCKS("Locking file - %s\n" ,filename);
	if (b_lock)
	{
		bool ready=FALSE;
		while(!ready)
		{
#ifdef HAVE_FLOCK
			if (flock(*fd , LOCK_EX | LOCK_NB))
			{
				if (errno == EWOULDBLOCK)
				{
					xprintf(1 , gettext("waiting to release lock on FD : %d\n") , *fd);
					i = flock(*fd , LOCK_EX);
				}
			}
			else i = 0;
#else
#ifdef HAVE_FCNTL_LOCK
			struct flock fl;

			memset(&fl , '\0' , sizeof(fl));
			fl.l_type = F_WRLCK;
			if (fcntl(*fd , F_SETLK , &fl))
			{
				if (errno == EWOULDBLOCK)
				{
					xprintf(1 , gettext("waiting to release lock on FD : %d\n") , *fd);
					memset(&fl , '\0' , sizeof(fl));
					fl.l_type = F_WRLCK;
					i = fcntl(*fd , F_SETLKW , &fl);
				}
			}
			else i = 0;
#endif
#endif
			if (access(filename , F_OK))
			{
				DEBUG_LOCKS("Lock file was removed - creating new one.\n");
				close(*fd);
				if (!makealldirs(filename))
				{
					*fd = open(filename , opt , 0644);
					if (*fd < 0)
					{
						i = -1;
						ready = TRUE;
					}
				}
				else
				{
					i = -1;
					ready = TRUE;
				}
			}
			else
				ready = TRUE;
		}
				
	}
	else
	{
#ifdef HAVE_FLOCK
		i = flock(*fd , LOCK_EX | LOCK_NB);
#else
#ifdef HAVE_FCNTL_LOCK
		struct flock fl;

		memset(&fl , '\0' , sizeof(fl));
		fl.l_type = F_WRLCK;
		i = fcntl(*fd , b_lock ? F_SETLKW : F_SETLK , &fl);
#endif
#endif
	}

	return i;
}

#ifdef HAVE_FCNTL_LOCK
int my_funlock(fd)
int fd;
{
        struct flock fl;
	int i;

        memset(&fl , '\0' , sizeof(fl));
        fl.l_type = F_UNLCK;
        i = fcntl(fd , F_SETLK , &fl);
        
        return i;
}
#endif

long int _atoi(str) 
char *str;
{
	char *__eptr__;
	long int rv;

	rv = strtol(str , (char **) &__eptr__ , 10);
	if (*__eptr__ != '\0') errno = ERANGE;
	else errno = 0;

	return rv;
}

double _atof(str) 
char *str;
{
	char *__eptr__;
	double rv;

	rv = strtod(str , (char **) &__eptr__);
	if (*__eptr__ != '\0') errno = ERANGE;
	else errno = 0;

	return rv;
}


char * _strtrchr(str , cfrom , cto)
char *str;
int cfrom;
int cto;
{
	char *p = str;

	while((p = strchr(p , cfrom))) *p = cto;

	return str;
}

void *_malloc(sz)
int sz;
{
	void *ret = malloc(sz);
	if (!ret)
	{
		perror("malloc");
	}
	return ret;
}

void *_realloc(from , sz)
void *from;
int sz;
{
	void *ret = from ? realloc(from , sz) : malloc(sz);
	if (!ret)
	{
		perror("realloc");
	}
	return ret;
}

char *get_1qstr(str)
char *str;
{
	static char *p;
	static char pom[4096];
	char *pom1 = NULL , *pom2 = NULL;
	int found;

	if (str) p = str;

	for ( ; p && *p && (!pom1 || !pom2) ; p++)
	{
		found = FALSE;

		if (*p == '\"')
		{
			if ((p == str) || (*(p-1) != '\\'))
				found = TRUE;
		}

		if (!pom1 && found)
			pom1 = p+1;
		else if (!pom2 && found)
			pom2 = p;
	}
	if (pom1 && pom2)
	{
		char *p2;
		p2 = pom;
		while(pom1 < pom2)
		{
			if (*pom1 == '\\')
			{
				pom1 ++;
				*p2 = *pom1;
			}
			else
			{
				*p2 = *pom1;	
			}
			p2++;
			pom1++;
		}
		*p2 = '\0';
		return pom;
	}
	else
	{
		p = NULL;
		return NULL;
	}
}

char *escape_str(str , unsafe)
char *str;
char *unsafe;
{
	char sbuf[4096];
	char *p,*r;

	for (p = str, r = sbuf ; *p ; p++)
	{
		if (strchr(unsafe, *p))
		{
			*r = '\\';
			r++;
			*r = *p;
			r++;
		}
		else
		{
			*r = *p;
			r++;
		}
	}
	*r = '\0';
	return new_string(sbuf);
}
/**************************************/
/* nahrada standartnej funkcie strtok */
/* jeden separator -> jeden parameter */
/* nie je reentrantna                 */
/**************************************/
char *strtokc(str , chr)
char *str;
int chr;
{
	static char *p;
	char *pom;
	char *ret;

	if (str) p = str;

	ret = p;

	if (p)
	{
		pom = strchr(p , chr);

		if (pom)
		{
			*pom = '\0';
			p = pom  + 1;
		}
		else p = NULL;
	}
	
	return ret;
}

/**************************************/
/* najdi poziciu n-teho vyskytu znaku */
/**************************************/

char *strfindnchr(str , chr , n)
char *str;
int chr;
int n;
{
	int cnt;
	char *p;
	
	for (p = str , cnt = 0 ; *p && cnt < n ; p++)
	{
		if (*p == chr) cnt ++;
	}
	if (cnt != n) return NULL;
	else return p;
}

/********************************************/
/* search in list for string occurrence     */
/********************************************/
bool is_in_list(str , list)
char *str;
char **list;
{
        char **p = list;

        while(*p)
        {
                if (!strcasecmp(*p , str))
                {
                        return TRUE;
                }
                p++;
        }
        return FALSE;
}

/*******************************************************/
/* z retazca uroby zoznam casti oddelenych oddelovacom */
/*******************************************************/
char **make_list(liststr,sep)
char *liststr;
char *sep;
{
	char *p;
	int i = 0;
	char **ret_val = NULL;
	int ilen;

	if (!liststr || !*liststr) return NULL;

	ret_val = _malloc(sizeof(char **));
	ret_val[0] = NULL;

	p = liststr;

	while(*p)
	{
		ilen = strcspn(p , sep);
		ret_val = _realloc(ret_val , sizeof(char **) * (i + 2));
		ret_val[i] = new_n_string(p,ilen);
		ret_val[i+1] = NULL;
		p += ilen;
		if (*p) p++;
		i++;
	}

	return ret_val;
}

/***********************************************/
/* male pismena v retazci zkonvertuje na velke */
/***********************************************/

char *upperstr(s) 
char *s;
{
	char *p ; 

	for(p = s ; *p != '\0' ; p ++) *p = toupper(*p); 

	return s;
}

/***********************************************/
/* velke pismena v retazci zkonvertuje na male */
/***********************************************/

char *lowerstr(s)
char *s;
{
        char *p ;

        for(p = s ; *p != '\0' ; p ++) *p = tolower(*p);

        return s;
}

/***********************************************/
/* alokuje miesto v pameti a skopiruje retezec */
/***********************************************/

char *new_string(s)
char *s;
{
	char *p; 

	if (s)
	{
		p = (char *) _malloc(strlen(s) + 1);
		strcpy(p , s);
	}
	else
		p = NULL;

	return p;
}

/**************************************************************/
/* alokuje miesto v pameti a skopiruje retezec dlaky l znakov */
/**************************************************************/

char *new_n_string(s , l)
char *s;
int l;
{
	char *p;

	if (!s) return NULL;

	p = (char *) _malloc(l + 1);
	if (l) strncpy(p , s , l);
	*(p + l) = '\0';
	return p;
}

/*****************************************************/
/* pre dane meno suboru vytvory vsetky neexistujuce  */
/* adresare v ceste ak je to mozne 		     */
/*****************************************************/

int makealldirs(path)
char *path;
{
	char pom[PATH_MAX];
	char *p;

	pom[0]='\0';

	if (path)
	{
		p = path;
#ifdef _WIN32
		if (strlen(p) > 2 && p[0] == '/' && p[1] == '/' && 
		    isalpha(p[2]) &&
		    (p[3] == '\0' || p[3] == '/'))
		{
			strncpy(pom , p ,3);
			pom[3] = '\0';
			p += 3;
		}
		p += strspn(p , "/");			
#endif
		while(*p)
		{
			int ilen = strcspn(p , "/");
 
			strcat(pom , "/");
			strncat(pom , p , ilen);

			p += ilen;
			p += strspn(p , "/");			

			if (*p && access(pom,F_OK))
			{
				if (mkdir(pom, S_IRWXU | S_IRGRP | S_IROTH | 
					S_IXGRP | S_IXOTH))
					return -1;
			}
		}
	}
	return 0;
}

/***********************************************/
/* z relativnej cesty urobi absolutnu a vyhodi */
/* vsetky "." a ".." adresare		       */
/***********************************************/
char *get_abs_file_path_oss(path)
char *path;
{
	char *p,pom[PATH_MAX],*tmp,result[PATH_MAX]="/";
	int ilen;
	bool last = 1;

	for(p = path; isspace(*p) && *p ; p++);

	if (*p != '/')
	{
		tmp = (char *) getcwd(NULL,PATH_MAX);
		if (cfg.cache_dir)
			sprintf(pom , "%s/%s" , cfg.cache_dir ,p);
		else
			sprintf(pom , "%s/%s" , tmp , p);
		_free(tmp);
	}
	else
	{
		sprintf(pom , "%s" , p);
	}

	p = pom;

#ifdef _WIN32
	if (strlen(pom) >2 && pom[0] == '/' && pom[1] == '/' && 
	    isalpha(pom[2]) &&
	    (pom[3] == '\0' || pom[3] == '/'))
	{
		strncpy(result , pom ,3);
		result[3] = '\0';
		p = pom + 3;
	}
#endif
	if (!*p) strcpy(result,"/");

	while(*p)
	{
		ilen = strcspn(p , "/");
		if (*(p+ilen)) *(p+ilen) = '\0';
		else last = 0;
 
		if (strcmp(p , "."))
		{
			if (strcmp(p , ".."))
			{
				if (!tl_is_dirname(result)) strcat(result , "/");
				strcat(result , p);
			}
			else
			{
				tmp = strrchr(result , '/');
				*(tmp + 1 - (tmp != result) ) = '\0';
			}
		}
		p += ilen+last;
		p += strspn(p , "/");
	}

	ilen = strlen(path);
	p = path + ilen - 1;
	if (*p != '/' && tl_is_dirname(result) == '/')
	{
		result[strlen(result) - 1] = '\0';
	}

	if ((tl_is_dirname(path) && !tl_is_dirname(result)) ||
		(strlen(result) == 0))
	{
		result[strlen(result) + 1] = '\0';
		result[strlen(result)] = '/';
	}

	return new_string(result);
}

/***********************************************/
/* z relativnej cesty urobi absolutnu a vyhodi */
/* vsetky "." a ".." adresare		       */
/***********************************************/
char *get_abs_file_path(path)
char *path;
{
	char *p,pom[PATH_MAX],*tmp,result[PATH_MAX]="/";
	int ilen;
	bool last = 1;

	for(p = path; isspace(*p) && *p ; p++);

	if (*p != '/')
	{
		tmp = (char *) getcwd(NULL,PATH_MAX);
		if (cfg.cache_dir)
			sprintf(pom , "%s/%s" , cfg.cache_dir ,p);
		else
			sprintf(pom , "%s/%s" , tmp , p);
		_free(tmp);
	}
	else
	{
		sprintf(pom , "%s" , p);
	}

	p = pom;

	if (!*p) strcpy(result,"/");

	while(*p)
	{
		ilen = strcspn(p , "/");
		if (*(p+ilen)) *(p+ilen) = '\0';
		else last = 0;
 
		if (strcmp(p , "."))
		{
			if (strcmp(p , ".."))
			{
				if (!tl_is_dirname(result)) strcat(result , "/");
				strcat(result , p);
			}
			else
			{
				tmp = strrchr(result , '/');
				*(tmp + 1 - (tmp != result) ) = '\0';
			}
		}
		p += ilen+last;
		p += strspn(p , "/");
	}

	ilen = strlen(path);
	p = path + ilen - 1;
	if (*p != '/' && tl_is_dirname(result) == '/')
	{
		result[strlen(result) - 1] = '\0';
	}

	if ((tl_is_dirname(path) && !tl_is_dirname(result)) ||
		(strlen(result) == 0))
	{
		result[strlen(result) + 1] = '\0';
		result[strlen(result)] = '/';
	}

	return new_string(result);
}

#ifdef _WIN32
char *cvt_win32_to_unix_path(path)
char *path;
{
	char pom[PATH_MAX];
	char *p = new_string(path);
	char *p1;

	pom[0] = '\0';
	p1 = p;

	if(strlen(p) >= 2 && isalpha(p[0]) && p[1] == ':')
	{
		sprintf(pom , "//%c" , p[0]);
		p += 2;
	}

	_strtrchr(p , '\\' , '/');

	strcat(pom , p);
	_free(p1);
		
	return get_abs_file_path_oss(pom);
}
#endif

/**********************************/
/* spocita vyskyt znaku v retazci */
/**********************************/

static int str_cnt_chr(s,c)
char *s;
int c;
{
	char *p = s;
	int ret = 0;

	while(*p)
	{
		if (*p == c) ret++;

		p++;
	}

	return ret;
}

/********************************************/
/* urci relativnu cestu z adresara v ktorom */
/* sa nachadza prvy subor na druhy subor    */
/********************************************/

char *get_relative_path(fromabs,toabs)
char *fromabs;
char *toabs;
{
	char *p1 ,*p2 , *pom1 , *pom2;
	int offset = 0 , i , plom;
	char pom[PATH_MAX];

	pom1 = p1 = get_abs_file_path_oss(fromabs);
	pom2 = p2 = get_abs_file_path_oss(toabs);

	while (*p1 && *p2 && *p1 == *p2)
	{
		p1++;
		p2++;
	}

	if (!strcmp(p1,p2))
	{
		free(pom1);
		free(pom2);
		return new_string("");
	}

	while((p1 >= pom1) && *p1 != '/') p1--;

	if (*p1 != '/') 
	{
		free(pom1);
		free(pom2);

		return NULL;
	}
	offset = p1 - pom1;

	plom = str_cnt_chr(p1 + 1 , '/');

	pom[0] = '\0';

	for (i = 0 ; i < plom ; i++)
	{
		strcat(pom , "../");
	}

	strcat(pom , pom2 + offset + 1);

	free(pom1);
	free(pom2);

	return new_string(pom);		
}

/********************************/
/* vrati poziciu pripony suboru */
/********************************/

char * get_extension(fname)
char *fname;
{
	char *p1,*p2;

	p1 = strrchr(fname , '.');
	p2 = strrchr(fname , '/');

	if (p1 > p2)
	{
		return(p1 + 1);
	}
	else return "";
	
}

static char *html_tag_tab[] = {
"<HTML" ,
"<html" ,
"<HEAD" ,
"<head" ,
"<META" ,
"<meta" ,
"<TITLE" ,
"<title" ,
"<BODY",
"<body",
};

bool ext_is_html(fn)
char *fn;
{
	char *ext = get_extension(fn);

	return str_is_in_list(0 , ext , "html" , "htm" , "shtml" , "phtml" , "css" , NULL);
}

bool ext_is_nothtml(fn)
char *fn;
{
	char *ext = get_extension(fn);

	return str_is_in_list(0 , ext , "gif" , "jpg" , "jpeg" , "png" , "mpeg" ,
			"mpg" , "avi" , "pdf" , "gz" , "tgz" , "zip" , "arj" ,
			 "hqx" , "rar" , "tar" , "Z" , "doc" , "doc" , "xls" ,
			 "wav" , "au" , "mp3" , NULL);
}

bool file_is_html(fn)
char *fn;
{
	int i,j,len;
	char pom[256];
	bufio *fd;

	if (ext_is_html(fn))
		return TRUE;

	if (ext_is_nothtml(fn))
		return FALSE;

	if ((fd = bufio_open(fn , O_BINARY | O_RDONLY)))
	{
		for (j = 0 ; j < 5 ; j++)
		{
			if ((len = bufio_readln(fd , pom , sizeof(pom))) > 0)
			{
				for (i = 0 ; i < NUM_ELEM(html_tag_tab) ; i++)
				    if (strstr(pom , html_tag_tab[i]))
				    {
				    	bufio_close(fd);
				    	return TRUE;
				    }
			}
			else
			{
				if (len < 0) xperror("file_is_html");
				bufio_close(fd);
				return FALSE;
			}
		}
		bufio_close(fd);
	}
	return FALSE;
}


#ifdef X_FACE

static void TOut(client_data , timer)
XtPointer client_data;
XtIntervalId *timer;
{
	*(XtIntervalId *)client_data = 0;
	_X_EscLoop();
}

static void rwCB(ptr , src , id)
XtPointer ptr;
int *src;
XtInputId *id;
{
	XtRemoveInput(*id);
	*(XtInputId *)ptr = 0;
	_X_EscLoop();
}

#endif

#ifdef GTK_FACE

static gint TOut(data)
gpointer data;
{
	*(int *)data = 0;
	_X_EscLoop();

	return FALSE;
}

static void rwCB(data , source , condition)
gpointer data;
gint source;
GdkInputCondition condition;
{

	gdk_input_remove(*(int *)data );
	*(int *)data = 0;

	_X_EscLoop();
}

#endif

int _selectr(sock , timeout)
int sock;
int timeout;
{
	fd_set readfds, exceptfds;
	struct timeval tout, *toutptr = NULL;
	int rv;

	FD_ZERO(&readfds);
	FD_SET(sock , &readfds);
	FD_ZERO(&exceptfds);
	FD_SET(sock , &exceptfds);

	if (timeout)
	{
		tout.tv_sec = timeout;
		tout.tv_usec = 0;
		toutptr = &tout;
	}

	rv = select(sock + 1 , &readfds , NULL , &exceptfds , toutptr);

	return rv;
}

int _selectw(sock , timeout)
int sock;
int timeout;
{
	fd_set writefds, exceptfds;
	struct timeval tout, *toutptr = NULL;
	int rv;

	FD_ZERO(&writefds);
	FD_SET(sock , &writefds);
	FD_ZERO(&exceptfds);
	FD_SET(sock , &exceptfds);

	if (timeout)
	{
		tout.tv_sec = timeout;
		tout.tv_usec = 0;
		toutptr = &tout;
	}

	rv = select(sock + 1 , NULL , &writefds , &exceptfds , toutptr);

	return rv;
}

int my_read(sock , buf , len , ssl_con)
int sock;
char *buf;
int len;
void *ssl_con;
{
	int rv = 0;
#ifdef X_FACE
	XtInputId iid = 0;
	XtIntervalId inid = 0;
#endif
#ifdef GTK_FACE
	gint iid = 0;
	gint inid = 0;
#endif

	do
	{
#ifdef I_FACE
		if (cfg.xi_face && cfg.done)
		{
#ifdef USE_SSL
		    if (!ssl_con ||
			(ssl_con && (SSL_pending((SSL*)ssl_con) == 0)))
#endif
		    {
#ifdef X_FACE
			inid = cfg.ctimeout ? XtAppAddTimeOut(cfg.X.app_context , 
				cfg.ctimeout * 60000, TOut , &inid) : 0;
#endif
#ifdef GTK_FACE
			inid = cfg.ctimeout ? gtk_timeout_add(cfg.ctimeout * 60000 ,
					(GtkFunction)TOut , &inid) : 0;
#endif
		    }
		}
		else
#endif
		{
#ifdef USE_SSL
			if (!ssl_con ||
				(ssl_con && (SSL_pending((SSL*)ssl_con) == 0)))
#endif
			{
				while ((rv = _selectr(sock , 60 * cfg.ctimeout)) == -1 
					&& errno == EINTR);
				if (rv <= 0)
				{
					if (rv == 0) errno = ETIMEDOUT;
					return -1;
				}
			}
		}
#ifdef I_FACE
#ifdef USE_SSL
		if (!ssl_con ||
			(ssl_con && (SSL_pending((SSL*)ssl_con) == 0)))
#endif
		{
		    if (cfg.xi_face && cfg.done)
		    {
#ifdef X_FACE
			iid = XtAppAddInput(XtDisplayToApplicationContext(cfg.X.dpy),
				 	sock , (XtPointer) XtInputReadMask , 
					rwCB , (XtPointer)&iid);

			_Xt_ServeLoop


			if (inid)
			{
				XtRemoveTimeOut(inid);
				inid = 0;
			}
			else if (cfg.ctimeout)
			{
				errno = ETIMEDOUT;
				rv = -1;
			}

			if (iid) 
			{
				XtRemoveInput(iid);
				iid = 0;
			}

#endif /*X_FACE*/

#ifdef GTK_FACE
			iid = gdk_input_add(sock , GDK_INPUT_READ , 
				(GdkInputFunction) rwCB , (gpointer) &iid);

			_Xt_ServeLoop

			if (inid)
			{
				gtk_timeout_remove(inid);
				inid = 0;
			}
			else if (cfg.ctimeout)
			{
				errno = ETIMEDOUT;
				rv = -1;
			}

			if (iid) 
			{
				gdk_input_remove(iid);
				iid = 0;
			}

#endif /*GTK_FACE*/

			if (rv) return rv;
		    }
		}
#endif /*I_FACE*/

		if (cfg.rbreak)
		{
			errno = EINTR;
			rv = -1;
			cfg.stop = TRUE;
			break;
		}

#ifdef USE_SSL
		if (ssl_con)
		{
			bool stopread = FALSE;

			while (!stopread)
			{
				rv = SSL_read((SSL *)ssl_con , buf , len);
				switch (SSL_get_error((SSL *)ssl_con , rv))
				{
					case SSL_ERROR_WANT_READ:
					case SSL_ERROR_WANT_WRITE:
						my_msleep(10);
						_Xt_Serve
						break;
					case SSL_ERROR_SSL:
						ERR_print_errors_fp(stdout);
						stopread = TRUE;
						break;
					default:
						stopread = TRUE;
						break;
				}
			}
		}
		else
#endif
			rv = read(sock , buf , len);

	} while (rv == -1 && errno == EINTR && !cfg.rbreak);


#ifdef X_FACE
	if (inid)
	{
		XtRemoveTimeOut(inid);
		inid = 0;
	}

	if (iid) 
	{
		XtRemoveInput(iid);
		iid = 0;
	}
#endif   

#ifdef GTK_FACE

	if (inid)
	{
		gtk_timeout_remove(inid);
		inid = 0;
	}

	if (iid) 
	{
		gdk_input_remove(iid);
		iid = 0;
	}

#endif   
	return rv;
}

int my_write(sock , buf , len , ssl_con)
int sock;
char *buf;
int len;
void *ssl_con;
{
	int rv = 0;
#ifdef X_FACE
	XtInputId iid = 0;
	XtIntervalId inid = 0;
#endif
#ifdef GTK_FACE
	gint iid = 0;
	gint inid = 0;
#endif

	do
	{
#ifdef I_FACE
		if (cfg.xi_face && cfg.done)
		{
#ifdef X_FACE
			inid = cfg.ctimeout ? XtAppAddTimeOut(cfg.X.app_context , 
				cfg.ctimeout * 60000, TOut , &inid) : 0;
#endif
#ifdef GTK_FACE
			inid = cfg.ctimeout ? gtk_timeout_add(cfg.ctimeout * 60000 ,
					(GtkFunction)TOut , &inid) : 0;
#endif
		}
		else
#endif
		{
	
			while ((rv = _selectw(sock , 60 * cfg.ctimeout)) == -1 
				&& errno == EINTR);
			if (rv <= 0)
			{
				if (rv == 0) errno = ETIMEDOUT;
				return -1;
			}
		}

#ifdef I_FACE
		if (cfg.xi_face && cfg.done)
		{
#ifdef X_FACE
			iid = XtAppAddInput(XtDisplayToApplicationContext(cfg.X.dpy),
				 	sock , (XtPointer) XtInputWriteMask , 
					rwCB , (XtPointer) &iid);

			_Xt_ServeLoop


			if (inid)
			{
				XtRemoveTimeOut(inid);
				inid = 0;
			}
			else if (cfg.ctimeout)
			{
				errno = ETIMEDOUT;
				rv = -1;
			}

			if (iid) 
			{
				XtRemoveInput(iid);
				iid = 0;
			}

#endif /*X_FACE*/

#ifdef GTK_FACE
			iid = gdk_input_add(sock , GDK_INPUT_WRITE , 
				(GdkInputFunction) rwCB , (gpointer) &iid);

			_Xt_ServeLoop

			if (inid)
			{
				gtk_timeout_remove(inid);
				inid = 0;
			}
			else if (cfg.ctimeout)
			{
				errno = ETIMEDOUT;
				rv = -1;
			}

			if (iid) 
			{
				gdk_input_remove(iid);
				iid = 0;
			}

#endif /*GTK_FACE*/


			if (rv) return rv;
		}
#endif /*I_FACE*/

		if (cfg.rbreak)
		{
			errno = EINTR;
			rv = -1;
			cfg.stop = TRUE;
			break;
		}

#ifdef USE_SSL
		if (ssl_con)
		{
			while (len)
			{
				rv = SSL_write((SSL *)ssl_con , buf , len);
				switch (SSL_get_error((SSL *)ssl_con , rv))
				{
					case SSL_ERROR_NONE:
						len -= rv;
						buf += rv;
						if (rv <= 0) len = 0;
						break;
					case SSL_ERROR_WANT_WRITE:
					case SSL_ERROR_WANT_READ:
						my_msleep(10);
						_Xt_Serve
						break;
					case SSL_ERROR_SSL:
						ERR_print_errors_fp(stdout);
						break;
					default:
						len = 0;
						break;
				}
			}
		}
		else
#endif
			rv = write(sock , buf , len);

	} while (rv == -1 && errno == EINTR && !cfg.rbreak);
   

#ifdef X_FACE
	if (inid)
	{
		XtRemoveTimeOut(inid);
		inid = 0;
	}

	if (iid) 
	{
		XtRemoveInput(iid);
		iid = 0;
	}
#endif   

#ifdef GTK_FACE
	if (inid)
	{
		gtk_timeout_remove(inid);
		inid = 0;
	}

	if (iid) 
	{
		gdk_input_remove(iid);
		iid = 0;
	}
#endif   

	return rv;
}

#ifdef I_FACE

void my_sleep(s)
unsigned int s;
{
#ifdef X_FACE
	XtIntervalId inid;
#endif
#ifdef GTK_FACE
	gint inid;
#endif

	if (cfg.xi_face)
	{
#ifdef X_FACE
		inid = XtAppAddTimeOut(cfg.X.app_context , s * 1000 , TOut , &inid);
		_Xt_ServeLoop
		if (inid)
			XtRemoveTimeOut(inid);
#endif
#ifdef GTK_FACE
		inid = gtk_timeout_add(s * 1000 , (GtkFunction) TOut , &inid);
		_Xt_ServeLoop
		if (inid)
			gtk_timeout_remove(inid);
#endif
	}
	else sleep(s);
}
#endif

void my_msleep(ms)
unsigned int ms;
{
#ifdef X_FACE
	XtIntervalId inid;
#endif
#ifdef GTK_FACE
	gint inid;
#endif

#ifdef I_FACE
	if (cfg.xi_face)
	{
#ifdef X_FACE
		inid = XtAppAddTimeOut(cfg.X.app_context , ms , TOut , &inid);
		_Xt_ServeLoop
		if (inid)
			XtRemoveTimeOut(inid);
#endif
#ifdef GTK_FACE
		inid = gtk_timeout_add(ms , (GtkFunction) TOut , &inid);
		_Xt_ServeLoop
		if (inid)
			gtk_timeout_remove(inid);
#endif

	}
	else 
#endif
#ifdef HAVE_USLEEP
		usleep(ms * 1000);
#else
	{
		struct timeval tout;

		tout.tv_sec = ms / 1000;
		tout.tv_usec = (ms % 1000) * 1000;

		select(0 , NULL , NULL , NULL , &tout);
	}
#endif
}

int unlink_recursive(fn)
char *fn;
{
	struct stat estat;

	if (lstat(fn , &estat))
	{
		xperror(fn);
		return -1;
	}

	if (!S_ISDIR(estat.st_mode))
	{
		if (unlink(fn))
		{
			xperror(fn);
			return(-1);
		}	
	}
	else
	{
		DIR *dir;
		struct dirent *dent;
		char next_dir[PATH_MAX];

	        if (!(dir = opendir(fn)))
        	{
                	xperror(fn);
	                return -1;
        	}

	        while((dent = readdir(dir)))
        	{
                	sprintf(next_dir , "%s/%s" , fn , dent->d_name);
	                if (!strcmp(dent->d_name , ".")) continue;
        	        if (!strcmp(dent->d_name , "..")) continue;

			unlink_recursive(next_dir);
        	}

	        closedir(dir);

	        if (rmdir(fn))
	        {
	        	xperror(next_dir);
	        	return -1;
	        }
	}

	return 0;
}

int str_is_in_list(int casesensitive , char *str , ...)
{
	char *which;
	va_list	args;
	int found = FALSE;

	va_start(args , str);

	for (which = va_arg(args , char *) ; which ; which = va_arg(args , char *))
	{
		if (casesensitive ? !strcmp(str , which) : !strcasecmp(str , which))
		{
			found = TRUE;
			break;
		}		
	}

	va_end(args);

	return found;
}

int copy_fd_to_file(fd , filename)
int fd;
char *filename;
{
	char pom[32768];
	int len;
	int dfd;

	if ((dfd = open(filename , O_BINARY | O_WRONLY | O_CREAT , 
		S_IRUSR | S_IRGRP | S_IROTH | S_IWUSR)) < 0)
	{
		xperror(filename);
		return -1;
	}

	lseek(fd , 0 , SEEK_SET);
	while((len = read(fd , pom , sizeof(pom))) > 0)
	{
		if (len != write(dfd , pom , len))
			return -1;
	}

	close(dfd);

	lseek(fd , 0 , SEEK_END);

	return len;
}

void make_clean_dir(urlp)
url *urlp;
{
	char *p,*ustr;

	ustr = new_string(url_to_filename(urlp , FALSE));

	if (cfg.enable_info)
		dinfo_remove(ustr);

	p = strrchr(ustr , '/');
	if (p) *p = '\0';

	while (strlen(ustr) > strlen(cfg.cache_dir))
	{
		if (rmdir(ustr))
		{
			if (errno != ENOTEMPTY &&
				errno != ENOENT &&
				errno != EEXIST)
				xperror(ustr);
			break;
		}

		p = strrchr(ustr , '/');
		if (p) *p = '\0';
	}

	_free(ustr);
}

void pavuk_do_at_exit()
{
#ifdef I_FACE
	dns_server_kill();
#endif
        free_all();

	if (cfg.url_hash_tbl)
	{
		dlhash_free(cfg.url_hash_tbl);
		cfg.url_hash_tbl = NULL;
	}

	if (cfg.fn_hash_tbl)
	{
		dlhash_free(cfg.fn_hash_tbl);
		cfg.fn_hash_tbl = NULL;
	}

        dns_free_tab();
        cfg_free_params();
        while(cfg.request)
        {
                url_info_free((url_info*)cfg.request->data);
                cfg.request = dllist_remove_entry(cfg.request , cfg.request);
        }

#ifdef _WIN32
	if (isatty(0) && cfg.wait_on_exit)
	{
		printf(gettext("press any key to exit\n"));
		getc(stdin);
	}
#endif
}

char *tl_adjust_filename(path)
char *path;
{
	char *pom;
	char *p,*p2;
	int l,n;

	pom = _malloc(strlen(path)+1);

	p = pom;
#ifdef _WIN32
	l = strspn(path , "/");
	strncpy(p , path , l);
	p += l;
	*p = '\0';
	path += l;
#endif

	while(*path)
	{
		n = strspn(path , "/");
		path += n;
		l = strcspn(path , "/");
		if (n)
		{
			*p = '/';
			p++;
		}

		if (!*(path+l) && ((NAME_MAX - 4) < l))
		{
			strncpy(p, path + l - (NAME_MAX - 4), NAME_MAX - 4);
			p += NAME_MAX - 4;
		}
		else if (l > NAME_MAX)
		{
			strncpy(p , path , NAME_MAX);
			p += NAME_MAX;
		}
		else
		{
			strncpy(p , path , l);
			p += l;
		}
		path += l;
	}
	*p = '\0';

	n = strlen(pom);
	p = strrchr(pom , '/');

	while(p && (n > PATH_MAX))
	{
		*p = '\0';
		p2 = strrchr(pom , '/');

		if (p2)
		{
			strcpy(p2+1 , p+1);
			n -= p - p2;
		}
		p = p2;
	}
	return pom;
}

int tl_filename_needs_adjust(path)
char *path;
{
	int l;

	if (strlen(path) > PATH_MAX) return TRUE;

	while(*path)
	{
		path += strspn(path , "/");
		l = strcspn(path , "/");

		if (!*(path+l) && ((NAME_MAX - 4) < l))
			return TRUE;
		else if (l > NAME_MAX)
			return TRUE;
		path += l;
	}
	
	
	return FALSE;
}

int tl_is_dirname(path)
char *path;
{
	char *p = strrchr(path , '/');
	return (p && (*(p+1) == '\0'));
}

char *tl_str_append(str1, str2)
char *str1;
char *str2;
{
	int l1,l2;
	char *rv;

	l1 = str1 ? strlen(str1) : 0;
	l2 = strlen(str2);
	rv = _realloc(str1 , l1+l2+1);
	strcpy(rv+l1, str2);

	return rv;
}

char *tl_str_concat(char *str1, ...)
{
	char *p;
	va_list	args;
	int len;
	char *rv = str1;

	len = str1 ? strlen(str1) : 0;

	va_start(args , str1);

	for (p = va_arg(args , char *) ; p ; p = va_arg(args , char *))
	{
		int slen = strlen(p);

		rv = _realloc(rv, len+slen+1);
		strcpy(rv+len , p);
		len += slen;
	}

	va_end(args);

	return rv;
}

char *tl_data_concat_str(int *len, char *data, ...)
{
	char *p;
	va_list	args;
	char *rv = data;

	va_start(args , data);

	for (p = va_arg(args , char *) ; p ; p = va_arg(args , char *))
	{
		int slen = strlen(p);

		rv = _realloc(rv, *len+slen+1);
		strcpy(rv+*len , p);
		*len += slen;
	}

	va_end(args);

	return rv;
}

char *tl_data_concat_data(tlen, tdata, len, data)
int *tlen;
char *tdata;
int len;
char *data;
{
	tdata = _realloc(tdata, *tlen+len);
	memcpy(tdata + *tlen, data, len);
	*tlen += len;

	return tdata;
}

