/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "config.h"
#include "tools.h"

static char base64_etab[] =
"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
/*
static char sw_end(c)
{
	return ((c & 0x01) ? 0x80 : 0) | ((c & 0x02) ? 0x40 : 0) | 
		((c & 0x04) ? 0x20 : 0) | ((c & 0x8) ? 0x10 : 0) | 
		((c & 0x10) ? 0x08 : 0) | ((c & 0x20) ? 0x04 : 0) |
		((c & 0x40) ? 0x02 : 0) | ((c & 0x80) ? 0x01 : 0);
	
}

static char sw_6end(c)
{
	return ((c & 0x01) ? 0x20 : 0) | ((c & 0x02) ? 0x10 : 0) | 
		((c & 0x04) ? 0x08 : 0) | ((c & 0x8) ? 0x04 : 0) | 
		((c & 0x10) ? 0x02 : 0) | ((c & 0x20) ? 0x01 : 0);
	
}
*/

char *base64_encode(str)
char *str;
{
	char *outstr = (char *)_malloc((strlen(str)/3 + 1) * 4 + 1);
	char *instr = (char *)_malloc(strlen(str)+3);
	int idx=0,outidx=0;

	memset(instr , '\0' , strlen(str)+3);
	memset(outstr , '\0' , (strlen(str)/3 + 1) * 4 + 1);
	strcpy(instr,str);

	while(instr[idx])
	{
		if (idx % 3 == 0)
		{
			outstr[outidx] = base64_etab[(int)(instr[idx] >> 2)];
			outidx ++;
		}
		else if (idx % 3 == 1)
		{
			outstr[outidx] = base64_etab[(int)
				(((instr[idx - 1] << 4) & 0x30) | 
				((instr[idx] >> 4) & 0x0f))];
			outidx ++;
			
			outstr[outidx] = base64_etab[(int)
				(((instr[idx] << 2) & 0x3c) | 
				((instr[idx + 1] >> 6) & 0x03)) ];
			outidx ++;
		}
		else
		{
			outstr[outidx] = base64_etab[(int)(instr[idx] & 0x3f)];
			outidx ++;
		}
		idx ++;
	}
	if (idx % 3 == 1)
	{

			outstr[outidx] = base64_etab[(int)
				(((instr[idx - 1] << 4) & 0x30) | 
				((instr[idx] >> 4) & 0x0f))];
			outstr[outidx+1] = '=';
			outstr[outidx+2] = '=';

	}
	if (idx % 3 == 2)
	{
			outstr[outidx] = '=';
	}
	
	free(instr);
	return outstr;
}
