/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#ifndef _PulldownShellP_H_
#define _PulldownShellP_H_

#include	<X11/ShellP.h>
#include	<Nws/PulldownShell.h>
#include	<Nws/dimdefP.h>

#define  XtInheritGetInternalDimension ((get_internal_dimension_Proc) _XtInherit)
#define  XtInheritSetInternalDimension ((set_internal_dimension_Proc) _XtInherit)

typedef struct {
	get_internal_dimension_Proc	get_internal_dimension;
	set_internal_dimension_Proc	set_internal_dimension;
} PulldownShellClassPart;

typedef struct _PulldownShellClassRec {
	CoreClassPart		core_class;
	CompositeClassPart	composite_class;
	ShellClassPart		shell_class;
	OverrideShellClassPart	override_shell_class;
	PulldownShellClassPart	pulldownShell_class;
} PulldownShellClassRec;

extern PulldownShellClassRec pulldownShellClassRec;

typedef struct _PulldownShellPart {
	Cursor		cursor;
	int		box_type;
	int		box_width;
	int		box_intensity;
	Pixel		box_color;
	int		backing_store;
	/* private */
	Pixel		dark,light;
	Boolean		down_after_br;
	XtIntervalId    timer;
} PulldownShellPart;

typedef struct _PulldownShellRec {
	CorePart		core;
	CompositePart		composite;
	ShellPart		shell;
  	OverrideShellPart	override;
	PulldownShellPart	pulldownShell;
} PulldownShellRec;

#endif

