/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Locale;
import java.util.Objects;
import org.apache.wicket.Application;
import org.apache.wicket.IWicketInternalException;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.core.util.resource.locator.IResourceStreamLocator;
import org.apache.wicket.core.util.resource.locator.caching.CachingResourceStreamLocator;
import org.apache.wicket.markup.html.IPackageResourceGuard;
import org.apache.wicket.mock.MockWebRequest;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.PartWriterCallback;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.caching.IStaticCacheableResource;
import org.apache.wicket.resource.IScopeAwareTextResourceProcessor;
import org.apache.wicket.resource.ITextResourceCompressor;
import org.apache.wicket.response.StringResponse;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.resource.IFixedLocationResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.resource.ResourceStreamWrapper;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageResource
extends AbstractResource
implements IStaticCacheableResource {
    private static final Logger log = LoggerFactory.getLogger(PackageResource.class);
    private static final long serialVersionUID = 1L;
    private final String absolutePath;
    private final Locale locale;
    private final String path;
    private final String scopeName;
    private final String name;
    private final String style;
    private final String variation;
    private boolean compress = false;
    private boolean cachingEnabled = true;
    private String textEncoding = null;
    private boolean readBuffered = true;

    protected PackageResource(Class<?> scope, String name, Locale locale, String style, String variation) {
        this.absolutePath = Packages.absolutePath(scope, (String)name);
        String parentEscape = this.getParentFolderPlaceholder();
        this.path = !Strings.isEmpty((String)parentEscape) ? Strings.replaceAll((CharSequence)name, (CharSequence)"../", (CharSequence)(parentEscape + "/")).toString() : name;
        this.name = name;
        this.scopeName = scope.getName();
        this.locale = locale;
        this.style = style;
        this.variation = variation;
    }

    private Locale getCurrentLocale() {
        if (this.locale == null && Session.exists()) {
            return Session.get().getLocale();
        }
        return this.locale;
    }

    private String getCurrentStyle() {
        if (this.style == null && Session.exists()) {
            return Session.get().getStyle();
        }
        return this.style;
    }

    @Override
    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public void setCachingEnabled(boolean enabled) {
        this.cachingEnabled = enabled;
    }

    public String getTextEncoding() {
        return this.textEncoding;
    }

    public void setTextEncoding(String textEncoding) {
        this.textEncoding = textEncoding;
    }

    @Override
    public Serializable getCacheKey() {
        Class<?> scope = this.getScope();
        String currentStyle = this.getCurrentStyle();
        Locale currentLocale = this.getCurrentLocale();
        IResourceStream packageResource = Application.get().getResourceSettings().getResourceStreamLocator().locate(scope, this.absolutePath, currentStyle, this.variation, currentLocale, null, false);
        if (packageResource != null) {
            return new CacheKey(this.scopeName, this.absolutePath, currentLocale, currentStyle, this.variation);
        }
        return null;
    }

    public final Class<?> getScope() {
        return WicketObjects.resolveClass(this.scopeName);
    }

    public final String getName() {
        return this.name;
    }

    public final String getStyle() {
        return this.style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse resourceResponse = new AbstractResource.ResourceResponse();
        IResourceStream resourceStream = this.getResourceStream();
        if (resourceStream == null) {
            return this.sendResourceError(resourceResponse, 404, "Unable to find resource");
        }
        Instant lastModified = resourceStream.lastModifiedTime();
        resourceResponse.setLastModified(lastModified);
        if (resourceResponse.dataNeedsToBeWritten(attributes)) {
            String contentType = resourceStream.getContentType();
            if (contentType == null && Application.exists()) {
                contentType = Application.get().getMimeType(this.path);
            }
            resourceResponse.setContentType(contentType);
            resourceResponse.setTextEncoding(this.getTextEncoding());
            resourceResponse.setAcceptRange(AbstractResource.ContentRangeType.BYTES);
            try {
                InputStream inputStream = resourceStream.getInputStream();
                byte[] bytes = null;
                if (this.readBuffered) {
                    bytes = IOUtils.toByteArray((InputStream)inputStream);
                    resourceResponse.setContentLength(bytes.length);
                } else {
                    resourceResponse.setContentLength(resourceStream.length().bytes());
                }
                RequestCycle cycle = RequestCycle.get();
                Long startbyte = (Long)cycle.getMetaData(CONTENT_RANGE_STARTBYTE);
                Long endbyte = (Long)cycle.getMetaData(CONTENT_RANGE_ENDBYTE);
                PartWriterCallback partWriterCallback = new PartWriterCallback(bytes != null ? new ByteArrayInputStream(bytes) : inputStream, resourceResponse.getContentLength(), startbyte, endbyte);
                resourceResponse.setWriteCallback(partWriterCallback.setClose(!this.readBuffered));
            }
            catch (IOException e) {
                log.debug(e.getMessage(), (Throwable)e);
                AbstractResource.ResourceResponse resourceResponse2 = this.sendResourceError(resourceResponse, 500, "Unable to read resource stream");
                return resourceResponse2;
            }
            catch (ResourceStreamNotFoundException e) {
                log.debug(e.getMessage(), (Throwable)e);
                AbstractResource.ResourceResponse resourceResponse3 = this.sendResourceError(resourceResponse, 500, "Unable to open resource stream");
                return resourceResponse3;
            }
            finally {
                try {
                    if (this.readBuffered) {
                        IOUtils.close((Closeable)resourceStream);
                    }
                }
                catch (IOException e) {
                    log.warn("Unable to close the resource stream", (Throwable)e);
                }
            }
        }
        return resourceResponse;
    }

    protected byte[] processResponse(IResource.Attributes attributes, byte[] original) {
        return this.compressResponse(attributes, original);
    }

    protected byte[] compressResponse(IResource.Attributes attributes, byte[] original) {
        ITextResourceCompressor compressor = this.getCompressor();
        if (compressor != null && this.getCompress()) {
            try {
                String output;
                Charset charset = this.getProcessingEncoding();
                String nonCompressed = new String(original, charset);
                if (compressor instanceof IScopeAwareTextResourceProcessor) {
                    IScopeAwareTextResourceProcessor scopeAwareProcessor = (IScopeAwareTextResourceProcessor)compressor;
                    output = scopeAwareProcessor.process(nonCompressed, this.getScope(), this.name);
                } else {
                    output = compressor.compress(nonCompressed);
                }
                String textEncoding = this.getTextEncoding();
                Charset outputCharset = Strings.isEmpty((String)textEncoding) ? charset : Charset.forName(textEncoding);
                return output.getBytes(outputCharset);
            }
            catch (Exception e) {
                log.error("Error while compressing the content", (Throwable)e);
                return original;
            }
        }
        return original;
    }

    protected Charset getProcessingEncoding() {
        return StandardCharsets.UTF_8;
    }

    protected ITextResourceCompressor getCompressor() {
        return null;
    }

    private AbstractResource.ResourceResponse sendResourceError(AbstractResource.ResourceResponse resourceResponse, int errorCode, String errorMessage) {
        String msg = String.format("resource [path = %s, style = %s, variation = %s, locale = %s]: %s (status=%d)", this.absolutePath, this.style, this.variation, this.locale, errorMessage, errorCode);
        log.warn(msg);
        resourceResponse.setError(errorCode, errorMessage);
        return resourceResponse;
    }

    @Override
    public IResourceStream getResourceStream() {
        return this.internalGetResourceStream(this.getCurrentStyle(), this.getCurrentLocale());
    }

    public boolean getCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    private IResourceStream internalGetResourceStream(String style, Locale locale) {
        IResourceStreamLocator resourceStreamLocator = Application.get().getResourceSettings().getResourceStreamLocator();
        Object resourceStream = resourceStreamLocator.locate(this.getScope(), this.absolutePath, style, this.variation, locale, null, false);
        String realPath = this.absolutePath;
        if (resourceStream instanceof IFixedLocationResourceStream) {
            realPath = ((IFixedLocationResourceStream)resourceStream).locationAsString();
            if (realPath != null) {
                int index = realPath.indexOf(this.absolutePath);
                if (index != -1) {
                    realPath = realPath.substring(index);
                }
            } else {
                realPath = this.absolutePath;
            }
        }
        if (!this.accept(realPath)) {
            throw new PackageResourceBlockedException("Access denied to (static) package resource " + this.absolutePath + ". See IPackageResourceGuard");
        }
        if (resourceStream != null) {
            resourceStream = new ProcessingResourceStream((IResourceStream)resourceStream);
        }
        return resourceStream;
    }

    protected boolean accept(String path) {
        IPackageResourceGuard guard = Application.get().getResourceSettings().getPackageResourceGuard();
        return guard.accept(path);
    }

    public static boolean exists(ResourceReference.Key key) {
        return PackageResource.exists(key.getScopeClass(), key.getName(), key.getLocale(), key.getStyle(), key.getVariation());
    }

    public static boolean exists(Class<?> scope, String path, Locale locale, String style, String variation) {
        return PackageResource.getResourceStream(scope, path, locale, style, variation, true) != null;
    }

    public static IResourceStream getResourceStream(Class<?> scope, String path, Locale locale, String style, String variation, boolean updateCache) {
        String absolutePath = Packages.absolutePath(scope, (String)path);
        IResourceStreamLocator resourceStreamLocator = Application.get().getResourceSettings().getResourceStreamLocator();
        if (resourceStreamLocator instanceof CachingResourceStreamLocator) {
            CachingResourceStreamLocator cache = (CachingResourceStreamLocator)resourceStreamLocator;
            return cache.locate(scope, absolutePath, style, variation, locale, null, false, updateCache);
        }
        return resourceStreamLocator.locate(scope, absolutePath, style, variation, locale, null, false);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('[').append(Classes.simpleName(this.getClass())).append(' ').append("name = ").append(this.path).append(", scope = ").append(this.scopeName).append(", locale = ").append(this.locale).append(", style = ").append(this.style).append(", variation = ").append(this.variation).append(']');
        return result.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.absolutePath == null ? 0 : this.absolutePath.hashCode());
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.scopeName == null ? 0 : this.scopeName.hashCode());
        result = 31 * result + (this.style == null ? 0 : this.style.hashCode());
        result = 31 * result + (this.variation == null ? 0 : this.variation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PackageResource other = (PackageResource)obj;
        return Objects.equals(this.absolutePath, other.absolutePath) && Objects.equals(this.locale, other.locale) && Objects.equals(this.path, other.path) && Objects.equals(this.scopeName, other.scopeName) && Objects.equals(this.style, other.style) && Objects.equals(this.variation, other.variation);
    }

    String getParentFolderPlaceholder() {
        String parentFolderPlaceholder = Application.exists() ? Application.get().getResourceSettings().getParentFolderPlaceholder() : "..";
        return parentFolderPlaceholder;
    }

    public PackageResource readBuffered(boolean readBuffered) {
        this.readBuffered = readBuffered;
        return this;
    }

    private static class CacheKey
    implements Serializable {
        private final String scopeName;
        private final String path;
        private final Locale locale;
        private final String style;
        private final String variation;

        public CacheKey(String scopeName, String path, Locale locale, String style, String variation) {
            this.scopeName = scopeName;
            this.path = path;
            this.locale = locale;
            this.style = style;
            this.variation = variation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.locale, cacheKey.locale) && Objects.equals(this.path, cacheKey.path) && Objects.equals(this.scopeName, cacheKey.scopeName) && Objects.equals(this.style, cacheKey.style) && Objects.equals(this.variation, cacheKey.variation);
        }

        public int hashCode() {
            int result = this.scopeName.hashCode();
            result = 31 * result + this.path.hashCode();
            result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
            result = 31 * result + (this.style != null ? this.style.hashCode() : 0);
            result = 31 * result + (this.variation != null ? this.variation.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("CacheKey");
            sb.append("{scopeName='").append(this.scopeName).append('\'');
            sb.append(", path='").append(this.path).append('\'');
            sb.append(", locale=").append(this.locale);
            sb.append(", style='").append(this.style).append('\'');
            sb.append(", variation='").append(this.variation).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    private class ProcessingResourceStream
    extends ResourceStreamWrapper {
        private static final long serialVersionUID = 1L;

        private ProcessingResourceStream(IResourceStream delegate) {
            super(delegate);
        }

        public InputStream getInputStream() throws ResourceStreamNotFoundException {
            RequestCycle cycle;
            byte[] bytes = null;
            InputStream inputStream = super.getInputStream();
            if (PackageResource.this.readBuffered) {
                try {
                    bytes = IOUtils.toByteArray((InputStream)inputStream);
                }
                catch (IOException iox) {
                    throw new WicketRuntimeException(iox);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)((Object)this));
                }
            }
            IResource.Attributes attributes = (cycle = RequestCycle.get()) != null ? new IResource.Attributes(cycle.getRequest(), cycle.getResponse()) : new IResource.Attributes((Request)new MockWebRequest(Url.parse((CharSequence)"")), new StringResponse());
            if (bytes != null) {
                byte[] processedBytes = PackageResource.this.processResponse(attributes, bytes);
                return new ByteArrayInputStream(processedBytes);
            }
            return inputStream;
        }
    }

    public static final class PackageResourceBlockedException
    extends WicketRuntimeException
    implements IWicketInternalException {
        private static final long serialVersionUID = 1L;

        public PackageResourceBlockedException(String message) {
            super(message);
        }
    }
}

