/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.resource.locator.caching;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.core.util.resource.UrlResourceStream;
import org.apache.wicket.core.util.resource.locator.IResourceNameIterator;
import org.apache.wicket.core.util.resource.locator.IResourceStreamLocator;
import org.apache.wicket.core.util.resource.locator.caching.FileResourceStreamReference;
import org.apache.wicket.core.util.resource.locator.caching.IResourceStreamReference;
import org.apache.wicket.core.util.resource.locator.caching.NullResourceStreamReference;
import org.apache.wicket.core.util.resource.locator.caching.UrlResourceStreamReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.FileResourceStream;
import org.apache.wicket.util.resource.IResourceStream;

public class CachingResourceStreamLocator
implements IResourceStreamLocator {
    private final ConcurrentMap<CacheKey, IResourceStreamReference> cache;
    private final IResourceStreamLocator delegate;

    public CachingResourceStreamLocator(IResourceStreamLocator resourceStreamLocator) {
        Args.notNull((Object)resourceStreamLocator, (String)"resourceStreamLocator");
        this.delegate = resourceStreamLocator;
        this.cache = new ConcurrentHashMap<CacheKey, IResourceStreamReference>();
    }

    @Override
    public IResourceStream locate(Class<?> clazz, String path) {
        IResourceStream result;
        CacheKey key = new CacheKey(clazz.getName(), path, null, null, null, null, true);
        IResourceStreamReference resourceStreamReference = (IResourceStreamReference)this.cache.get(key);
        if (resourceStreamReference == null) {
            result = this.delegate.locate(clazz, path);
            this.updateCache(key, result);
        } else {
            result = resourceStreamReference.getReference();
        }
        return result;
    }

    private void updateCache(CacheKey key, IResourceStream stream) {
        if (null == stream) {
            this.cache.put(key, NullResourceStreamReference.INSTANCE);
        } else if (stream instanceof FileResourceStream) {
            FileResourceStream fileResourceStream = (FileResourceStream)stream;
            this.cache.put(key, new FileResourceStreamReference(fileResourceStream));
        } else if (stream instanceof UrlResourceStream) {
            UrlResourceStream urlResourceStream = (UrlResourceStream)stream;
            this.cache.put(key, new UrlResourceStreamReference(urlResourceStream));
        }
    }

    @Override
    public IResourceStream locate(Class<?> scope, String path, String style, String variation, Locale locale, String extension, boolean strict) {
        return this.locate(scope, path, style, variation, locale, extension, strict, true);
    }

    public IResourceStream locate(Class<?> scope, String path, String style, String variation, Locale locale, String extension, boolean strict, boolean updateCache) {
        IResourceStream result;
        CacheKey key = new CacheKey(scope.getName(), path, extension, locale, style, variation, strict);
        IResourceStreamReference resourceStreamReference = (IResourceStreamReference)this.cache.get(key);
        if (resourceStreamReference == null) {
            result = this.delegate.locate(scope, path, style, variation, locale, extension, strict);
            if (updateCache) {
                this.updateCache(key, result);
            }
        } else {
            result = resourceStreamReference.getReference();
        }
        return result;
    }

    @Override
    public IResourceNameIterator newResourceNameIterator(String path, Locale locale, String style, String variation, String extension, boolean strict) {
        return this.delegate.newResourceNameIterator(path, locale, style, variation, extension, strict);
    }

    public void clearCache() {
        this.cache.clear();
    }

    private static class CacheKey
    extends ResourceReference.Key {
        private static final long serialVersionUID = 1L;
        private final String extension;
        private final boolean strict;

        private CacheKey(String scope, String name, String extension, Locale locale, String style, String variation, boolean strict) {
            super(scope, name, locale, style, variation);
            this.extension = extension;
            this.strict = strict;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.extension == null ? 0 : this.extension.hashCode());
            result = 31 * result + (this.strict ? 1231 : 1237);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.extension == null ? other.extension != null : !this.extension.equals(other.extension)) {
                return false;
            }
            return this.strict == other.strict;
        }
    }
}

