/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.QualifiedDBIdentifier;
import org.apache.openjpa.jdbc.schema.ReferenceCounter;
import org.apache.openjpa.jdbc.schema.Table;

public abstract class Constraint
extends ReferenceCounter {
    private static final long serialVersionUID = 1L;
    private DBIdentifier _name = DBIdentifier.NULL;
    private QualifiedDBIdentifier _fullPath = null;
    private Table _table = null;
    private DBIdentifier _tableName = DBIdentifier.NULL;
    private DBIdentifier _schemaName = DBIdentifier.NULL;
    private DBIdentifier _columnName = DBIdentifier.NULL;
    private boolean _deferred = false;

    Constraint() {
    }

    @Deprecated
    Constraint(String name, Table table) {
        this(DBIdentifier.newConstant(name), table);
    }

    Constraint(DBIdentifier name, Table table) {
        this.setIdentifier(name);
        if (table != null) {
            this.setTableIdentifier(table.getIdentifier());
            this.setSchemaIdentifier(table.getSchemaIdentifier());
        }
        this._table = table;
    }

    void remove() {
        this._table = null;
    }

    public Table getTable() {
        return this._table;
    }

    @Deprecated
    public String getTableName() {
        return this.getTableIdentifier().getName();
    }

    public DBIdentifier getTableIdentifier() {
        return this._tableName == null ? DBIdentifier.NULL : this._tableName;
    }

    @Deprecated
    public void setTableName(String name) {
        this.setTableIdentifier(DBIdentifier.newTable(name));
    }

    public void setTableIdentifier(DBIdentifier name) {
        if (this.getTable() != null) {
            throw new IllegalStateException();
        }
        this._tableName = name;
        this._fullPath = null;
    }

    @Deprecated
    public String getSchemaName() {
        return this.getSchemaIdentifier().getName();
    }

    public DBIdentifier getSchemaIdentifier() {
        return this._schemaName == null ? DBIdentifier.NULL : this._schemaName;
    }

    @Deprecated
    public void setSchemaName(String schema) {
        this.setSchemaIdentifier(DBIdentifier.newSchema(schema));
    }

    public void setSchemaIdentifier(DBIdentifier schema) {
        if (this.getTable() != null) {
            throw new IllegalStateException();
        }
        this._schemaName = schema;
    }

    @Deprecated
    public String getColumnName() {
        return this.getColumnIdentifier().getName();
    }

    public DBIdentifier getColumnIdentifier() {
        return this._columnName == null ? DBIdentifier.NULL : this._columnName;
    }

    @Deprecated
    public void setColumnName(String name) {
        this.setColumnIdentifier(DBIdentifier.newColumn(name));
    }

    public void setColumnIdentifier(DBIdentifier name) {
        if (this.getTable() != null) {
            throw new IllegalStateException();
        }
        this._columnName = name;
    }

    @Deprecated
    public String getName() {
        return this.getIdentifier().getName();
    }

    public DBIdentifier getIdentifier() {
        return this._name == null ? DBIdentifier.NULL : this._name;
    }

    @Deprecated
    public void setName(String name) {
        this.setIdentifier(DBIdentifier.newConstraint(name));
    }

    public void setIdentifier(DBIdentifier name) {
        if (this.getTable() != null) {
            throw new IllegalStateException();
        }
        this._name = name;
        this._fullPath = null;
    }

    @Deprecated
    public String getFullName() {
        return this.getFullIdentifier().getName();
    }

    public QualifiedDBIdentifier getQualifiedPath() {
        if (this._fullPath == null) {
            this._fullPath = QualifiedDBIdentifier.newPath(this.getTableIdentifier(), this.getIdentifier());
        }
        return this._fullPath;
    }

    public DBIdentifier getFullIdentifier() {
        return this.getQualifiedPath().getIdentifier();
    }

    public abstract boolean isLogical();

    public boolean isDeferred() {
        return this._deferred;
    }

    public void setDeferred(boolean deferred) {
        this._deferred = deferred;
    }

    public String toString() {
        if (!this.getIdentifier().isNull()) {
            return this.getIdentifier().getName();
        }
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        return "<" + name.toLowerCase() + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Constraint that = (Constraint)o;
        if (this._deferred != that._deferred) {
            return false;
        }
        if (this._name != null ? !this._name.equals(that._name) : that._name != null) {
            return false;
        }
        if (this._fullPath != null ? !this._fullPath.equals(that._fullPath) : that._fullPath != null) {
            return false;
        }
        if (this._table != null ? !this._table.equals(that._table) : that._table != null) {
            return false;
        }
        if (this._tableName != null ? !this._tableName.equals(that._tableName) : that._tableName != null) {
            return false;
        }
        if (this._schemaName != null ? !this._schemaName.equals(that._schemaName) : that._schemaName != null) {
            return false;
        }
        return this._columnName != null ? this._columnName.equals(that._columnName) : that._columnName == null;
    }

    public int hashCode() {
        int result = this._name != null ? this._name.hashCode() : 0;
        result = 31 * result + (this._fullPath != null ? this._fullPath.hashCode() : 0);
        result = 31 * result + (this._table != null ? this._table.hashCode() : 0);
        result = 31 * result + (this._tableName != null ? this._tableName.hashCode() : 0);
        result = 31 * result + (this._schemaName != null ? this._schemaName.hashCode() : 0);
        result = 31 * result + (this._columnName != null ? this._columnName.hashCode() : 0);
        result = 31 * result + (this._deferred ? 1 : 0);
        return result;
    }
}

