<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

## Change Log

### 2.1.0 (Thu Mar 16 21:13:05 2023 -0700)

**Database Migrations**

- [#23139](https://github.com/apache/superset/pull/23139) fix: memoized decorator memory leak (@dpgaspar)
- [#19676](https://github.com/apache/superset/pull/19676) chore(frontend): Spelling (@jsoref)
- [#22852](https://github.com/apache/superset/pull/22852) chore: removing unnecessary double spaces, a.k.a. "shotgun holes" (@rusackas)
- [#21912](https://github.com/apache/superset/pull/21912) feat(ssh-tunnelling): Setup SSH Tunneling Commands for Database Connections (@hughhhh)
- [#22248](https://github.com/apache/superset/pull/22248) chore: Add a migration that removes filter_bar_orientation from dashboard's json_metadata (@kgabryje)
- [#21417](https://github.com/apache/superset/pull/21417) fix(db-migration): new_dataset_models_take_2 error on postgres (@micsbot)
- [#21778](https://github.com/apache/superset/pull/21778) fix(migration): Ensure the paginated update is deterministic (@john-bodley)
- [#21682](https://github.com/apache/superset/pull/21682) feat(sqllab): save query parameters in database (@mayurnewase)
- [#21679](https://github.com/apache/superset/pull/21679) fix(migration): Catch DatabaseError to avoid migration crash with MySQL 8.0 (@qlands)
- [#20892](https://github.com/apache/superset/pull/20892) feat: Add dataset tagging to the back-end (@cccs-Dustin)
- [#21284](https://github.com/apache/superset/pull/21284) chore(sqllab): Cleanup /tables/... endpoint (@john-bodley)
- [#21101](https://github.com/apache/superset/pull/21101) fix(plugin-chart-table): Upgrade old color formats (@kgabryje)
- [#20936](https://github.com/apache/superset/pull/20936) chore(db): ensure query_context is MediumText before viz migration (@ktmud)
- [#20939](https://github.com/apache/superset/pull/20939) fix: skip row if created_at_fk is null (@eschutho)
- [#20552](https://github.com/apache/superset/pull/20552) feat(report): allow capturing dashboard reports in specific state (@ktmud)
- [#20617](https://github.com/apache/superset/pull/20617) fix: Add migration to add created_by_fk as explicit owner for charts and datasets (@john-bodley)
- [#20779](https://github.com/apache/superset/pull/20779) fix(db): set slices.query_context to MEDIUMTEXT for mysql (@ktmud)
- [#20761](https://github.com/apache/superset/pull/20761) fix(db): use paginated_update for viz migration (@ktmud)
- [#19890](https://github.com/apache/superset/pull/19890) chore: upgrade SQLAlchemy to 1.4 (@betodealmeida)
- [#20359](https://github.com/apache/superset/pull/20359) feat: Area viz migration (@zhaoyongjie)
- [#20641](https://github.com/apache/superset/pull/20641) fix: migration revisions from #19532 (@dpgaspar)
- [#20346](https://github.com/apache/superset/pull/20346) feat: TreeMap migration (@zhaoyongjie)
- [#19532](https://github.com/apache/superset/pull/19532) feat(database): Add user_id and dttm composite index to Log model. (@xneg)
- [#19983](https://github.com/apache/superset/pull/19983) feat: save active tabs in dashboard permalink (@ktmud)
- [#20492](https://github.com/apache/superset/pull/20492) refactor: Cleanup user get_id/get_user_id (@john-bodley)
- [#20484](https://github.com/apache/superset/pull/20484) fix: migration revision order (@dpgaspar)
- [#20449](https://github.com/apache/superset/pull/20449) fix: RLS new db migration downgrade fails on SQLite (@dpgaspar)
- [#20432](https://github.com/apache/superset/pull/20432) feat: add name, description and non null tables to RLS (@dpgaspar)

**Features**

- [#22713](https://github.com/apache/superset/pull/22713) feat(helm): allow persisting nodePort for services (@rajan123456)
- [#23040](https://github.com/apache/superset/pull/23040) feat(sqllab): Add event logger (@justinpark)
- [#22670](https://github.com/apache/superset/pull/22670) feat(datasets): Populate Usage tab in Edit Dataset view (@codyml)
- [#22967](https://github.com/apache/superset/pull/22967) feat(ssh_tunnel): SSH Tunnel Switch extension (@Antonio-RiveroMartnez)
- [#22043](https://github.com/apache/superset/pull/22043) feat: add tabs to edit dataset page (@pkdotson)
- [#22835](https://github.com/apache/superset/pull/22835) feat: Enable new dataset creation flow II (@lyndsiWilliams)
- [#22854](https://github.com/apache/superset/pull/22854) feat(helm): Make Chart.AppVersion default value for image tag (@dnskr)
- [#22833](https://github.com/apache/superset/pull/22833) feat: Adds the ECharts Sunburst chart (@michael-s-molina)
- [#20291](https://github.com/apache/superset/pull/20291) feat: add pyproject.toml file to project (@leo-schick)
- [#22006](https://github.com/apache/superset/pull/22006) feat: Add excel export (@igorsinc)
- [#22805](https://github.com/apache/superset/pull/22805) feat(ssh_tunnel): Add feature flag to SSH Tunnel API (@Antonio-RiveroMartnez)
- [#22785](https://github.com/apache/superset/pull/22785) feat: Move cross filters to Dashboard (@geido)
- [#22806](https://github.com/apache/superset/pull/22806) feat: export/import `allow_dml` flag (@betodealmeida)
- [#22827](https://github.com/apache/superset/pull/22827) feat(helm): Add ability to customize affinity per deployment (@sergeyshevch)
- [#22770](https://github.com/apache/superset/pull/22770) feat(docker): Build multiple python version images (@Germandrummer92)
- [#22689](https://github.com/apache/superset/pull/22689) feat: add ssh tunneling to dynamic form for Database Connection UI (@hughhhh)
- [#22776](https://github.com/apache/superset/pull/22776) feat: Adds a separator to Select All option (@michael-s-molina)
- [#22707](https://github.com/apache/superset/pull/22707) feat: Generic X-axis improvements (@michael-s-molina)
- [#22084](https://github.com/apache/superset/pull/22084) feat: Select all for synchronous select (@cccs-RyanK)
- [#22723](https://github.com/apache/superset/pull/22723) feat(ssh_tunnel): Rename allow_ssh_tunneling and change the default value to False (@Antonio-RiveroMartnez)
- [#22610](https://github.com/apache/superset/pull/22610) feat: Enable new dataset creation flow (@lyndsiWilliams)
- [#21625](https://github.com/apache/superset/pull/21625) feat(plugin-chart-echarts): supports sunburst chart v2 [WIP] (@stephenLYZ)
- [#22737](https://github.com/apache/superset/pull/22737) feat: Updates button styles of Modal pre-defined functions (@michael-s-molina)
- [#22625](https://github.com/apache/superset/pull/22625) feat: Add logging for ssh tunneling test_connection attempts (@hughhhh)
- [#21645](https://github.com/apache/superset/pull/21645) feat(charts): allow query mutator to update queries after splitting original sql (@solanksh)
- [#22513](https://github.com/apache/superset/pull/22513) feat(ssh_tunnel): SQLAlchemy Form UI (@Antonio-RiveroMartnez)
- [#19779](https://github.com/apache/superset/pull/19779) feat: make CTA text in Alerts & Reports mails configurable (@cemremengu)
- [#22588](https://github.com/apache/superset/pull/22588) feat(dashboard): Display a loading spinner while dashboard is being saved (@kgabryje)
- [#22325](https://github.com/apache/superset/pull/22325) feat(RLS): RESTful apis and react view for RLS (@mayurnewase)
- [#21325](https://github.com/apache/superset/pull/21325) feat(db_engine_specs): big query cost estimation (@zamar-roura)
- [#22541](https://github.com/apache/superset/pull/22541) feat(helm): add deploymentLabels variable (@mathieuherbert)
- [#22526](https://github.com/apache/superset/pull/22526) feat(rbac): add customizable related filters (@villebro)
- [#22589](https://github.com/apache/superset/pull/22589) feat(chart): Added Papua New Guinea to countries map (@wilfred-wulbou)
- [#22498](https://github.com/apache/superset/pull/22498) feat(trino): support early cancellation of queries (@villebro)
- [#22458](https://github.com/apache/superset/pull/22458) feat: update time comparison choices (again) (@john-bodley)
- [#22302](https://github.com/apache/superset/pull/22302) feat(welcome): make examples tab customizable (@villebro)
- [#22328](https://github.com/apache/superset/pull/22328) feat(thumbnails): add support for user specific thumbs (@villebro)
- [#22379](https://github.com/apache/superset/pull/22379) feat: Add oneLine mode to AsyncSelect (@kgabryje)
- [#22364](https://github.com/apache/superset/pull/22364) feat(dashboard): Add edit button to dashboard native filters filter cards (@codyml)
- [#21318](https://github.com/apache/superset/pull/21318) feat(explore-popover): Show disabled 'Save' button in explore popover (@agl-developer)
- [#22136](https://github.com/apache/superset/pull/22136) feat: Flow for tables that already have a dataset (@lyndsiWilliams)
- [#22317](https://github.com/apache/superset/pull/22317) feat: New time range label (@kgabryje)
- [#21573](https://github.com/apache/superset/pull/21573) feat: add databricks form (@eschutho)
- [#22276](https://github.com/apache/superset/pull/22276) feat: Programmatically open "more filters" dropdown in Horizontal Filter Bar (@geido)
- [#22188](https://github.com/apache/superset/pull/22188) feat: root context provider extension point (@diegomedina248)
- [#22273](https://github.com/apache/superset/pull/22273) feat(native-filters): Adjust filter components for horizontal mode (@kgabryje)
- [#22287](https://github.com/apache/superset/pull/22287) feat: Automatically closes the DropdownContainer when scrolling outside of the component (@michael-s-molina)
- [#22250](https://github.com/apache/superset/pull/22250) feat: Adds overflow to the DropdownContainer popover (@michael-s-molina)
- [#22173](https://github.com/apache/superset/pull/22173) feat: Uses new table component in Drill to Detail (@michael-s-molina)
- [#22123](https://github.com/apache/superset/pull/22123) feat: add risingwave.py in db engine specs (@BowenXiao1999)
- [#21992](https://github.com/apache/superset/pull/21992) feat: CSV File Upload form updates (Grouping with Collapse/Expand) (@Antonio-RiveroMartnez)
- [#21993](https://github.com/apache/superset/pull/21993) feat: Axis sort in the Bar Chart V2 (@zhaoyongjie)
- [#22135](https://github.com/apache/superset/pull/22135) feat: Adds virtualization option to antd based Table component (@eric-briscoe)
- [#22220](https://github.com/apache/superset/pull/22220) feat(chart): Added Latvia to countries map (@maleksan)
- [#22169](https://github.com/apache/superset/pull/22169) feat: Make filters and dividers display horizontally in horizontal native filters filter bar (@codyml)
- [#21922](https://github.com/apache/superset/pull/21922) feat: CSV File Upload form updates (@Antonio-RiveroMartnez)
- [#22064](https://github.com/apache/superset/pull/22064) feat: Horizontal filter bar states (@geido)
- [#22160](https://github.com/apache/superset/pull/22160) feat: auto select schema (@betodealmeida)
- [#22039](https://github.com/apache/superset/pull/22039) feat: use a new official CH driver: clickhouse-connect (@EugeneTorap)
- [#21943](https://github.com/apache/superset/pull/21943) feat: refactor all `get_sqla_engine` to use contextmanager in codebase (@hughhhh)
- [#22077](https://github.com/apache/superset/pull/22077) feat: Add a new database driver for Amazon DynamoDB (@passren)
- [#21948](https://github.com/apache/superset/pull/21948) feat: Integrate ant d table component into DatasetPanel (@eric-briscoe)
- [#21520](https://github.com/apache/superset/pull/21520) feat: create table component based on ant design Table (@eric-briscoe)
- [#22020](https://github.com/apache/superset/pull/22020) feat(helm): add `metadata namespace` (@waynewenswag)
- [#21819](https://github.com/apache/superset/pull/21819) feat(dashboard): confirm overwrite to prevent unintended changes (@justinpark)
- [#22027](https://github.com/apache/superset/pull/22027) feat: Add 3 new extension points for inserting custom icons (@jfrag1)
- [#21895](https://github.com/apache/superset/pull/21895) feat: Improves SafeMarkdown HTML sanitization (@michael-s-molina)
- [#22031](https://github.com/apache/superset/pull/22031) feat: Adds more customization properties to DropdownContainer (@michael-s-molina)
- [#22004](https://github.com/apache/superset/pull/22004) feat(dashboard): Support changing filter bar location (@kgabryje)
- [#21974](https://github.com/apache/superset/pull/21974) feat: Adds the DropdownContainer component (@michael-s-molina)
- [#21767](https://github.com/apache/superset/pull/21767) feat: support multiple temporal filters in AdhocFilter and move the Time Section away (@zhaoyongjie)
- [#21955](https://github.com/apache/superset/pull/21955) feat: Selectable dropdown triggered by icon component (@geido)
- [#21931](https://github.com/apache/superset/pull/21931) feat(reports): execute as other than selenium user (@villebro)
- [#21806](https://github.com/apache/superset/pull/21806) feat(helm): Support for flower and websocket containers (@Yann-J)
- [#21924](https://github.com/apache/superset/pull/21924) feat(dashboard): Move dashboard auto refresh intervals options to config (@zhaorui2022)
- [#21838](https://github.com/apache/superset/pull/21838) feat(bigquery): Custom message when Service Account doesnt have the correct Roles and Permissions (@Antonio-RiveroMartnez)
- [#21935](https://github.com/apache/superset/pull/21935) feat: Adds the HORIZONTAL_FILTER_BAR feature flag (@michael-s-molina)
- [#21790](https://github.com/apache/superset/pull/21790) feat: create function for get_sqla_engine with context (@hughhhh)
- [#21530](https://github.com/apache/superset/pull/21530) feat(rightmenu): Add Datasets to + Menu and Hide Databases when one has been connected (@Antonio-RiveroMartnez)
- [#21893](https://github.com/apache/superset/pull/21893) feat: Add dataset visuals for when a table is selected (@lyndsiWilliams)
- [#21879](https://github.com/apache/superset/pull/21879) feat(explore): add config for default time filter (@Usiel)
- [#21351](https://github.com/apache/superset/pull/21351) feat(dashboard): menu improvements, fallback support for Drill to Detail (@codyml)
- [#21840](https://github.com/apache/superset/pull/21840) feat(datasets): Change in API to create virtual datasets (@sinhashubham95)
- [#20934](https://github.com/apache/superset/pull/20934) feat(explore): Don't discard controls with custom sql when changing datasource (@kgabryje)
- [#21867](https://github.com/apache/superset/pull/21867) feat(select filter): add CRLF separator for Windows (@mapledan)
- [#21507](https://github.com/apache/superset/pull/21507) feat(color): color consistency enhancements (@stephenLYZ)
- [#21760](https://github.com/apache/superset/pull/21760) feat: Cross-referenced Dashboards in Chart list (Column + Filter) (@geido)
- [#21319](https://github.com/apache/superset/pull/21319) feat(embedded-dashboard): Share Switchboard State for Sending Events from Plugins (@sinhashubham95)
- [#21486](https://github.com/apache/superset/pull/21486) feat: add denylist for db engines (@eschutho)
- [#20312](https://github.com/apache/superset/pull/20312) feat(api): Add option to enable sync on import (@reesercollins)
- [#21685](https://github.com/apache/superset/pull/21685) feat: Shows related dashboards in Explore (@michael-s-molina)
- [#21708](https://github.com/apache/superset/pull/21708) feat: Adds the CROSS_REFERENCE feature flag (@michael-s-molina)
- [#21713](https://github.com/apache/superset/pull/21713) feat: support None operand in EQUAL operator (@zhaoyongjie)
- [#21649](https://github.com/apache/superset/pull/21649) feat(chart): add feature flag that displays the data pane closed by default (@Painyjames)
- [#21683](https://github.com/apache/superset/pull/21683) feat: Use SPA navigation between AddSlice and Dataset list pages (@kgabryje)
- [#21664](https://github.com/apache/superset/pull/21664) feat: deprecate created_slices API endpoint (@dpgaspar)
- [#21352](https://github.com/apache/superset/pull/21352) feat: Added latin america countries to country map (@bryanjtc)
- [#21560](https://github.com/apache/superset/pull/21560) feat: Adds the MetadataBar to the Explore header (@michael-s-molina)
- [#21515](https://github.com/apache/superset/pull/21515) feat: new config to filter specific users from dropdown lists (@dpgaspar)
- [#21444](https://github.com/apache/superset/pull/21444) feat(embedded): +2 functions: getDashboardPermalink, getActiveTabs (@jayakrishnankk)
- [#21593](https://github.com/apache/superset/pull/21593) feat: explicit distribute columns on BoxPlot and apply time grain (@zhaoyongjie)
- [#21577](https://github.com/apache/superset/pull/21577) feat: adding XAxis to BigNumberTrend (@zhaoyongjie)
- [#21241](https://github.com/apache/superset/pull/21241) feat: Dataset Creation Footer Component (@AAfghahi)
- [#21518](https://github.com/apache/superset/pull/21518) feat: Increments charts endpoint with related dashboards (@michael-s-molina)
- [#21547](https://github.com/apache/superset/pull/21547) feat: support multiple columns with time grain in Table Chart (@zhaoyongjie)
- [#20931](https://github.com/apache/superset/pull/20931) feat(helm): add RollingUpdate parameters (@gforien)
- [#21537](https://github.com/apache/superset/pull/21537) feat: support multiple time columns with time grain in Pivot Table v2 (@zhaoyongjie)
- [#21213](https://github.com/apache/superset/pull/21213) feat(nav): Update Tabbed Nav on CRUD Pages (@Antonio-RiveroMartnez)
- [#21536](https://github.com/apache/superset/pull/21536) feat(helm): add annotations on ServiceAccount (@gforien)
- [#21519](https://github.com/apache/superset/pull/21519) feat: generate consistent QueryObject whether GenericAxis is enabled or disabled (@zhaoyongjie)
- [#21482](https://github.com/apache/superset/pull/21482) feat: Making bar graphs in Table viz from fixed-size divs instead of calculated gradients (@rusackas)
- [#21443](https://github.com/apache/superset/pull/21443) feat(filters): add onFilterUpdate handler to list view filters (@riahk)
- [#21189](https://github.com/apache/superset/pull/21189) feat: Create dataset header component (@lyndsiWilliams)
- [#21356](https://github.com/apache/superset/pull/21356) feat(plugin-chart-echarts): able to sort bar on the bar chart V2 (@stephenLYZ)
- [#21322](https://github.com/apache/superset/pull/21322) feat: add snowflake keypair authentication (@xiayanzheng)
- [#21343](https://github.com/apache/superset/pull/21343) feat: Adds MetadataBar to Drill to Detail modal (@michael-s-molina)
- [#21245](https://github.com/apache/superset/pull/21245) feat: Update nav bar with new data information architecture for SQL Lab + SQL (@hughhhh)
- [#21075](https://github.com/apache/superset/pull/21075) feat: add tableselector to dataset creation page (@pkdotson)
- [#21163](https://github.com/apache/superset/pull/21163) feat: apply Time Grain to X-Axis column (@zhaoyongjie)
- [#20837](https://github.com/apache/superset/pull/20837) feat: only show active user for chart/dashboard/datasource owner drop… (@zephyring)
- [#21321](https://github.com/apache/superset/pull/21321) feat(explore): standardized controls for time pivot chart (@stephenLYZ)
- [#21248](https://github.com/apache/superset/pull/21248) feat: filter parameters from DB API (@betodealmeida)
- [#21269](https://github.com/apache/superset/pull/21269) feat: Adds a helper text option to the Select component (@michael-s-molina)
- [#21300](https://github.com/apache/superset/pull/21300) feat(sqllab): Make LeftBar width resizable (@justinpark)
- [#21070](https://github.com/apache/superset/pull/21070) feat(embedded): provides filter bar visibility setting on embedded dashboard (#21069) (@jileeon)
- [#21199](https://github.com/apache/superset/pull/21199) feat: filter with created_by for charts and dashboards (@lilykuang)
- [#21236](https://github.com/apache/superset/pull/21236) feat(helm): Added env variable SERVER_WORKER_AMOUNT (@rathberm)
- [#20295](https://github.com/apache/superset/pull/20295) feat: Environment tag (@reesercollins)
- [#20309](https://github.com/apache/superset/pull/20309) feat: Virtual dataset duplication (@reesercollins)
- [#21168](https://github.com/apache/superset/pull/21168) feat: Adds drill to detail context menu to Table (@michael-s-molina)
- [#21198](https://github.com/apache/superset/pull/21198) feat: Adds drill to detail context menu to Pivot Table (@michael-s-molina)
- [#21170](https://github.com/apache/superset/pull/21170) feat: print comment for chromatic storybook link (@hughhhh)
- [#21095](https://github.com/apache/superset/pull/21095) feat: Add Chromatic publishing to superset-frontend storybook (@eric-briscoe)
- [#21150](https://github.com/apache/superset/pull/21150) feat: Adds drill to detail context menu to World Map (@michael-s-molina)
- [#21058](https://github.com/apache/superset/pull/21058) feat: Create dataset blank state (@lyndsiWilliams)
- [#20728](https://github.com/apache/superset/pull/20728) feat(dashboard): Add Drill to Detail modal w/ chart menu + right-click support (@codyml)
- [#21124](https://github.com/apache/superset/pull/21124) feat: generate label map on the backend (@zhaoyongjie)
- [#21040](https://github.com/apache/superset/pull/21040) feat: Add label and tooltip for the color schemes control (@geido)
- [#21116](https://github.com/apache/superset/pull/21116) feat: Allow users to set Tab Title from superset_config.py (@hughhhh)
- [#20903](https://github.com/apache/superset/pull/20903) feat: add header_data into emails (@AAfghahi)
- [#21090](https://github.com/apache/superset/pull/21090) feat: Adds the MetadataBar component (@michael-s-molina)
- [#21102](https://github.com/apache/superset/pull/21102) feat: update makefile with reports and alerts (@hughhhh)
- [#21033](https://github.com/apache/superset/pull/21033) feat: add extension point for workspace home page (@riahk)
- [#21035](https://github.com/apache/superset/pull/21035) feat(trino): add query cancellation (@villebro)
- [#20891](https://github.com/apache/superset/pull/20891) feat: Adds drill to detail context menu for ECharts visualizations (@michael-s-molina)
- [#20567](https://github.com/apache/superset/pull/20567) feat(helm): add liveness and readiness for deployment webserver (@jplanckeel)
- [#20990](https://github.com/apache/superset/pull/20990) feat: per-db add metrics (@betodealmeida)
- [#21008](https://github.com/apache/superset/pull/21008) feat: supports multiple filters in samples endpoint (@zhaoyongjie)
- [#20945](https://github.com/apache/superset/pull/20945) feat: useReducer for dataset creation (@AAfghahi)
- [#20835](https://github.com/apache/superset/pull/20835) feat: add 'dashboard.nav.right' extension to registry (@samtfm)
- [#20416](https://github.com/apache/superset/pull/20416) feat(embedded-SDK): enable CSV download (@lilykuang)
- [#20670](https://github.com/apache/superset/pull/20670) feat: Add resize drag handle to Dataset SQL fields (@diegomedina248)
- [#20869](https://github.com/apache/superset/pull/20869) feat: Creating dataset/add route (@AAfghahi)
- [#20852](https://github.com/apache/superset/pull/20852) feat(SqlLab): Change Save Dataset Button to Split Save Query Button IV (@lyndsiWilliams)
- [#20883](https://github.com/apache/superset/pull/20883) feat(helm): support different replicaCount (@gforien)
- [#20890](https://github.com/apache/superset/pull/20890) feat: Use SPA navigation from datasets list to Explore (@kgabryje)
- [#20908](https://github.com/apache/superset/pull/20908) feat: allow more HTML tags in report description (@ktmud)
- [#20528](https://github.com/apache/superset/pull/20528) feat(dashboard): Add thumbnails to dashboard edit draggable chart list (@codyml)
- [#20799](https://github.com/apache/superset/pull/20799) feat(sql lab): display presto and trino tracking url (@ktmud)
- [#20755](https://github.com/apache/superset/pull/20755) feat: blankstate metrics columns (@pkdotson)
- [#20842](https://github.com/apache/superset/pull/20842) feat: a simple LRUCache in frontend (@zhaoyongjie)
- [#20848](https://github.com/apache/superset/pull/20848) feat(explore): UX changes in fast viz switcher (@kgabryje)
- [#20743](https://github.com/apache/superset/pull/20743) feat: Pass dashboard context to explore through local storage (@kgabryje)
- [#20801](https://github.com/apache/superset/pull/20801) feat: Add Türkiye Map to Country Map (@rizacavus)
- [#20809](https://github.com/apache/superset/pull/20809) feat: Create Chart onClick Functionality (@AAfghahi)
- [#20683](https://github.com/apache/superset/pull/20683) feat: the samples endpoint supports filters and pagination (@zhaoyongjie)
- [#20778](https://github.com/apache/superset/pull/20778) feat(dashboard): Make FilterBar width resizable (@justinpark)
- [#20281](https://github.com/apache/superset/pull/20281) feat: Visualize SqlLab.Query model data in Explore 📈 (@hughhhh)
- [#20632](https://github.com/apache/superset/pull/20632) feat(dashboard): make permalinks stable (@ktmud)
- [#20668](https://github.com/apache/superset/pull/20668) feat: Reuse Dashboard redux data in Explore (@kgabryje)
- [#19965](https://github.com/apache/superset/pull/19965) feat: have user go to explore after dataset creation (@pkdotson)
- [#20666](https://github.com/apache/superset/pull/20666) feat(HelmChart): Add securityContext on pod level (@miloszbednarzak)
- [#20648](https://github.com/apache/superset/pull/20648) feat(handlebars plugin): adding handlebars helpers for common math/formatting operations (@rusackas)
- [#20606](https://github.com/apache/superset/pull/20606) feat(dashboard): Transition to Explore with React Router (@kgabryje)
- [#19383](https://github.com/apache/superset/pull/19383) feat: truncate long values in table viz, a per-column setting (@stevetracvc)
- [#20600](https://github.com/apache/superset/pull/20600) feat: add hooks on set_perm for new data permissions (@dpgaspar)
- [#20509](https://github.com/apache/superset/pull/20509) feat(HelmChart): Configurable securityContext in Pods (@miloszbednarzak)
- [#20017](https://github.com/apache/superset/pull/20017) feat: hack db connection modal ctabtns (@pkdotson)
- [#20586](https://github.com/apache/superset/pull/20586) feat: drop missing columns control (@zhaoyongjie)
- [#19520](https://github.com/apache/superset/pull/19520) feat(deck.gl): add color range for deck.gl 3D chart (@stephenLYZ)
- [#20512](https://github.com/apache/superset/pull/20512) feat(sql lab): Save Dataset Modal Autocomplete should display list when overwriting (@Antonio-RiveroMartnez)
- [#20575](https://github.com/apache/superset/pull/20575) feat: add extension point to the top of welcome page (@lilykuang)
- [#20579](https://github.com/apache/superset/pull/20579) feat: apply standardized form data to deckgl (@zhaoyongjie)
- [#20514](https://github.com/apache/superset/pull/20514) feat: add extension point to the right side of the menu bar (@samtfm)
- [#20530](https://github.com/apache/superset/pull/20530) feat: apply standardized form data to tier 2 charts (@zhaoyongjie)
- [#20524](https://github.com/apache/superset/pull/20524) feat(explore): Apply denormalization to tier 2 charts form data (@kgabryje)
- [#20513](https://github.com/apache/superset/pull/20513) feat(vizgallery): Double-click viz type to submit form (@codyml)
- [#20462](https://github.com/apache/superset/pull/20462) feat: add Spark Sql DB engine spec and support Spark 3.x (@SusurHe)
- [#20399](https://github.com/apache/superset/pull/20399) feat: Adds the /explore endpoint to the v1 API (@michael-s-molina)
- [#20056](https://github.com/apache/superset/pull/20056) feat(SQL Lab): Make SQL Lab explore use the default viz from the config file (@cccs-Dustin)
- [#20397](https://github.com/apache/superset/pull/20397) feat: Adds support for clearing the Select cache (@michael-s-molina)
- [#20251](https://github.com/apache/superset/pull/20251) feat(embedded): enforce allow domains (@lilykuang)
- [#20412](https://github.com/apache/superset/pull/20412) feat: allow setting db UUID (@betodealmeida)

**Fixes**

- [#23388](https://github.com/apache/superset/pull/23388) fix: update default WEBDRIVER_OPTION_ARGS and add Firefox libs to Dockerfile (@nytai)
- [#23299](https://github.com/apache/superset/pull/23299) fix(dashboard): Infinite load when filter with default first value is out of scope (@kgabryje)
- [#23238](https://github.com/apache/superset/pull/23238) fix(dashboard): Charts crashing when cross filter on adhoc column is applied (@kgabryje)
- [#23243](https://github.com/apache/superset/pull/23243) fix: customize tab on heatmap chart is blank (@lilykuang)
- [#23246](https://github.com/apache/superset/pull/23246) fix(dao): use explicit id filter (@villebro)
- [#23186](https://github.com/apache/superset/pull/23186) fix: refuse to start with default secret on non debug envs (@dpgaspar)
- [#23237](https://github.com/apache/superset/pull/23237) fix(dashboard): Don't show cross filters checkbox to users without write permissions (@kgabryje)
- [#23217](https://github.com/apache/superset/pull/23217) fix: add disallowed query params for engines specs (@dpgaspar)
- [#23190](https://github.com/apache/superset/pull/23190) fix(dashboard): Focusing charts and native filters from filters badge (@kgabryje)
- [#23192](https://github.com/apache/superset/pull/23192) fix(clickhouse): add missing default format (@villebro)
- [#23185](https://github.com/apache/superset/pull/23185) fix(clickhouse): add clickhouse connect driver (@villebro)
- [#23184](https://github.com/apache/superset/pull/23184) fix: bump FAB to 4.3.0 (@dpgaspar)
- [#23118](https://github.com/apache/superset/pull/23118) fix(rbac): show objects accessible by database access perm (@villebro)
- [#23175](https://github.com/apache/superset/pull/23175) fix(ssh-tunnel): add password to `from_private_key` function (@hughhhh)
- [#23195](https://github.com/apache/superset/pull/23195) fix(ssh_tunnel): Display SSHTunnel Switch when editing a DB that was created with the Dynamic Form (@Antonio-RiveroMartnez)
- [#23196](https://github.com/apache/superset/pull/23196) fix(sshtunnel): argument params to properly setting `server_port` (@hughhhh)
- [#23096](https://github.com/apache/superset/pull/23096) fix: reorganize role permissions (@dpgaspar)
- [#23107](https://github.com/apache/superset/pull/23107) fix: missing **init** on module sqllab commands (@dpgaspar)
- [#23101](https://github.com/apache/superset/pull/23101) fix: removing pyproject.toml (@zephyring)
- [#23093](https://github.com/apache/superset/pull/23093) fix: dict bug on QueryContextFactory (@okayhooni)
- [#23083](https://github.com/apache/superset/pull/23083) fix: css template permissions for gamma role (@dpgaspar)
- [#23012](https://github.com/apache/superset/pull/23012) fix: cache warmup solution non legacy charts. (@dheeraj-jaiswal-lowes)
- [#22968](https://github.com/apache/superset/pull/22968) fix(sqllab): Invalid schema fetch by deprecated value (@justinpark)
- [#22939](https://github.com/apache/superset/pull/22939) fix(i18n): improve Russian translation (@artemonsh)
- [#23039](https://github.com/apache/superset/pull/23039) fix: Menu items are not disappearing when deleting a dashboard (@michael-s-molina)
- [#23021](https://github.com/apache/superset/pull/23021) fix: Time Column on Generic X-axis (@michael-s-molina)
- [#21720](https://github.com/apache/superset/pull/21720) fix(dashboard): Stop updating chart owners for charts removed from dashboard (@codyml)
- [#22830](https://github.com/apache/superset/pull/22830) fix: Handles disabled options on Select All (@michael-s-molina)
- [#23006](https://github.com/apache/superset/pull/23006) fix(ssh_tunnel): Fix bug on database edition for databases with ssh tunnels (@Antonio-RiveroMartnez)
- [#23025](https://github.com/apache/superset/pull/23025) fix: dataset import error message (@dpgaspar)
- [#23020](https://github.com/apache/superset/pull/23020) fix(explore): Enable saving metric after changing title (@kgabryje)
- [#22990](https://github.com/apache/superset/pull/22990) fix(sqllab): clean unwanted scrollbar (@justinpark)
- [#22471](https://github.com/apache/superset/pull/22471) fix(dashboard): export & import chart description and certification details (@artemonsh)
- [#22991](https://github.com/apache/superset/pull/22991) fix(migrations): Flask-Migrate output is not logged during alembic migrations #17991 (@treygilliland)
- [#22947](https://github.com/apache/superset/pull/22947) fix: Make cte_alias a property of db engine spec (@alexclavel-ocient)
- [#23000](https://github.com/apache/superset/pull/23000) fix(explore): Save button incorrectly disabled when adding new metric with dnd (@kgabryje)
- [#22942](https://github.com/apache/superset/pull/22942) fix: add new config to allow for specific import data urls (@dpgaspar)
- [#22989](https://github.com/apache/superset/pull/22989) fix: Form data was not being passed to save/update slice (@michael-s-molina)
- [#22984](https://github.com/apache/superset/pull/22984) fix(explore): Mark time range dashboard filter with warning icon (@kgabryje)
- [#22982](https://github.com/apache/superset/pull/22982) fix: Prevents last temporal filter removal (@michael-s-molina)
- [#22941](https://github.com/apache/superset/pull/22941) fix(native-filters): Don't include description icon in truncation calc (@kgabryje)
- [#22943](https://github.com/apache/superset/pull/22943) fix(datasets): Include expression and description in duplicated dataset columns (@codyml)
- [#22896](https://github.com/apache/superset/pull/22896) fix(explore): unable to update linked charts (@justinpark)
- [#22945](https://github.com/apache/superset/pull/22945) fix(explore): Time comparison in Mixed Chart in GENERIC_CHART_AXES not working (@kgabryje)
- [#22929](https://github.com/apache/superset/pull/22929) fix: Improve performance of CSV download (@etr2460)
- [#22944](https://github.com/apache/superset/pull/22944) fix(datasets): Fix property selection on JSON response (@codyml)
- [#22940](https://github.com/apache/superset/pull/22940) fix: Remove button is broken for metrics on Explore (@michael-s-molina)
- [#22937](https://github.com/apache/superset/pull/22937) fix(native-filters): Ensure that time range filter loses focus after closing modal (@kgabryje)
- [#22912](https://github.com/apache/superset/pull/22912) fix: fix warning in ssh tunnel (@AAfghahi)
- [#22889](https://github.com/apache/superset/pull/22889) fix(fab): Fix regression on FAB dropdowns (@codyml)
- [#22920](https://github.com/apache/superset/pull/22920) fix: Time range filter applied on a dashboard is not persisting to the chart explore (@michael-s-molina)
- [#22744](https://github.com/apache/superset/pull/22744) fix(dependency): update cryptography import (@Germandrummer92)
- [#22036](https://github.com/apache/superset/pull/22036) fix(i18n): greatly optimize Chinese translation (@kpretty)
- [#21999](https://github.com/apache/superset/pull/21999) fix(sqllab): inconsistent addNewQueryEditor behavior (@justinpark)
- [#22881](https://github.com/apache/superset/pull/22881) fix: edit pyarrow stringify to better handle emojis and accents (@eschutho)
- [#22907](https://github.com/apache/superset/pull/22907) fix: bump isort to fix pre-commit CI (@EugeneTorap)
- [#22818](https://github.com/apache/superset/pull/22818) fix: revert RESTful apis and react view for RLS (@mayurnewase)
- [#22861](https://github.com/apache/superset/pull/22861) fix(sqllab): reverts #22695 (@justinpark)
- [#22872](https://github.com/apache/superset/pull/22872) fix: Convert TIMESTAMP\_\* to TIMESTAMP in Snowflake (@geido)
- [#22453](https://github.com/apache/superset/pull/22453) fix(Annotation Layers): Error when render options with renamed columns (@Always-prog)
- [#22791](https://github.com/apache/superset/pull/22791) fix(cpq): Add `schema` to Query.data() payload (@hughhhh)
- [#22813](https://github.com/apache/superset/pull/22813) fix(sqllab): type error on renderBigIntStr (@justinpark)
- [#22807](https://github.com/apache/superset/pull/22807) fix: allow CSV upload in Other db (@betodealmeida)
- [#22814](https://github.com/apache/superset/pull/22814) fix: Unexpected error on simple filter (@michael-s-molina)
- [#22794](https://github.com/apache/superset/pull/22794) fix(hive): Regression in #21794 (@john-bodley)
- [#22792](https://github.com/apache/superset/pull/22792) fix: better logic to extract errors on databricks (@eschutho)
- [#22695](https://github.com/apache/superset/pull/22695) fix(sqllab): Invalid schema fetch for deprecated value (@justinpark)
- [#22764](https://github.com/apache/superset/pull/22764) fix(ssh-tunnel): update fields for open tunnel with private + private key passwords (@hughhhh)
- [#16926](https://github.com/apache/superset/pull/16926) fix: Read MAPBOX_API_KEY from environment (@Lawful2002)
- [#22763](https://github.com/apache/superset/pull/22763) fix(ssh-tunnel): wrap pkey into StringIO buffer before creating the tunnel (@hughhhh)
- [#22727](https://github.com/apache/superset/pull/22727) fix: pass in slack error messages properly (@eschutho)
- [#22614](https://github.com/apache/superset/pull/22614) fix: Report screenshot cut off on left and right sides (@lyndsiWilliams)
- [#22698](https://github.com/apache/superset/pull/22698) fix: change order of webdriver timeout checks (@eschutho)
- [#21185](https://github.com/apache/superset/pull/21185) fix(async-queries): make global async. queries cookie SameSite option configurable (@rdubois)
- [#22671](https://github.com/apache/superset/pull/22671) fix: remove whitespace from http_path for databricks (@eschutho)
- [#22716](https://github.com/apache/superset/pull/22716) fix(helm): remove config overrides for CSRF (@reidab)
- [#22693](https://github.com/apache/superset/pull/22693) fix(explore): Restore missing dataset states (@codyml)
- [#22720](https://github.com/apache/superset/pull/22720) fix: bootstrapping frontend (@cdreier)
- [#22709](https://github.com/apache/superset/pull/22709) fix: Spacing in alert modal (@lyndsiWilliams)
- [#22688](https://github.com/apache/superset/pull/22688) fix: alert modal bug fix (@AAfghahi)
- [#22462](https://github.com/apache/superset/pull/22462) fix(embed): fix server error due to breaking change on flask-login (@Usiel)
- [#22609](https://github.com/apache/superset/pull/22609) fix(sqllab): Overflow bigint in json-tree view (@justinpark)
- [#22682](https://github.com/apache/superset/pull/22682) fix(nav): make doc and bug buttons customizable (@villebro)
- [#22659](https://github.com/apache/superset/pull/22659) fix(bootstrap-data): always check flashes (@villebro)
- [#22658](https://github.com/apache/superset/pull/22658) fix(viz-gallery): respect denylist in viz gallery (@villebro)
- [#22663](https://github.com/apache/superset/pull/22663) fix(dockerfile): fix "unhealthy" container state (@artemonsh)
- [#22635](https://github.com/apache/superset/pull/22635) fix: Stop query in SQL Lab with impala engine (@wanghong1314)
- [#22648](https://github.com/apache/superset/pull/22648) fix(dashboard): Add safety checks to areas that throw runtime errors in dashboard filters (@eric-briscoe)
- [#22566](https://github.com/apache/superset/pull/22566) fix(sqllab): remove link to sqllab if missing perms (@villebro)
- [#22628](https://github.com/apache/superset/pull/22628) fix: stringify ValueErrors for NaT types (@eschutho)
- [#22443](https://github.com/apache/superset/pull/22443) fix: change type of slack error (@eschutho)
- [#22457](https://github.com/apache/superset/pull/22457) fix(dashboard): Add runtime safety checks and improved tests (@eric-briscoe)
- [#22581](https://github.com/apache/superset/pull/22581) fix(ssh-tunnel): fix dataset creation flow through modal for DB with tunnel (@hughhhh)
- [#21772](https://github.com/apache/superset/pull/21772) fix: change example comment to match type (@eschutho)
- [#22586](https://github.com/apache/superset/pull/22586) fix: adding extraConfig to celery beat deployment (@cdreier)
- [#22358](https://github.com/apache/superset/pull/22358) fix: dashboard get by id or slug access filter (@dpgaspar)
- [#22591](https://github.com/apache/superset/pull/22591) fix: Talisman configuration (@michael-s-molina)
- [#22590](https://github.com/apache/superset/pull/22590) fix(helm): Fixing up chart and linting (@craig-rueda)
- [#22565](https://github.com/apache/superset/pull/22565) fix(explore): support saving undefined time grain (@villebro)
- [#22567](https://github.com/apache/superset/pull/22567) fix(cypress): make test chart time range deterministic (@villebro)
- [#22563](https://github.com/apache/superset/pull/22563) fix(websocket): bump ts-node to fix startup error (@villebro)
- [#22507](https://github.com/apache/superset/pull/22507) fix(localization): pybabel doesn't extract plural forms from frontend (@artemonsh)
- [#22523](https://github.com/apache/superset/pull/22523) fix: adding missing examples for bubble chart, bullet chart, calendar heatmap chart and country map chart in the gallery (@yash-samsung)
- [#22543](https://github.com/apache/superset/pull/22543) fix(explore): datasource_type typo (@Musa10)
- [#22314](https://github.com/apache/superset/pull/22314) fix(init): Initialize \_jwt_cookie_name in AsyncQueryManager **init** (@xneg)
- [#22512](https://github.com/apache/superset/pull/22512) fix(cypress): disable flaky tests (@villebro)
- [#22208](https://github.com/apache/superset/pull/22208) fix(assets api): import replaces dashboard (@Stanhoucke)
- [#22475](https://github.com/apache/superset/pull/22475) fix(chart-list): Hide 'Dashboards added to' column. (@codyml)
- [#22066](https://github.com/apache/superset/pull/22066) fix: Fixed spacing in alert modal (@lyndsiWilliams)
- [#22262](https://github.com/apache/superset/pull/22262) fix: Create dataset polish/bug fix (@lyndsiWilliams)
- [#22421](https://github.com/apache/superset/pull/22421) fix: fix comment in Docker environment files (@aleksvujic)
- [#22460](https://github.com/apache/superset/pull/22460) fix(cypress): Fix failing/flaky E2E tests (@codyml)
- [#22440](https://github.com/apache/superset/pull/22440) fix: remove unsupported REST API search col with dotted notation on c… (@dpgaspar)
- [#21064](https://github.com/apache/superset/pull/21064) fix(chart-table): Scrollbar causing header + footer overflow (@reesercollins)
- [#22431](https://github.com/apache/superset/pull/22431) fix(hive): Fix regression from #21943 (@john-bodley)
- [#22383](https://github.com/apache/superset/pull/22383) fix(dashboard): Update owners of dashboard list after editing (@hiroki-sawano)
- [#22417](https://github.com/apache/superset/pull/22417) fix: Force configuration for SafeMarkdown component in Handlebars (@geido)
- [#21737](https://github.com/apache/superset/pull/21737) fix(trino): Fix Trino timestamp conversion (@mdesmet)
- [#22405](https://github.com/apache/superset/pull/22405) fix(sqla): copy temporal range logic to helper (@villebro)
- [#21724](https://github.com/apache/superset/pull/21724) fix(report): Capture unexpected errors in report screenshots. Fixes #21653 (@zhaorui2022)
- [#22350](https://github.com/apache/superset/pull/22350) fix: make database connection modal ace fields uncontrolled (@eschutho)
- [#22381](https://github.com/apache/superset/pull/22381) fix: correct exception level in log and add error message (@eschutho)
- [#21965](https://github.com/apache/superset/pull/21965) fix: Update typo in docker-add-drivers.mdx (@jankatins)
- [#22361](https://github.com/apache/superset/pull/22361) fix: make sure that gsheets db connection form loads properly (@eschutho)
- [#19576](https://github.com/apache/superset/pull/19576) fix(readme): link target and title (@mikkeschiren)
- [#21942](https://github.com/apache/superset/pull/21942) fix(translations): French translation (typo fixes) (@xavier-GitHub76)
- [#22357](https://github.com/apache/superset/pull/22357) fix(snowflake): Allow encrypted_extra field to be imported (@askldjd)
- [#22365](https://github.com/apache/superset/pull/22365) fix: Button resizing in horizontal filter bar (@michael-s-molina)
- [#22373](https://github.com/apache/superset/pull/22373) fix: Add tooltip to dropdown trigger in horizontal filter bar (@kgabryje)
- [#22371](https://github.com/apache/superset/pull/22371) fix: DropdownContainer items width calculation (@michael-s-molina)
- [#22338](https://github.com/apache/superset/pull/22338) fix: Time filter position and click in Horizontal FilterBar (@geido)
- [#22360](https://github.com/apache/superset/pull/22360) fix: Change dropdown in Alert/Report modal to use javascript for conditional rendering instead of css (@lyndsiWilliams)
- [#22362](https://github.com/apache/superset/pull/22362) fix: Reordering native filters ignored by filter bar (@kgabryje)
- [#22349](https://github.com/apache/superset/pull/22349) fix(bigquery): Properly display errors for BigQuery DBs (@Antonio-RiveroMartnez)
- [#22324](https://github.com/apache/superset/pull/22324) fix: Broken effect in useCSSTextTruncation hook (@codyml)
- [#22346](https://github.com/apache/superset/pull/22346) fix: Missing spacing in adhoc filters popover (@kgabryje)
- [#22337](https://github.com/apache/superset/pull/22337) fix: Styling fixes for horizontal filter bar (@kgabryje)
- [#22329](https://github.com/apache/superset/pull/22329) fix(sqllab): Fix autocomplete for SQL Lab (@Antonio-RiveroMartnez)
- [#22320](https://github.com/apache/superset/pull/22320) fix: add columns back into SQL Lab to Explore Flow (@AAfghahi)
- [#22200](https://github.com/apache/superset/pull/22200) fix: Display Error Messages in DB Connection Modal (@AAfghahi)
- [#22319](https://github.com/apache/superset/pull/22319) fix(dashboard): Fix dashboard's left side being cut off (@kgabryje)
- [#22323](https://github.com/apache/superset/pull/22323) fix(dashboard): dashboard actions fail when bad component id exists in children array (@eric-briscoe)
- [#22318](https://github.com/apache/superset/pull/22318) fix: DropdownContainer resize algorithm (@michael-s-molina)
- [#22280](https://github.com/apache/superset/pull/22280) fix(sqla): use same template processor in all methods (@villebro)
- [#22321](https://github.com/apache/superset/pull/22321) fix: convert `<NA>` values to None instead of stringifying (@eschutho)
- [#22274](https://github.com/apache/superset/pull/22274) fix(alerts): cron picker alignment issues (@diegomedina248)
- [#22303](https://github.com/apache/superset/pull/22303) fix(docker): Fixing ws docker push (@craig-rueda)
- [#22009](https://github.com/apache/superset/pull/22009) fix(dashboard): chart doesn't resize when tab switch (@stephenLYZ)
- [#22286](https://github.com/apache/superset/pull/22286) fix: Horizontal filter bar resizing (@michael-s-molina)
- [#22288](https://github.com/apache/superset/pull/22288) fix(native-filters): Misc spacing fixes for horizontal and horizontal overflow filter bar items (@codyml)
- [#22289](https://github.com/apache/superset/pull/22289) fix(native-filters): Add empty text node before OutPortal (@codyml)
- [#22264](https://github.com/apache/superset/pull/22264) fix: allow datasource imports on Windows (@BTatlock)
- [#22252](https://github.com/apache/superset/pull/22252) fix(dashboard): Change horizontal filter bar divider truncation logic (@codyml)
- [#22265](https://github.com/apache/superset/pull/22265) fix(dashboard): Force native filters into vertical orientation when FF off (@codyml)
- [#22260](https://github.com/apache/superset/pull/22260) fix(dashboard): Fix FilterWithDataMask typing and add null check (@codyml)
- [#22249](https://github.com/apache/superset/pull/22249) fix(file_upload): Fix columnar and Excel upload forms (@Antonio-RiveroMartnez)
- [#22010](https://github.com/apache/superset/pull/22010) fix: Apply border radius and fix height for MetadataBar (@kgabryje)
- [#22211](https://github.com/apache/superset/pull/22211) fix(dashboard): Add correct icon, label and badge to horizontal native filters dropdown button (@codyml)
- [#22210](https://github.com/apache/superset/pull/22210) fix(dashboard): Fix hover labels for horizontal overflow native filter dividers (@codyml)
- [#22212](https://github.com/apache/superset/pull/22212) fix(dashboard): Fix filter card positioning for horizontal native filters (@codyml)
- [#22238](https://github.com/apache/superset/pull/22238) fix(generic-chart-axes): apply time filter on all target column types (@villebro)
- [#22234](https://github.com/apache/superset/pull/22234) fix: the TimePicker overlay the AdhocFilter (@zhaoyongjie)
- [#22196](https://github.com/apache/superset/pull/22196) fix(reports): force data generation in csv reports (@mayurnewase)
- [#22219](https://github.com/apache/superset/pull/22219) fix(explore): Prevent infinite rerenders when editing dataset (@kgabryje)
- [#22213](https://github.com/apache/superset/pull/22213) fix: (dashboard) Adds optional chaining to avoid runtime error (@eric-briscoe)
- [#22218](https://github.com/apache/superset/pull/22218) fix(plugin-chart-echarts): tooltip overflow bug (@villebro)
- [#22082](https://github.com/apache/superset/pull/22082) fix: Drill to detail blocked by tooltip (@michael-s-molina)
- [#22207](https://github.com/apache/superset/pull/22207) fix(explore): Value undefined and Unhashable type errors (@kgabryje)
- [#22186](https://github.com/apache/superset/pull/22186) fix: Empty Error Alert Modal (@AAfghahi)
- [#22171](https://github.com/apache/superset/pull/22171) fix: don't stringify extraJson in form (@eschutho)
- [#22179](https://github.com/apache/superset/pull/22179) fix: chart id mapping in dashboard api (@villebro)
- [#22172](https://github.com/apache/superset/pull/22172) fix: SQL Lab QuerySource via referrer (@john-bodley)
- [#22147](https://github.com/apache/superset/pull/22147) fix: Unhandled exception Str Column Type (@sinhashubham95)
- [#22170](https://github.com/apache/superset/pull/22170) fix: Adds time grain to Pivot Table v2 (@michael-s-molina)
- [#22152](https://github.com/apache/superset/pull/22152) fix: Flaky E2E tests (@geido)
- [#22167](https://github.com/apache/superset/pull/22167) fix(alerts): execute query as report executor (@villebro)
- [#22115](https://github.com/apache/superset/pull/22115) fix: Add scrollTopOnPagination property to Table (@geido)
- [#22118](https://github.com/apache/superset/pull/22118) fix: slug is empty if filename is non-ASCII (@EugeneTorap)
- [#22137](https://github.com/apache/superset/pull/22137) fix: Missing applied filters indicator (@john-bodley)
- [#22129](https://github.com/apache/superset/pull/22129) fix: add back database lookup from sip 68 revert (@eschutho)
- [#22013](https://github.com/apache/superset/pull/22013) fix(sqllab): Add templateParams on kv store (@justinpark)
- [#22081](https://github.com/apache/superset/pull/22081) fix: Right click on country map with code filter (@michael-s-molina)
- [#21794](https://github.com/apache/superset/pull/21794) fix(presto/trino): Ensure get_table_names only returns real tables (@john-bodley)
- [#22040](https://github.com/apache/superset/pull/22040) fix: accept only JSON credentials (@betodealmeida)
- [#21976](https://github.com/apache/superset/pull/21976) fix(native-filters): panels are collapsed when switch native filters (@stephenLYZ)
- [#22029](https://github.com/apache/superset/pull/22029) fix: JSON serializers (@john-bodley)
- [#22014](https://github.com/apache/superset/pull/22014) fix: Revert shared controls typing change. (@codyml)
- [#22011](https://github.com/apache/superset/pull/22011) fix: Change downloadAsImage to use Superset theme (@lyndsiWilliams)
- [#21996](https://github.com/apache/superset/pull/21996) fix: invalid float number format by json-bigint (@justinpark)
- [#21995](https://github.com/apache/superset/pull/21995) fix: bump gecko and mozilla in Dockerfile (@AAfghahi)
- [#21959](https://github.com/apache/superset/pull/21959) fix: rename datasource->dataset in error message (@mistercrunch)
- [#21968](https://github.com/apache/superset/pull/21968) fix: invalid float number format by json-bigint (@justinpark)
- [#21973](https://github.com/apache/superset/pull/21973) fix: bump expected npm version in superset-websocket (@gebhardtr)
- [#21946](https://github.com/apache/superset/pull/21946) fix: error_parsing (@AAfghahi)
- [#21960](https://github.com/apache/superset/pull/21960) fix: Adds logging for SPA route navigation with React router (@eric-briscoe)
- [#21944](https://github.com/apache/superset/pull/21944) fix: add form data for empty state control to save dataset (@pkdotson)
- [#21952](https://github.com/apache/superset/pull/21952) fix(explore): Small changes in metadata bar copy and tooltip placement (@kgabryje)
- [#21953](https://github.com/apache/superset/pull/21953) fix: small bump to shillelagh (@AAfghahi)
- [#21920](https://github.com/apache/superset/pull/21920) fix(explore): Chart save modal displays error instead of failing silently (@kgabryje)
- [#21877](https://github.com/apache/superset/pull/21877) fix(sqllab): wiped out unsaved changes by delayed actions (@justinpark)
- [#21941](https://github.com/apache/superset/pull/21941) fix: Most common flaky Cypress tests (@geido)
- [#21807](https://github.com/apache/superset/pull/21807) fix(dashboard): Remove bar at bottom of dashboard edit sidebar (@codyml)
- [#21936](https://github.com/apache/superset/pull/21936) fix: Crash caused by numpy.vectorize (@john-bodley)
- [#21937](https://github.com/apache/superset/pull/21937) fix: BIGINT rendering regression in chartAction (@justinpark)
- [#21923](https://github.com/apache/superset/pull/21923) fix: accept old database payload (@betodealmeida)
- [#21857](https://github.com/apache/superset/pull/21857) fix: Default temporal column in Datasource (@geido)
- [#21919](https://github.com/apache/superset/pull/21919) fix: time grain key from P0.25Y to P3M (@zhaoyongjie)
- [#21771](https://github.com/apache/superset/pull/21771) fix(sqllab): remove set state on component update lifecycle (@justinpark)
- [#21899](https://github.com/apache/superset/pull/21899) fix(sqllab): fix control x to stop query (@pkdotson)
- [#21921](https://github.com/apache/superset/pull/21921) fix: Ensure data cleanup in Cypress (@geido)
- [#21911](https://github.com/apache/superset/pull/21911) fix(superset): Fixed API for bulk delete of embedded dashboards (@sinhashubham95)
- [#21894](https://github.com/apache/superset/pull/21894) fix(dashboard): Ensure correct positioning of "Drill to detail by" submenu (@codyml)
- [#21878](https://github.com/apache/superset/pull/21878) fix: type of AnnotationLayer (@justinpark)
- [#21892](https://github.com/apache/superset/pull/21892) fix: Mistaken use of BootstrapUser type (@codyml)
- [#21876](https://github.com/apache/superset/pull/21876) fix: Change timer font to monospace (@lyndsiWilliams)
- [#21797](https://github.com/apache/superset/pull/21797) fix: docker links (@lucapette)
- [#21822](https://github.com/apache/superset/pull/21822) fix(dashboard): Prevent XSS attack vector (@agl-developer)
- [#21869](https://github.com/apache/superset/pull/21869) fix: categorical x-axis can't apply the label of column (@zhaoyongjie)
- [#21847](https://github.com/apache/superset/pull/21847) fix: custom SQL in the XAxis (@zhaoyongjie)
- [#21845](https://github.com/apache/superset/pull/21845) fix: drilling on the categorical xaxis on the mixed chart (@zhaoyongjie)
- [#21844](https://github.com/apache/superset/pull/21844) fix: drilling on the categorical xaxis on the stacked barchart v2 (@zhaoyongjie)
- [#21817](https://github.com/apache/superset/pull/21817) fix: Allow comma in Number Format (@geido)
- [#21770](https://github.com/apache/superset/pull/21770) fix: Dataset left panel now uses client side search (@lyndsiWilliams)
- [#21832](https://github.com/apache/superset/pull/21832) fix(sqllab): Fix spacing on Schedule option in SqlEditor dropdown (@lyndsiWilliams)
- [#21641](https://github.com/apache/superset/pull/21641) fix(superset-embedded-sdk): Buffer is not defined (@doornot)
- [#21765](https://github.com/apache/superset/pull/21765) fix(alerts): restrict list view and gamma perms (@villebro)
- [#21557](https://github.com/apache/superset/pull/21557) fix: Dataset creation header is now uneditable and holds proper default values (@lyndsiWilliams)
- [#21792](https://github.com/apache/superset/pull/21792) fix(explore): Persist URL params to form-data (@john-bodley)
- [#21779](https://github.com/apache/superset/pull/21779) fix(plugin-chart-handlebars): Update webpack/babel config to fix build/runtime warnings/errors (@codyml)
- [#21743](https://github.com/apache/superset/pull/21743) fix: Fix regression introduced in #20893 (@john-bodley)
- [#21785](https://github.com/apache/superset/pull/21785) fix: Preserve unknown URL params (@michael-s-molina)
- [#21782](https://github.com/apache/superset/pull/21782) fix: regression in #21766 (@zhaoyongjie)
- [#21442](https://github.com/apache/superset/pull/21442) fix(datasets): Stop showing alert when saving from query (@Antonio-RiveroMartnez)
- [#21698](https://github.com/apache/superset/pull/21698) fix(sqllab): Async queries are now fetched properly (@lyndsiWilliams)
- [#21741](https://github.com/apache/superset/pull/21741) fix(sqllab): resultset disappeared on switching tabs (@justinpark)
- [#21740](https://github.com/apache/superset/pull/21740) fix: Gsheets takes 2 clicks to save (@hughhhh)
- [#21707](https://github.com/apache/superset/pull/21707) fix(explore): chart link is broken without localStorage (@justinpark)
- [#21722](https://github.com/apache/superset/pull/21722) fix: Null values on Treemap right-click (@michael-s-molina)
- [#21710](https://github.com/apache/superset/pull/21710) fix: gsheets editing with dynamic forms (@hughhhh)
- [#21709](https://github.com/apache/superset/pull/21709) fix(database): Handle String errors in DatabaseModal (@Antonio-RiveroMartnez)
- [#21719](https://github.com/apache/superset/pull/21719) fix: Drill to detail formatted val on TableChart (@michael-s-molina)
- [#21696](https://github.com/apache/superset/pull/21696) fix: Pass slice_id in Explore get (@michael-s-molina)
- [#21697](https://github.com/apache/superset/pull/21697) fix: Right-click on misconfigured World Map (@michael-s-molina)
- [#21691](https://github.com/apache/superset/pull/21691) fix: add `get_column` function for Query obj (@hughhhh)
- [#21647](https://github.com/apache/superset/pull/21647) fix: Race conditions with setupExtensions (@geido)
- [#21667](https://github.com/apache/superset/pull/21667) fix(sqllab): async query broken due to #21320 (@justinpark)
- [#21680](https://github.com/apache/superset/pull/21680) fix(native-filters): Range filter max/min default display value (@kgabryje)
- [#21684](https://github.com/apache/superset/pull/21684) fix: add logging to alerts and reports to find non-triggering issues (@pkdotson)
- [#21446](https://github.com/apache/superset/pull/21446) fix: Allow clickhouse dbs with timestamps to visualize queries (@hughhhh)
- [#21317](https://github.com/apache/superset/pull/21317) fix(explore): Dashboard list is unsorted in save modal (@agl-developer)
- [#21632](https://github.com/apache/superset/pull/21632) fix(sqllab): perf regression on #21532 refactor (@justinpark)
- [#21570](https://github.com/apache/superset/pull/21570) fix: catch error when masking encrypted extra is none (@eschutho)
- [#21661](https://github.com/apache/superset/pull/21661) fix(plugin-chart-echarts): boxplot throw error in the dashboard (@stephenLYZ)
- [#21644](https://github.com/apache/superset/pull/21644) fix: time grain can't be removed in explore (@zhaoyongjie)
- [#21305](https://github.com/apache/superset/pull/21305) fix(dashboard): Change text and icons in dashboard editmode (@agl-developer)
- [#21662](https://github.com/apache/superset/pull/21662) fix: new welcome new users action (@stephenLYZ)
- [#21648](https://github.com/apache/superset/pull/21648) fix: Switch tab on drag hover (@michael-s-molina)
- [#21630](https://github.com/apache/superset/pull/21630) fix: Selected tab after save and go to dashboard (@michael-s-molina)
- [#21628](https://github.com/apache/superset/pull/21628) fix(sqllab): SqlEditorLeftBar listening to database changes (@Antonio-RiveroMartnez)
- [#21539](https://github.com/apache/superset/pull/21539) fix(dashboard): fix Pivot Table V2 dragPreview in the dashboard (@stephenLYZ)
- [#21501](https://github.com/apache/superset/pull/21501) fix(table-chart): don't color empty cells in table chart with color formatters (@mayurnewase)
- [#21358](https://github.com/apache/superset/pull/21358) fix: Dataset duplication fatal error (@reesercollins)
- [#21591](https://github.com/apache/superset/pull/21591) fix(tags): Adding **init** to tags (@craig-rueda)
- [#21576](https://github.com/apache/superset/pull/21576) fix(dashboard): dashboard doesn't load properly if it has tabs (@stephenLYZ)
- [#21544](https://github.com/apache/superset/pull/21544) fix(explore): Fix datasource switch for table chart (@codyml)
- [#21065](https://github.com/apache/superset/pull/21065) fix(databases): GSheets and Clickhouse DBs are not allowed to upload files (@Antonio-RiveroMartnez)
- [#21549](https://github.com/apache/superset/pull/21549) fix(dashboard): show correct roles for dashboard access dropdown (@mayurnewase)
- [#21316](https://github.com/apache/superset/pull/21316) fix(sqllab): avoid unexpected re-rendering on DatabaseSelector (@justinpark)
- [#21529](https://github.com/apache/superset/pull/21529) fix: Reset dataset name after saving a new dataset in SQL Lab (@EugeneTorap)
- [#21542](https://github.com/apache/superset/pull/21542) fix(docs): added missing timescale.png (@noctarius)
- [#21514](https://github.com/apache/superset/pull/21514) fix: pie chart orientation description error (@LiuBodong)
- [#21497](https://github.com/apache/superset/pull/21497) fix(explore): fix chart save when dashboard deleted (@codyml)
- [#21516](https://github.com/apache/superset/pull/21516) fix: Dataset timeout (@geido)
- [#21495](https://github.com/apache/superset/pull/21495) fix: can't show duckdb table names in the "SEE TABLE SCHEMA" dropdown list (@forestlzj)
- [#21492](https://github.com/apache/superset/pull/21492) fix: dataset after insert when db relation does not exist (@dpgaspar)
- [#21470](https://github.com/apache/superset/pull/21470) fix: Address regression introduced in #21284 (@john-bodley)
- [#21480](https://github.com/apache/superset/pull/21480) fix: Duplicated numeric values in Select (@michael-s-molina)
- [#21489](https://github.com/apache/superset/pull/21489) fix: BigQuery cannot accept Time Grain (@zhaoyongjie)
- [#21484](https://github.com/apache/superset/pull/21484) fix(explore): Fix generic X-axis time grain disappearing (@codyml)
- [#21378](https://github.com/apache/superset/pull/21378) fix: Time Offset in SQLite and refine logic in Date Type conversion (@zhaoyongjie)
- [#21481](https://github.com/apache/superset/pull/21481) fix: revert #21356(able to sort bar on the bar chart V2) (@stephenLYZ)
- [#21469](https://github.com/apache/superset/pull/21469) fix: Supports form_data param in old Explore endpoint (@michael-s-molina)
- [#21315](https://github.com/apache/superset/pull/21315) fix(explore): Prevent shared controls from checking feature flags outside React render (@codyml)
- [#21461](https://github.com/apache/superset/pull/21461) fix: dashboard filter value is cleared when 2 similar dashboards opened in succession (@mayurnewase)
- [#21464](https://github.com/apache/superset/pull/21464) fix: hide time_grain when x_axis value is undefined (@zhaoyongjie)
- [#21454](https://github.com/apache/superset/pull/21454) fix: permission sqlalchemy events (@dpgaspar)
- [#21371](https://github.com/apache/superset/pull/21371) fix: should be able to remove selection from X-AXIS control (@zhaoyongjie)
- [#21450](https://github.com/apache/superset/pull/21450) fix: remove extras from all adhoc_filters controls (@villebro)
- [#21422](https://github.com/apache/superset/pull/21422) fix(dashboard): JS error when editing charts (@ktmud)
- [#21366](https://github.com/apache/superset/pull/21366) fix(explore): disable resize bar when the results area is collapsed (@stephenLYZ)
- [#21432](https://github.com/apache/superset/pull/21432) fix(dashboard): drag preview not working (@stephenLYZ)
- [#21399](https://github.com/apache/superset/pull/21399) fix(ui): Quick Fix for app_icon (@craig-rueda)
- [#21372](https://github.com/apache/superset/pull/21372) fix(big number): time grain control is useless in BigNumber Viz (@zhaoyongjie)
- [#21282](https://github.com/apache/superset/pull/21282) fix(dashboard): Fix scrolling on "View as table" modal (@codyml)
- [#21313](https://github.com/apache/superset/pull/21313) fix: revert permission refactoring PR (@zephyring)
- [#21311](https://github.com/apache/superset/pull/21311) fix(sqllab): Copy link doesn't apply the unsaved changes (@justinpark)
- [#21342](https://github.com/apache/superset/pull/21342) fix: database modal crashed when use SQLAlchemy URI string (@zhaoyongjie)
- [#21323](https://github.com/apache/superset/pull/21323) fix(dashboard): padding between rows within tabs (@gbusch)
- [#21243](https://github.com/apache/superset/pull/21243) fix(ViewQuery-Modal): Copy icon is out of box when resize query modal (@Paulo-Eduardo)
- [#21299](https://github.com/apache/superset/pull/21299) fix: DB connection modal connect bug (@AAfghahi)
- [#21306](https://github.com/apache/superset/pull/21306) fix: flaky test when sync metadata (@zhaoyongjie)
- [#21043](https://github.com/apache/superset/pull/21043) fix(utils): use getaddrinfo response to support dual-stack port checks (@vin01)
- [#21042](https://github.com/apache/superset/pull/21042) fix(utils): use getaddrinfo for hostname check to support ipv6 (@vin01)
- [#21304](https://github.com/apache/superset/pull/21304) fix(sqllab): invalid table metadata request (@justinpark)
- [#21275](https://github.com/apache/superset/pull/21275) fix: Fix console errors about feature flags when running tests (@codyml)
- [#21293](https://github.com/apache/superset/pull/21293) fix(explore): Incorrect conversion from simple bool filter to custom sql (@kgabryje)
- [#21277](https://github.com/apache/superset/pull/21277) fix: Revert "#20095 - fix(database): make to display validation error msg when all … (@sadpandajoe)
- [#21244](https://github.com/apache/superset/pull/21244) fix: dataset exists error in save Dataset modal (@AAfghahi)
- [#21274](https://github.com/apache/superset/pull/21274) fix: bump min version of elastic search (@AAfghahi)
- [#21161](https://github.com/apache/superset/pull/21161) fix: dataset name change and permission change (@dpgaspar)
- [#21251](https://github.com/apache/superset/pull/21251) fix: Table content disappears when switching between tabs (@EugeneTorap)
- [#21257](https://github.com/apache/superset/pull/21257) fix: SQLAlchemy coercing subquery warning on RLS (@dpgaspar)
- [#21260](https://github.com/apache/superset/pull/21260) fix(sqllab): unable to create new tabs (@justinpark)
- [#21246](https://github.com/apache/superset/pull/21246) fix(sqllab): sql editor's name has lost after reload (@justinpark)
- [#21247](https://github.com/apache/superset/pull/21247) fix: Revert "Update Tab Name via config (#21116)" (@hughhhh)
- [#21232](https://github.com/apache/superset/pull/21232) fix(dev-server run): Check for environment tag not being undefined (@sinhashubham95)
- [#21171](https://github.com/apache/superset/pull/21171) fix: improve get_db_engine_spec_for_backend (@betodealmeida)
- [#21066](https://github.com/apache/superset/pull/21066) fix(Trino): create `PrestoBaseEngineSpec` base class to share common code between Trino and Presto (@dungdm93)
- [#21226](https://github.com/apache/superset/pull/21226) fix: Fixes error caused by step id placed in wrong location (@eric-briscoe)
- [#21208](https://github.com/apache/superset/pull/21208) fix(embedded): Guest Role Permissions (@sinhashubham95)
- [#21190](https://github.com/apache/superset/pull/21190) fix: add back custom sql filtering with Query as source (@hughhhh)
- [#21224](https://github.com/apache/superset/pull/21224) fix: Update chromatic PR action to have access to Job outputs (@eric-briscoe)
- [#21222](https://github.com/apache/superset/pull/21222) fix: Removes if statement causing comment not to run in Chromatic PR action (@eric-briscoe)
- [#21217](https://github.com/apache/superset/pull/21217) fix: Update exception for DatasourceNotFound from `DatasourceDao.get_datasource()` (@hughhhh)
- [#21219](https://github.com/apache/superset/pull/21219) fix: Splitting into two separate chromatic jobs to reduce conditional logic causing run issues (@eric-briscoe)
- [#21209](https://github.com/apache/superset/pull/21209) fix: World Map right-click value (@michael-s-molina)
- [#21205](https://github.com/apache/superset/pull/21205) fix(readme): formatting in README.md (@yuzutas0)
- [#21181](https://github.com/apache/superset/pull/21181) fix: Typing of labelMap (@michael-s-molina)
- [#21201](https://github.com/apache/superset/pull/21201) fix: Add warnings if feature flags are read before initialization (@codyml)
- [#21167](https://github.com/apache/superset/pull/21167) fix(database-modal): Adjusting spacing on database connection form (@Paulo-Eduardo)
- [#21140](https://github.com/apache/superset/pull/21140) fix(alert-modal): Radio button is not vertically-aligned (@Paulo-Eduardo)
- [#21172](https://github.com/apache/superset/pull/21172) fix(database-modal): Show a different placeholder text in Snowflake connection form (@agl-developer)
- [#20095](https://github.com/apache/superset/pull/20095) fix(database): make to display validation error msg when all cases (@prosdev0107)
- [#21157](https://github.com/apache/superset/pull/21157) fix: Filter throwing an error on Embedded Dashboard (@lilykuang)
- [#21174](https://github.com/apache/superset/pull/21174) fix(sqllab): reverts #21141 (@justinpark)
- [#21151](https://github.com/apache/superset/pull/21151) fix: Drill to detail on values with comma (@michael-s-molina)
- [#21015](https://github.com/apache/superset/pull/21015) fix(charts): Hide Values greater than Max Y Axis Bound on Mixed Time Series with Bar series (@Antonio-RiveroMartnez)
- [#21141](https://github.com/apache/superset/pull/21141) fix(sqllab): avoid unexpected re-rendering on DatabaseSelector (@justinpark)
- [#21135](https://github.com/apache/superset/pull/21135) fix: resample method shouldn't be freeform (@zhaoyongjie)
- [#21130](https://github.com/apache/superset/pull/21130) fix: timestamp bug for chart-powered-query (@AAfghahi)
- [#21006](https://github.com/apache/superset/pull/21006) fix: Use Home page in SPA (@EugeneTorap)
- [#21113](https://github.com/apache/superset/pull/21113) fix: datetime value should be seconds in sqlite (@zhaoyongjie)
- [#21114](https://github.com/apache/superset/pull/21114) fix(explore): Filters with custom SQL disappearing (@kgabryje)
- [#21100](https://github.com/apache/superset/pull/21100) fix(dashboard): Dashboard header overflowing in edit mode (@kgabryje)
- [#21019](https://github.com/apache/superset/pull/21019) fix: Unable to sync columns when dataset name has '+' (@diegomedina248)
- [#21004](https://github.com/apache/superset/pull/21004) fix(database-modal): 'CTAS & CVAS SCHEMA' getting cut off (@stephenLYZ)
- [#21029](https://github.com/apache/superset/pull/21029) fix: take form_data reference for metrics for pivot_v2 table reports (@hughhhh)
- [#21003](https://github.com/apache/superset/pull/21003) fix: Validate required fields in sql_json API (@EugeneTorap)
- [#21045](https://github.com/apache/superset/pull/21045) fix: add plain postgres alias (@betodealmeida)
- [#21034](https://github.com/apache/superset/pull/21034) fix: [sc-54864] Adds safety check to provide near term fix to save query (@eric-briscoe)
- [#21025](https://github.com/apache/superset/pull/21025) fix: unable to show view as table modal (@zhaoyongjie)
- [#21030](https://github.com/apache/superset/pull/21030) fix: making crossFilter.chartsInScope optional (@rusackas)
- [#20970](https://github.com/apache/superset/pull/20970) fix: forwardRef warnings in selects (@michael-s-molina)
- [#21017](https://github.com/apache/superset/pull/21017) fix(plugin-echart-timeseries): legend truncated on show extra controls (@justinpark)
- [#21016](https://github.com/apache/superset/pull/21016) fix(sqllab): result set min-height (@ktmud)
- [#20999](https://github.com/apache/superset/pull/20999) fix: quick fix to rows returned in results (@AAfghahi)
- [#20965](https://github.com/apache/superset/pull/20965) fix: save dataset and repopulate state (@eschutho)
- [#20972](https://github.com/apache/superset/pull/20972) fix(explore): Replace url search params only if current page is Explore (@kgabryje)
- [#20989](https://github.com/apache/superset/pull/20989) fix: for series limit comparison on explore with chart = Query (@hughhhh)
- [#20977](https://github.com/apache/superset/pull/20977) fix: series limit solution for source is query (@AAfghahi)
- [#20975](https://github.com/apache/superset/pull/20975) fix: Columns not passing properly from SQL Lab to Explore (@lyndsiWilliams)
- [#20959](https://github.com/apache/superset/pull/20959) fix: remove extra line for link (@pkdotson)
- [#20938](https://github.com/apache/superset/pull/20938) fix: add timegrains to data payload (@hughhhh)
- [#20964](https://github.com/apache/superset/pull/20964) fix: No back button in save dataset modal (@AAfghahi)
- [#20966](https://github.com/apache/superset/pull/20966) fix: BigQuery get_parameters_from_uri (@betodealmeida)
- [#20941](https://github.com/apache/superset/pull/20941) fix: Use SPA Dataset link in Chart and Dashboard (@EugeneTorap)
- [#20947](https://github.com/apache/superset/pull/20947) fix(sqllab): Fix tab state (@lyndsiWilliams)
- [#20937](https://github.com/apache/superset/pull/20937) fix(sqllab): tracking url and error alert padding (@ktmud)
- [#20627](https://github.com/apache/superset/pull/20627) fix(chart): Time Series set showMaxLabel as null for time xAxis (@Antonio-RiveroMartnez)
- [#20720](https://github.com/apache/superset/pull/20720) fix(charts): Scrollbar after removing an annotation (@Antonio-RiveroMartnez)
- [#20933](https://github.com/apache/superset/pull/20933) fix: adjust timeseries grid right offset to match the rest (@diegomedina248)
- [#20932](https://github.com/apache/superset/pull/20932) fix(import): error with disable_data_preview field (@diegomedina248)
- [#20574](https://github.com/apache/superset/pull/20574) fix: Change dataset name affect data access role set to this dataset (@diegomedina248)
- [#20081](https://github.com/apache/superset/pull/20081) fix: database permissions on update and delete (avoid orphaned perms) (@dpgaspar)
- [#20927](https://github.com/apache/superset/pull/20927) fix(dashboard): Incorrect scopes of cross filters (@kgabryje)
- [#20862](https://github.com/apache/superset/pull/20862) fix: overwrite update override columns on PUT /dataset (@hughhhh)
- [#20924](https://github.com/apache/superset/pull/20924) fix: hide modal after overwrite (@hughhhh)
- [#20923](https://github.com/apache/superset/pull/20923) fix(explore): Time controls not showing for Queries (@eric-briscoe)
- [#20880](https://github.com/apache/superset/pull/20880) fix: Save dataset + chart when Chart source is Query (@hughhhh)
- [#20895](https://github.com/apache/superset/pull/20895) fix: make a new entrypoint for deprecated postgres dialect (@eschutho)
- [#20905](https://github.com/apache/superset/pull/20905) fix(sqllab): hide tracking url when fetching (@ktmud)
- [#20893](https://github.com/apache/superset/pull/20893) fix: Address performance regression introduced in #11785 (@john-bodley)
- [#20909](https://github.com/apache/superset/pull/20909) fix(plugin-chart-pivot-table): Invalid Formats Date Fields (@justinpark)
- [#20882](https://github.com/apache/superset/pull/20882) fix: invalid metric should raise an exception (@zhaoyongjie)
- [#20491](https://github.com/apache/superset/pull/20491) fix(sql lab): Syntax errors should return with 422 status (@diegomedina248)
- [#20638](https://github.com/apache/superset/pull/20638) fix: Published Dashboard without charts don't show up for non admin users (@diegomedina248)
- [#20753](https://github.com/apache/superset/pull/20753) fix(reports): Confirmation message after deleting reports (@Antonio-RiveroMartnez)
- [#20833](https://github.com/apache/superset/pull/20833) fix(charts): Table Chart doesn't twitch when resizing (@Antonio-RiveroMartnez)
- [#20874](https://github.com/apache/superset/pull/20874) fix(viz): Header scrolling for Time Table in dashboard (@Antonio-RiveroMartnez)
- [#20871](https://github.com/apache/superset/pull/20871) fix: create property for schema_perm for `Query` (@hughhhh)
- [#20879](https://github.com/apache/superset/pull/20879) fix: add having_druid back into the chart schema (@eschutho)
- [#20867](https://github.com/apache/superset/pull/20867) fix: switch form_data between different datasource (@zhaoyongjie)
- [#20847](https://github.com/apache/superset/pull/20847) fix: Fix chart title truncating when Chrome is zoomed out (@kgabryje)
- [#20864](https://github.com/apache/superset/pull/20864) fix: explore warnings cleanup (@diegomedina248)
- [#20851](https://github.com/apache/superset/pull/20851) fix: change buttons to be only save and overwrite (@hughhhh)
- [#20829](https://github.com/apache/superset/pull/20829) fix: adding extraConfig to worker deployment #20828 (@cdreier)
- [#20834](https://github.com/apache/superset/pull/20834) fix: add complex type to pydruid (@betodealmeida)
- [#20726](https://github.com/apache/superset/pull/20726) fix: Use cache_manager.cache rather than cache_manager.data_cache for caching table metadata (@john-bodley)
- [#20811](https://github.com/apache/superset/pull/20811) fix: Ensure consistent rollback logic for failed SQL operations (@john-bodley)
- [#20805](https://github.com/apache/superset/pull/20805) fix(plugin-chart-echarts): xAxis of bar chart overflow (@stephenLYZ)
- [#20823](https://github.com/apache/superset/pull/20823) fix(dashboard): add toast if JSON metadata is invalid (@stephenLYZ)
- [#20826](https://github.com/apache/superset/pull/20826) fix: invalid dataset schema (@zhaoyongjie)
- [#20795](https://github.com/apache/superset/pull/20795) fix: Timeseries visualization with Chart Source = Query (@hughhhh)
- [#20750](https://github.com/apache/superset/pull/20750) fix: [explore][mixed time series chart] when user change size of view query window, query B part will disappear (@diegomedina248)
- [#20816](https://github.com/apache/superset/pull/20816) fix: chart empty state & result panel when multiple queries are executed display incorrectly (@diegomedina248)
- [#20812](https://github.com/apache/superset/pull/20812) fix: Redirects old Explore URLs to the new ones (@michael-s-molina)
- [#20802](https://github.com/apache/superset/pull/20802) fix(explore): Adhoc columns don't display correctly (@kgabryje)
- [#20780](https://github.com/apache/superset/pull/20780) fix: unexpected commit causes pytest failure (@zhaoyongjie)
- [#20796](https://github.com/apache/superset/pull/20796) fix: Reverts #20749 and #20645 (@michael-s-molina)
- [#20794](https://github.com/apache/superset/pull/20794) fix: properly set `owners` to Sqlatable.owners_data inside payload (@hughhhh)
- [#20674](https://github.com/apache/superset/pull/20674) fix: Databricks views showing up as tables (@betodealmeida)
- [#20783](https://github.com/apache/superset/pull/20783) fix(plugin-chart-echarts): layout broken when resizing (@stephenLYZ)
- [#20566](https://github.com/apache/superset/pull/20566) fix(heatmap): add detail descriptions for heatmap 'normalize across' (@stephenLYZ)
- [#20754](https://github.com/apache/superset/pull/20754) fix: set allow `filter_select` for Query objects in Explore (@hughhhh)
- [#20784](https://github.com/apache/superset/pull/20784) fix: core coverage and add a coverage step in workflow (@zhaoyongjie)
- [#20684](https://github.com/apache/superset/pull/20684) fix(dashboard): Fix missing metadata on draggable dashboard edit chart cards (@codyml)
- [#20725](https://github.com/apache/superset/pull/20725) fix: datasourcedao datasource not found error (@pkdotson)
- [#20673](https://github.com/apache/superset/pull/20673) fix(explore): Fix chart standalone URL for report/thumbnail generation (@codyml)
- [#20760](https://github.com/apache/superset/pull/20760) fix(csv): Do not coerce persisted data integer columns to float (@john-bodley)
- [#20757](https://github.com/apache/superset/pull/20757) fix: PrestoEngineSpec.\_show_columns return type (@john-bodley)
- [#20706](https://github.com/apache/superset/pull/20706) fix(sql lab): MultiSelector component render twice (@diegomedina248)
- [#20727](https://github.com/apache/superset/pull/20727) fix(docker): Fixing broken node build (@craig-rueda)
- [#20751](https://github.com/apache/superset/pull/20751) fix: change dataset functionality in Explore (@hughhhh)
- [#20749](https://github.com/apache/superset/pull/20749) fix: Error when saving datasource from Explore (@michael-s-molina)
- [#20747](https://github.com/apache/superset/pull/20747) fix: set reference to columns properly for sqllab -> explore (@hughhhh)
- [#20661](https://github.com/apache/superset/pull/20661) fix: reuse existing row on dual write if available (@eschutho)
- [#20710](https://github.com/apache/superset/pull/20710) fix: Fixes the instructions to publish to PyPI (@michael-s-molina)
- [#20712](https://github.com/apache/superset/pull/20712) fix: Ensure main_dttm_col is adhered to for non-drag-and-drop (@john-bodley)
- [#20711](https://github.com/apache/superset/pull/20711) fix: Re-add schema as a searchable field for the datasets v1 API (@john-bodley)
- [#20699](https://github.com/apache/superset/pull/20699) fix: columns are lost when dashboard to explore (@zhaoyongjie)
- [#20688](https://github.com/apache/superset/pull/20688) fix: "Refresh Dashboard" only refreshes active tab (@diegomedina248)
- [#20700](https://github.com/apache/superset/pull/20700) fix(releases): docker build on M1 npm run build fails (@dpgaspar)
- [#20691](https://github.com/apache/superset/pull/20691) fix(sqllab): Save Dataset Modal Multiple overwrites (@Antonio-RiveroMartnez)
- [#20687](https://github.com/apache/superset/pull/20687) fix(line-chart): Formula Annotations on Line Charts are broken (@stephenLYZ)
- [#20671](https://github.com/apache/superset/pull/20671) fix(treemap-v2): color scheme not work when there is only one dimension (@stephenLYZ)
- [#20693](https://github.com/apache/superset/pull/20693) fix(dashboard): Native filter on the dashboard with multiple tabs is displayed as out of scope (@diegomedina248)
- [#20680](https://github.com/apache/superset/pull/20680) fix(explore): datatable crash when dimension is empty (@Usiel)
- [#20689](https://github.com/apache/superset/pull/20689) fix: Revert "feat: Reuse Dashboard redux data in Explore (#20668)" (@kgabryje)
- [#20676](https://github.com/apache/superset/pull/20676) fix: superset-ui/core code coverage (@zhaoyongjie)
- [#20659](https://github.com/apache/superset/pull/20659) fix: X Axis should be called Y Axis when using the Bar Chart V2 on Horizontal mode (@diegomedina248)
- [#20629](https://github.com/apache/superset/pull/20629) fix: pandas bug when data is blank on post-processing (@eschutho)
- [#20647](https://github.com/apache/superset/pull/20647) fix(embedded): Ensure guest token is passed to log endpoint (@jfrag1)
- [#20613](https://github.com/apache/superset/pull/20613) fix: enable admin to edit dataset in explore (@pkdotson)
- [#20637](https://github.com/apache/superset/pull/20637) fix(databases): Display for credentials input (@Antonio-RiveroMartnez)
- [#20499](https://github.com/apache/superset/pull/20499) fix: Refactor ownership checks (@john-bodley)
- [#20119](https://github.com/apache/superset/pull/20119) fix: Bad date type in email text report for table chart (@codemaster08240328)
- [#19244](https://github.com/apache/superset/pull/19244) fix: Add database search in available charts on dashboard. (@codemaster08240328)
- [#20623](https://github.com/apache/superset/pull/20623) fix: controls validator glitch (@zhaoyongjie)
- [#20618](https://github.com/apache/superset/pull/20618) fix: datetime.data in series (@zhaoyongjie)
- [#20573](https://github.com/apache/superset/pull/20573) fix(import): Show the error message with db install guide when exist the importing db issue (@prosdev0107)
- [#20605](https://github.com/apache/superset/pull/20605) fix: welcome page user authentication check (@dpgaspar)
- [#20256](https://github.com/apache/superset/pull/20256) fix(schedule-query): getUISchema function called in SchemaForm component (@RahulRaj97)
- [#20523](https://github.com/apache/superset/pull/20523) fix(database-modal): Refresh Data when importing (@Antonio-RiveroMartnez)
- [#20496](https://github.com/apache/superset/pull/20496) fix: change permissions on action (@eschutho)

**Others**

- [#23325](https://github.com/apache/superset/pull/23325) chore: use util test env for init check (@eschutho)
- [#23298](https://github.com/apache/superset/pull/23298) docs: improve API v1 migration documentation (@dpgaspar)
- [#23199](https://github.com/apache/superset/pull/23199) docs: update installation docs to include frontend asset build (@eschutho)
- [#23131](https://github.com/apache/superset/pull/23131) chore: Add docs for ssh tunneling (@hughhhh)
- [#23102](https://github.com/apache/superset/pull/23102) chore: change AlertQueryError to 400 (@eschutho)
- [#23041](https://github.com/apache/superset/pull/23041) chore: increment statsd as warn (@eschutho)
- [#22903](https://github.com/apache/superset/pull/22903) chore: Updating connection URI for MS SQL Server (@kuruv)
- [#23077](https://github.com/apache/superset/pull/23077) chore: Improve greeting message (@tisonkun)
- [#23003](https://github.com/apache/superset/pull/23003) chore: move dashboard screenshot standalone logic (@eschutho)
- [#22969](https://github.com/apache/superset/pull/22969) test: Clean up SelectAsyncControl test warnings (@lyndsiWilliams)
- [#22971](https://github.com/apache/superset/pull/22971) test: Convert DatasetList test from jsx to tsx (@lyndsiWilliams)
- [#22973](https://github.com/apache/superset/pull/22973) chore: Remove dependency warnings from DatasetList.tsx (@lyndsiWilliams)
- [#22974](https://github.com/apache/superset/pull/22974) chore: Remove dependency warnings from SqlEditor/index.jsx (@lyndsiWilliams)
- [#22975](https://github.com/apache/superset/pull/22975) chore: Remove dependency warnings from SqlEditorLeftBar/index.tsx (@lyndsiWilliams)
- [#23081](https://github.com/apache/superset/pull/23081) chore(style): make brand icon max width customizable (@villebro)
- [#23079](https://github.com/apache/superset/pull/23079) build(deps-dev): bump eslint from 8.33.0 to 8.34.0 in /superset-websocket (@dependabot[bot])
- [#23080](https://github.com/apache/superset/pull/23080) build(deps): bump ws from 8.12.0 to 8.12.1 in /superset-websocket (@dependabot[bot])
- [#22913](https://github.com/apache/superset/pull/22913) chore: Migrate /superset/csv/`<client_id>` to API v1 (@diegomedina248)
- [#22931](https://github.com/apache/superset/pull/22931) chore: Migrate get_or_create_table endpoint to api v1 (@jfrag1)
- [#22486](https://github.com/apache/superset/pull/22486) docs: remove duplicate navbar item (@tisonkun)
- [#23029](https://github.com/apache/superset/pull/23029) build(deps-dev): bump @types/node from 18.11.19 to 18.13.0 in /superset-websocket (@dependabot[bot])
- [#23030](https://github.com/apache/superset/pull/23030) build(deps-dev): bump prettier from 2.8.3 to 2.8.4 in /superset-websocket (@dependabot[bot])
- [#23031](https://github.com/apache/superset/pull/23031) build(deps): bump hot-shots from 9.3.0 to 10.0.0 in /superset-websocket (@dependabot[bot])
- [#23073](https://github.com/apache/superset/pull/23073) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.49.0 to 5.52.0 in /superset-websocket (@dependabot[bot])
- [#22444](https://github.com/apache/superset/pull/22444) chore: remove db_engines (@betodealmeida)
- [#22957](https://github.com/apache/superset/pull/22957) chore(datasets): Refactor DatasetDAO update to leverage bulk logic for create, update, and delete operations (@john-bodley)
- [#23054](https://github.com/apache/superset/pull/23054) chore: Removes icon warnings from tests (@michael-s-molina)
- [#23051](https://github.com/apache/superset/pull/23051) docs(teradata): fix connection string (@villebro)
- [#23009](https://github.com/apache/superset/pull/23009) chore: refactor SliceAdder for react 17 and react 18 (@lilykuang)
- [#23023](https://github.com/apache/superset/pull/23023) chore(tests): Cypress optimizations to help with fails (@codyml)
- [#22933](https://github.com/apache/superset/pull/22933) build(deps-dev): bump typescript from 4.9.4 to 4.9.5 in /superset-websocket (@dependabot[bot])
- [#23013](https://github.com/apache/superset/pull/23013) build(deps-dev): bump @typescript-eslint/parser from 5.48.1 to 5.51.0 in /superset-websocket (@dependabot[bot])
- [#22997](https://github.com/apache/superset/pull/22997) build(deps-dev): bump @types/node from 18.11.13 to 18.11.19 in /superset-websocket (@dependabot[bot])
- [#22955](https://github.com/apache/superset/pull/22955) build(deps): bump http-cache-semantics from 4.1.0 to 4.1.1 in /superset-frontend/cypress-base (@dependabot[bot])
- [#22767](https://github.com/apache/superset/pull/22767) build(deps-dev): bump eslint-config-prettier from 7.2.0 to 8.6.0 in /superset-websocket (@dependabot[bot])
- [#21809](https://github.com/apache/superset/pull/21809) chore(deps): bump ajv and react-jsonschema-form in /superset-frontend (@dependabot[bot])
- [#22938](https://github.com/apache/superset/pull/22938) chore: Localization of Superset pt. 3 (@artemonsh)
- [#23005](https://github.com/apache/superset/pull/23005) chore: updating link to sandbox.js (@rusackas)
- [#22956](https://github.com/apache/superset/pull/22956) build(deps): bump http-cache-semantics from 4.1.0 to 4.1.1 in /docs (@dependabot[bot])
- [#22996](https://github.com/apache/superset/pull/22996) build(deps): bump pre-commit from 2.20.0 to 3.0.4 in /requirements (@dependabot[bot])
- [#22986](https://github.com/apache/superset/pull/22986) docs: added Orange inside the inthewild.md doc (@icsu)
- [#22831](https://github.com/apache/superset/pull/22831) chore: Fix grammar (@john-bodley)
- [#22934](https://github.com/apache/superset/pull/22934) chore: bump python version to 3.8.16 in Dockerfile (@EugeneTorap)
- [#22988](https://github.com/apache/superset/pull/22988) docs(alerts & reports): clarify nature of "-dev" labeled container images (@sfirke)
- [#22972](https://github.com/apache/superset/pull/22972) test: Clean up QueryList test warnings (@lyndsiWilliams)
- [#22970](https://github.com/apache/superset/pull/22970) test: Fix act errors in DatabaseList test (@lyndsiWilliams)
- [#22961](https://github.com/apache/superset/pull/22961) docs: add Caizin to the user list (@tejaskatariya)
- [#22935](https://github.com/apache/superset/pull/22935) chore: add waitress for win32 platform (@EugeneTorap)
- [#22958](https://github.com/apache/superset/pull/22958) build(deps): bump http-cache-semantics from 4.1.0 to 4.1.1 in /superset-frontend (@dependabot[bot])
- [#22963](https://github.com/apache/superset/pull/22963) chore(superset-ui-chart-controls): refactor pivot and rename operator (@villebro)
- [#22798](https://github.com/apache/superset/pull/22798) chore(welcome): change default last tab to "all" (@villebro)
- [#22927](https://github.com/apache/superset/pull/22927) chore: Bump Flask-AppBuilder constraints (@john-bodley)
- [#22915](https://github.com/apache/superset/pull/22915) test: Clean up AdhocFilterOption test warnings (@lyndsiWilliams)
- [#22501](https://github.com/apache/superset/pull/22501) chore: Migrate /superset/tables/\* to API v1 (@diegomedina248)
- [#22902](https://github.com/apache/superset/pull/22902) build(deps-dev): bump eslint from 8.32.0 to 8.33.0 in /superset-websocket (@dependabot[bot])
- [#22878](https://github.com/apache/superset/pull/22878) chore: upgrade react-router-dom to 5.3.4 (@lilykuang)
- [#22914](https://github.com/apache/superset/pull/22914) chore: upgrade packages for react v17 upgrade (@lilykuang)
- [#22815](https://github.com/apache/superset/pull/22815) chore: migrate @vx/responsive to @visx/responsive for react 18 upgrade (@lilykuang)
- [#22871](https://github.com/apache/superset/pull/22871) chore(db_engine_specs): clean up column spec logic and add tests (@villebro)
- [#22623](https://github.com/apache/superset/pull/22623) chore: skip puppeteer chromium download (@nisheldo)
- [#22772](https://github.com/apache/superset/pull/22772) chore: Localization of Superset pt. 2 (@artemonsh)
- [#22809](https://github.com/apache/superset/pull/22809) chore: migrate /sql_json and /results to apiv1 (@diegomedina248)
- [#22882](https://github.com/apache/superset/pull/22882) chore: deprecate /superset/filter/... endpoint, migrate to apiv1 (@jfrag1)
- [#22892](https://github.com/apache/superset/pull/22892) build(deps): bump underscore from 1.12.0 to 1.12.1 in /superset-frontend (@dependabot[bot])
- [#22891](https://github.com/apache/superset/pull/22891) build(deps): bump moment from 2.29.2 to 2.29.4 in /docs (@dependabot[bot])
- [#22888](https://github.com/apache/superset/pull/22888) docs: add Skyscanner to users list (@cleslie)
- [#22611](https://github.com/apache/superset/pull/22611) chore: Migrate /superset/queries/`<last_updated_ms>` to API v1 (@diegomedina248)
- [#22887](https://github.com/apache/superset/pull/22887) chore: add statsd support to base API and refactor (@dpgaspar)
- [#22496](https://github.com/apache/superset/pull/22496) chore: deprecate /superset/slice_json/`<int:slice_id>` and /superset/annotation_json/`<int:layer_id>` (@diegomedina248)
- [#22779](https://github.com/apache/superset/pull/22779) chore: upgrade react-reverse-portal for react upgrade (@lilykuang)
- [#22780](https://github.com/apache/superset/pull/22780) chore: upgrade react-table for react 18 upgrade (@lilykuang)
- [#22834](https://github.com/apache/superset/pull/22834) chore: migrate react-diff-viewer to react-diff-viewer-continued for react 18 upgrade (@lilykuang)
- [#22865](https://github.com/apache/superset/pull/22865) docs(cache): update doc strings (@cemremengu)
- [#22858](https://github.com/apache/superset/pull/22858) build(deps): bump ua-parser-js from 0.7.31 to 0.7.33 in /docs (@dependabot[bot])
- [#19678](https://github.com/apache/superset/pull/19678) chore(misc): Spelling (@jsoref)
- [#22838](https://github.com/apache/superset/pull/22838) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.48.2 to 5.49.0 in /superset-websocket (@dependabot[bot])
- [#22846](https://github.com/apache/superset/pull/22846) test: Fix act errors in DatabaseModal test (@lyndsiWilliams)
- [#22845](https://github.com/apache/superset/pull/22845) test: Fix act errors in DatasourceControl test (@lyndsiWilliams)
- [#22789](https://github.com/apache/superset/pull/22789) chore: Migrate /superset/recent_activity/`<user_id>`/ to /api/v1/ (@jfrag1)
- [#22844](https://github.com/apache/superset/pull/22844) chore(tests): Streamline Cypress login to fix fails/flakes (@codyml)
- [#20872](https://github.com/apache/superset/pull/20872) docs(alerts & reports): add, prune, reorganize (@sfirke)
- [#22617](https://github.com/apache/superset/pull/22617) chore(issue templates): discouraging Issues for feature requests (@rusackas)
- [#22585](https://github.com/apache/superset/pull/22585) chore: upgrade react-datetime, react-intersection-observer and react-checkbox-tree (@lilykuang)
- [#22516](https://github.com/apache/superset/pull/22516) chore: Convert direct uses of antd icons to 'Icons' component (@codyml)
- [#22413](https://github.com/apache/superset/pull/22413) chore(sqla): Add explicit bidirectional performant relationships for SQLA model (@john-bodley)
- [#22796](https://github.com/apache/superset/pull/22796) docs: link docker readme in docker config section (@nytai)
- [#22793](https://github.com/apache/superset/pull/22793) chore(dashboard): Log events for download as image (@justinpark)
- [#22771](https://github.com/apache/superset/pull/22771) chore(logging): add health checks to statsd (@villebro)
- [#22782](https://github.com/apache/superset/pull/22782) chore(ci): fix numpy type errors and revert #22610 (@villebro)
- [#22474](https://github.com/apache/superset/pull/22474) chore: Migrate .less styles to Emotion (@kgabryje)
- [#22415](https://github.com/apache/superset/pull/22415) chore(translation): add missing Russian translation, add plural forms (@artemonsh)
- [#22766](https://github.com/apache/superset/pull/22766) chore: adding missing examples in the gallery for some chart types (@yash-samsung)
- [#22592](https://github.com/apache/superset/pull/22592) chore: upgrade react-resize-detector (@lilykuang)
- [#22753](https://github.com/apache/superset/pull/22753) chore: re add upload tests (@dpgaspar)
- [#22748](https://github.com/apache/superset/pull/22748) build(deps): bump minimatch from 3.0.4 to 3.1.2 in /superset-embedded-sdk (@dependabot[bot])
- [#22750](https://github.com/apache/superset/pull/22750) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.48.1 to 5.48.2 in /superset-websocket (@dependabot[bot])
- [#22751](https://github.com/apache/superset/pull/22751) build(deps-dev): bump eslint from 8.29.0 to 8.32.0 in /superset-websocket (@dependabot[bot])
- [#22752](https://github.com/apache/superset/pull/22752) build(deps-dev): bump @types/jsonwebtoken from 8.5.9 to 9.0.1 in /superset-websocket (@dependabot[bot])
- [#22745](https://github.com/apache/superset/pull/22745) build(deps): bump minimatch from 3.0.4 to 3.1.2 in /superset-frontend/cypress-base (@dependabot[bot])
- [#22738](https://github.com/apache/superset/pull/22738) build(deps): bump ws and @types/ws in /superset-websocket (@dependabot[bot])
- [#22740](https://github.com/apache/superset/pull/22740) build(deps-dev): bump prettier from 2.8.2 to 2.8.3 in /superset-websocket (@dependabot[bot])
- [#22731](https://github.com/apache/superset/pull/22731) build(deps): bump express and @applitools/eyes-storybook in /superset-frontend (@dependabot[bot])
- [#22739](https://github.com/apache/superset/pull/22739) build(deps-dev): bump @typescript-eslint/parser from 5.47.0 to 5.48.1 in /superset-websocket (@dependabot[bot])
- [#22138](https://github.com/apache/superset/pull/22138) build(deps): bump loader-utils from 1.4.0 to 1.4.2 in /superset-frontend (@dependabot[bot])
- [#22742](https://github.com/apache/superset/pull/22742) chore: Use redis 7 on tests and pin on local dev and non-dev (@dpgaspar)
- [#22624](https://github.com/apache/superset/pull/22624) chore: Migrate /superset/stop_query/ to API v1 (@diegomedina248)
- [#22504](https://github.com/apache/superset/pull/22504) build(deps): bump jsonwebtoken from 8.5.1 to 9.0.0 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#22515](https://github.com/apache/superset/pull/22515) build(deps): bump jsonwebtoken from 8.5.1 to 9.0.0 in /superset-websocket (@dependabot[bot])
- [#22575](https://github.com/apache/superset/pull/22575) build(deps): bump json5 from 1.0.1 to 1.0.2 in /superset-embedded-sdk (@dependabot[bot])
- [#22577](https://github.com/apache/superset/pull/22577) build(deps): bump json5 from 2.1.3 to 2.2.3 in /superset-frontend/cypress-base (@dependabot[bot])
- [#22578](https://github.com/apache/superset/pull/22578) build(deps): bump json5 from 1.0.1 to 1.0.2 in /superset-frontend (@dependabot[bot])
- [#22711](https://github.com/apache/superset/pull/22711) docs(security): clarify CSP requirements and provide example TALISMAN_CONFIG (@reidab)
- [#22721](https://github.com/apache/superset/pull/22721) chore: Adds 1.5.3 release to CHANGELOG.md and UPDATING.md (@michael-s-molina)
- [#22499](https://github.com/apache/superset/pull/22499) chore(celery) & docs(celery): update celery config variables names (@artemonsh)
- [#22706](https://github.com/apache/superset/pull/22706) docs: add Swile to users list (@PaoloTerzi)
- [#21612](https://github.com/apache/superset/pull/21612) chore(deps): bump parse-path and lerna in /superset-frontend (@dependabot[bot])
- [#20820](https://github.com/apache/superset/pull/20820) chore(deps): bump pre-commit from 2.14.0 to 2.20.0 in /requirements (@dependabot[bot])
- [#22655](https://github.com/apache/superset/pull/22655) build(deps): bump winston from 3.3.3 to 3.8.2 in /superset-websocket (@dependabot[bot])
- [#22576](https://github.com/apache/superset/pull/22576) build(deps): bump json5 from 2.2.0 to 2.2.3 in /superset-websocket (@dependabot[bot])
- [#22656](https://github.com/apache/superset/pull/22656) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.45.0 to 5.48.1 in /superset-websocket (@dependabot[bot])
- [#22718](https://github.com/apache/superset/pull/22718) docs: add Mainstrat to INTHEWILD.md (@itziarmj)
- [#22712](https://github.com/apache/superset/pull/22712) docs(k8s): add note about database driver dependencies to k8s setup (@reidab)
- [#22710](https://github.com/apache/superset/pull/22710) docs(k8s): add note about authlib requirement to oauth setup example (@reidab)
- [#22687](https://github.com/apache/superset/pull/22687) docs(caching): Restructure and improve caching docs (@reidab)
- [#22631](https://github.com/apache/superset/pull/22631) chore: using bitly to manage expiring Slack invitation links (@rusackas)
- [#22668](https://github.com/apache/superset/pull/22668) chore: Swapping main superset images for more current versions (@rusackas)
- [#22230](https://github.com/apache/superset/pull/22230) chore: Move charts to src/pages folder (@EugeneTorap)
- [#22692](https://github.com/apache/superset/pull/22692) docs: add city of Ann Arbor to INTHEWILD (@sfirke)
- [#22694](https://github.com/apache/superset/pull/22694) chore(superset-ui): bump superset-ui-chart-controls and plugin-chart-handlebars back to version 0.18.25 (@lilykuang)
- [#22596](https://github.com/apache/superset/pull/22596) chore: upgrade react-redux (@lilykuang)
- [#22580](https://github.com/apache/superset/pull/22580) chore: Bump Flask-AppBuilder to 4.2.0 (@john-bodley)
- [#22150](https://github.com/apache/superset/pull/22150) chore: Localization of Superset pt. 1 (@artemonsh)
- [#22579](https://github.com/apache/superset/pull/22579) chore: Migrate /superset/search_queries to API v1 (@diegomedina248)
- [#22666](https://github.com/apache/superset/pull/22666) chore: Add KarrotPay in INTHEWILD.md (@posquit0)
- [#22669](https://github.com/apache/superset/pull/22669) docs: Add Careem to the user's list (@SamraHanifCareem)
- [#22676](https://github.com/apache/superset/pull/22676) chore(embedded): bump package versions (@villebro)
- [#22645](https://github.com/apache/superset/pull/22645) chore: upgrade react-window (@lilykuang)
- [#22646](https://github.com/apache/superset/pull/22646) chore: upgrade use-immer (@lilykuang)
- [#22638](https://github.com/apache/superset/pull/22638) build(deps-dev): bump prettier from 2.4.1 to 2.8.2 in /superset-websocket (@dependabot[bot])
- [#22355](https://github.com/apache/superset/pull/22355) chore: Bump flask libs (@EugeneTorap)
- [#22615](https://github.com/apache/superset/pull/22615) chore: bump sqloxide to 0.1.30 (@nisheldo)
- [#22517](https://github.com/apache/superset/pull/22517) chore: adjusting Alerts & reports docs to use the latest chromedriver (@rusackas)
- [#22597](https://github.com/apache/superset/pull/22597) chore: adding missing examples in the gallery for several chart types (@yash-samsung)
- [#22583](https://github.com/apache/superset/pull/22583) chore: upgrade react-json-tree (@lilykuang)
- [#22573](https://github.com/apache/superset/pull/22573) chore: upgrade react-ace (@lilykuang)
- [#22572](https://github.com/apache/superset/pull/22572) chore: upgrade interweave (@lilykuang)
- [#22363](https://github.com/apache/superset/pull/22363) chore: Use visibilityToggle prop to control password input visibility (@lyndsiWilliams)
- [#22561](https://github.com/apache/superset/pull/22561) build(deps): bump json5 from 2.2.1 to 2.2.2 in /docs (@dependabot[bot])
- [#22533](https://github.com/apache/superset/pull/22533) build(deps): bump wheel from 0.37.0 to 0.38.1 in /requirements (@dependabot[bot])
- [#22557](https://github.com/apache/superset/pull/22557) build(deps): bump fast-json-patch from 3.1.0 to 3.1.1 in /docs (@dependabot[bot])
- [#22366](https://github.com/apache/superset/pull/22366) chore(ssh-tunnel): Refactor establishing raw connection with contextmanger (@hughhhh)
- [#22508](https://github.com/apache/superset/pull/22508) refactor: rename filter_rel_fields to base_related_field_filters (@dpgaspar)
- [#22489](https://github.com/apache/superset/pull/22489) chore: Bump Pillow to 9.3.0 (@EugeneTorap)
- [#22461](https://github.com/apache/superset/pull/22461) chore: Update dataset_id & dataset_type datasource_id & datasource_type for SPA explore (@hughhhh)
- [#22142](https://github.com/apache/superset/pull/22142) build(deps): bump loader-utils from 1.4.0 to 1.4.2 in /superset-embedded-sdk (@dependabot[bot])
- [#22216](https://github.com/apache/superset/pull/22216) build(deps): bump pip-compile-multi from 2.4.1 to 2.6.1 in /requirements (@dependabot[bot])
- [#22465](https://github.com/apache/superset/pull/22465) chore(deps-dev): bump @typescript-eslint/parser from 5.45.0 to 5.47.0 in /superset-websocket (@dependabot[bot])
- [#22479](https://github.com/apache/superset/pull/22479) chore: updating changelog and updating (@AAfghahi)
- [#22340](https://github.com/apache/superset/pull/22340) build(deps): bump qs from 6.5.2 to 6.5.3 in /superset-frontend/cypress-base (@dependabot[bot])
- [#22476](https://github.com/apache/superset/pull/22476) chore: adding additional code owners for cypress tests (@rusackas)
- [#22158](https://github.com/apache/superset/pull/22158) build(deps): bump @ant-design/icons from 4.2.2 to 4.8.0 in /superset-frontend (@dependabot[bot])
- [#22430](https://github.com/apache/superset/pull/22430) chore(viz): Rename legacy non-time-series Bar Chart (@codyml)
- [#22435](https://github.com/apache/superset/pull/22435) chore: Re-add inheritance of Presto macros for Trino et al. (@john-bodley)
- [#21754](https://github.com/apache/superset/pull/21754) chore(deps): bump express from 4.18.1 to 4.18.2 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#22412](https://github.com/apache/superset/pull/22412) build(deps): bump uuid and @types/uuid in /superset-websocket (@dependabot[bot])
- [#22414](https://github.com/apache/superset/pull/22414) build(deps-dev): bump typescript from 4.2.3 to 4.9.4 in /superset-websocket (@dependabot[bot])
- [#22343](https://github.com/apache/superset/pull/22343) build(deps): bump qs from 6.5.2 to 6.5.3 in /superset-frontend (@dependabot[bot])
- [#22432](https://github.com/apache/superset/pull/22432) chore: set Snowflake user agent (@betodealmeida)
- [#22424](https://github.com/apache/superset/pull/22424) test: Fix act errors in VizTypeControl test (@lyndsiWilliams)
- [#22134](https://github.com/apache/superset/pull/22134) build(deps): bump loader-utils from 2.0.2 to 2.0.4 in /docs (@dependabot[bot])
- [#22411](https://github.com/apache/superset/pull/22411) chore: show database UUID in API (@betodealmeida)
- [#21712](https://github.com/apache/superset/pull/21712) chore(deps): bump css-what from 2.1.2 to 2.1.3 in /superset-frontend (@dependabot[bot])
- [#22341](https://github.com/apache/superset/pull/22341) build(deps): bump express from 4.17.1 to 4.18.2 in /docs (@dependabot[bot])
- [#22322](https://github.com/apache/superset/pull/22322) build(deps-dev): bump eslint from 7.32.0 to 8.29.0 in /superset-websocket (@dependabot[bot])
- [#22386](https://github.com/apache/superset/pull/22386) build(deps-dev): bump @types/node from 18.11.10 to 18.11.13 in /superset-websocket (@dependabot[bot])
- [#22389](https://github.com/apache/superset/pull/22389) perf: Prevent rerendering and re-querying metadata of filters in horizontal bar (@kgabryje)
- [#22382](https://github.com/apache/superset/pull/22382) chore(plugin-chart-echarts): upgrade to echarts 5.4.1 (@villebro)
- [#22369](https://github.com/apache/superset/pull/22369) chore(viz): rename v1 and v2 charts (@villebro)
- [#22347](https://github.com/apache/superset/pull/22347) chore(docs): adding community calendar link to the community page (@rusackas)
- [#19721](https://github.com/apache/superset/pull/19721) refactor(frontend): Make dashboard search box the first filter (@cemremengu)
- [#22354](https://github.com/apache/superset/pull/22354) chore: Bump holidays to 0.17.2 (@EugeneTorap)
- [#22335](https://github.com/apache/superset/pull/22335) chore: Refactor python libs (@EugeneTorap)
- [#22327](https://github.com/apache/superset/pull/22327) build(deps): bump ws and @types/ws in /superset-websocket (@dependabot[bot])
- [#22334](https://github.com/apache/superset/pull/22334) test: Fix act errors in FixedOrMetricControl test (@lyndsiWilliams)
- [#22305](https://github.com/apache/superset/pull/22305) chore: Add Horizontal FilterBar e2e tests (@geido)
- [#22333](https://github.com/apache/superset/pull/22333) chore: return 404 instead of 500 for datasource not found (@hughhhh)
- [#22231](https://github.com/apache/superset/pull/22231) chore: Remove actions prop and refactor code in SQL Lab (@EugeneTorap)
- [#22217](https://github.com/apache/superset/pull/22217) chore: Support Python 3.11 (@EugeneTorap)
- [#22309](https://github.com/apache/superset/pull/22309) build(deps-dev): bump @typescript-eslint/eslint-plugin from 4.19.0 to 5.45.0 in /superset-websocket (@dependabot[bot])
- [#22023](https://github.com/apache/superset/pull/22023) docs: update Flask-Babel links (@haocheng6)
- [#22315](https://github.com/apache/superset/pull/22315) build(deps): bump decode-uri-component from 0.2.0 to 0.2.2 in /superset-frontend (@dependabot[bot])
- [#22307](https://github.com/apache/superset/pull/22307) chore(native-filters): Grid units, type guard, feature flag guard (@codyml)
- [#21466](https://github.com/apache/superset/pull/21466) chore: Bump bigquery libs (@EugeneTorap)
- [#22313](https://github.com/apache/superset/pull/22313) docs: Add REDCap Cloud to superset users (@EugeneTorap)
- [#22297](https://github.com/apache/superset/pull/22297) build(deps-dev): bump @types/node from 16.11.6 to 18.11.10 in /superset-websocket (@dependabot[bot])
- [#22296](https://github.com/apache/superset/pull/22296) build(deps-dev): bump @types/cookie from 0.4.1 to 0.5.1 in /superset-websocket (@dependabot[bot])
- [#22295](https://github.com/apache/superset/pull/22295) build(deps): bump hot-shots from 9.0.0 to 9.3.0 in /superset-websocket (@dependabot[bot])
- [#22242](https://github.com/apache/superset/pull/22242) docs: Add Oslandia to superset users (@vpicavet)
- [#22279](https://github.com/apache/superset/pull/22279) chore: bump clickhouse to 0.4.6 (@betodealmeida)
- [#22255](https://github.com/apache/superset/pull/22255) build(deps-dev): bump @typescript-eslint/parser from 4.19.0 to 5.45.0 in /superset-websocket (@dependabot[bot])
- [#22272](https://github.com/apache/superset/pull/22272) chore(superset-ui): remove deprecated fields from QueryObject (@villebro)
- [#22266](https://github.com/apache/superset/pull/22266) chore(dashboard): Fix missing React key errors (@codyml)
- [#22214](https://github.com/apache/superset/pull/22214) chore(dashboard): Ignore empty json value for overwrite confirm (@justinpark)
- [#22224](https://github.com/apache/superset/pull/22224) refactor: restructure shared-contrls modules (@zhaoyongjie)
- [#22181](https://github.com/apache/superset/pull/22181) build(docker): Push websocket image (@Yann-J)
- [#22197](https://github.com/apache/superset/pull/22197) chore: rename 'Change dataset' action to 'Swap dataset' (@mistercrunch)
- [#22178](https://github.com/apache/superset/pull/22178) chore: remove annotation layer FAB CRUD model view (@dpgaspar)
- [#22187](https://github.com/apache/superset/pull/22187) docs: add AI inside to users list (@kamalkeshavani-aiinside)
- [#22157](https://github.com/apache/superset/pull/22157) docs: installing database drivers - trino (@wrb2)
- [#22085](https://github.com/apache/superset/pull/22085) chore: Change get_table_names/get_view_names return type (@john-bodley)
- [#22145](https://github.com/apache/superset/pull/22145) docs: Add docs for Amazon Dynamodb database driver (@passren)
- [#22007](https://github.com/apache/superset/pull/22007) chore: Upgrade antd@4.10.3 (@geido)
- [#22093](https://github.com/apache/superset/pull/22093) test(sqllab): Convert tests to RTL for SqlEditor (@corbinrobb)
- [#22130](https://github.com/apache/superset/pull/22130) docs: Add potential downtime line item to UPDATING.md (@john-bodley)
- [#21650](https://github.com/apache/superset/pull/21650) chore: Use queryEditorId in SqlEditor child components (@EugeneTorap)
- [#22121](https://github.com/apache/superset/pull/22121) chore(docs): update slack invite url (@kamalkeshavani-aiinside)
- [#22050](https://github.com/apache/superset/pull/22050) chore(sqllab): Change icon color for running sql (@justinpark)
- [#22116](https://github.com/apache/superset/pull/22116) chore: deprecate /superset/datasources/ (@dpgaspar)
- [#21971](https://github.com/apache/superset/pull/21971) refactor: use exception status for logging (@eschutho)
- [#21986](https://github.com/apache/superset/pull/21986) chore: remove shadow write of new sip 68 dataset models (@eschutho)
- [#22113](https://github.com/apache/superset/pull/22113) refactor: add deprecated decorator for old SupersetView's (@dpgaspar)
- [#22102](https://github.com/apache/superset/pull/22102) chore: deprecate /superset/fetch_datasource_metadata mig to API v1 (@dpgaspar)
- [#22074](https://github.com/apache/superset/pull/22074) refactor: update documents and rename variables (@zhaoyongjie)
- [#22083](https://github.com/apache/superset/pull/22083) chore: improve performance on bootstrap permissions (@dpgaspar)
- [#22024](https://github.com/apache/superset/pull/22024) chore(bigquery): Add extra logging for BigQuery exceptions so we can have better insight on exceptions (@Antonio-RiveroMartnez)
- [#22067](https://github.com/apache/superset/pull/22067) chore: update Druid (@betodealmeida)
- [#22068](https://github.com/apache/superset/pull/22068) test: Fix act errors in DndColumnSelectControl tests (@corbinrobb)
- [#22048](https://github.com/apache/superset/pull/22048) test: Fix act errors in DndMetricSelect test (@lyndsiWilliams)
- [#22041](https://github.com/apache/superset/pull/22041) chore: Adds RTL tests to DropdownContainer (@michael-s-molina)
- [#21954](https://github.com/apache/superset/pull/21954) build: Multi-stage build and slim image for websocket container (@Yann-J)
- [#22032](https://github.com/apache/superset/pull/22032) chore(dataset): enable reload for schema and table (@justinpark)
- [#22015](https://github.com/apache/superset/pull/22015) refactor: Feature flags getter (@zhaoyongjie)
- [#22002](https://github.com/apache/superset/pull/22002) refactor: clean up codes (@zhaoyongjie)
- [#21990](https://github.com/apache/superset/pull/21990) chore: Verify edit permission for Horizontal filter bar (@geido)
- [#21938](https://github.com/apache/superset/pull/21938) chore: Refactor ownership (@john-bodley)
- [#21982](https://github.com/apache/superset/pull/21982) chore: bubble up more db error messages (@villebro)
- [#21836](https://github.com/apache/superset/pull/21836) refactor: return initial exception and check if it's user error (@hughhhh)
- [#21781](https://github.com/apache/superset/pull/21781) perf(native-filters): reduce the re-rendering of native filter modal (@stephenLYZ)
- [#21821](https://github.com/apache/superset/pull/21821) perf(native-filters): improve native filter modal form performance (@stephenLYZ)
- [#21963](https://github.com/apache/superset/pull/21963) build(helm): Helm-docs + fix Helm chart release (@Yann-J)
- [#21958](https://github.com/apache/superset/pull/21958) chore: bump pyathena and related packages (@eschutho)
- [#21725](https://github.com/apache/superset/pull/21725) chore: Remove several React app console warnings and errors v2 (@agl-developer)
- [#21951](https://github.com/apache/superset/pull/21951) docs(athena): add assuming IAM role with PyAthena (@gforien)
- [#21802](https://github.com/apache/superset/pull/21802) chore: additional logging in alerts and reports (@AAfghahi)
- [#21916](https://github.com/apache/superset/pull/21916) chore(plugin-chart-echarts): bump ECharts to 5.4.0 (@villebro)
- [#21908](https://github.com/apache/superset/pull/21908) chore: Improves D2D loading indicator (@michael-s-molina)
- [#21896](https://github.com/apache/superset/pull/21896) chore: Updating SIP issue template to boost the link, and (hopefully) reduce duplicate-numbered SIP issues. (@rusackas)
- [#21815](https://github.com/apache/superset/pull/21815) chore: Remove CROSS_REFERENCES feature flag (@geido)
- [#21805](https://github.com/apache/superset/pull/21805) chore: E2E Dashboards Cross-references (@geido)
- [#21622](https://github.com/apache/superset/pull/21622) chore: Color consistency E2E tests (@geido)
- [#21849](https://github.com/apache/superset/pull/21849) docs: 414 (@Onroe)
- [#21816](https://github.com/apache/superset/pull/21816) chore: Added translate functions (@AndVK)
- [#21818](https://github.com/apache/superset/pull/21818) chore: Add `USER_CLIENT_ERRORS` to stop logging exceptions that are user driven (@hughhhh)
- [#21523](https://github.com/apache/superset/pull/21523) refactor: serialize extra json in state (@eschutho)
- [#21714](https://github.com/apache/superset/pull/21714) chore: add more logging for alerts and reports (@pkdotson)
- [#21787](https://github.com/apache/superset/pull/21787) chore: stop logging "SyntaxError" as exceptions (@hughhhh)
- [#21766](https://github.com/apache/superset/pull/21766) refactor: preparation for time section migration (@zhaoyongjie)
- [#21738](https://github.com/apache/superset/pull/21738) chore: cleanup on catalog check for Gsheets (@hughhhh)
- [#21438](https://github.com/apache/superset/pull/21438) perf(dashboard): Virtualization POC (@kgabryje)
- [#21744](https://github.com/apache/superset/pull/21744) chore(explore): Add tests for getControlValuesCompatibleWithDatasource (@codyml)
- [#21748](https://github.com/apache/superset/pull/21748) chore(deps): bump react-map-gl from 4.0.10 to 6.1.19 (@stephenLYZ)
- [#21711](https://github.com/apache/superset/pull/21711) chore(sqllab): refactor addQueryEditor for new tab (@justinpark)
- [#20435](https://github.com/apache/superset/pull/20435) chore: Slovenian translation update (@dkrat7)
- [#21024](https://github.com/apache/superset/pull/21024) docs(snowflake): Remove wrong version info for snowflake (@dingobar)
- [#21491](https://github.com/apache/superset/pull/21491) docs: wording in template (@JakobMiksch)
- [#21583](https://github.com/apache/superset/pull/21583) build: optimize docker build by better utilizing build cache (@pwang2)
- [#21670](https://github.com/apache/superset/pull/21670) docs(cache): update datasource -> dataset (@nytai)
- [#21681](https://github.com/apache/superset/pull/21681) chore: E2E tests for Drill to Detail supported Charts (@geido)
- [#21702](https://github.com/apache/superset/pull/21702) chore(key-value): remove redundant exception logging (@villebro)
- [#17320](https://github.com/apache/superset/pull/17320) other: Improve health check for docker-compose. (@PMExtra)
- [#21474](https://github.com/apache/superset/pull/21474) chore: Adding/categorizing missing flags in `FEATURE_FLAGS.md` (@rusackas)
- [#21586](https://github.com/apache/superset/pull/21586) chore(dep): Unpin slackclient dependency (@ecederstrand)
- [#21687](https://github.com/apache/superset/pull/21687) docs: add Wise to users list (@koszti)
- [#21487](https://github.com/apache/superset/pull/21487) refactor: pass all properties to validate_parameters (@eschutho)
- [#21627](https://github.com/apache/superset/pull/21627) chore: add 4xx error codes where applicable (@eschutho)
- [#21614](https://github.com/apache/superset/pull/21614) chore(style): Enforce optional chaining (@rusackas)
- [#21459](https://github.com/apache/superset/pull/21459) chore(tags): Refactor logic to leverage Flask-SQLAlchemy extension (@john-bodley)
- [#21631](https://github.com/apache/superset/pull/21631) chore: avoid undefined property on `Global` type (@justinpark)
- [#21660](https://github.com/apache/superset/pull/21660) docs: add organization that uses superset (@zamar-roura)
- [#21551](https://github.com/apache/superset/pull/21551) chore: Create dashboard with tier 1 and tier 2 charts (@kgabryje)
- [#21643](https://github.com/apache/superset/pull/21643) refactor: remove useless groupby from QueryObject (@zhaoyongjie)
- [#21654](https://github.com/apache/superset/pull/21654) chore(deps): bump minimist from 0.0.5 to 1.2.6 in /superset-frontend (@dependabot[bot])
- [#21611](https://github.com/apache/superset/pull/21611) chore: removing '.git' from web url references in Yeoman generator's package.json (@rusackas)
- [#21532](https://github.com/apache/superset/pull/21532) chore: refactor AceEditorWrapper to functional component (@EugeneTorap)
- [#20958](https://github.com/apache/superset/pull/20958) docs: update installing-superset-using-docker-compose.mdx (@avlihachev)
- [#20853](https://github.com/apache/superset/pull/20853) docs: Removing erroneous FAQ timeout message (@john-bodley)
- [#21169](https://github.com/apache/superset/pull/21169) chore(deps): bump node-forge and webpack-dev-server in /superset-frontend (@dependabot[bot])
- [#21602](https://github.com/apache/superset/pull/21602) chore(deps-dev): bump @types/jsonwebtoken from 8.5.5 to 8.5.9 in /superset-websocket (@dependabot[bot])
- [#20978](https://github.com/apache/superset/pull/20978) chore(deps): bump http-errors from 1.8.0 to 2.0.0 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#20983](https://github.com/apache/superset/pull/20983) chore(deps): bump cookie from 0.4.1 to 0.5.0 in /superset-websocket (@dependabot[bot])
- [#20785](https://github.com/apache/superset/pull/20785) chore(deps): bump terser from 5.10.0 to 5.14.2 in /superset-embedded-sdk (@dependabot[bot])
- [#21601](https://github.com/apache/superset/pull/21601) chore: Updates CHANGELOG.md and UPDATING.md with 1.5.2 changes (@michael-s-molina)
- [#21589](https://github.com/apache/superset/pull/21589) refactor: Organizes the Select files (@michael-s-molina)
- [#21543](https://github.com/apache/superset/pull/21543) chore(dashboard): Add filter_scopes warning message for json metadata editor (@justinpark)
- [#21581](https://github.com/apache/superset/pull/21581) chore(deps): Unpin sqlparse dependency (@ecederstrand)
- [#21566](https://github.com/apache/superset/pull/21566) docs: Turkey map already added (@rizacavus)
- [#21565](https://github.com/apache/superset/pull/21565) chore(deps): bump moment-timezone from 0.5.33 to 0.5.37 in /superset-frontend (@dependabot[bot])
- [#21553](https://github.com/apache/superset/pull/21553) chore: Remove chromatic job per PR as it has errors (@eric-briscoe)
- [#21496](https://github.com/apache/superset/pull/21496) refactor: Rewrites ColorSchemeControl with TypeScript (@michael-s-molina)
- [#21320](https://github.com/apache/superset/pull/21320) chore: refactor SqlEditor to functional component (@EugeneTorap)
- [#21510](https://github.com/apache/superset/pull/21510) refactor: refine timestamp expr function (@zhaoyongjie)
- [#21524](https://github.com/apache/superset/pull/21524) chore: should return if get a exception in Dashboard edit modal (@zhaoyongjie)
- [#21504](https://github.com/apache/superset/pull/21504) perf(word-cloud): reduce render to improve performance (@stephenLYZ)
- [#21326](https://github.com/apache/superset/pull/21326) chore: Use slim image in Dockerfile (@EugeneTorap)
- [#21445](https://github.com/apache/superset/pull/21445) refactor: Moves the DeprecatedSelect to its own folder (@michael-s-molina)
- [#21449](https://github.com/apache/superset/pull/21449) refactor: get Axis from a helper function (@zhaoyongjie)
- [#21094](https://github.com/apache/superset/pull/21094) chore: Extract common select component code (@cccs-RyanK)
- [#21346](https://github.com/apache/superset/pull/21346) chore: remove blank space from users filters (@lilykuang)
- [#21456](https://github.com/apache/superset/pull/21456) test: Fix act errors in ExploreChartPanel test (@lyndsiWilliams)
- [#21439](https://github.com/apache/superset/pull/21439) perf: Memoize the common_bootstrap_payload and include user param (#21018) (@bkyryliuk)
- [#21414](https://github.com/apache/superset/pull/21414) test: Fixes act errors in ErrorMessage tests (@michael-s-molina)
- [#21332](https://github.com/apache/superset/pull/21332) chore: Cypress runtime enhancements (@geido)
- [#21427](https://github.com/apache/superset/pull/21427) test: Fix act errors in CustomFrame test (@lyndsiWilliams)
- [#21415](https://github.com/apache/superset/pull/21415) test: Fixes act errors in LastUpdated test (@michael-s-molina)
- [#21413](https://github.com/apache/superset/pull/21413) chore: Bump sqlalchemy-utils to 0.38.3 (@EugeneTorap)
- [#21429](https://github.com/apache/superset/pull/21429) test: Fix act errors in DndFilterSelect test (@lyndsiWilliams)
- [#21428](https://github.com/apache/superset/pull/21428) test: Fix act errors in DndColumnSelect test (@lyndsiWilliams)
- [#21426](https://github.com/apache/superset/pull/21426) test: Fix act errors in DatasourceControl test (@lyndsiWilliams)
- [#21423](https://github.com/apache/superset/pull/21423) test: Fix act errors in AnnotationLayer test (@lyndsiWilliams)
- [#21421](https://github.com/apache/superset/pull/21421) test: Fix act errors in CollectionControl test (@lyndsiWilliams)
- [#21424](https://github.com/apache/superset/pull/21424) test: Fixes act errors in DatasourceEditor test (@michael-s-molina)
- [#21420](https://github.com/apache/superset/pull/21420) test: Fixes act errors in ReportModal test (@michael-s-molina)
- [#21418](https://github.com/apache/superset/pull/21418) test: Fixes act errors in ListView test (@michael-s-molina)
- [#21416](https://github.com/apache/superset/pull/21416) test: Fixes act errors in PopoverSection test (@michael-s-molina)
- [#21412](https://github.com/apache/superset/pull/21412) test: Fixes act errors in ErrorBoundary test (@michael-s-molina)
- [#21303](https://github.com/apache/superset/pull/21303) chore: add test for SPA explore endpoints around missing datasets (@hughhhh)
- [#21410](https://github.com/apache/superset/pull/21410) test: Fix act errors in DatasourcePanelDragOption test (@lyndsiWilliams)
- [#21407](https://github.com/apache/superset/pull/21407) test: Fix act error in FilterInput test (@lyndsiWilliams)
- [#21409](https://github.com/apache/superset/pull/21409) test: Fix act errors in DatasourcePanel test (@lyndsiWilliams)
- [#21406](https://github.com/apache/superset/pull/21406) test: Fix act errors in SamplesPane test (@lyndsiWilliams)
- [#21404](https://github.com/apache/superset/pull/21404) test: Fix act errors in ResultsPaneOnDashboard test (@lyndsiWilliams)
- [#21403](https://github.com/apache/superset/pull/21403) test: Fix act error in DataTablesPane test (@lyndsiWilliams)
- [#21402](https://github.com/apache/superset/pull/21402) test: Fix act errors in ExploreChartHeader test (@lyndsiWilliams)
- [#21401](https://github.com/apache/superset/pull/21401) test: Fix act error in ExportToCVSDropdown test (@lyndsiWilliams)
- [#21400](https://github.com/apache/superset/pull/21400) test: Fix act error in PropertyModal test (@lyndsiWilliams)
- [#21398](https://github.com/apache/superset/pull/21398) test: Fix act errors in ControlPanelsContainer test (@lyndsiWilliams)
- [#21397](https://github.com/apache/superset/pull/21397) test: Fix act errors in ExploreChartPanel test (@lyndsiWilliams)
- [#21396](https://github.com/apache/superset/pull/21396) test: Fix act errors in SelectFilterPlugin test (@lyndsiWilliams)
- [#21395](https://github.com/apache/superset/pull/21395) test: Fix act errors in LanguagePicker test (@lyndsiWilliams)
- [#21370](https://github.com/apache/superset/pull/21370) chore(database): raised version of sqlalchemy-kusto (@xneg)
- [#21393](https://github.com/apache/superset/pull/21393) test: Fixes act errors in Toast test (@michael-s-molina)
- [#21391](https://github.com/apache/superset/pull/21391) test: Fix act errors in Menu test (@lyndsiWilliams)
- [#21390](https://github.com/apache/superset/pull/21390) test: Fixes act errors in RefreshLabel test (@michael-s-molina)
- [#21394](https://github.com/apache/superset/pull/21394) test: Fixes act errors in ErrorAlert test (@michael-s-molina)
- [#21383](https://github.com/apache/superset/pull/21383) test: Fix act errors in LeftPanel test (@lyndsiWilliams)
- [#21389](https://github.com/apache/superset/pull/21389) test: Fixes act errors in PageHeaderWithActions test (@michael-s-molina)
- [#21392](https://github.com/apache/superset/pull/21392) test: Fixes act errors in AlteredSliceTag test (@michael-s-molina)
- [#21384](https://github.com/apache/superset/pull/21384) test: Fixes act errors in CertifiedBadge test (@michael-s-molina)
- [#21386](https://github.com/apache/superset/pull/21386) test: Fixes act errors in Alert test (@michael-s-molina)
- [#21387](https://github.com/apache/superset/pull/21387) test: Fix act errors in SubMenu test (@lyndsiWilliams)
- [#21381](https://github.com/apache/superset/pull/21381) test: Fix act errors in AddDataset test (@lyndsiWilliams)
- [#21374](https://github.com/apache/superset/pull/21374) test: Fixes act errors in IndeterminateCheckbox test (@michael-s-molina)
- [#21376](https://github.com/apache/superset/pull/21376) test: Fixes act errors in HeaderReportDropdown test (@michael-s-molina)
- [#21375](https://github.com/apache/superset/pull/21375) test: Fixes act errors in TableView test (@michael-s-molina)
- [#21377](https://github.com/apache/superset/pull/21377) test: Fixes act errors in TimezoneSelector test (@michael-s-molina)
- [#21367](https://github.com/apache/superset/pull/21367) test: Fix act errors in DatasetLayout test (@lyndsiWilliams)
- [#21363](https://github.com/apache/superset/pull/21363) test: Fix act errors in SqlEditorLeftBar test (@lyndsiWilliams)
- [#21361](https://github.com/apache/superset/pull/21361) test: Fix act errors in PopoverDropdown test (@lyndsiWilliams)
- [#21360](https://github.com/apache/superset/pull/21360) test: Fix act errors in FaveStar test (@lyndsiWilliams)
- [#21365](https://github.com/apache/superset/pull/21365) test: Fix act errors in DatabaseModal test (@lyndsiWilliams)
- [#21362](https://github.com/apache/superset/pull/21362) test: Fix act errors in SaveDatasetActionButton test (@lyndsiWilliams)
- [#21309](https://github.com/apache/superset/pull/21309) docs: correct location of existing time grain definition (@sfirke)
- [#21186](https://github.com/apache/superset/pull/21186) chore: refactor ResultSet to functional component (@EugeneTorap)
- [#21329](https://github.com/apache/superset/pull/21329) chore: bump FAB to 4.1.4 (@dpgaspar)
- [#21324](https://github.com/apache/superset/pull/21324) chore: upgrade yeoman-generator to fix security warnings (@stephenLYZ)
- [#20910](https://github.com/apache/superset/pull/20910) chore: refactor ChartHolder to typescript + tests (@diegomedina248)
- [#21285](https://github.com/apache/superset/pull/21285) chore: Bump pandas to 1.4.4 (@EugeneTorap)
- [#21240](https://github.com/apache/superset/pull/21240) refactor: introduce react-query on api resource hook (@justinpark)
- [#21173](https://github.com/apache/superset/pull/21173) chore: migrate available_domains to api/v1 (@zephyring)
- [#21270](https://github.com/apache/superset/pull/21270) chore: update release docs (@michael-s-molina)
- [#21278](https://github.com/apache/superset/pull/21278) chore: Renaming Line Chart to Line Chart v2 (@lauderbaugh)
- [#20776](https://github.com/apache/superset/pull/20776) chore: updating thrift (@nisheldo)
- [#21280](https://github.com/apache/superset/pull/21280) chore(sqllab): Remove max-width on side panel (@justinpark)
- [#21218](https://github.com/apache/superset/pull/21218) chore: missing IconType on Icons (@justinpark)
- [#21239](https://github.com/apache/superset/pull/21239) chore: Minor Applitools enhancements (@geido)
- [#21148](https://github.com/apache/superset/pull/21148) chore: Drill to detail Modal tests (@geido)
- [#21212](https://github.com/apache/superset/pull/21212) chore: Keeps context menu in viewport (@michael-s-molina)
- [#21187](https://github.com/apache/superset/pull/21187) chore: E2E tests for the Drill to detail modal (@geido)
- [#21184](https://github.com/apache/superset/pull/21184) chore: Add new e2e tests for Explore (@kgabryje)
- [#21195](https://github.com/apache/superset/pull/21195) chore: Dump clickhouse-sqlalchemy 0.2.2 (@EugeneTorap)
- [#21156](https://github.com/apache/superset/pull/21156) perf: Reimplement permissions fetching to do it in a single transaction (@bkyryliuk)
- [#20877](https://github.com/apache/superset/pull/20877) perf(sqllab): Rendering perf improvement using immutable state (@justinpark)
- [#21062](https://github.com/apache/superset/pull/21062) chore(deps): bump async from 2.6.3 to 2.6.4 in /superset-frontend (@dependabot[bot])
- [#21037](https://github.com/apache/superset/pull/21037) docs: Format the same size of picture for better part of "Supported Databases" document (@zhouyao1994)
- [#21128](https://github.com/apache/superset/pull/21128) docs: added timescaledb (@Rajakavitha1)
- [#21123](https://github.com/apache/superset/pull/21123) chore: support trailing slashes in database api (@diegomedina248)
- [#21136](https://github.com/apache/superset/pull/21136) chore: refactor FilterableTable to functional component (@EugeneTorap)
- [#21104](https://github.com/apache/superset/pull/21104) chore(deps): bump jsprim to 1.4.2 (@diegomedina248)
- [#21142](https://github.com/apache/superset/pull/21142) chore(fab): Expose the TableColumnInlineView extra column listed in the legacy FAB API (@john-bodley)
- [#21121](https://github.com/apache/superset/pull/21121) chore: Dump all babel libs (@EugeneTorap)
- [#21020](https://github.com/apache/superset/pull/21020) test: Fix async tests in SaveDatasetModal and complete overwrite screen test (@lyndsiWilliams)
- [#21118](https://github.com/apache/superset/pull/21118) chore(fab): Expose the SqlMetricInlineView extra column listed in the legacy FAB API (@john-bodley)
- [#21111](https://github.com/apache/superset/pull/21111) docs: improve encrypted field adapter docs (@dpgaspar)
- [#21002](https://github.com/apache/superset/pull/21002) chore: Support Python 3.10 and bump pandas 1.4 and pyarrow 6 (@EugeneTorap)
- [#21052](https://github.com/apache/superset/pull/21052) chore: Add embedded docs configuration details to extensions registry (@jfrag1)
- [#21046](https://github.com/apache/superset/pull/21046) chore(deps): bump ejs from 2.7.4 to 3.1.8 in /superset-frontend (@dependabot[bot])
- [#21047](https://github.com/apache/superset/pull/21047) chore(deps): bump minimist from 1.2.5 to 1.2.6 in /superset-frontend (@dependabot[bot])
- [#20949](https://github.com/apache/superset/pull/20949) chore: add test for tab state (@eschutho)
- [#20974](https://github.com/apache/superset/pull/20974) perf: Implement model specific lookups by id to improve performance (@bkyryliuk)
- [#20807](https://github.com/apache/superset/pull/20807) chore: Audit E2E tests for color schemes in Dashboard and Explore (@geido)
- [#20773](https://github.com/apache/superset/pull/20773) chore: update text for dbconn modal (@pkdotson)
- [#20979](https://github.com/apache/superset/pull/20979) chore(deps): bump express from 4.17.1 to 4.18.1 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#20980](https://github.com/apache/superset/pull/20980) chore(deps): bump debug from 4.3.2 to 4.3.4 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#20976](https://github.com/apache/superset/pull/20976) chore(requirements): Bump trino-python-client (@john-bodley)
- [#20982](https://github.com/apache/superset/pull/20982) chore(deps): bump cookie-parser from 1.4.5 to 1.4.6 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#20920](https://github.com/apache/superset/pull/20920) chore: make dependabot upgrade package.json + add more package.json files (@rusackas)
- [#20894](https://github.com/apache/superset/pull/20894) chore: always get dashboard_id on dashboard API get endpoint (@lilykuang)
- [#20948](https://github.com/apache/superset/pull/20948) chore: unpin snowflake (@betodealmeida)
- [#20911](https://github.com/apache/superset/pull/20911) test: autouse app_context in unit tests (@ktmud)
- [#20868](https://github.com/apache/superset/pull/20868) chore: change Sort-by and Sort-Descending controls for Bar Chart v2 (@stephenLYZ)
- [#20921](https://github.com/apache/superset/pull/20921) chore: add cypress codeowners to e2e tests (@eschutho)
- [#20922](https://github.com/apache/superset/pull/20922) chore: Update Makefile to use `npm ci` (@hughhhh)
- [#20917](https://github.com/apache/superset/pull/20917) chore: Add Applitools logo to the docs homepage (@geido)
- [#20787](https://github.com/apache/superset/pull/20787) chore(deps): bump terser from 4.6.3 to 4.8.1 in /superset-frontend (@dependabot[bot])
- [#20822](https://github.com/apache/superset/pull/20822) chore(deps): bump tox from 3.24.1 to 3.25.1 in /requirements (@dependabot[bot])
- [#20612](https://github.com/apache/superset/pull/20612) chore(explore): update Explore icons and icon colors (@codyml)
- [#20915](https://github.com/apache/superset/pull/20915) chore(test): Unskip Cypress test (@codyml)
- [#20884](https://github.com/apache/superset/pull/20884) other(mypy): Enable warn_unused_ignores (@john-bodley)
- [#20690](https://github.com/apache/superset/pull/20690) chore: Remove unnecessary code from async and sync select components (@cccs-RyanK)
- [#20669](https://github.com/apache/superset/pull/20669) chore: adding Bazaar Technologies to Superset Users (@umair-abro)
- [#20786](https://github.com/apache/superset/pull/20786) chore(deps): bump terser from 5.9.0 to 5.14.2 in /docs (@dependabot[bot])
- [#20810](https://github.com/apache/superset/pull/20810) refactor: Improve performance regression introduced in #20473 (@john-bodley)
- [#20858](https://github.com/apache/superset/pull/20858) chore: updated resources with newer blogs and events (@srinify)
- [#20870](https://github.com/apache/superset/pull/20870) test: suppress flask_appbuilder logs in CI (@ktmud)
- [#20804](https://github.com/apache/superset/pull/20804) chore: Feature flag for embedding charts (@geido)
- [#20789](https://github.com/apache/superset/pull/20789) chore: Ignore Applitools by default when running Cypress tests (@geido)
- [#20856](https://github.com/apache/superset/pull/20856) docs: fix alt image issue (@srinify)
- [#20589](https://github.com/apache/superset/pull/20589) chore: Update color scheme when deleted or changed (@geido)
- [#20849](https://github.com/apache/superset/pull/20849) chore: add databricks logo (@srinify)
- [#20846](https://github.com/apache/superset/pull/20846) chore: Change Button background color from primary.dark1 to primary.base (@kgabryje)
- [#20841](https://github.com/apache/superset/pull/20841) chore: add SAMPLES_ROW_LIMIT in frontend conf (@zhaoyongjie)
- [#20775](https://github.com/apache/superset/pull/20775) chore: update Pillow (@nisheldo)
- [#20813](https://github.com/apache/superset/pull/20813) chore: bumps the handlebars plugin package version to match the family. (@rusackas)
- [#20732](https://github.com/apache/superset/pull/20732) other: Blossom metric fields for dataset API column selection (@john-bodley)
- [#20660](https://github.com/apache/superset/pull/20660) chore: add user agent to Databricks requests (@betodealmeida)
- [#20769](https://github.com/apache/superset/pull/20769) chore: add coverage command in package.json (@zhaoyongjie)
- [#20705](https://github.com/apache/superset/pull/20705) docs: add Platzi.com to users list (@ernestoruiz89)
- [#20713](https://github.com/apache/superset/pull/20713) chore: add apache header for 2.0 changelog (@ktmud)
- [#20703](https://github.com/apache/superset/pull/20703) refactor(test): add login_as_admin to global conftest (@ktmud)
- [#20490](https://github.com/apache/superset/pull/20490) docs: WIP release notes for 2.0 (@srinify)
- [#20709](https://github.com/apache/superset/pull/20709) chore: Updates CHANGELOG.md and UPDATING.md with 2.0.0 changes (@michael-s-molina)
- [#20557](https://github.com/apache/superset/pull/20557) docs: update intro.mdx (@ciusji)
- [#20598](https://github.com/apache/superset/pull/20598) docs: add pyodbc (@vladik-hbinov)
- [#20695](https://github.com/apache/superset/pull/20695) docs: update elasticsearch.mdx (@lguillaud)
- [#20645](https://github.com/apache/superset/pull/20645) refactor: Unify shared datasources reducers and actions (@michael-s-molina)
- [#20675](https://github.com/apache/superset/pull/20675) refactor: Renders addSlice in SPA (@michael-s-molina)
- [#20498](https://github.com/apache/superset/pull/20498) chore(explore): Update chart save to use API endpoints (@codyml)
- [#20098](https://github.com/apache/superset/pull/20098) chore(docs): custom and built-in event logging class at the same time (@wiktor2200)
- [#20649](https://github.com/apache/superset/pull/20649) chore(deps-dev): bump jsdom from 16.4.0 to 20.0.0 in /superset-frontend (@dependabot[bot])
- [#20622](https://github.com/apache/superset/pull/20622) chore(docs): enhanced docs for feature flags setting to make it more clear (@wiktor2200)
- [#20657](https://github.com/apache/superset/pull/20657) docs: Remove unnecessary line item (@john-bodley)
- [#20338](https://github.com/apache/superset/pull/20338) chore: removing Druid from front- and back- end (@AAfghahi)
- [#20466](https://github.com/apache/superset/pull/20466) chore: Split Select component into Async and Sync components (@cccs-RyanK)
- [#20578](https://github.com/apache/superset/pull/20578) docs: add WikiMedia Foundation to users list (@vg)
- [#20643](https://github.com/apache/superset/pull/20643) chore(deps): bump moment from 2.29.2 to 2.29.4 in /docs (@dependabot[bot])
- [#20469](https://github.com/apache/superset/pull/20469) chore(deps): bump got from 11.8.3 to 11.8.5 in /superset-frontend/cypress-base (@dependabot[bot])
- [#20614](https://github.com/apache/superset/pull/20614) chore(deps): bump parse-url from 6.0.0 to 6.0.2 in /superset-frontend (@dependabot[bot])
- [#20640](https://github.com/apache/superset/pull/20640) docs: small fixes for OAuth (@dpgaspar)
- [#20475](https://github.com/apache/superset/pull/20475) chore: Set table viz default row limit to 1000 (@diegomedina248)
- [#20628](https://github.com/apache/superset/pull/20628) chore: rename "uiOverrideRegistry" -> "extensionsRegistry" (@suddjian)
- [#20572](https://github.com/apache/superset/pull/20572) refactor: Renders Explore in SPA (@michael-s-molina)
- [#20502](https://github.com/apache/superset/pull/20502) refactor: Deprecate ensure_user_is_set in favor of override_user (@john-bodley)
- [#20344](https://github.com/apache/superset/pull/20344) chore(rls): Remove passing global username (@john-bodley)
- [#20602](https://github.com/apache/superset/pull/20602) chore: rename drop missing columns to show empty columns (@zhaoyongjie)
- [#20554](https://github.com/apache/superset/pull/20554) chore: organize github actions (@suddjian)
- [#20550](https://github.com/apache/superset/pull/20550) chore: updating python docker image to 3.8.13 (@nisheldo)
- [#20582](https://github.com/apache/superset/pull/20582) refactor: remove unused flatten function (@zhaoyongjie)
- [#20568](https://github.com/apache/superset/pull/20568) test: Improve & un-skip flaky Cypress test (@codyml)
- [#20519](https://github.com/apache/superset/pull/20519) chore(explore): Get Explore data from endpoint instead of bootstrap_data (@kgabryje)
- [#20526](https://github.com/apache/superset/pull/20526) chore: Updates Metrics and Columns font-size (@michael-s-molina)
- [#20529](https://github.com/apache/superset/pull/20529) chore: move isAdhocColumn from controls to core (@zhaoyongjie)
- [#20518](https://github.com/apache/superset/pull/20518) refactor(standardized form data): refine interface and improve code smells (@zhaoyongjie)
- [#20427](https://github.com/apache/superset/pull/20427) chore: added new translations to the spanish language (@cdpazos27)
- [#20510](https://github.com/apache/superset/pull/20510) chore: Updates control panel font size in Explore (@michael-s-molina)
- [#20473](https://github.com/apache/superset/pull/20473) refactor: Minor optimization for updating DatasetDAO columns and metrics (@john-bodley)
- [#20260](https://github.com/apache/superset/pull/20260) docs(contribute): update compatible Python versions in local environment setup instructions (@diegoauad)
- [#20448](https://github.com/apache/superset/pull/20448) chore: Restructure explore redux state (@kgabryje)
- [#20179](https://github.com/apache/superset/pull/20179) chore: Convert QueryAutoRefresh to TypeScript functional React component [sc-48362] (@eric-briscoe)
- [#20429](https://github.com/apache/superset/pull/20429) chore: remove label for new user (@eschutho)
- [#20446](https://github.com/apache/superset/pull/20446) docs(featureflags): add GENERIC_CHART_AXES flag (@novemberde)
- [#20369](https://github.com/apache/superset/pull/20369) chore(newchart): update chart creation dataset selection help text, styles (@codyml)
- [#20380](https://github.com/apache/superset/pull/20380) chore: switching out ConnectorRegistry references for DatasourceDAO (@hughhhh)
- [#20445](https://github.com/apache/superset/pull/20445) refactor: create echarts query section (@zhaoyongjie)
- [#20438](https://github.com/apache/superset/pull/20438) chore: move xaxis to superset-ui (@zhaoyongjie)
- [#20417](https://github.com/apache/superset/pull/20417) test: Skip flaky Cypress test (@codyml)
- [#20264](https://github.com/apache/superset/pull/20264) docs: Added details to Druid connection string (@Neeraj-2307)
- [#20400](https://github.com/apache/superset/pull/20400) docs: Update docs on contributing to docs (@codyml)
- [#20398](https://github.com/apache/superset/pull/20398) docs: add Matomo tracking to docs (@codyml)
