/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.hystrix.v1;

import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.hystrix.v1.SWExecutionHookWrapper;
import org.apache.skywalking.apm.plugin.hystrix.v1.SWHystrixPluginsWrapperCache;

public class HystrixPluginsInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        SWHystrixPluginsWrapperCache wrapperCache = (SWHystrixPluginsWrapperCache)objInst.getSkyWalkingDynamicField();
        if (wrapperCache == null || wrapperCache.getSwExecutionHookWrapper() == null) {
            EnhancedInstance enhancedInstance = objInst;
            synchronized (enhancedInstance) {
                if (wrapperCache == null) {
                    wrapperCache = new SWHystrixPluginsWrapperCache();
                    objInst.setSkyWalkingDynamicField((Object)wrapperCache);
                }
                if (wrapperCache.getSwExecutionHookWrapper() == null) {
                    SWExecutionHookWrapper wrapper = new SWExecutionHookWrapper((HystrixCommandExecutionHook)ret);
                    wrapperCache.setSwExecutionHookWrapper(wrapper);
                    HystrixPluginsInterceptor.registerSWExecutionHookWrapper(wrapper);
                    return wrapper;
                }
            }
        }
        return ret;
    }

    private static void registerSWExecutionHookWrapper(SWExecutionHookWrapper wrapper) {
        HystrixConcurrencyStrategy concurrencyStrategy = HystrixPlugins.getInstance().getConcurrencyStrategy();
        HystrixEventNotifier eventNotifier = HystrixPlugins.getInstance().getEventNotifier();
        HystrixMetricsPublisher metricsPublisher = HystrixPlugins.getInstance().getMetricsPublisher();
        HystrixPropertiesStrategy propertiesStrategy = HystrixPlugins.getInstance().getPropertiesStrategy();
        HystrixPlugins.reset();
        HystrixPlugins.getInstance().registerConcurrencyStrategy(concurrencyStrategy);
        HystrixPlugins.getInstance().registerCommandExecutionHook((HystrixCommandExecutionHook)wrapper);
        HystrixPlugins.getInstance().registerEventNotifier(eventNotifier);
        HystrixPlugins.getInstance().registerMetricsPublisher(metricsPublisher);
        HystrixPlugins.getInstance().registerPropertiesStrategy(propertiesStrategy);
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

