/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Java;

public final class Checksums {
    private static final MethodHandle BYTE_BUFFER_UPDATE;

    private Checksums() {
    }

    public static void update(Checksum checksum, ByteBuffer buffer, int length) {
        Checksums.update(checksum, buffer, 0, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(Checksum checksum, ByteBuffer buffer, int offset, int length) {
        if (buffer.hasArray()) {
            checksum.update(buffer.array(), buffer.position() + buffer.arrayOffset() + offset, length);
        } else if (BYTE_BUFFER_UPDATE != null && buffer.isDirect()) {
            int oldPosition = buffer.position();
            int oldLimit = buffer.limit();
            try {
                int start = oldPosition + offset;
                buffer.limit(start + length);
                buffer.position(start);
                BYTE_BUFFER_UPDATE.invokeExact(checksum, buffer);
            }
            catch (Throwable t) {
                Checksums.handleUpdateThrowable(t);
            }
            finally {
                buffer.limit(oldLimit);
                buffer.position(oldPosition);
            }
        } else {
            int start;
            for (int i = start = buffer.position() + offset; i < start + length; ++i) {
                checksum.update(buffer.get(i));
            }
        }
    }

    private static void handleUpdateThrowable(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IllegalStateException(t);
    }

    public static void updateInt(Checksum checksum, int input) {
        checksum.update((byte)(input >> 24));
        checksum.update((byte)(input >> 16));
        checksum.update((byte)(input >> 8));
        checksum.update((byte)input);
    }

    public static void updateLong(Checksum checksum, long input) {
        checksum.update((byte)(input >> 56));
        checksum.update((byte)(input >> 48));
        checksum.update((byte)(input >> 40));
        checksum.update((byte)(input >> 32));
        checksum.update((byte)(input >> 24));
        checksum.update((byte)(input >> 16));
        checksum.update((byte)(input >> 8));
        checksum.update((byte)input);
    }

    static {
        MethodHandle byteBufferUpdate = null;
        if (Java.IS_JAVA9_COMPATIBLE) {
            try {
                byteBufferUpdate = MethodHandles.publicLookup().findVirtual(Checksum.class, "update", MethodType.methodType(Void.TYPE, ByteBuffer.class));
            }
            catch (Throwable t) {
                Checksums.handleUpdateThrowable(t);
            }
        }
        BYTE_BUFFER_UPDATE = byteBufferUpdate;
    }
}

