/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.security.authenticator;

import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.internals.SecurityManagerCompatibility;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.security.auth.SaslExtensionsCallback;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.security.scram.ScramExtensionsCallback;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.security.scram.internals.ScramMechanism;

public class SaslClientCallbackHandler
implements AuthenticateCallbackHandler {
    private String mechanism;

    @Override
    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        this.mechanism = saslMechanism;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        Subject subject = SecurityManagerCompatibility.get().current();
        for (Callback callback : callbacks) {
            Object extensions;
            if (callback instanceof NameCallback) {
                NameCallback nc = (NameCallback)callback;
                if (subject != null && !subject.getPublicCredentials(String.class).isEmpty()) {
                    nc.setName(subject.getPublicCredentials(String.class).iterator().next());
                    continue;
                }
                nc.setName(nc.getDefaultName());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                if (subject != null && !subject.getPrivateCredentials(String.class).isEmpty()) {
                    char[] password = subject.getPrivateCredentials(String.class).iterator().next().toCharArray();
                    ((PasswordCallback)callback).setPassword(password);
                    continue;
                }
                String errorMessage = "Could not login: the client is being asked for a password, but the Kafka client code does not currently support obtaining a password from the user.";
                throw new UnsupportedCallbackException(callback, errorMessage);
            }
            if (callback instanceof RealmCallback) {
                RealmCallback rc = (RealmCallback)callback;
                rc.setText(rc.getDefaultText());
                continue;
            }
            if (callback instanceof AuthorizeCallback) {
                AuthorizeCallback ac = (AuthorizeCallback)callback;
                String authId = ac.getAuthenticationID();
                String authzId = ac.getAuthorizationID();
                ac.setAuthorized(authId.equals(authzId));
                if (!ac.isAuthorized()) continue;
                ac.setAuthorizedID(authzId);
                continue;
            }
            if (callback instanceof ScramExtensionsCallback) {
                if (!ScramMechanism.isScram(this.mechanism) || subject == null || subject.getPublicCredentials(Map.class).isEmpty()) continue;
                extensions = subject.getPublicCredentials(Map.class).iterator().next();
                ((ScramExtensionsCallback)callback).extensions((Map<String, String>)extensions);
                continue;
            }
            if (callback instanceof SaslExtensionsCallback) {
                if ("GSSAPI".equals(this.mechanism) || subject == null || subject.getPublicCredentials(SaslExtensions.class).isEmpty()) continue;
                extensions = subject.getPublicCredentials(SaslExtensions.class).iterator().next();
                ((SaslExtensionsCallback)callback).extensions((SaslExtensions)extensions);
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unrecognized SASL ClientCallback");
        }
    }

    @Override
    public void close() {
    }
}

