/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.ProduceRequestData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Message;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.RecordBatch;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.Records;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.ProduceRequest;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.AbstractIterator;

public final class RequestUtils {
    private RequestUtils() {
    }

    public static Optional<Integer> getLeaderEpoch(int leaderEpoch) {
        return leaderEpoch == -1 ? Optional.empty() : Optional.of(leaderEpoch);
    }

    public static boolean hasTransactionalRecords(ProduceRequest request) {
        return RequestUtils.flag(request, RecordBatch::isTransactional);
    }

    static boolean flag(ProduceRequest request, Predicate<RecordBatch> predicate) {
        for (ProduceRequestData.TopicProduceData tp : request.data().topicData()) {
            for (ProduceRequestData.PartitionProduceData p : tp.partitionData()) {
                AbstractIterator<? extends RecordBatch> iter;
                if (!(p.records() instanceof Records) || !(iter = ((Records)p.records()).batchIterator()).hasNext() || !predicate.test((RecordBatch)iter.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static ByteBuffer serialize(Message header, short headerVersion, Message apiMessage, short apiVersion) {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int headerSize = header.size(cache, headerVersion);
        int messageSize = apiMessage.size(cache, apiVersion);
        ByteBufferAccessor writable = new ByteBufferAccessor(ByteBuffer.allocate(headerSize + messageSize));
        header.write(writable, cache, headerVersion);
        apiMessage.write(writable, cache, apiVersion);
        writable.flip();
        return writable.buffer();
    }
}

