/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.remote;

import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;

public class GRPCStreamServiceStatus {
    private static final ILog LOGGER = LogManager.getLogger(GRPCStreamServiceStatus.class);
    private volatile boolean status;

    public GRPCStreamServiceStatus(boolean status) {
        this.status = status;
    }

    public boolean isStatus() {
        return this.status;
    }

    public void finished() {
        this.status = true;
    }

    public void wait4Finish() {
        long recheckCycle = 5L;
        long hasWaited = 0L;
        long maxCycle = 30000L;
        while (!this.status) {
            this.try2Sleep(recheckCycle);
            hasWaited += recheckCycle;
            if (recheckCycle >= maxCycle) {
                LOGGER.warn("Collector traceSegment service doesn't response in {} seconds.", hasWaited / 1000L);
                continue;
            }
            recheckCycle = Math.min(recheckCycle * 2L, maxCycle);
        }
    }

    private void try2Sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

