/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.IntFunction;
import org.apache.sis.util.collection.SetOfUnknownSize;

public abstract class ListOfUnknownSize<E>
extends AbstractSequentialList<E> {
    protected ListOfUnknownSize() {
    }

    @Override
    public boolean isEmpty() {
        return this.sizeIfKnown().orElseGet(() -> this.isValidIndex(0) ? 1 : 0) == 0;
    }

    @Override
    public int size() {
        int i = 1;
        do {
            OptionalInt size;
            if (!(size = this.sizeIfKnown()).isPresent()) continue;
            return size.getAsInt();
        } while (this.isValidIndex(i) && (i <<= 1) >= 0);
        i >>>= 1;
        while (this.isValidIndex(++i) && i != Integer.MAX_VALUE) {
        }
        return i;
    }

    protected OptionalInt sizeIfKnown() {
        return OptionalInt.empty();
    }

    protected abstract boolean isValidIndex(int var1);

    @Override
    public abstract E get(int var1);

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        java.util.Iterator<?> it = c.iterator();
        while (it.hasNext()) {
            modified |= this.remove(it.next());
        }
        return modified;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new Iterator(index);
    }

    protected int characteristics() {
        return 16;
    }

    @Override
    public Spliterator<E> spliterator() {
        int characteristics = this.characteristics();
        OptionalInt size = this.sizeIfKnown();
        return size.isPresent() ? Spliterators.spliterator(this.iterator(), (long)size.getAsInt(), characteristics) : Spliterators.spliteratorUnknownSize(this.iterator(), characteristics);
    }

    @Override
    public Object[] toArray() {
        return SetOfUnknownSize.toArray(this.iterator(), new Object[this.sizeIfKnown().orElse(16)], true);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return SetOfUnknownSize.toArray(this.iterator(), array, false);
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return SetOfUnknownSize.toArray(this.iterator(), generator.apply(this.sizeIfKnown().orElse(16)), true);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        java.util.Iterator it = this.iterator();
        java.util.Iterator ot = ((List)object).iterator();
        while (it.hasNext()) {
            if (ot.hasNext() && Objects.equals(it.next(), ot.next())) continue;
            return false;
        }
        return !ot.hasNext();
    }

    private final class Iterator
    implements ListIterator<E> {
        private int cursor;

        Iterator(int index) {
            this.cursor = index;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public boolean hasNext() {
            return ListOfUnknownSize.this.isValidIndex(this.cursor);
        }

        @Override
        public E next() {
            Object element;
            try {
                element = ListOfUnknownSize.this.get(this.cursor);
            }
            catch (IndexOutOfBoundsException e) {
                throw (NoSuchElementException)new NoSuchElementException().initCause(e);
            }
            ++this.cursor;
            return element;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            if (this.cursor != 0) {
                return ListOfUnknownSize.this.get(--this.cursor);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

