/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.S2Geography;

import com.google.common.geometry.S2Builder;
import com.google.common.geometry.S2BuilderLayer;
import com.google.common.geometry.S2Error;
import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2Loop;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2PointVectorLayer;
import com.google.common.geometry.S2Polygon;
import com.google.common.geometry.S2PolygonLayer;
import com.google.common.geometry.S2Polyline;
import com.google.common.geometry.S2PolylineLayer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.sedona.common.S2Geography.Geography;
import org.apache.sedona.common.S2Geography.GeographyCollection;
import org.apache.sedona.common.S2Geography.MultiPolygonGeography;
import org.apache.sedona.common.S2Geography.PointGeography;
import org.apache.sedona.common.S2Geography.PolygonGeography;
import org.apache.sedona.common.S2Geography.PolylineGeography;
import org.apache.sedona.common.S2Geography.SinglePointGeography;
import org.apache.sedona.common.S2Geography.SinglePolylineGeography;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ByteArrayInStream;
import org.locationtech.jts.io.ByteOrderDataInStream;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.Ordinate;
import org.locationtech.jts.io.ParseException;

public class WKBReader {
    private static final String INVALID_GEOM_TYPE_MSG = "Invalid geometry type encountered in ";
    private static final String FIELD_NUMCOORDS = "numCoords";
    private static final String FIELD_NUMRINGS = "numRings";
    private static final String FIELD_NUMELEMS = "numElems";
    private GeometryFactory factory;
    private CoordinateSequenceFactory csFactory;
    private PrecisionModel precisionModel;
    private int inputDimension = 2;
    private boolean isStrict = false;
    private ByteOrderDataInStream dis = new ByteOrderDataInStream();
    private double[] ordValues;
    private int maxNumFieldValue;

    public static byte[] hexToBytes(String hex) {
        int byteLen = hex.length() / 2;
        byte[] bytes = new byte[byteLen];
        for (int i = 0; i < hex.length() / 2; ++i) {
            byte b;
            int i2 = 2 * i;
            if (i2 + 1 > hex.length()) {
                throw new IllegalArgumentException("Hex string has odd length");
            }
            int nib1 = WKBReader.hexToInt(hex.charAt(i2));
            int nib0 = WKBReader.hexToInt(hex.charAt(i2 + 1));
            bytes[i] = b = (byte)((nib1 << 4) + (byte)nib0);
        }
        return bytes;
    }

    private static int hexToInt(char hex) {
        int nib = Character.digit(hex, 16);
        if (nib < 0) {
            throw new IllegalArgumentException("Invalid hex digit: '" + hex + "'");
        }
        return nib;
    }

    public WKBReader() {
        this(new GeometryFactory());
    }

    public WKBReader(GeometryFactory geometryFactory) {
        this.factory = geometryFactory;
        this.precisionModel = this.factory.getPrecisionModel();
        this.csFactory = this.factory.getCoordinateSequenceFactory();
    }

    public Geography read(byte[] bytes) throws ParseException {
        try {
            return this.read((InStream)new ByteArrayInStream(bytes), Integer.MAX_VALUE);
        }
        catch (IOException ex) {
            throw new RuntimeException("I/O error reading WKB: " + ex.getMessage(), ex);
        }
    }

    public Geography read(InStream is) throws IOException, ParseException {
        return this.read(is, Integer.MAX_VALUE);
    }

    private Geography read(InStream is, int maxCoordNum) throws IOException, ParseException {
        this.maxNumFieldValue = maxCoordNum;
        this.dis.setInStream(is);
        return this.readGeometry(0);
    }

    private int readNumField(String fieldName) throws IOException, ParseException {
        int num = this.dis.readInt();
        if (num < 0 || num > this.maxNumFieldValue) {
            throw new ParseException(fieldName + " value is too large");
        }
        return num;
    }

    private Geography readGeometry(int SRID) throws IOException, ParseException {
        boolean hasSRID;
        byte byteOrderWKB = this.dis.readByte();
        if (byteOrderWKB == 1) {
            this.dis.setOrder(2);
        } else if (byteOrderWKB == 0) {
            this.dis.setOrder(1);
        } else if (this.isStrict) {
            throw new ParseException("Unknown geometry byte order (not NDR or XDR): " + byteOrderWKB);
        }
        int typeInt = this.dis.readInt();
        int geometryType = (typeInt & 0xFFFF) % 1000;
        boolean hasZ = (typeInt & Integer.MIN_VALUE) != 0 || (typeInt & 0xFFFF) / 1000 == 1 || (typeInt & 0xFFFF) / 1000 == 3;
        boolean hasM = (typeInt & 0x40000000) != 0 || (typeInt & 0xFFFF) / 1000 == 2 || (typeInt & 0xFFFF) / 1000 == 3;
        this.inputDimension = 2 + (hasZ ? 1 : 0) + (hasM ? 1 : 0);
        EnumSet<Ordinate> ordinateFlags = EnumSet.of(Ordinate.X, Ordinate.Y);
        if (hasZ) {
            ordinateFlags.add(Ordinate.Z);
        }
        if (hasM) {
            ordinateFlags.add(Ordinate.M);
        }
        boolean bl = hasSRID = (typeInt & 0x20000000) != 0;
        if (hasSRID) {
            SRID = this.dis.readInt();
        }
        if (this.ordValues == null || this.ordValues.length < this.inputDimension) {
            this.ordValues = new double[this.inputDimension];
        }
        Geography geog = null;
        switch (geometryType) {
            case 1: {
                geog = this.readPoint(ordinateFlags);
                break;
            }
            case 2: {
                geog = this.readPolyline(ordinateFlags);
                break;
            }
            case 3: {
                geog = this.readPolygon(ordinateFlags);
                break;
            }
            case 4: {
                geog = this.readMultiPoint(SRID);
                break;
            }
            case 5: {
                geog = this.readMultiPolyline(SRID);
                break;
            }
            case 6: {
                geog = this.readMultiPolygon(SRID);
                break;
            }
            case 7: {
                geog = this.readGeographyCollection(SRID);
                break;
            }
            default: {
                throw new ParseException("Unknown WKB type " + geometryType);
            }
        }
        this.setSRID(geog, SRID);
        return geog;
    }

    private Geography setSRID(Geography g, int SRID) {
        if (SRID != 0) {
            g.setSRID(SRID);
        }
        return g;
    }

    private SinglePointGeography readPoint(EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        CoordinateSequence pts = this.readCoordinateSequence(1, ordinateFlags);
        if (pts.size() <= 0 || Double.isNaN(pts.getX(0)) || Double.isNaN(pts.getY(0))) {
            return new SinglePointGeography();
        }
        double lon = pts.getX(0);
        double lat = pts.getY(0);
        S2Point s2Point = S2LatLng.fromDegrees((double)lat, (double)lon).toPoint();
        S2Builder builder = new S2Builder.Builder().build();
        S2PointVectorLayer layer = new S2PointVectorLayer();
        builder.startLayer((S2BuilderLayer)layer);
        builder.addPoint(s2Point);
        S2Error error = new S2Error();
        if (!builder.build(error)) {
            throw new IOException("Failed to build S2 point layer: " + error.text());
        }
        List points = layer.getPointVector();
        if (points.isEmpty()) {
            return new SinglePointGeography();
        }
        return new SinglePointGeography((S2Point)points.get(0));
    }

    private SinglePolylineGeography readPolyline(EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        int size = this.readNumField(FIELD_NUMCOORDS);
        CoordinateSequence seq = this.readCoordinateSequenceLineString(size, ordinateFlags);
        if (seq.size() < 2) {
            return new SinglePolylineGeography();
        }
        ArrayList<S2Point> pts = new ArrayList<S2Point>(seq.size());
        for (int i = 0; i < seq.size(); ++i) {
            double lon = seq.getX(i);
            double lat = seq.getY(i);
            pts.add(S2LatLng.fromDegrees((double)lat, (double)lon).toPoint());
        }
        S2Builder builder = new S2Builder.Builder().build();
        S2PolylineLayer layer = new S2PolylineLayer();
        builder.startLayer((S2BuilderLayer)layer);
        builder.addPolyline(new S2Polyline(pts));
        S2Error error = new S2Error();
        if (!builder.build(error)) {
            throw new IOException("Failed to build S2 polyline: " + error.text());
        }
        S2Polyline s2poly = layer.getPolyline();
        return new SinglePolylineGeography(s2poly);
    }

    private PolygonGeography readPolygon(EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        int numRings = this.readNumField(FIELD_NUMRINGS);
        if (numRings <= 0) {
            return new PolygonGeography();
        }
        ArrayList<S2Loop> loops = new ArrayList<S2Loop>(numRings);
        for (int r = 0; r < numRings; ++r) {
            int coordCount = this.readNumField(FIELD_NUMCOORDS);
            CoordinateSequence seq = this.readCoordinateSequenceRing(coordCount, ordinateFlags);
            ArrayList<S2Point> pts = new ArrayList<S2Point>(seq.size());
            for (int i = 0; i < seq.size(); ++i) {
                pts.add(S2LatLng.fromDegrees((double)seq.getY(i), (double)seq.getX(i)).toPoint());
            }
            loops.add(new S2Loop(pts));
        }
        if (loops.isEmpty()) {
            return new PolygonGeography();
        }
        S2Builder builder = new S2Builder.Builder().build();
        S2PolygonLayer polyLayer = new S2PolygonLayer();
        builder.startLayer((S2BuilderLayer)polyLayer);
        for (S2Loop loop : loops) {
            builder.addLoop(loop);
        }
        S2Error error = new S2Error();
        if (!builder.build(error)) {
            throw new IOException("S2Builder failed: " + error.text());
        }
        S2Polygon s2poly = polyLayer.getPolygon();
        return new PolygonGeography(s2poly);
    }

    private PointGeography readMultiPoint(int SRID) throws IOException, ParseException {
        int numGeom = this.readNumField(FIELD_NUMELEMS);
        ArrayList<S2Point> pts = new ArrayList<S2Point>(numGeom);
        for (int i = 0; i < numGeom; ++i) {
            Geography point = this.readGeometry(SRID);
            if (!(point instanceof PointGeography)) {
                throw new ParseException("Invalid geometry type encountered in MultiPoint");
            }
            pts.addAll(((PointGeography)point).getPoints());
        }
        return new PointGeography(pts);
    }

    private PolylineGeography readMultiPolyline(int SRID) throws IOException, ParseException {
        int numGeom = this.readNumField(FIELD_NUMELEMS);
        ArrayList<S2Polyline> polylines = new ArrayList<S2Polyline>(numGeom);
        for (int i = 0; i < numGeom; ++i) {
            Geography polyline = this.readGeometry(SRID);
            if (!(polyline instanceof PolylineGeography)) {
                throw new ParseException("Invalid geometry type encountered in MultiPolyline");
            }
            polylines.addAll(((PolylineGeography)polyline).getPolylines());
        }
        return new PolylineGeography(polylines);
    }

    private MultiPolygonGeography readMultiPolygon(int SRID) throws IOException, ParseException {
        int numGeom = this.readNumField(FIELD_NUMELEMS);
        ArrayList<S2Polygon> polygons = new ArrayList<S2Polygon>(numGeom);
        for (int i = 0; i < numGeom; ++i) {
            Geography geom = this.readGeometry(SRID);
            polygons.add(((PolygonGeography)geom).polygon);
        }
        return new MultiPolygonGeography(Geography.GeographyKind.MULTIPOLYGON, polygons);
    }

    private GeographyCollection readGeographyCollection(int SRID) throws IOException, ParseException {
        int numGeom = this.readNumField(FIELD_NUMELEMS);
        Geography[] geoms = new Geography[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            geoms[i] = this.readGeometry(SRID);
        }
        return new GeographyCollection(List.of(geoms));
    }

    private CoordinateSequence readCoordinateSequence(int size, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        CoordinateSequence seq = this.csFactory.create(size, this.inputDimension, ordinateFlags.contains(Ordinate.M) ? 1 : 0);
        int targetDim = seq.getDimension();
        if (targetDim > this.inputDimension) {
            targetDim = this.inputDimension;
        }
        for (int i = 0; i < size; ++i) {
            this.readCoordinate();
            for (int j = 0; j < targetDim; ++j) {
                seq.setOrdinate(i, j, this.ordValues[j]);
            }
        }
        return seq;
    }

    private CoordinateSequence readCoordinateSequenceLineString(int size, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        CoordinateSequence seq = this.readCoordinateSequence(size, ordinateFlags);
        if (this.isStrict) {
            return seq;
        }
        if (seq.size() == 0 || seq.size() >= 2) {
            return seq;
        }
        return CoordinateSequences.extend((CoordinateSequenceFactory)this.csFactory, (CoordinateSequence)seq, (int)2);
    }

    private CoordinateSequence readCoordinateSequenceRing(int size, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        CoordinateSequence seq = this.readCoordinateSequence(size, ordinateFlags);
        if (this.isStrict) {
            return seq;
        }
        if (CoordinateSequences.isRing((CoordinateSequence)seq)) {
            return seq;
        }
        return CoordinateSequences.ensureValidRing((CoordinateSequenceFactory)this.csFactory, (CoordinateSequence)seq);
    }

    private void readCoordinate() throws IOException, ParseException {
        for (int i = 0; i < this.inputDimension; ++i) {
            if (i <= 1) {
                try {
                    double v = this.dis.readDouble();
                    this.ordValues[i] = this.precisionModel.makePrecise(v);
                    continue;
                }
                catch (ParseException pe) {
                    return;
                }
            }
            this.ordValues[i] = this.dis.readDouble();
        }
    }
}

