/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.conv;

import java.io.IOException;
import java.util.Optional;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.projection.Sinusoidal;

public class HdfEosModisConvention
extends CoordSystemBuilder {
    private static final String CRS = "Projection";
    private static final String DATA_GROUP = "Data_Fields";
    private static final String DIMX_NAME = "XDim";
    private static final String DIMY_NAME = "YDim";
    private static final String TIME_NAME = "time";
    private static final String CONVENTION_NAME = "HDF4-EOS-MODIS";
    private boolean addTimeCoord;

    private HdfEosModisConvention(NetcdfDataset.Builder datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = CONVENTION_NAME;
    }

    @Override
    public void augmentDataset(CancelTask cancelTask) throws IOException {
        this.addTimeCoord = this.addTimeCoordinate();
        this.augmentGroup(this.rootGroup);
        this.rootGroup.addAttribute(new Attribute("Conventions", "CF-1.0"));
    }

    private boolean addTimeCoordinate() {
        CalendarDate cd2 = this.parseFilenameForDate(this.datasetBuilder.orgFile.getLocation());
        if (cd2 == null) {
            return false;
        }
        this.rootGroup.addAttribute(new Attribute("_MODIS_Date", cd2.toString()));
        this.rootGroup.addDimension(new Dimension(TIME_NAME, 1));
        String units = "seconds since " + cd2;
        CoordinateAxis.Builder timeCoord = (CoordinateAxis.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(TIME_NAME)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName("")).setUnits(units)).setDesc("time coordinate");
        timeCoord.setAutoGen(0.0, 0.0);
        timeCoord.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, timeCoord);
        return true;
    }

    private CalendarDate parseFilenameForDate(String filename) {
        String[] tokes = filename.split("\\.");
        if (tokes.length < 2) {
            return null;
        }
        if (tokes[1].length() < 8) {
            return null;
        }
        String want = tokes[1];
        String yearS = want.substring(1, 5);
        String jdayS = want.substring(5, 8);
        try {
            int year = Integer.parseInt(yearS);
            int jday = Integer.parseInt(jdayS);
            return CalendarDate.withDoy(null, year, jday, 0, 0, 0);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void augmentGroup(Group.Builder g2) {
        Optional<Variable.Builder<?>> crs = g2.findVariableLocal("_HDFEOS_CRS");
        if (crs.isPresent()) {
            this.augmentGroupWithProjectionInfo(g2);
        }
        for (Group.Builder nested : g2.gbuilders) {
            this.augmentGroup(nested);
        }
    }

    private void augmentGroupWithProjectionInfo(Group.Builder g2) {
        Optional<Group.Builder> dataGopt = g2.findGroupLocal(DATA_GROUP);
        if (!dataGopt.isPresent()) {
            return;
        }
        Group.Builder dataG = dataGopt.get();
        Optional<Dimension> dimXopt = dataG.findDimensionLocal(DIMX_NAME);
        Optional<Dimension> dimYopt = dataG.findDimensionLocal(DIMY_NAME);
        if (!dimXopt.isPresent() || !dimYopt.isPresent()) {
            return;
        }
        Dimension dimX = dimXopt.get();
        Dimension dimY = dimYopt.get();
        g2.findVariableLocal("_HDFEOS_CRS").ifPresent(crs -> {
            Attribute projAtt = crs.getAttributeContainer().findAttribute(CRS);
            if (projAtt == null) {
                return;
            }
            Attribute upperLeft = crs.getAttributeContainer().findAttribute("UpperLeftPointMtrs");
            Attribute lowerRight = crs.getAttributeContainer().findAttribute("LowerRightMtrs");
            Attribute projParams = crs.getAttributeContainer().findAttribute("ProjParams");
            if (upperLeft == null || lowerRight == null) {
                return;
            }
            double minX = upperLeft.getNumericValue(0).doubleValue();
            double minY = upperLeft.getNumericValue(1).doubleValue();
            double maxX = lowerRight.getNumericValue(0).doubleValue();
            double maxY = lowerRight.getNumericValue(1).doubleValue();
            boolean hasProjection = false;
            String coordinates = null;
            if (projAtt.getStringValue().equals("GCTP_SNSOID")) {
                hasProjection = true;
                ProjectionCT ct = this.makeSinusoidalProjection(CRS, projParams);
                VariableDS.Builder crss = this.makeCoordinateTransformVariable(ct);
                crss.addAttribute(new Attribute("_CoordinateAxisTypes", "GeoX GeoY"));
                dataG.addVariable(crss);
                this.datasetBuilder.replaceCoordinateAxis(dataG, this.makeCoordAxis(dataG, DIMX_NAME, dimX.getLength(), minX, maxX, true));
                this.datasetBuilder.replaceCoordinateAxis(dataG, this.makeCoordAxis(dataG, DIMY_NAME, dimY.getLength(), minY, maxY, false));
                coordinates = this.addTimeCoord ? "time XDim YDim" : "XDim YDim";
            } else if (projAtt.getStringValue().equals("GCTP_GEO")) {
                this.datasetBuilder.replaceCoordinateAxis(dataG, this.makeLatLonCoordAxis(dataG, dimX.getLength(), minX * 1.0E-6, maxX * 1.0E-6, true));
                this.datasetBuilder.replaceCoordinateAxis(dataG, this.makeLatLonCoordAxis(dataG, dimY.getLength(), minY * 1.0E-6, maxY * 1.0E-6, false));
                coordinates = this.addTimeCoord ? "time Lat Lon" : "Lat Lon";
            }
            for (Variable.Builder<?> v : dataG.vbuilders) {
                if (v.getRank() != 2 || !v.getDimensionName(0).equals(dimY.getShortName()) || !v.getDimensionName(1).equals(dimX.getShortName())) continue;
                if (coordinates != null) {
                    v.addAttribute(new Attribute("coordinates", coordinates));
                }
                if (!hasProjection) continue;
                v.addAttribute(new Attribute("grid_mapping", CRS));
            }
        });
    }

    private CoordinateAxis.Builder makeCoordAxis(Group.Builder dataG, String name, int n, double start, double end, boolean isX) {
        CoordinateAxis.Builder vb = (CoordinateAxis.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(name)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(dataG)).setDimensionsByName(name)).setUnits("km")).setDesc(isX ? "x coordinate" : "y coordinate");
        double incr = (end - start) / (double)n;
        vb.setAutoGen(start * 0.001, incr * 0.001);
        vb.addAttribute(new Attribute("_CoordinateAxisType", isX ? AxisType.GeoX.name() : AxisType.GeoY.name()));
        return vb;
    }

    private CoordinateAxis.Builder makeLatLonCoordAxis(Group.Builder dataG, int n, double start, double end, boolean isLon) {
        String name = isLon ? AxisType.Lon.toString() : AxisType.Lat.toString();
        String dimName = isLon ? DIMX_NAME : DIMY_NAME;
        CoordinateAxis.Builder v = (CoordinateAxis.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(name)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(dataG)).setDimensionsByName(dimName)).setUnits(isLon ? "degrees_east" : "degrees_north");
        double incr = (end - start) / (double)n;
        v.setAutoGen(start, incr);
        v.addAttribute(new Attribute("_CoordinateAxisType", name));
        return v;
    }

    private ProjectionCT makeSinusoidalProjection(String name, Attribute projParams) {
        double radius = projParams.getNumericValue(0).doubleValue();
        double centMer = projParams.getNumericValue(4).doubleValue();
        double falseEast = projParams.getNumericValue(6).doubleValue();
        double falseNorth = projParams.getNumericValue(7).doubleValue();
        Sinusoidal proj = new Sinusoidal(centMer, falseEast * 0.001, falseNorth * 0.001, radius * 0.001);
        return new ProjectionCT(name, "FGDC", proj);
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        public String getConventionName() {
            return HdfEosModisConvention.CONVENTION_NAME;
        }

        @Override
        public boolean isMine(NetcdfFile ncfile) {
            if (!ncfile.getFileTypeId().equals("HDF4-EOS")) {
                return false;
            }
            String typeName = ncfile.getRootGroup().attributes().findAttributeString("featureType", null);
            if (typeName == null) {
                return false;
            }
            if (!typeName.equals(FeatureType.GRID.toString()) && !typeName.equals(FeatureType.SWATH.toString())) {
                return false;
            }
            return this.checkGroup(ncfile.getRootGroup());
        }

        private boolean checkGroup(Group g2) {
            Variable crs = g2.findVariableLocal("_HDFEOS_CRS");
            Group dataG = g2.findGroupLocal(HdfEosModisConvention.DATA_GROUP);
            if (crs != null && dataG != null) {
                Attribute att = crs.findAttribute(HdfEosModisConvention.CRS);
                if (att == null) {
                    return false;
                }
                if (!att.getStringValue().equals("GCTP_SNSOID") && !att.getStringValue().equals("GCTP_GEO")) {
                    return false;
                }
                return dataG.findDimensionLocal(HdfEosModisConvention.DIMX_NAME) != null && dataG.findDimensionLocal(HdfEosModisConvention.DIMY_NAME) != null;
            }
            for (Group ng : g2.getGroups()) {
                if (!this.checkGroup(ng)) continue;
                return true;
            }
            return false;
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder datasetBuilder) {
            return new HdfEosModisConvention(datasetBuilder);
        }
    }
}

