/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.util.ArrayList;
import opennlp.tools.cmdline.tokenizer.DetokenEvaluationErrorListener;
import opennlp.tools.tokenize.Detokenizer;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.util.Span;
import opennlp.tools.util.eval.EvaluationMonitor;
import opennlp.tools.util.eval.Evaluator;
import opennlp.tools.util.eval.FMeasure;

public class DetokenizerEvaluator
extends Evaluator<TokenSample> {
    private final FMeasure fmeasure = new FMeasure();
    private final Detokenizer detokenizer;

    public DetokenizerEvaluator(Detokenizer detokenizer, DetokenEvaluationErrorListener ... listeners) {
        super((EvaluationMonitor<T>[])listeners);
        this.detokenizer = detokenizer;
    }

    @Override
    protected TokenSample processSample(TokenSample reference) {
        String[] tokens = Span.spansToStrings(reference.getTokenSpans(), reference.getText());
        String tokensstring = this.detokenizer.detokenize(tokens, null);
        ArrayList<String> predictionsArray = new ArrayList<String>();
        ArrayList<String> referencesArray = new ArrayList<String>();
        predictionsArray.add(tokensstring);
        referencesArray.add(reference.getText());
        Object[] references = referencesArray.toArray();
        Object[] predictions = predictionsArray.toArray();
        this.fmeasure.updateScores(references, predictions);
        return new TokenSample(tokensstring, reference.getTokenSpans());
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }
}

