/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.commons.Internal;
import opennlp.tools.formats.Conll02NameSampleStream;
import opennlp.tools.formats.FormatUtil;
import opennlp.tools.formats.LanguageSampleStreamFactory;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;

@Internal
public class Conll02NameSampleStreamFactory
extends LanguageSampleStreamFactory<NameSample, Parameters> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, "conll02", new Conll02NameSampleStreamFactory(Parameters.class));
    }

    protected Conll02NameSampleStreamFactory(Class<Parameters> params) {
        super(params);
    }

    public ObjectStream<NameSample> create(String[] args) {
        Conll02NameSampleStream.LANGUAGE lang;
        Parameters params = this.validateBasicFormatParameters(args, Parameters.class);
        if ("nl".equals(params.getLang()) || "nld".equals(params.getLang())) {
            lang = Conll02NameSampleStream.LANGUAGE.NLD;
            this.language = params.getLang();
        } else if ("es".equals(params.getLang()) || "spa".equals(params.getLang())) {
            lang = Conll02NameSampleStream.LANGUAGE.SPA;
            this.language = params.getLang();
        } else {
            throw new TerminateToolException(1, "Unsupported language: " + params.getLang());
        }
        int typesToGenerate = 0;
        if (params.getTypes().contains("per")) {
            typesToGenerate |= 1;
        }
        if (params.getTypes().contains("org")) {
            typesToGenerate |= 2;
        }
        if (params.getTypes().contains("loc")) {
            typesToGenerate |= 4;
        }
        if (params.getTypes().contains("misc")) {
            typesToGenerate |= 8;
        }
        try {
            return new Conll02NameSampleStream(lang, FormatUtil.createInputStreamFactory(params.getData()), typesToGenerate);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO Error while creating an Input Stream: " + e.getMessage(), (Throwable)e);
        }
    }

    public static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="spa|nld")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="per,loc,org,misc")
        public String getTypes();
    }
}

