/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.List;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.BrownCluster;
import opennlp.tools.util.featuregen.BrownTokenClasses;
import opennlp.tools.util.featuregen.FeatureGeneratorUtil;

public class BrownTokenClassFeatureGenerator
implements AdaptiveFeatureGenerator {
    private static final String PREFIX = "c,browncluster=";
    private final BrownCluster brownLexicon;

    public BrownTokenClassFeatureGenerator(BrownCluster dict) {
        this.brownLexicon = dict;
    }

    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        String wordShape = FeatureGeneratorUtil.tokenFeature(tokens[index]);
        List<String> wordClasses = BrownTokenClasses.getWordClasses(tokens[index], this.brownLexicon);
        for (String wordClass : wordClasses) {
            features.add(PREFIX + wordShape + "," + wordClass);
        }
    }
}

