/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.convert;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.ldap.convert.ConverterUtils;

public final class ConversionServiceBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private static final String CONVERSION_SERVICE_BEAN_NAME = "conversionService";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.hasUserDefinedConversionService(beanFactory)) {
            return;
        }
        ConversionService service = beanFactory.getConversionService();
        if (service instanceof ConverterRegistry) {
            ConverterRegistry registry = (ConverterRegistry)service;
            ConverterUtils.addDefaultConverters(registry);
        }
    }

    private boolean hasUserDefinedConversionService(ConfigurableListableBeanFactory beanFactory) {
        return beanFactory.containsBean(CONVERSION_SERVICE_BEAN_NAME) && beanFactory.isTypeMatch(CONVERSION_SERVICE_BEAN_NAME, ConversionService.class);
    }
}

