/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.faces.view.facelets.MetadataTarget;

public final class MetadataTargetImpl
extends MetadataTarget {
    private final Map<String, PropertyDescriptor> propertyDescriptors;
    private final Class<?> type;

    public MetadataTargetImpl(Class<?> type) throws IntrospectionException {
        this.type = type;
        PropertyDescriptor[] descriptors = Introspector.getBeanInfo(type).getPropertyDescriptors();
        if (descriptors == null || descriptors.length == 0) {
            this.propertyDescriptors = null;
        } else {
            this.propertyDescriptors = new HashMap<String, PropertyDescriptor>(descriptors.length);
            for (PropertyDescriptor descriptor : descriptors) {
                this.propertyDescriptors.put(descriptor.getName(), descriptor);
            }
        }
    }

    public PropertyDescriptor getProperty(String name) {
        if (this.propertyDescriptors == null) {
            return null;
        }
        return this.propertyDescriptors.get(name);
    }

    public Class<?> getPropertyType(String name) {
        PropertyDescriptor pd = this.getProperty(name);
        if (pd != null) {
            return pd.getPropertyType();
        }
        return null;
    }

    public Method getReadMethod(String name) {
        PropertyDescriptor pd = this.getProperty(name);
        if (pd != null) {
            return pd.getReadMethod();
        }
        return null;
    }

    public Class<?> getTargetClass() {
        return this.type;
    }

    public Method getWriteMethod(String name) {
        PropertyDescriptor pd = this.getProperty(name);
        if (pd != null) {
            return pd.getWriteMethod();
        }
        return null;
    }

    public boolean isTargetInstanceOf(Class type) {
        return type.isAssignableFrom(type);
    }
}

