/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Conditional;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeatureEvent;
import org.apache.karaf.features.FeatureState;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.internal.download.DownloadManager;
import org.apache.karaf.features.internal.download.StreamProvider;
import org.apache.karaf.features.internal.region.SubsystemResolver;
import org.apache.karaf.features.internal.resolver.ResolverUtil;
import org.apache.karaf.features.internal.resolver.ResourceUtils;
import org.apache.karaf.features.internal.service.BundleComparator;
import org.apache.karaf.features.internal.service.RequirementSort;
import org.apache.karaf.features.internal.service.ResourceComparator;
import org.apache.karaf.features.internal.service.State;
import org.apache.karaf.features.internal.util.ChecksumUtils;
import org.apache.karaf.features.internal.util.Macro;
import org.apache.karaf.features.internal.util.MapUtils;
import org.apache.karaf.features.internal.util.MultiException;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.repository.Repository;
import org.osgi.service.resolver.Resolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Deployer.class);
    private final DownloadManager manager;
    private final Resolver resolver;
    private final DeployCallback callback;

    public Deployer(DownloadManager manager, Resolver resolver, DeployCallback callback) {
        this.manager = manager;
        this.resolver = resolver;
        this.callback = callback;
    }

    /*
     * WARNING - void declaration
     */
    public void deploy(DeploymentState dstate, DeploymentRequest request) throws Exception {
        boolean bl;
        boolean bl2;
        Object r2;
        String name;
        Bundle bundle6;
        boolean bl3;
        boolean noRefreshUnmanaged = request.options.contains((Object)FeaturesService.Option.NoAutoRefreshUnmanagedBundles);
        boolean noRefreshManaged = request.options.contains((Object)FeaturesService.Option.NoAutoRefreshManagedBundles);
        boolean noRefresh = request.options.contains((Object)FeaturesService.Option.NoAutoRefreshBundles);
        boolean noStart = request.options.contains((Object)FeaturesService.Option.NoAutoStartBundles);
        boolean verbose = request.options.contains((Object)FeaturesService.Option.Verbose);
        boolean simulate = request.options.contains((Object)FeaturesService.Option.Simulate);
        boolean noManageBundles = request.options.contains((Object)FeaturesService.Option.NoAutoManageBundles);
        boolean showWiring = request.options.contains((Object)FeaturesService.Option.DisplayFeaturesWiring) || request.options.contains((Object)FeaturesService.Option.DisplayAllWiring);
        boolean showFeaturesWiringOnly = request.options.contains((Object)FeaturesService.Option.DisplayFeaturesWiring) && !request.options.contains((Object)FeaturesService.Option.DisplayAllWiring);
        Map<String, Set<Long>> managedBundles = MapUtils.copy(dstate.state.managedBundles);
        Map<String, Set<Bundle>> unmanagedBundles = MapUtils.apply(MapUtils.diff(dstate.bundlesPerRegion, dstate.state.managedBundles), MapUtils.map(dstate.bundles));
        SubsystemResolver resolver = new SubsystemResolver(this.resolver, this.manager);
        resolver.prepare(dstate.features.values(), request.requirements, MapUtils.apply(unmanagedBundles, this.adapt(BundleRevision.class)));
        Set<String> prereqs = resolver.collectPrerequisites();
        if (!prereqs.isEmpty()) {
            Iterator<String> iterator = prereqs.iterator();
            while (iterator.hasNext()) {
                String prereq = iterator.next();
                String[] parts = prereq.split("/");
                String name2 = parts[0];
                String version = parts[1];
                VersionRange range = this.getRange(version, request.featureResolutionRange);
                boolean found = false;
                for (Set<String> featureSet : dstate.state.installedFeatures.values()) {
                    Object feature2;
                    String[] stringArray;
                    Iterator<String> iterator2 = featureSet.iterator();
                    while (iterator2.hasNext() && !(found = name2.equals((stringArray = ((String)(feature2 = iterator2.next())).split("/"))[0]) && range.contains(VersionTable.getVersion(stringArray[1])))) {
                    }
                    if (!found) continue;
                    break;
                }
                if (!found) continue;
                iterator.remove();
            }
        }
        if (!prereqs.isEmpty()) {
            if (request.requirements.get("root").containsAll(prereqs)) {
                throw new CircularPrerequisiteException(prereqs);
            }
            DeploymentRequest newRequest = new DeploymentRequest();
            newRequest.bundleUpdateRange = request.bundleUpdateRange;
            newRequest.featureResolutionRange = request.featureResolutionRange;
            newRequest.serviceRequirements = request.serviceRequirements;
            newRequest.globalRepository = request.globalRepository;
            newRequest.options = request.options;
            newRequest.overrides = request.overrides;
            newRequest.requirements = MapUtils.copy(dstate.state.requirements);
            for (String prereq : prereqs) {
                MapUtils.addToMapSet(newRequest.requirements, "root", prereq);
            }
            newRequest.stateChanges = Collections.emptyMap();
            newRequest.updateSnaphots = request.updateSnaphots;
            this.deploy(dstate, newRequest);
            throw new PartialDeploymentException(prereqs);
        }
        resolver.resolve(request.overrides, request.featureResolutionRange, request.serviceRequirements, request.globalRepository, request.outputFile);
        Map<String, StreamProvider> providers = resolver.getProviders();
        Map<String, Set<Resource>> featuresPerRegion = resolver.getFeaturesPerRegions();
        Map<String, Set<String>> installedFeatures = MapUtils.apply(featuresPerRegion, this.featureId());
        Map<String, Set<String>> newFeatures = MapUtils.diff(installedFeatures, dstate.state.installedFeatures);
        Map<String, Set<String>> delFeatures = MapUtils.diff(dstate.state.installedFeatures, installedFeatures);
        Map<String, Map<String, String>> stateFeatures = MapUtils.copy(dstate.state.stateFeatures);
        for (Map.Entry<String, Set<String>> entry : delFeatures.entrySet()) {
            Map<String, String> map = stateFeatures.get(entry.getKey());
            if (map == null) continue;
            map.keySet().removeAll((Collection)entry.getValue());
            if (!map.isEmpty()) continue;
            stateFeatures.remove(entry.getKey());
        }
        for (Map.Entry<String, Object> entry : request.stateChanges.entrySet()) {
            String region = entry.getKey();
            Map<String, String> regionStates = stateFeatures.get(region);
            if (regionStates == null) continue;
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                String feature3 = (String)entry2.getKey();
                if (!regionStates.containsKey(feature3)) continue;
                regionStates.put(feature3, ((FeatureState)((Object)entry2.getValue())).name());
            }
        }
        for (Map.Entry<String, Object> entry : newFeatures.entrySet()) {
            for (Object feature4 : (Set)entry.getValue()) {
                Map<String, String> map = stateFeatures.get(entry.getKey());
                if (map == null) {
                    map = new HashMap<String, String>();
                    stateFeatures.put(entry.getKey(), map);
                }
                map.put((String)feature4, noStart ? FeatureState.Installed.name() : FeatureState.Started.name());
            }
        }
        Map<String, Map<String, BundleInfo>> bundleInfos = resolver.getBundleInfos();
        Deployment deployment = this.computeDeployment(dstate, request, resolver);
        TreeMap<Bundle, String> toRefresh = new TreeMap<Bundle, String>(new BundleComparator());
        for (RegionDeployment regionDeployment : deployment.regions.values()) {
            for (Bundle b : regionDeployment.toDelete) {
                toRefresh.put(b, "Bundle will be uninstalled");
            }
            for (Bundle b : regionDeployment.toUpdate.keySet()) {
                toRefresh.put(b, "Bundle will be updated");
            }
        }
        if (!noRefreshManaged) {
            this.computeBundlesToRefresh(toRefresh, dstate.bundles.values(), deployment.resToBnd, resolver.getWiring());
        }
        if (noRefreshUnmanaged) {
            toRefresh.keySet().removeAll(MapUtils.flatten(unmanagedBundles));
        }
        TreeSet<Bundle> toManage = new TreeSet<Bundle>(new BundleComparator());
        if (!noManageBundles) {
            Set<Resource> features = resolver.getFeatures().keySet();
            Set<BundleRevision> set = MapUtils.apply(MapUtils.flatten(unmanagedBundles), this.adapt(BundleRevision.class));
            HashSet<Resource> requested = new HashSet<Resource>();
            if (resolver != null && resolver.getWiring() != null) {
                for (List<Wire> list : resolver.getWiring().values()) {
                    for (Object wire : list) {
                        if (!features.contains(wire.getRequirer()) || !set.contains(wire.getProvider())) continue;
                        requested.add(wire.getProvider());
                    }
                }
            }
            set.removeAll(requested);
            if (resolver != null && resolver.getWiring() != null) {
                for (List<Wire> list : resolver.getWiring().values()) {
                    for (Object wire : list) {
                        if (!requested.contains(wire.getProvider()) || !set.contains(wire.getRequirer())) continue;
                        requested.remove(wire.getProvider());
                    }
                }
            }
            if (!requested.isEmpty()) {
                long l;
                HashMap<Long, String> bundleToRegion = new HashMap<Long, String>();
                for (Map.Entry<String, Set<Long>> entry : dstate.bundlesPerRegion.entrySet()) {
                    Object wire;
                    wire = entry.getValue().iterator();
                    while (wire.hasNext()) {
                        l = (Long)wire.next();
                        bundleToRegion.put(l, entry.getKey());
                    }
                }
                for (Resource resource : requested) {
                    Bundle bundle2 = ((BundleRevision)resource).getBundle();
                    l = bundle2.getBundleId();
                    MapUtils.addToMapSet(managedBundles, bundleToRegion.get(l), l);
                    toManage.add(bundle2);
                }
            }
        }
        HashSet<Bundle> toStart = new HashSet<Bundle>();
        HashSet<Bundle> hashSet = new HashSet<Bundle>();
        HashSet<Object> toStop = new HashSet<Bundle>();
        HashMap<Resource, FeatureState> states = new HashMap<Resource, FeatureState>();
        HashMap<Resource, FeatureState> hashMap = new HashMap<Resource, FeatureState>();
        HashMap hashMap2 = new HashMap();
        for (Map.Entry<String, Set<Resource>> entry : resolver.getFeaturesPerRegions().entrySet()) {
            String region = entry.getKey();
            Map<String, String> map = stateFeatures.get(region);
            for (Resource resource : entry.getValue()) {
                HashSet<Resource> hashSet2 = new HashSet<Resource>();
                for (Wire wire : resolver.getWiring().get(resource)) {
                    if (!"osgi.identity".equals(wire.getRequirement().getNamespace()) || !"true".equals(wire.getRequirement().getDirectives().get("condition"))) continue;
                    hashSet2.add(wire.getProvider());
                }
                if (hashSet2.isEmpty()) {
                    String string = map.get(ResourceUtils.getFeatureId(resource));
                    hashMap.put(resource, FeatureState.valueOf(string));
                    continue;
                }
                hashMap2.put(resource, hashSet2);
            }
        }
        for (Resource resource : hashMap2.keySet()) {
            FeatureState state = null;
            for (Resource resource2 : (Set)hashMap2.get(resource)) {
                FeatureState featureState = (FeatureState)((Object)hashMap.get(resource2));
                if (state == null) {
                    state = featureState;
                    continue;
                }
                if (state != FeatureState.Started || featureState != FeatureState.Resolved) continue;
                state = FeatureState.Resolved;
            }
            hashMap.put(resource, state);
        }
        for (Resource resource : hashMap.keySet()) {
            if (hashMap.get(resource) != FeatureState.Resolved) continue;
            this.propagateState(states, resource, FeatureState.Resolved, resolver);
        }
        for (Resource resource : hashMap.keySet()) {
            if (hashMap.get(resource) != FeatureState.Started) continue;
            this.propagateState(states, resource, FeatureState.Started, resolver);
        }
        for (Resource resource : resolver.getBundles().keySet()) {
            BundleInfo bundleInfo = null;
            for (Map.Entry<String, Map<String, BundleInfo>> entry : resolver.getBundleInfos().entrySet()) {
                bundleInfo = entry.getValue().get(ResourceUtils.getUri(resource));
            }
            Bundle bundle2 = deployment.resToBnd.get(resource);
            if (bundle2 == null) {
                if (bundleInfo != null && bundleInfo.isStart()) {
                    states.put(resource, FeatureState.Started);
                    continue;
                }
                states.put(resource, FeatureState.Resolved);
                continue;
            }
            states.remove(resource);
        }
        states.keySet().retainAll(resolver.getBundles().keySet());
        for (Map.Entry entry : states.entrySet()) {
            Bundle bundle4 = deployment.resToBnd.get(entry.getKey());
            if (bundle4 == null) continue;
            switch ((FeatureState)((Object)entry.getValue())) {
                case Started: {
                    hashSet.add(bundle4);
                    toStart.add(bundle4);
                    break;
                }
                case Resolved: {
                    hashSet.add(bundle4);
                    toStop.add(bundle4);
                }
            }
        }
        HashMap<Resource, Integer> startLevels = new HashMap<Resource, Integer>();
        HashMap<Bundle, Integer> hashMap3 = new HashMap<Bundle, Integer>();
        for (Map.Entry entry : resolver.getBundlesPerRegions().entrySet()) {
            String string = (String)entry.getKey();
            for (Resource resource : (Set)entry.getValue()) {
                int curSl;
                BundleInfo bundleInfo = bundleInfos.get(string).get(ResourceUtils.getUri(resource));
                if (bundleInfo == null) continue;
                int n = bundleInfo.getStartLevel() > 0 ? bundleInfo.getStartLevel() : dstate.initialBundleStartLevel;
                startLevels.put(resource, n);
                Bundle bundle7 = deployment.resToBnd.get(resource);
                if (bundle7 == null || n == (curSl = ((BundleStartLevel)bundle7.adapt(BundleStartLevel.class)).getStartLevel())) continue;
                hashMap3.put(bundle7, n);
                if (n <= dstate.currentStartLevel) continue;
                toStop.add(bundle7);
            }
        }
        if (showWiring) {
            this.logWiring(resolver.getWiring(), showFeaturesWiringOnly);
        }
        this.logDeployment(deployment, verbose);
        if (simulate) {
            if (!noRefresh && !toRefresh.isEmpty()) {
                this.print("  Bundles to refresh:", verbose);
                for (Map.Entry entry : toRefresh.entrySet()) {
                    Bundle bundle3 = (Bundle)entry.getKey();
                    this.print("    " + bundle3.getSymbolicName() + "/" + bundle3.getVersion() + " (" + (String)entry.getValue() + ")", verbose);
                }
            }
            if (!toManage.isEmpty()) {
                this.print("  Managing bundle:", verbose);
                for (Bundle bundle4 : toManage) {
                    this.print("    " + bundle4.getSymbolicName() + "/" + bundle4.getVersion(), verbose);
                }
            }
            return;
        }
        RegionDeployment rootRegionDeployment = deployment.regions.get("root");
        if (rootRegionDeployment != null && rootRegionDeployment.toDelete.contains(dstate.serviceBundle)) {
            throw new UnsupportedOperationException("Uninstalling the FeaturesService bundle is not supported");
        }
        if (rootRegionDeployment != null && rootRegionDeployment.toUpdate.containsKey(dstate.serviceBundle)) {
            this.callback.persistResolveRequest(request);
            if (deployment.bundleChecksums.containsKey(dstate.serviceBundle.getBundleId())) {
                State state = dstate.state.copy();
                state.bundleChecksums.put(dstate.serviceBundle.getBundleId(), deployment.bundleChecksums.get(dstate.serviceBundle.getBundleId()));
                this.callback.saveState(state);
            }
            Resource resource = rootRegionDeployment.toUpdate.get(dstate.serviceBundle);
            String string = ResourceUtils.getUri(resource);
            this.print("The FeaturesService bundle needs is being updated with " + string, verbose);
            toRefresh.clear();
            toRefresh.put(dstate.serviceBundle, "FeaturesService bundle is being updated");
            this.computeBundlesToRefresh(toRefresh, dstate.bundles.values(), Collections.emptyMap(), Collections.emptyMap());
            this.callback.stopBundle(dstate.serviceBundle, 1);
            Throwable throwable = null;
            try (InputStream inputStream = this.getBundleInputStream(resource, providers);){
                this.callback.updateBundle(dstate.serviceBundle, string, inputStream);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            this.callback.refreshPackages(toRefresh.keySet());
            this.callback.startBundle(dstate.serviceBundle);
            return;
        }
        for (RegionDeployment regionDeployment : deployment.regions.values()) {
            toStop.addAll(regionDeployment.toUpdate.keySet());
            toStop.addAll(regionDeployment.toDelete);
        }
        this.removeFragmentsAndBundlesInState(toStop, 21);
        if (!toStop.isEmpty()) {
            this.print("Stopping bundles:", verbose);
            while (!toStop.isEmpty()) {
                List<Bundle> list = this.getBundlesToStop(toStop);
                for (Bundle bundle5 : list) {
                    this.print("  " + bundle5.getSymbolicName() + "/" + bundle5.getVersion(), verbose);
                    this.callback.stopBundle(bundle5, hashMap3.containsKey(bundle5) ? 0 : 1);
                    toStop.remove(bundle5);
                }
            }
        }
        boolean bl4 = false;
        for (RegionDeployment regionDeployment : deployment.regions.values()) {
            bl3 = !regionDeployment.toDelete.isEmpty();
            if (!bl3) continue;
            break;
        }
        if (bl3) {
            this.print("Uninstalling bundles:", verbose);
            for (Map.Entry<String, RegionDeployment> entry : deployment.regions.entrySet()) {
                String string = entry.getKey();
                RegionDeployment regionDeployment = entry.getValue();
                for (Bundle bundle6 : regionDeployment.toDelete) {
                    this.print("  " + bundle6.getSymbolicName() + "/" + bundle6.getVersion(), verbose);
                    this.callback.uninstall(bundle6);
                    MapUtils.removeFromMapSet(managedBundles, string, bundle6.getBundleId());
                }
            }
        }
        HashMap<String, Set<Long>> hashMap4 = new HashMap<String, Set<Long>>();
        MapUtils.add(hashMap4, MapUtils.apply(unmanagedBundles, this.bundleId()));
        MapUtils.add(hashMap4, managedBundles);
        RegionDigraph regionDigraph = resolver.getFlatDigraph();
        Map<String, Map<String, Map<String, Set<String>>>> map = MapUtils.copy(dstate.filtersPerRegion);
        map.keySet().retainAll(hashMap4.keySet());
        for (String string : map.keySet()) {
            map.get(string).keySet().retainAll(map.keySet());
        }
        for (Region region : regionDigraph.getRegions()) {
            name = region.getName();
            Map<String, Map<String, Set<String>>> policy = map.get(name);
            if (policy == null) {
                policy = new HashMap<String, Map<String, Set<String>>>();
                map.put(name, policy);
            }
            for (RegionDigraph.FilteredRegion fr : region.getEdges()) {
                r2 = fr.getRegion().getName();
                HashMap filters = new HashMap();
                Map<String, Collection<String>> current = fr.getFilter().getSharingPolicy();
                for (String ns : current.keySet()) {
                    for (String f : current.get(ns)) {
                        MapUtils.addToMapSet(filters, ns, f);
                    }
                }
                policy.put((String)r2, filters);
            }
        }
        this.callback.replaceDigraph(map, hashMap4);
        boolean bl5 = false;
        for (RegionDeployment regionDeployment : deployment.regions.values()) {
            bl2 = !regionDeployment.toUpdate.isEmpty();
            if (!bl2) continue;
            break;
        }
        if (bl2) {
            this.print("Updating bundles:", verbose);
            for (Map.Entry<String, RegionDeployment> entry : deployment.regions.entrySet()) {
                for (Map.Entry<Bundle, Resource> entry3 : entry.getValue().toUpdate.entrySet()) {
                    bundle6 = entry3.getKey();
                    Resource resource = entry3.getValue();
                    String string = ResourceUtils.getUri(resource);
                    this.print("  " + string, verbose);
                    InputStream is = this.getBundleInputStream(resource, providers);
                    r2 = null;
                    try {
                        this.callback.updateBundle(bundle6, string, is);
                    }
                    catch (Throwable filters) {
                        r2 = filters;
                        throw filters;
                    }
                    finally {
                        if (is != null) {
                            if (r2 != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable filters) {
                                    ((Throwable)r2).addSuppressed(filters);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                    toStart.add(bundle6);
                }
            }
        }
        for (Map.Entry entry : hashMap3.entrySet()) {
            Bundle bundle7 = (Bundle)entry.getKey();
            int n = (Integer)entry.getValue();
            this.callback.setBundleStartLevel(bundle7, n);
        }
        boolean bl6 = false;
        for (RegionDeployment regionDeployment : deployment.regions.values()) {
            bl = !regionDeployment.toInstall.isEmpty();
            if (!bl) continue;
            break;
        }
        if (bl) {
            this.print("Installing bundles:", verbose);
            HashMap<void, Integer> hashMap5 = new HashMap<void, Integer>();
            for (Map.Entry<String, RegionDeployment> entry : deployment.regions.entrySet()) {
                name = entry.getKey();
                RegionDeployment regionDeployment = entry.getValue();
                for (Resource resource : regionDeployment.toInstall) {
                    FeatureState reqState;
                    Integer startLevel;
                    void bundle8;
                    long crc;
                    String uri = ResourceUtils.getUri(resource);
                    this.print("  " + uri, verbose);
                    ChecksumUtils.CRCInputStream is = new ChecksumUtils.CRCInputStream(this.getBundleInputStream(resource, providers));
                    Object object = null;
                    try {
                        Bundle bundle9 = this.callback.installBundle(name, uri, is);
                        crc = is.getCRC();
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (is != null) {
                            if (object != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                    MapUtils.addToMapSet(managedBundles, name, bundle8.getBundleId());
                    deployment.resToBnd.put(resource, (Bundle)bundle8);
                    if ("crc".equals(request.updateSnaphots) && this.isUpdateable(resource) && !deployment.bundleChecksums.containsKey(bundle8.getBundleId())) {
                        deployment.bundleChecksums.put(bundle8.getBundleId(), crc);
                    }
                    if ((startLevel = (Integer)startLevels.get(resource)) != null && startLevel != dstate.initialBundleStartLevel) {
                        hashMap5.put(bundle8, startLevel);
                    }
                    if ((reqState = (FeatureState)((Object)states.get(resource))) == null) {
                        reqState = FeatureState.Started;
                    }
                    switch (reqState) {
                        case Started: {
                            hashSet.add((Bundle)bundle8);
                            toStart.add((Bundle)bundle8);
                            break;
                        }
                        case Resolved: {
                            hashSet.add((Bundle)bundle8);
                        }
                    }
                }
            }
            for (Bundle bundle9 : hashMap5.keySet()) {
                this.callback.setBundleStartLevel(bundle9, (Integer)hashMap5.get(bundle9));
            }
        }
        State state = new State();
        state.bundleChecksums.putAll(deployment.bundleChecksums);
        state.requirements.putAll(request.requirements);
        state.installedFeatures.putAll(installedFeatures);
        state.stateFeatures.putAll(stateFeatures);
        state.managedBundles.putAll(managedBundles);
        this.callback.saveState(state);
        if (!newFeatures.isEmpty()) {
            Set<String> set = MapUtils.flatten(newFeatures);
            for (Feature feature9 : dstate.features.values()) {
                if (set.contains(feature9.getId())) {
                    this.callback.installFeature(feature9);
                }
                for (Conditional conditional : feature9.getConditional()) {
                    Feature condFeature = conditional.asFeature();
                    if (!set.contains(condFeature.getId())) continue;
                    this.callback.installFeature(condFeature);
                }
            }
        }
        if (!noRefresh) {
            if (toRefresh.containsKey(dstate.bundles.get(0L))) {
                this.print("The system bundle needs to be refreshed, restarting Karaf...", verbose);
                System.setProperty("karaf.restart", "true");
                dstate.bundles.get(0L).stop();
                return;
            }
            toStop = new HashSet();
            toStop.addAll(toRefresh.keySet());
            this.removeFragmentsAndBundlesInState(toStop, 21);
            if (!toStop.isEmpty()) {
                this.print("Stopping bundles:", verbose);
                while (!toStop.isEmpty()) {
                    List<Bundle> list = this.getBundlesToStop(toStop);
                    for (Bundle bundle6 : list) {
                        this.print("  " + bundle6.getSymbolicName() + "/" + bundle6.getVersion(), verbose);
                        this.callback.stopBundle(bundle6, 1);
                        toStop.remove(bundle6);
                        toStart.add(bundle6);
                    }
                }
            }
            if (!toRefresh.isEmpty()) {
                this.print("Refreshing bundles:", verbose);
                for (Map.Entry entry : toRefresh.entrySet()) {
                    bundle6 = (Bundle)entry.getKey();
                    this.print("    " + bundle6.getSymbolicName() + "/" + bundle6.getVersion() + " (" + (String)entry.getValue() + ")", verbose);
                }
                if (dstate.serviceBundle != null && toRefresh.containsKey(dstate.serviceBundle)) {
                    Deployer.ensureAllClassesLoaded(dstate.serviceBundle);
                }
                this.callback.refreshPackages(toRefresh.keySet());
            }
        }
        hashSet.addAll(toStart);
        hashSet.addAll(toRefresh.keySet());
        this.removeBundlesInState(hashSet, 1);
        this.callback.resolveBundles(hashSet, resolver.getWiring(), deployment.resToBnd);
        this.removeFragmentsAndBundlesInState(toStart, 33);
        if (!toStart.isEmpty()) {
            ArrayList<Exception> arrayList = new ArrayList<Exception>();
            this.print("Starting bundles:", verbose);
            while (!toStart.isEmpty()) {
                List<Bundle> list = this.getBundlesToStart(toStart, dstate.serviceBundle);
                for (Bundle bundle11 : list) {
                    this.print("  " + bundle11.getSymbolicName() + "/" + bundle11.getVersion(), verbose);
                    try {
                        this.callback.startBundle(bundle11);
                    }
                    catch (BundleException bundleException) {
                        arrayList.add((Exception)((Object)bundleException));
                    }
                    toStart.remove(bundle11);
                }
            }
            if (!arrayList.isEmpty()) {
                throw new MultiException("Error restarting bundles", arrayList);
            }
        }
        for (Map.Entry<String, Set<String>> entry : delFeatures.entrySet()) {
            for (String name5 : entry.getValue()) {
                Feature feature = dstate.features.get(name5);
                if (feature == null) continue;
                this.callback.callListeners(new FeatureEvent(FeatureEvent.EventType.FeatureUninstalled, feature, entry.getKey(), false));
            }
        }
        for (Map.Entry<String, Set<String>> entry : newFeatures.entrySet()) {
            for (String name6 : entry.getValue()) {
                Feature feature = dstate.features.get(name6);
                if (feature == null) continue;
                this.callback.callListeners(new FeatureEvent(FeatureEvent.EventType.FeatureInstalled, feature, entry.getKey(), false));
            }
        }
        this.print("Done.", verbose);
    }

    private VersionRange getRange(String version, String featureResolutionRange) {
        VersionRange range = version.equals("0.0.0") ? VersionRange.ANY_VERSION : (!version.startsWith("[") && !version.startsWith("(") ? new VersionRange(Macro.transform(featureResolutionRange, version)) : new VersionRange(version));
        return range;
    }

    private void propagateState(Map<Resource, FeatureState> states, Resource resource, FeatureState state, SubsystemResolver resolver) {
        FeatureState reqState;
        if (!this.isSubsystem(resource) && (reqState = this.mergeStates(state, states.get(resource))) != states.get(resource)) {
            states.put(resource, reqState);
            for (Wire wire : resolver.getWiring().get(resource)) {
                if (!"osgi.identity".equals(wire.getCapability().getNamespace())) continue;
                this.propagateState(states, wire.getProvider(), reqState, resolver);
            }
        }
    }

    private boolean isSubsystem(Resource resource) {
        return "karaf.subsystem".equals(ResourceUtils.getType(resource));
    }

    private boolean isBundle(Resource resource) {
        return "osgi.bundle".equals(ResourceUtils.getType(resource));
    }

    private FeatureState mergeStates(FeatureState s1, FeatureState s2) {
        if (s1 == FeatureState.Started || s2 == FeatureState.Started) {
            return FeatureState.Started;
        }
        if (s1 == FeatureState.Resolved || s2 == FeatureState.Resolved) {
            return FeatureState.Resolved;
        }
        return FeatureState.Installed;
    }

    private void computeBundlesToRefresh(Map<Bundle, String> toRefresh, Collection<Bundle> bundles, Map<Resource, Bundle> resources, Map<Resource, List<Wire>> resolution) {
        int size;
        HashMap newFragments = new HashMap();
        for (Bundle bundle : bundles) {
            newFragments.put(bundle, new HashSet());
        }
        if (resolution != null) {
            for (Resource res : resolution.keySet()) {
                for (Wire wire : resolution.get(res)) {
                    Bundle bundle;
                    if (!"osgi.wiring.host".equals(wire.getCapability().getNamespace()) || (bundle = wire.getProvider() instanceof BundleRevision ? ((BundleRevision)wire.getProvider()).getBundle() : resources.get(wire.getProvider())) == null) continue;
                    Bundle b = resources.get(wire.getRequirer());
                    Resource r = b != null ? (Resource)b.adapt(BundleRevision.class) : wire.getRequirer();
                    ((Set)newFragments.get(bundle)).add(r);
                }
            }
        }
        HashMap<Bundle, Resource> bndToRes = new HashMap<Bundle, Resource>();
        for (Map.Entry<Resource, Bundle> entry : resources.entrySet()) {
            bndToRes.put(entry.getValue(), entry.getKey());
        }
        block4: do {
            size = toRefresh.size();
            block5: for (Bundle bundle : bundles) {
                Object wire2;
                List<Wire> newWires;
                BundleWiring wiring;
                Resource resource = (Resource)bndToRes.get(bundle);
                if (resource == null) {
                    resource = (Resource)bundle.adapt(BundleRevision.class);
                }
                if (toRefresh.containsKey(bundle) || (wiring = (BundleWiring)bundle.adapt(BundleWiring.class)) == null) continue;
                List<Wire> list = newWires = resolution != null ? resolution.get(resource) : null;
                if (newWires == null) continue;
                HashSet<BundleRevision> oldFragments = new HashSet<BundleRevision>();
                for (Object wire2 : wiring.getProvidedWires(null)) {
                    if (!"osgi.wiring.host".equals(wire2.getCapability().getNamespace())) continue;
                    oldFragments.add(wire2.getRequirer());
                }
                if (!oldFragments.containsAll((Collection)newFragments.get(bundle))) {
                    toRefresh.put(bundle, "Attached fragments changed: " + new ArrayList((Collection)newFragments.get(bundle)));
                    continue block4;
                }
                HashSet<Resource> wiredBundles = new HashSet<Resource>();
                wire2 = wiring.getRequiredWires(null).iterator();
                while (wire2.hasNext()) {
                    BundleWire wire3 = (BundleWire)wire2.next();
                    BundleRevision rev = wire3.getProvider();
                    Bundle provider = rev.getBundle();
                    if (toRefresh.containsKey(provider)) {
                        toRefresh.put(bundle, "Wired to " + provider.getSymbolicName() + "/" + provider.getVersion() + " which is being refreshed");
                        continue block5;
                    }
                    Resource res = (Resource)bndToRes.get(provider);
                    wiredBundles.add((Resource)(res != null ? res : rev));
                }
                HashMap<Resource, Requirement> wiredResources = new HashMap<Resource, Requirement>();
                for (Wire wire4 : newWires) {
                    String effective;
                    String namespace = wire4.getRequirement().getNamespace();
                    if (!namespace.equals("osgi.wiring.bundle") && !namespace.equals("osgi.wiring.package") && !namespace.equals("osgi.wiring.host") || (effective = (String)wire4.getRequirement().getDirectives().get("effective")) != null && !"resolve".equals(effective) || !this.isBundle(wire4.getProvider()) || wiredResources.containsKey(wire4.getProvider())) continue;
                    wiredResources.put(wire4.getProvider(), wire4.getRequirement());
                }
                if (wiredBundles.containsAll(wiredResources.keySet())) continue;
                HashMap newResources = new HashMap(wiredResources);
                newResources.keySet().removeAll(wiredBundles);
                StringBuilder sb = new StringBuilder();
                sb.append("Should be wired to: ");
                boolean first = true;
                for (Map.Entry entry : newResources.entrySet()) {
                    if (!first) {
                        sb.append(", ");
                    } else {
                        first = false;
                    }
                    Resource res = (Resource)entry.getKey();
                    Requirement req = (Requirement)entry.getValue();
                    sb.append(ResolverUtil.getSymbolicName(res)).append("/").append(ResolverUtil.getVersion(res));
                    sb.append(" (through ");
                    sb.append(req);
                    sb.append(")");
                }
                toRefresh.put(bundle, sb.toString());
            }
        } while (toRefresh.size() > size);
    }

    private void print(String message, boolean verbose) {
        this.callback.print(message, verbose);
    }

    private void removeFragmentsAndBundlesInState(Collection<Bundle> bundles, int state) {
        Iterator<Bundle> iterator = bundles.iterator();
        while (iterator.hasNext()) {
            Bundle bundle = iterator.next();
            if ((bundle.getState() & state) == 0 && bundle.getHeaders().get("Fragment-Host") == null) continue;
            iterator.remove();
        }
    }

    private void removeBundlesInState(Collection<Bundle> bundles, int state) {
        Iterator<Bundle> iterator = bundles.iterator();
        while (iterator.hasNext()) {
            Bundle bundle = iterator.next();
            if ((bundle.getState() & state) == 0) continue;
            iterator.remove();
        }
    }

    protected void logWiring(Map<Resource, List<Wire>> wiring, boolean onlyFeatures) {
        this.print("Wiring:", true);
        HashMap wires = new HashMap();
        for (Resource r : wiring.keySet()) {
            if (onlyFeatures && !"karaf.feature".equals(ResourceUtils.getType(r))) continue;
            for (Wire w : wiring.get(r)) {
                if (onlyFeatures && !"karaf.feature".equals(ResourceUtils.getType(w.getProvider()))) continue;
                MapUtils.addToMapSet(wires, w.getRequirer(), w.getProvider());
            }
        }
        ArrayList sorted = new ArrayList(wires.keySet());
        Collections.sort(sorted, (r1, r2) -> ((Set)wires.get(r1)).size() - ((Set)wires.get(r2)).size());
        for (Resource r : sorted) {
            this.print("    " + ResolverUtil.getSymbolicName(r) + " / " + ResolverUtil.getVersion(r), true);
            for (Resource w : (Set)wires.get(r)) {
                this.print("        " + ResolverUtil.getSymbolicName(w) + " / " + ResolverUtil.getVersion(w), true);
            }
        }
    }

    protected void logDeployment(Deployment overallDeployment, boolean verbose) {
        if (overallDeployment.regions.isEmpty()) {
            this.print("No deployment change.", verbose);
            return;
        }
        this.print("Changes to perform:", verbose);
        for (Map.Entry<String, RegionDeployment> region : overallDeployment.regions.entrySet()) {
            RegionDeployment deployment = region.getValue();
            this.print("  Region: " + region.getKey(), verbose);
            if (!deployment.toDelete.isEmpty()) {
                this.print("    Bundles to uninstall:", verbose);
                for (Bundle bundle : deployment.toDelete) {
                    this.print("      " + bundle.getSymbolicName() + "/" + bundle.getVersion(), verbose);
                }
            }
            if (!deployment.toUpdate.isEmpty()) {
                this.print("    Bundles to update:", verbose);
                for (Map.Entry entry : deployment.toUpdate.entrySet()) {
                    this.print("      " + ((Bundle)entry.getKey()).getSymbolicName() + "/" + ((Bundle)entry.getKey()).getVersion() + " with " + ResourceUtils.getUri((Resource)entry.getValue()), verbose);
                }
            }
            if (deployment.toInstall.isEmpty()) continue;
            this.print("    Bundles to install:", verbose);
            for (Resource resource : deployment.toInstall) {
                this.print("      " + ResourceUtils.getUri(resource), verbose);
            }
        }
    }

    protected Deployment computeDeployment(DeploymentState dstate, DeploymentRequest request, SubsystemResolver resolver) throws IOException {
        Deployment result = new Deployment();
        Map<String, Set<Resource>> bundlesPerRegions = resolver.getBundlesPerRegions();
        HashSet<String> regions = new HashSet<String>();
        regions.addAll(dstate.state.managedBundles.keySet());
        regions.addAll(bundlesPerRegions.keySet());
        for (String region : regions) {
            Set<Resource> bundlesInRegion;
            RegionDeployment deployment = new RegionDeployment();
            Set<Long> managed = dstate.state.managedBundles.get(region);
            if (managed == null) {
                managed = Collections.emptySet();
            }
            ArrayList<Resource> toDeploy = (bundlesInRegion = bundlesPerRegions.get(region)) != null ? new ArrayList<Resource>(bundlesInRegion) : new ArrayList();
            Bundle systemBundle = dstate.bundles.get(0L);
            if (systemBundle != null) {
                toDeploy.remove(systemBundle.adapt(BundleRevision.class));
            }
            for (long bundleId : managed) {
                Bundle bundle = dstate.bundles.get(bundleId);
                if (bundle == null) continue;
                Resource resource = null;
                for (Resource res : toDeploy) {
                    if (!bundle.getSymbolicName().equals(ResolverUtil.getSymbolicName(res)) || !bundle.getVersion().equals((Object)ResolverUtil.getVersion(res))) continue;
                    resource = res;
                    break;
                }
                if (resource != null) {
                    if (this.isUpdateable(resource)) {
                        if ("always".equalsIgnoreCase(request.updateSnaphots)) {
                            LOGGER.debug("Update snapshot for " + bundle.getLocation());
                            deployment.toUpdate.put(bundle, resource);
                        } else if ("crc".equalsIgnoreCase(request.updateSnaphots)) {
                            long newCrc;
                            long oldCrc;
                            block42: {
                                if (dstate.state.bundleChecksums.containsKey(bundleId)) {
                                    oldCrc = dstate.state.bundleChecksums.get(bundleId);
                                } else {
                                    oldCrc = 0L;
                                    try {
                                        URL url = bundle.getEntry("META-INF/MANIFEST.MF");
                                        URLConnection con = url.openConnection();
                                        Method method = con.getClass().getDeclaredMethod("getLocalURL", new Class[0]);
                                        method.setAccessible(true);
                                        String jarUrl = ((URL)method.invoke((Object)con, new Object[0])).toExternalForm();
                                        if (!jarUrl.startsWith("jar:")) break block42;
                                        String jar = jarUrl.substring("jar:".length(), jarUrl.indexOf("!/"));
                                        jar = new URL(jar).getFile();
                                        try (FileInputStream is = new FileInputStream(jar);){
                                            oldCrc = ChecksumUtils.checksum(is);
                                        }
                                        result.bundleChecksums.put(bundleId, oldCrc);
                                    }
                                    catch (Throwable t) {
                                        LOGGER.debug("Error calculating checksum for bundle: %s", (Object)bundle, (Object)t);
                                    }
                                }
                            }
                            try (InputStream is = this.getBundleInputStream(resource, resolver.getProviders());){
                                newCrc = ChecksumUtils.checksum(is);
                                result.bundleChecksums.put(bundle.getBundleId(), newCrc);
                            }
                            if (newCrc != oldCrc) {
                                LOGGER.debug("New snapshot available for " + bundle.getLocation());
                                deployment.toUpdate.put(bundle, resource);
                            }
                        }
                    }
                    toDeploy.remove(resource);
                    result.resToBnd.put(resource, bundle);
                    continue;
                }
                if (!managed.contains(bundle.getBundleId())) continue;
                deployment.toDelete.add(bundle);
            }
            for (Resource resource : toDeploy) {
                TreeMap<Version, Bundle> matching = new TreeMap<Version, Bundle>();
                VersionRange range = new VersionRange(Macro.transform(request.bundleUpdateRange, ResolverUtil.getVersion(resource).toString()));
                for (Bundle bundle : deployment.toDelete) {
                    if (!bundle.getSymbolicName().equals(ResolverUtil.getSymbolicName(resource)) || !range.contains(bundle.getVersion())) continue;
                    matching.put(bundle.getVersion(), bundle);
                }
                if (!matching.isEmpty()) {
                    Bundle bundle = (Bundle)matching.lastEntry().getValue();
                    deployment.toUpdate.put(bundle, resource);
                    deployment.toDelete.remove(bundle);
                    result.resToBnd.put(resource, bundle);
                    continue;
                }
                deployment.toInstall.add(resource);
            }
            Collections.sort(deployment.toInstall, new ResourceComparator());
            if (deployment.toDelete.isEmpty() && deployment.toUpdate.isEmpty() && deployment.toInstall.isEmpty()) continue;
            result.regions.put(region, deployment);
        }
        return result;
    }

    protected <T> MapUtils.Function<Bundle, T> adapt(final Class<T> clazz) {
        return new MapUtils.Function<Bundle, T>(){

            @Override
            public T apply(Bundle bundle) {
                return bundle.adapt(clazz);
            }
        };
    }

    protected MapUtils.Function<Bundle, Long> bundleId() {
        return new MapUtils.Function<Bundle, Long>(){

            @Override
            public Long apply(Bundle bundle) {
                return bundle.getBundleId();
            }
        };
    }

    protected MapUtils.Function<Resource, String> featureId() {
        return new MapUtils.Function<Resource, String>(){

            @Override
            public String apply(Resource resource) {
                return ResourceUtils.getFeatureId(resource);
            }
        };
    }

    protected boolean isUpdateable(Resource resource) {
        String uri = ResourceUtils.getUri(resource);
        return uri.matches("mvn:.*SNAPSHOT|(?!mvn:).*");
    }

    protected List<Bundle> getBundlesToStart(Collection<Bundle> bundles, Bundle serviceBundle) {
        boolean restart = false;
        TreeMap bundlesPerStartLevel = new TreeMap();
        for (Object bundle : bundles) {
            if (bundle == serviceBundle) {
                restart = true;
                continue;
            }
            int n = ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
            MapUtils.addToMapSet(bundlesPerStartLevel, n, bundle);
        }
        bundles = bundlesPerStartLevel.isEmpty() ? Collections.emptyList() : (Collection<Object>)bundlesPerStartLevel.remove(bundlesPerStartLevel.firstKey());
        ArrayList<Object> revs = new ArrayList<Object>();
        for (Bundle bundle : bundles) {
            revs.add(bundle.adapt(BundleRevision.class));
        }
        ArrayList<Bundle> sorted = new ArrayList<Bundle>();
        for (BundleRevision rev : RequirementSort.sort(revs)) {
            sorted.add(rev.getBundle());
        }
        if (sorted.isEmpty() && restart) {
            sorted.add(serviceBundle);
        }
        return sorted;
    }

    protected List<Bundle> getBundlesToStop(Collection<Bundle> bundles) {
        TreeMap bundlesPerStartLevel = new TreeMap();
        for (Object bundle : bundles) {
            int sl = ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
            MapUtils.addToMapSet(bundlesPerStartLevel, sl, bundle);
        }
        bundles = (Collection)bundlesPerStartLevel.get(bundlesPerStartLevel.lastKey());
        ArrayList<Bundle> bundlesToDestroy = new ArrayList<Bundle>();
        for (Bundle bundle : bundles) {
            ServiceReference[] references = bundle.getRegisteredServices();
            int usage = 0;
            if (references != null) {
                for (ServiceReference reference : references) {
                    usage += Deployer.getServiceUsage(reference, bundles);
                }
            }
            LOGGER.debug("Usage for bundle {} is {}", (Object)bundle, (Object)usage);
            if (usage != 0) continue;
            bundlesToDestroy.add(bundle);
        }
        if (!bundlesToDestroy.isEmpty()) {
            Collections.sort(bundlesToDestroy, new Comparator<Bundle>(){

                @Override
                public int compare(Bundle b1, Bundle b2) {
                    return Long.compare(b2.getLastModified(), b1.getLastModified());
                }
            });
            LOGGER.debug("Selected bundles {} for destroy (no services in use)", bundlesToDestroy);
        } else {
            ServiceReference ref = null;
            for (Bundle bundle : bundles) {
                ServiceReference[] references;
                for (ServiceReference reference : references = bundle.getRegisteredServices()) {
                    if (Deployer.getServiceUsage(reference, bundles) == 0 || ref != null && reference.compareTo(ref) >= 0) continue;
                    LOGGER.debug("Currently selecting bundle {} for destroy (with reference {})", (Object)bundle, (Object)reference);
                    ref = reference;
                }
            }
            if (ref != null) {
                bundlesToDestroy.add(ref.getBundle());
            }
            LOGGER.debug("Selected bundle {} for destroy (lowest ranking service)", bundlesToDestroy);
        }
        return bundlesToDestroy;
    }

    private static int getServiceUsage(ServiceReference ref, Collection<Bundle> bundles) {
        Bundle[] usingBundles = ref.getUsingBundles();
        int nb = 0;
        if (usingBundles != null) {
            for (Bundle bundle : usingBundles) {
                if (!bundles.contains(bundle)) continue;
                ++nb;
            }
        }
        return nb;
    }

    protected InputStream getBundleInputStream(Resource resource, Map<String, StreamProvider> providers) throws IOException {
        String uri = ResourceUtils.getUri(resource);
        if (uri == null) {
            throw new IllegalStateException("Resource has no uri");
        }
        StreamProvider provider = providers.get(uri);
        if (provider == null) {
            return new URL(uri).openStream();
        }
        return provider.open();
    }

    public static void ensureAllClassesLoaded(Bundle bundle) throws ClassNotFoundException {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring != null) {
            for (String path : wiring.listResources("/", "*.class", 1)) {
                String className = path.substring(0, path.length() - ".class".length());
                className = className.replace('/', '.');
                bundle.loadClass(className);
            }
        }
    }

    static class RegionDeployment {
        List<Resource> toInstall = new ArrayList<Resource>();
        List<Bundle> toDelete = new ArrayList<Bundle>();
        Map<Bundle, Resource> toUpdate = new HashMap<Bundle, Resource>();

        RegionDeployment() {
        }
    }

    static class Deployment {
        Map<Long, Long> bundleChecksums = new HashMap<Long, Long>();
        Map<Resource, Bundle> resToBnd = new HashMap<Resource, Bundle>();
        Map<String, RegionDeployment> regions = new HashMap<String, RegionDeployment>();

        Deployment() {
        }
    }

    public static class DeploymentRequest {
        public Set<String> overrides;
        public String featureResolutionRange;
        public String serviceRequirements;
        public String bundleUpdateRange;
        public String updateSnaphots;
        public Repository globalRepository;
        public Map<String, Set<String>> requirements;
        public Map<String, Map<String, FeatureState>> stateChanges;
        public EnumSet<FeaturesService.Option> options;
        public String outputFile;
    }

    public static class DeploymentState {
        public State state;
        public Bundle serviceBundle;
        public int initialBundleStartLevel;
        public int currentStartLevel;
        public Map<Long, Bundle> bundles;
        public Map<String, Feature> features;
        public Map<String, Set<Long>> bundlesPerRegion;
        public Map<String, Map<String, Map<String, Set<String>>>> filtersPerRegion;
    }

    public static class PartialDeploymentException
    extends Exception {
        private final Set<String> missing;

        public PartialDeploymentException(Set<String> missing) {
            this.missing = missing;
        }

        public Set<String> getMissing() {
            return this.missing;
        }
    }

    public static class CircularPrerequisiteException
    extends Exception {
        private final Set<String> prereqs;

        public CircularPrerequisiteException(Set<String> prereqs) {
            super(prereqs.toString());
            this.prereqs = prereqs;
        }

        public Set<String> getPrereqs() {
            return this.prereqs;
        }
    }

    public static interface DeployCallback {
        public void print(String var1, boolean var2);

        public void saveState(State var1);

        public void persistResolveRequest(DeploymentRequest var1) throws IOException;

        public void installFeature(Feature var1) throws IOException, InvalidSyntaxException;

        public void callListeners(FeatureEvent var1);

        public Bundle installBundle(String var1, String var2, InputStream var3) throws BundleException;

        public void updateBundle(Bundle var1, String var2, InputStream var3) throws BundleException;

        public void uninstall(Bundle var1) throws BundleException;

        public void startBundle(Bundle var1) throws BundleException;

        public void stopBundle(Bundle var1, int var2) throws BundleException;

        public void setBundleStartLevel(Bundle var1, int var2);

        public void refreshPackages(Collection<Bundle> var1) throws InterruptedException;

        public void resolveBundles(Set<Bundle> var1, Map<Resource, List<Wire>> var2, Map<Resource, Bundle> var3);

        public void replaceDigraph(Map<String, Map<String, Map<String, Set<String>>>> var1, Map<String, Set<Long>> var2) throws BundleException, InvalidSyntaxException;
    }
}

