/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.testng.IReporter;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.log4testng.Logger;
import org.testng.reporters.util.StackTraceTools;
import org.testng.xml.XmlSuite;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailableReporter
implements IReporter {
    private static final Logger L = Logger.getLogger(class$org$testng$reporters$EmailableReporter == null ? (class$org$testng$reporters$EmailableReporter = EmailableReporter.class$("org.testng.reporters.EmailableReporter")) : class$org$testng$reporters$EmailableReporter);
    private PrintWriter m_out;
    private int m_row;
    private int m_methodIndex;
    private int m_rowTotal;
    static /* synthetic */ Class class$org$testng$reporters$EmailableReporter;

    @Override
    public void generateReport(List<XmlSuite> xml, List<ISuite> suites, String outdir) {
        try {
            this.m_out = new PrintWriter(new BufferedWriter(new FileWriter(new File(outdir, "emailable-report.html"))));
        }
        catch (IOException e) {
            L.error("output file", e);
            return;
        }
        this.startHtml(this.m_out);
        this.generateSuiteSummaryReport(suites);
        this.generateMethodSummaryReport(suites);
        this.generateMethodDetailReport(suites);
        this.endHtml(this.m_out);
        this.m_out.flush();
        this.m_out.close();
    }

    protected void generateMethodSummaryReport(List<ISuite> suites) {
        this.m_methodIndex = 0;
        this.m_out.println("<a id=\"summary\"></a>");
        this.startResultSummaryTable("passed");
        for (ISuite suite : suites) {
            if (suites.size() > 1) {
                this.titleRow(suite.getName(), 4);
            }
            Map<String, ISuiteResult> r = suite.getResults();
            for (ISuiteResult r2 : r.values()) {
                ITestContext test = r2.getTestContext();
                this.resultSummary(test.getFailedConfigurations(), test.getName(), "failed", " (configuration methods)");
                this.resultSummary(test.getFailedTests(), test.getName(), "failed", "");
                this.resultSummary(test.getSkippedConfigurations(), test.getName(), "skipped", " (configuration methods)");
                this.resultSummary(test.getSkippedTests(), test.getName(), "skipped", "");
                this.resultSummary(test.getPassedTests(), test.getName(), "passed", "");
            }
        }
        this.m_out.println("</table>");
    }

    protected void generateMethodDetailReport(List<ISuite> suites) {
        this.m_methodIndex = 0;
        for (ISuite suite : suites) {
            Map<String, ISuiteResult> r = suite.getResults();
            for (ISuiteResult r2 : r.values()) {
                if (r.values().size() > 0) {
                    this.m_out.println(new StringBuffer().append("<h1>").append(r2.getTestContext().getName()).append("</h1>").toString());
                }
                this.resultDetail(r2.getTestContext().getFailedConfigurations(), "failed");
                this.resultDetail(r2.getTestContext().getFailedTests(), "failed");
                this.resultDetail(r2.getTestContext().getSkippedConfigurations(), "skipped");
                this.resultDetail(r2.getTestContext().getSkippedTests(), "skipped");
                this.resultDetail(r2.getTestContext().getPassedTests(), "passed");
            }
        }
    }

    private void resultSummary(IResultMap tests, String testname, String style, String details) {
        if (tests.getAllResults().size() > 0) {
            StringBuffer buff = new StringBuffer();
            String lastc = "";
            int mq = 0;
            int cq = 0;
            for (ITestNGMethod method : this.getMethodSet(tests)) {
                ++this.m_row;
                ++this.m_methodIndex;
                String cname = method.getTestClass().getName();
                if (mq == 0) {
                    this.titleRow(new StringBuffer().append(testname).append(" &#8212; ").append(style).append(details).toString(), 4);
                }
                if (!cname.equalsIgnoreCase(lastc)) {
                    if (mq > 0) {
                        this.m_out.println(new StringBuffer().append("<tr class=\"").append(style).append(++cq % 2 == 0 ? "even" : "odd").append("\">").append("<td rowspan=\"").append(mq).append("\">").append(lastc).append((Object)buff).toString());
                    }
                    mq = 0;
                    buff.setLength(0);
                    lastc = cname;
                }
                Set<ITestResult> result_set = tests.getResults(method);
                long end = Long.MIN_VALUE;
                long start = Long.MAX_VALUE;
                for (ITestResult ans : tests.getResults(method)) {
                    if (ans.getEndMillis() > end) {
                        end = ans.getEndMillis();
                    }
                    if (ans.getStartMillis() >= start) continue;
                    start = ans.getStartMillis();
                }
                if (++mq > 1) {
                    buff.append(new StringBuffer().append("<tr class=\"").append(style).append(cq % 2 == 0 ? "odd" : "even").append("\">").toString());
                }
                buff.append(new StringBuffer().append("<td><a href=\"#m").append(this.m_methodIndex).append("\">").append(this.qualifiedName(method)).append("</a></td>").append("<td class=\"numi\">").append(result_set.size()).append("</td><td class=\"numi\">").append(end - start).append("</td></tr>").toString());
            }
            if (mq > 0) {
                this.m_out.println(new StringBuffer().append("<tr class=\"").append(style).append(++cq % 2 == 0 ? "even" : "odd").append("\">").append("<td rowspan=\"").append(mq).append("\">").append(lastc).append((Object)buff).toString());
            }
        }
    }

    private void startResultSummaryTable(String style) {
        this.tableStart(style);
        this.m_out.println("<tr><th>Class</th><th>Method</th><th># of<br/>Scenarios</th><th>Time<br/>(Msecs)</th></tr>");
        this.m_row = 0;
    }

    private String qualifiedName(ITestNGMethod method) {
        String addon = "";
        if (method.getGroups().length > 0 && !"basic".equalsIgnoreCase(method.getGroups()[0])) {
            addon = new StringBuffer().append(" (").append(method.getGroups()[0]).append(")").toString();
        }
        return new StringBuffer().append(method.getMethodName()).append(addon).toString();
    }

    private void resultDetail(IResultMap tests, String style) {
        if (tests.getAllResults().size() > 0) {
            int row = 0;
            for (ITestNGMethod method : this.getMethodSet(tests)) {
                ++row;
                ++this.m_methodIndex;
                String cname = method.getTestClass().getName();
                this.m_out.println(new StringBuffer().append("<a id=\"m").append(this.m_methodIndex).append("\"></a><h2>").append(cname).append(":").append(method.getMethodName()).append("</h2>").toString());
                int rq = 0;
                Set<ITestResult> resultSet = tests.getResults(method);
                for (ITestResult ans : resultSet) {
                    boolean hasThrowable;
                    List<String> msgs;
                    boolean hasParameters;
                    ++rq;
                    Object[] parameters = ans.getParameters();
                    boolean bl = hasParameters = parameters != null && parameters.length > 0;
                    if (hasParameters) {
                        if (rq == 1) {
                            this.tableStart("param");
                            this.m_out.print("<tr>");
                            for (int x = 1; x <= parameters.length; ++x) {
                                this.m_out.print(new StringBuffer().append("<th style=\"padding-left:1em;padding-right:1em\">Parameter #").append(x).append("</th>").toString());
                            }
                            this.m_out.println("</tr>");
                        }
                        this.m_out.print(new StringBuffer().append("<tr").append(rq % 2 == 0 ? " class=\"stripe\"" : "").append(">").toString());
                        for (Object p : parameters) {
                            this.m_out.println(new StringBuffer().append("<td style=\"padding-left:.5em;padding-right:2em\">").append(p != null ? p.toString() : "null").append("</td>").toString());
                        }
                        this.m_out.println("</tr>");
                    }
                    boolean hasReporterOutput = (msgs = Reporter.getOutput(ans)).size() > 0;
                    Throwable exception = ans.getThrowable();
                    boolean bl2 = hasThrowable = exception != null;
                    if (hasReporterOutput || hasThrowable) {
                        String indent = " style=\"padding-left:3em\"";
                        if (hasParameters) {
                            this.m_out.println(new StringBuffer().append("<tr").append(rq % 2 == 0 ? " class=\"stripe\"" : "").append("><td").append(indent).append(" colspan=\"").append(parameters.length).append("\">").toString());
                        } else {
                            this.m_out.println(new StringBuffer().append("<div").append(indent).append(">").toString());
                        }
                        if (hasReporterOutput) {
                            if (hasThrowable) {
                                this.m_out.println("<h3>Test Messages</h3>");
                            }
                            for (String line : msgs) {
                                this.m_out.println(new StringBuffer().append(line).append("<br/>").toString());
                            }
                        }
                        if (hasThrowable) {
                            boolean wantsMinimalOutput;
                            boolean bl3 = wantsMinimalOutput = ans.getStatus() == 1;
                            if (hasReporterOutput) {
                                this.m_out.println(new StringBuffer().append("<h3>").append(wantsMinimalOutput ? "Expected Exception" : "Failure").append("</h3>").toString());
                            }
                            this.generateExceptionReport(exception, method);
                        }
                        if (hasParameters) {
                            this.m_out.println("</td></tr>");
                        } else {
                            this.m_out.println("</div>");
                        }
                    }
                    if (!hasParameters || rq != resultSet.size()) continue;
                    this.m_out.println("</table>");
                }
                this.m_out.println("<p class=\"totop\"><a href=\"#summary\">back to summary</a></p>");
            }
        }
    }

    protected void generateExceptionReport(Throwable exception, ITestNGMethod method) {
        this.generateExceptionReport(exception, method, exception.getLocalizedMessage());
    }

    private void generateExceptionReport(Throwable exception, ITestNGMethod method, String title) {
        this.m_out.println(new StringBuffer().append("<p>").append(title).append("</p>").toString());
        StackTraceElement[] s1 = exception.getStackTrace();
        Throwable t2 = exception.getCause();
        if (t2 == exception) {
            t2 = null;
        }
        int maxlines = Math.min(100, StackTraceTools.getTestRoot(s1, method));
        for (int x = 0; x <= maxlines; ++x) {
            this.m_out.println(new StringBuffer().append(x > 0 ? "<br/>at " : "").append(s1[x].toString()).toString());
        }
        if (maxlines < s1.length) {
            this.m_out.println(new StringBuffer().append("<br/>").append(s1.length - maxlines).append(" lines not shown").toString());
        }
        if (t2 != null) {
            this.generateExceptionReport(t2, method, new StringBuffer().append("Caused by ").append(t2.getLocalizedMessage()).toString());
        }
    }

    private Collection<ITestNGMethod> getMethodSet(IResultMap tests) {
        TreeSet<ITestNGMethod> r = new TreeSet<ITestNGMethod>(new TestSorter());
        r.addAll(tests.getAllMethods());
        return r;
    }

    public void generateSuiteSummaryReport(List<ISuite> suites) {
        this.tableStart("param");
        this.m_out.print("<tr><th>Test</th>");
        this.tableColumnStart("Methods<br/>Passed");
        this.tableColumnStart("Scenarios<br/>Passed");
        this.tableColumnStart("# skipped");
        this.tableColumnStart("# failed");
        this.tableColumnStart("Total<br/>Time");
        this.tableColumnStart("Included<br/>Groups");
        this.tableColumnStart("Excluded<br/>Groups");
        this.m_out.println("</tr>");
        DecimalFormat formatter = new DecimalFormat("#,##0.0");
        int qty_tests = 0;
        int qty_pass_m = 0;
        int qty_pass_s = 0;
        int qty_skip = 0;
        int qty_fail = 0;
        long time_start = Long.MAX_VALUE;
        long time_end = Long.MIN_VALUE;
        for (ISuite suite : suites) {
            if (suites.size() > 1) {
                this.titleRow(suite.getName(), 7);
            }
            Map<String, ISuiteResult> tests = suite.getResults();
            for (ISuiteResult r : tests.values()) {
                ++qty_tests;
                ITestContext overview = r.getTestContext();
                this.startSummaryRow(overview.getName());
                int q = this.getMethodSet(overview.getPassedTests()).size();
                qty_pass_m += q;
                this.summaryCell(q, Integer.MAX_VALUE);
                q = overview.getPassedTests().size();
                qty_pass_s += q;
                this.summaryCell(q, Integer.MAX_VALUE);
                q = this.getMethodSet(overview.getSkippedTests()).size();
                qty_skip += q;
                this.summaryCell(q, 0);
                q = this.getMethodSet(overview.getFailedTests()).size();
                qty_fail += q;
                this.summaryCell(q, 0);
                time_start = Math.min(overview.getStartDate().getTime(), time_start);
                time_end = Math.max(overview.getEndDate().getTime(), time_end);
                this.summaryCell(new StringBuffer().append(formatter.format((double)(overview.getEndDate().getTime() - overview.getStartDate().getTime()) / 1000.0)).append(" seconds").toString(), true);
                this.summaryCell(overview.getIncludedGroups());
                this.summaryCell(overview.getExcludedGroups());
                this.m_out.println("</tr>");
            }
        }
        if (qty_tests > 1) {
            this.m_out.println("<tr class=\"total\"><td>Total</td>");
            this.summaryCell(qty_pass_m, Integer.MAX_VALUE);
            this.summaryCell(qty_pass_s, Integer.MAX_VALUE);
            this.summaryCell(qty_skip, 0);
            this.summaryCell(qty_fail, 0);
            this.summaryCell(new StringBuffer().append(formatter.format((double)(time_end - time_start) / 1000.0)).append(" seconds").toString(), true);
            this.m_out.println("<td colspan=\"2\">&nbsp;</td></tr>");
        }
        this.m_out.println("</table>");
    }

    private void summaryCell(String[] val) {
        StringBuffer b = new StringBuffer();
        for (String v : val) {
            b.append(new StringBuffer().append(v).append(" ").toString());
        }
        this.summaryCell(b.toString(), true);
    }

    private void summaryCell(String v, boolean isgood) {
        this.m_out.print(new StringBuffer().append("<td class=\"numi").append(isgood ? "" : "_attn").append("\">").append(v).append("</td>").toString());
    }

    private void startSummaryRow(String label) {
        ++this.m_row;
        this.m_out.print(new StringBuffer().append("<tr").append(this.m_row % 2 == 0 ? " class=\"stripe\"" : "").append("><td style=\"text-align:left;padding-right:2em\">").append(label).append("</td>").toString());
    }

    private void summaryCell(int v, int maxexpected) {
        this.summaryCell(String.valueOf(v), v <= maxexpected);
        this.m_rowTotal += v;
    }

    private void tableStart(String cssclass) {
        this.m_out.println(new StringBuffer().append("<table cellspacing=0 cellpadding=0").append(cssclass != null ? new StringBuffer().append(" class=\"").append(cssclass).append("\"").toString() : " style=\"padding-bottom:2em\"").append(">").toString());
        this.m_row = 0;
    }

    private void tableColumnStart(String label) {
        this.m_out.print(new StringBuffer().append("<th class=\"numi\">").append(label).append("</th>").toString());
    }

    private void titleRow(String label, int cq) {
        this.m_out.println(new StringBuffer().append("<tr><th colspan=\"").append(cq).append("\">").append(label).append("</th></tr>").toString());
        this.m_row = 0;
    }

    protected void writeStyle(String[] formats, String[] targets) {
    }

    protected void startHtml(PrintWriter out) {
        out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">");
        out.println("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        out.println("<head>");
        out.println("<title>TestNG:  Unit Test</title>");
        out.println("<style type=\"text/css\">");
        out.println("table caption,table.info_table,table.param,table.passed,table.failed {margin-bottom:10px;border:1px solid #000099;border-collapse:collapse;empty-cells:show;}");
        out.println("table.info_table td,table.info_table th,table.param td,table.param th,table.passed td,table.passed th,table.failed td,table.failed th {");
        out.println("border:1px solid #000099;padding:.25em .5em .25em .5em");
        out.println("}");
        out.println("table.param th {vertical-align:bottom}");
        out.println("td.numi,th.numi,td.numi_attn {");
        out.println("text-align:right");
        out.println("}");
        out.println("tr.total td {font-weight:bold}");
        out.println("table caption {");
        out.println("text-align:center;font-weight:bold;");
        out.println("}");
        out.println("table.passed tr.stripe td,table tr.passedodd td {background-color: #00AA00;}");
        out.println("table.passed td,table tr.passedeven td {background-color: #33FF33;}");
        out.println("table.passed tr.stripe td,table tr.skippedodd td {background-color: #cccccc;}");
        out.println("table.passed td,table tr.skippedodd td {background-color: #dddddd;}");
        out.println("table.failed tr.stripe td,table tr.failedodd td,table.param td.numi_attn {background-color: #FF3333;}");
        out.println("table.failed td,table tr.failedeven td,table.param tr.stripe td.numi_attn {background-color: #DD0000;}");
        out.println("tr.stripe td,tr.stripe th {background-color: #E6EBF9;}");
        out.println("p.totop {font-size:85%;text-align:center;border-bottom:2px black solid}");
        out.println("div.shootout {padding:2em;border:3px #4854A8 solid}");
        out.println("</style>");
        out.println("</head>");
        out.println("<body>");
    }

    protected void endHtml(PrintWriter out) {
        out.println("</body></html>");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestSorter<T extends ITestNGMethod>
    implements Comparator {
        private TestSorter() {
        }

        public int compare(Object o1, Object o2) {
            int r = ((ITestNGMethod)o1).getTestClass().getName().compareTo(((ITestNGMethod)o2).getTestClass().getName());
            if (r == 0) {
                r = ((ITestNGMethod)o1).getMethodName().compareTo(((ITestNGMethod)o2).getMethodName());
            }
            return r;
        }
    }
}

