/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import org.apache.manifoldcf.scriptengine.Command;
import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.ScriptParser;
import org.apache.manifoldcf.scriptengine.Token;
import org.apache.manifoldcf.scriptengine.TokenStream;
import org.apache.manifoldcf.scriptengine.Variable;
import org.apache.manifoldcf.scriptengine.VariableReference;

public class InsertCommand
implements Command {
    @Override
    public boolean parseAndExecute(ScriptParser sp, TokenStream currentStream) throws ScriptException {
        VariableReference objectRef = sp.evaluateExpression(currentStream);
        if (objectRef == null) {
            ScriptParser.syntaxError(currentStream, "Missing object expression");
        }
        Variable object = objectRef.resolve();
        Token t = currentStream.peek();
        if (t == null || t.getToken() == null || !t.getToken().equals("into")) {
            ScriptParser.syntaxError(currentStream, "Missing 'into'");
        }
        currentStream.skip();
        VariableReference targetRef = sp.evaluateExpression(currentStream);
        if (targetRef == null) {
            ScriptParser.syntaxError(currentStream, "Missing target expression");
        }
        Variable target = ScriptParser.resolveMustExist(currentStream, targetRef);
        t = currentStream.peek();
        if (t != null && t.getToken() != null && t.getToken().equals("at")) {
            currentStream.skip();
            VariableReference indexRef = sp.evaluateExpression(currentStream);
            if (indexRef == null) {
                ScriptParser.syntaxError(currentStream, "Missing expression after 'at'");
            }
            target.insertAt(object, indexRef.resolve());
        } else {
            target.insertAt(object, null);
        }
        return false;
    }

    @Override
    public void parseAndSkip(ScriptParser sp, TokenStream currentStream) throws ScriptException {
        Token t;
        if (!sp.skipExpression(currentStream)) {
            ScriptParser.syntaxError(currentStream, "Missing object expression");
        }
        if ((t = currentStream.peek()) == null || t.getToken() == null || !t.getToken().equals("into")) {
            ScriptParser.syntaxError(currentStream, "Missing 'into'");
        }
        currentStream.skip();
        if (!sp.skipExpression(currentStream)) {
            ScriptParser.syntaxError(currentStream, "Missing target expression");
        }
        if ((t = currentStream.peek()) != null && t.getToken() != null && t.getToken().equals("at")) {
            currentStream.skip();
            if (!sp.skipExpression(currentStream)) {
                ScriptParser.syntaxError(currentStream, "Missing expression after 'at'");
            }
        }
    }
}

