/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.servlet.common.exporter;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Predicate;
import io.prometheus.client.SampleNameFilter;
import io.prometheus.client.exporter.common.TextFormat;
import io.prometheus.client.servlet.common.adapter.HttpServletRequestAdapter;
import io.prometheus.client.servlet.common.adapter.HttpServletResponseAdapter;
import io.prometheus.client.servlet.common.adapter.ServletConfigAdapter;
import io.prometheus.client.servlet.common.exporter.ServletConfigurationException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Exporter {
    public static final String NAME_MUST_BE_EQUAL_TO = "name-must-be-equal-to";
    public static final String NAME_MUST_NOT_BE_EQUAL_TO = "name-must-not-be-equal-to";
    public static final String NAME_MUST_START_WITH = "name-must-start-with";
    public static final String NAME_MUST_NOT_START_WITH = "name-must-not-start-with";
    private CollectorRegistry registry;
    private Predicate<String> sampleNameFilter;

    public Exporter(CollectorRegistry registry, Predicate<String> sampleNameFilter) {
        this.registry = registry;
        this.sampleNameFilter = sampleNameFilter;
    }

    public void init(ServletConfigAdapter servletConfig) throws ServletConfigurationException {
        List allowedNames = SampleNameFilter.stringToList((String)servletConfig.getInitParameter(NAME_MUST_BE_EQUAL_TO));
        List excludedNames = SampleNameFilter.stringToList((String)servletConfig.getInitParameter(NAME_MUST_NOT_BE_EQUAL_TO));
        List allowedPrefixes = SampleNameFilter.stringToList((String)servletConfig.getInitParameter(NAME_MUST_START_WITH));
        List excludedPrefixes = SampleNameFilter.stringToList((String)servletConfig.getInitParameter(NAME_MUST_NOT_START_WITH));
        if (!(allowedPrefixes.isEmpty() && excludedPrefixes.isEmpty() && allowedNames.isEmpty() && excludedNames.isEmpty())) {
            SampleNameFilter filter = new SampleNameFilter.Builder().nameMustBeEqualTo((Collection)allowedNames).nameMustNotBeEqualTo((Collection)excludedNames).nameMustStartWith((Collection)allowedPrefixes).nameMustNotStartWith((Collection)excludedPrefixes).build();
            this.sampleNameFilter = this.sampleNameFilter != null ? filter.and(this.sampleNameFilter) : filter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequestAdapter req, HttpServletResponseAdapter resp) throws IOException {
        resp.setStatus(200);
        String contentType = TextFormat.chooseContentType((String)req.getHeader("Accept"));
        resp.setContentType(contentType);
        BufferedWriter writer = new BufferedWriter(resp.getWriter());
        try {
            Predicate filter = SampleNameFilter.restrictToNamesEqualTo(this.sampleNameFilter, this.parse(req));
            if (filter == null) {
                TextFormat.writeFormat((String)contentType, (Writer)writer, (Enumeration)this.registry.metricFamilySamples());
            } else {
                TextFormat.writeFormat((String)contentType, (Writer)writer, (Enumeration)this.registry.filteredMetricFamilySamples(filter));
            }
            ((Writer)writer).flush();
        }
        finally {
            ((Writer)writer).close();
        }
    }

    private Set<String> parse(HttpServletRequestAdapter req) {
        String[] includedParam = req.getParameterValues("name[]");
        if (includedParam == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(includedParam));
    }

    public void doPost(HttpServletRequestAdapter req, HttpServletResponseAdapter resp) throws IOException {
        this.doGet(req, resp);
    }
}

