/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="delay")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DelayDefinition
extends ExpressionNode
implements ExecutorServiceAwareDefinition<DelayDefinition> {
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true")
    private String asyncDelayed;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true")
    private String callerRunsWhenRejected;

    public DelayDefinition() {
    }

    public DelayDefinition(Expression delay) {
        super(delay);
    }

    public String getShortName() {
        return "delay";
    }

    @Override
    public String getLabel() {
        return "delay[" + this.getExpression() + "]";
    }

    public String toString() {
        return "Delay[" + this.getExpression() + " -> " + this.getOutputs() + "]";
    }

    public DelayDefinition delayTime(Long delay) {
        this.setExpression(ExpressionNodeHelper.toExpressionDefinition(ExpressionBuilder.constantExpression((Object)delay)));
        return this;
    }

    public DelayDefinition callerRunsWhenRejected(boolean callerRunsWhenRejected) {
        this.setCallerRunsWhenRejected(Boolean.toString(callerRunsWhenRejected));
        return this;
    }

    public DelayDefinition asyncDelayed() {
        this.setAsyncDelayed(Boolean.toString(true));
        return this;
    }

    public DelayDefinition syncDelayed() {
        this.setAsyncDelayed(Boolean.toString(false));
        return this;
    }

    @Override
    public DelayDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public DelayDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public String getAsyncDelayed() {
        return this.asyncDelayed;
    }

    public void setAsyncDelayed(String asyncDelayed) {
        this.asyncDelayed = asyncDelayed;
    }

    public String getCallerRunsWhenRejected() {
        return this.callerRunsWhenRejected;
    }

    public void setCallerRunsWhenRejected(String callerRunsWhenRejected) {
        this.callerRunsWhenRejected = callerRunsWhenRejected;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }
}

