/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.server.DelayedFetchMetrics$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.server.purgatory.DelayedOperation;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.FetchPartitionStatus;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetSnapshot;
import org.apache.kafka.storage.internals.log.LogReadResult;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001B\u0006\r\u0001EA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011!i\u0005A!A!\u0002\u0013q\u0005\"B2\u0001\t\u0003!\u0007\"B6\u0001\t\u0003b\u0007\"\u0002=\u0001\t\u0003J\b\"B?\u0001\t\u0003r\b\"B@\u0001\t\u0003r(\u0001\u0004#fY\u0006LX\r\u001a$fi\u000eD'BA\u0007\u000f\u0003\u0019\u0019XM\u001d<fe*\tq\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001\u0011b\u0004\u0005\u0002\u001495\tAC\u0003\u0002\u0016-\u0005I\u0001/\u001e:hCR|'/\u001f\u0006\u0003\u001b]Q!a\u0004\r\u000b\u0005eQ\u0012AB1qC\u000eDWMC\u0001\u001c\u0003\ry'oZ\u0005\u0003;Q\u0011\u0001\u0003R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u0005r\u0011!B;uS2\u001c\u0018BA\u0012!\u0005\u001daunZ4j]\u001e\fa\u0001]1sC6\u001c\bC\u0001\u0014,\u001b\u00059#B\u0001\u0015*\u0003\rawn\u001a\u0006\u0003UY\tqa\u001d;pe\u0006<W-\u0003\u0002-O\tYa)\u001a;dQB\u000b'/Y7t\u0003Q1W\r^2i!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;vgB!q\u0006\u000e\u001c=\u001b\u0005\u0001$BA\u00193\u0003\u0011)H/\u001b7\u000b\u0003M\nAA[1wC&\u0011Q\u0007\r\u0002\u000e\u0019&t7.\u001a3ICNDW*\u00199\u0011\u0005]RT\"\u0001\u001d\u000b\u0005e:\u0012AB2p[6|g.\u0003\u0002<q\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\t\u0003{\tk\u0011A\u0010\u0006\u0003Q}R!\u0001Q!\u0002\u0013%tG/\u001a:oC2\u001c(B\u0001\u0016\u0018\u0013\t\u0019eH\u0001\u000bGKR\u001c\u0007\u000eU1si&$\u0018n\u001c8Ti\u0006$Xo]\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\t1u)D\u0001\r\u0013\tAEB\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u000bE,x\u000e^1\u0011\u0005\u0019[\u0015B\u0001'\r\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000e\u0005\u0003P%R\u0003W\"\u0001)\u000b\u0003E\u000bQa]2bY\u0006L!a\u0015)\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA+Y56\taK\u0003\u0002X!\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005e3&aA*fcB!qj\u0017\u001c^\u0013\ta\u0006K\u0001\u0004UkBdWM\r\t\u0003MyK!aX\u0014\u0003%\u0019+Go\u00195QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\t\u0003\u001f\u0006L!A\u0019)\u0003\tUs\u0017\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u00154w\r[5k!\t1\u0005\u0001C\u0003%\r\u0001\u0007Q\u0005C\u0003.\r\u0001\u0007a\u0006C\u0003E\r\u0001\u0007Q\tC\u0003J\r\u0001\u0007!\nC\u0003N\r\u0001\u0007a*\u0001\u0005u_N#(/\u001b8h)\u0005i\u0007C\u00018v\u001d\ty7\u000f\u0005\u0002q!6\t\u0011O\u0003\u0002s!\u00051AH]8pizJ!\u0001\u001e)\u0002\rA\u0013X\rZ3g\u0013\t1xO\u0001\u0004TiJLgn\u001a\u0006\u0003iB\u000b1\u0002\u001e:z\u0007>l\u0007\u000f\\3uKR\t!\u0010\u0005\u0002Pw&\u0011A\u0010\u0015\u0002\b\u0005>|G.Z1o\u00031yg.\u0012=qSJ\fG/[8o)\u0005\u0001\u0017AC8o\u0007>l\u0007\u000f\\3uK\u0002")
public class DelayedFetch
extends DelayedOperation
implements Logging {
    private final FetchParams params;
    private final LinkedHashMap<TopicIdPartition, FetchPartitionStatus> fetchPartitionStatus;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String toString() {
        return "DelayedFetch(params=" + this.params + ", numPartitions=" + this.fetchPartitionStatus.size() + ")";
    }

    public boolean tryComplete() {
        boolean bl;
        Object object = new Object();
        try {
            IntRef accumulatedSize = IntRef.create((int)0);
            this.fetchPartitionStatus.forEach((topicIdPartition, fetchStatus) -> {
                LogOffsetMetadata fetchOffset = fetchStatus.startOffsetMetadata();
                Optional fetchLeaderEpoch = fetchStatus.fetchInfo().currentLeaderEpoch;
                try {
                    LogOffsetMetadata logOffsetMetadata = fetchOffset;
                    LogOffsetMetadata logOffsetMetadata2 = LogOffsetMetadata.UNKNOWN_OFFSET_METADATA;
                    if (logOffsetMetadata == null ? logOffsetMetadata2 != null : !logOffsetMetadata.equals(logOffsetMetadata2)) {
                        LogOffsetMetadata logOffsetMetadata3;
                        Partition partition = $this.replicaManager.getPartitionOrException(topicIdPartition.topicPartition());
                        LogOffsetSnapshot offsetSnapshot = partition.fetchOffsetSnapshot(fetchLeaderEpoch, $this.params.fetchOnlyLeader());
                        FetchIsolation fetchIsolation = $this.params.isolation;
                        if (FetchIsolation.LOG_END.equals(fetchIsolation)) {
                            logOffsetMetadata3 = offsetSnapshot.logEndOffset();
                        } else if (FetchIsolation.HIGH_WATERMARK.equals(fetchIsolation)) {
                            logOffsetMetadata3 = offsetSnapshot.highWatermark();
                        } else if (FetchIsolation.TXN_COMMITTED.equals(fetchIsolation)) {
                            logOffsetMetadata3 = offsetSnapshot.lastStableOffset();
                        } else {
                            throw new MatchError((Object)fetchIsolation);
                        }
                        LogOffsetMetadata endOffset = logOffsetMetadata3;
                        if (fetchOffset.messageOffset > endOffset.messageOffset) {
                            this.debug((Function0<String>)(Function0 & Serializable)() -> "Satisfying fetch " + this + " since it is fetching later segments of partition " + topicIdPartition + ".");
                            throw new NonLocalReturnControl.mcZ.sp(object, this.forceComplete());
                        }
                        if (fetchOffset.messageOffset < endOffset.messageOffset) {
                            if (fetchOffset.onOlderSegment(endOffset)) {
                                this.debug((Function0<String>)(Function0 & Serializable)() -> "Satisfying fetch " + this + " immediately since it is fetching older segments.");
                                if (!$this.params.isFromFollower() || !$this.replicaManager.shouldLeaderThrottle($this.quota, partition, $this.params.replicaId)) {
                                    throw new NonLocalReturnControl.mcZ.sp(object, this.forceComplete());
                                }
                            } else if (fetchOffset.onSameSegment(endOffset)) {
                                int bytesAvailable = package$.MODULE$.min(endOffset.positionDiff(fetchOffset), fetchStatus.fetchInfo().maxBytes);
                                if (!$this.params.isFromFollower() || !$this.replicaManager.shouldLeaderThrottle($this.quota, partition, $this.params.replicaId)) {
                                    accumulatedSize$1.elem += bytesAvailable;
                                }
                            }
                        }
                        fetchStatus.fetchInfo().lastFetchedEpoch.ifPresent(fetchEpoch -> {
                            OffsetForLeaderEpochResponseData.EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(fetchLeaderEpoch, Predef$.MODULE$.Integer2int(fetchEpoch), false);
                            if (epochEndOffset.errorCode() != Errors.NONE.code() || epochEndOffset.endOffset() == -1L || epochEndOffset.leaderEpoch() == -1) {
                                this.debug((Function0<String>)(Function0 & Serializable)() -> "Could not obtain last offset for leader epoch for partition " + topicIdPartition + ", epochEndOffset=" + epochEndOffset + ".");
                                throw new NonLocalReturnControl.mcZ.sp(object, this.forceComplete());
                            }
                            if (epochEndOffset.leaderEpoch() < Predef$.MODULE$.Integer2int(fetchEpoch) || epochEndOffset.endOffset() < fetchStatus$1.fetchInfo().fetchOffset) {
                                this.debug((Function0<String>)(Function0 & Serializable)() -> "Satisfying fetch " + this + " since it has diverging epoch requiring truncation for partition " + topicIdPartition + " epochEndOffset=" + epochEndOffset + " fetchEpoch=" + fetchEpoch + " fetchOffset=" + fetchStatus$1.fetchInfo().fetchOffset + ".");
                                throw new NonLocalReturnControl.mcZ.sp(object, this.forceComplete());
                            }
                        });
                    }
                }
                catch (NotLeaderOrFollowerException notLeaderOrFollowerException) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Broker is no longer the leader or follower of " + topicIdPartition + ", satisfy " + this + " immediately");
                    throw new NonLocalReturnControl.mcZ.sp(object, this.forceComplete());
                }
                catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Broker no longer knows of partition " + topicIdPartition + ", satisfy " + this + " immediately");
                    throw new NonLocalReturnControl.mcZ.sp(object, this.forceComplete());
                }
                catch (KafkaStorageException kafkaStorageException) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Partition " + topicIdPartition + " is in an offline log directory, satisfy " + this + " immediately");
                    throw new NonLocalReturnControl.mcZ.sp(object, this.forceComplete());
                }
                catch (FencedLeaderEpochException fencedLeaderEpochException) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Broker is the leader of partition " + topicIdPartition + ", but the requested epoch " + fetchLeaderEpoch + " is fenced by the latest leader epoch, satisfy " + this + " immediately");
                    throw new NonLocalReturnControl.mcZ.sp(object, this.forceComplete());
                }
            });
            if (accumulatedSize.elem < this.params.minBytes) {
                return false;
            }
            bl = this.forceComplete();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public void onExpiration() {
        if (this.params.isFromFollower()) {
            DelayedFetchMetrics$.MODULE$.followerExpiredRequestMeter().mark();
            return;
        }
        DelayedFetchMetrics$.MODULE$.consumerExpiredRequestMeter().mark();
    }

    public void onComplete() {
        Buffer fetchInfos = CollectionConverters$.MODULE$.MapHasAsScala(this.fetchPartitionStatus).asScala().iterator().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicIdPartition tp = (TopicIdPartition)x0$1._1();
                FetchPartitionStatus status = (FetchPartitionStatus)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)status.fetchInfo());
            }
            throw new MatchError(null);
        }).toBuffer();
        Seq fetchPartitionData = (Seq)this.replicaManager.readFromLog(this.params, (Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>>)fetchInfos, this.quota, true).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicIdPartition tp = (TopicIdPartition)x0$2._1();
                LogReadResult result = (LogReadResult)x0$2._2();
                boolean isReassignmentFetch = $this.params.isFromFollower() && $this.replicaManager.isAddingReplica(tp.topicPartition(), $this.params.replicaId);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)result.toFetchPartitionData(isReassignmentFetch));
            }
            throw new MatchError(null);
        });
        this.responseCallback.apply((Object)fetchPartitionData);
    }

    public DelayedFetch(FetchParams params, LinkedHashMap<TopicIdPartition, FetchPartitionStatus> fetchPartitionStatus, ReplicaManager replicaManager, ReplicaQuota quota, Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback) {
        this.params = params;
        this.fetchPartitionStatus = fetchPartitionStatus;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.responseCallback = responseCallback;
        super(params.maxWaitMs);
    }
}

