/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.image.node.TopicImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.PartitionRegistration;

public record TopicImage(String name, Uuid id, Map<Integer, PartitionRegistration> partitions) {
    public TopicImage {
        partitions = Collections.unmodifiableMap(partitions);
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        writer.write(0, new TopicRecord().setName(this.name).setTopicId(this.id));
        for (Map.Entry<Integer, PartitionRegistration> entry : this.partitions.entrySet()) {
            int partitionId = entry.getKey();
            PartitionRegistration partition = entry.getValue();
            writer.write(partition.toRecord(this.id, partitionId, options));
        }
    }

    @Override
    public String toString() {
        return new TopicImageNode(this).stringify();
    }
}

