/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Objects;

public class TimestampedKeyAndJoinSide<K> {
    private final K key;
    private final long timestamp;
    private final boolean leftSide;

    private TimestampedKeyAndJoinSide(boolean leftSide, K key, long timestamp) {
        this.key = Objects.requireNonNull(key, "key cannot be null");
        this.leftSide = leftSide;
        this.timestamp = timestamp;
    }

    public static <K> TimestampedKeyAndJoinSide<K> makeLeft(K key, long timestamp) {
        return new TimestampedKeyAndJoinSide<K>(true, key, timestamp);
    }

    public static <K> TimestampedKeyAndJoinSide<K> makeRight(K key, long timestamp) {
        return new TimestampedKeyAndJoinSide<K>(false, key, timestamp);
    }

    public boolean isLeftSide() {
        return this.leftSide;
    }

    public K getKey() {
        return this.key;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        String joinSide = this.leftSide ? "left" : "right";
        return "<" + joinSide + "," + this.key + ":" + this.timestamp + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimestampedKeyAndJoinSide that = (TimestampedKeyAndJoinSide)o;
        return this.leftSide == that.leftSide && Objects.equals(this.key, that.key) && this.timestamp == that.timestamp;
    }

    public int hashCode() {
        return Objects.hash(this.leftSide, this.key, this.timestamp);
    }
}

