/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import kafka.server.CachedPartition;
import kafka.server.FetchContext;
import kafka.server.FetchSession;
import kafka.server.IncrementalFetchContext$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Ew!B\u0011#\u0011\u00039c!B\u0015#\u0011\u0003Q\u0003\"B\u0019\u0002\t\u0003\u0011\u0004bB\u001a\u0002\u0005\u0004%I\u0001\u000e\u0005\u0007\u007f\u0005\u0001\u000b\u0011B\u001b\u0007\t%\u0012\u0003\u0001\u0011\u0005\t\t\u0016\u0011)\u0019!C\u0005\u000b\"A1+\u0002B\u0001B\u0003%a\t\u0003\u0005U\u000b\t\u0015\r\u0011\"\u0003V\u0011!aVA!A!\u0002\u00131\u0006\u0002C/\u0006\u0005\u000b\u0007I\u0011\u00020\t\u0011\t,!\u0011!Q\u0001\n}C\u0001bY\u0003\u0003\u0006\u0004%I\u0001\u001a\u0005\tY\u0016\u0011\t\u0011)A\u0005K\")\u0011'\u0002C\u0001[\"A1'\u0002EC\u0002\u0013\u0005C\u0007C\u0003t\u000b\u0011\u0005C\u000fC\u0004\u0002\u0004\u0015!\t%!\u0002\u0007\r\u0005\u0015R\u0001BA\u0014\u0011)\tyD\u0005BC\u0002\u0013\u0005\u0011\u0011\t\u0005\u000b\u0003\u0007\u0012\"\u0011!Q\u0001\n\u0005e\u0002BCA#%\t\u0015\r\u0011\"\u0001\u0002H!Q\u0011q\n\n\u0003\u0002\u0003\u0006I!!\u0013\t\rE\u0012B\u0011AA)\u0011-\tYF\u0005a\u0001\u0002\u0004%I!!\u0018\t\u0017\u0005%%\u00031AA\u0002\u0013%\u00111\u0012\u0005\f\u0003#\u0013\u0002\u0019!A!B\u0013\ty\u0006C\u0004\u0002\u0014J!\t%!&\t\u000f\u0005]%\u0003\"\u0011\u0002\u001a\"9\u00111\u0014\n\u0005B\u0005u\u0005bBAP\u000b\u0011\u0005\u0013\u0011\u0015\u0005\b\u0003{+A\u0011IA`\u0011\u001d\tI-\u0002C!\u0003\u0017\fq#\u00138de\u0016lWM\u001c;bY\u001a+Go\u00195D_:$X\r\u001f;\u000b\u0005\r\"\u0013AB:feZ,'OC\u0001&\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001K\u0001\u000e\u0003\t\u0012q#\u00138de\u0016lWM\u001c;bY\u001a+Go\u00195D_:$X\r\u001f;\u0014\u0005\u0005Y\u0003C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002O\u00051An\\4hKJ,\u0012!\u000e\t\u0003muj\u0011a\u000e\u0006\u0003qe\nAb]2bY\u0006dwnZ4j]\u001eT!AO\u001e\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001P\u0001\u0004G>l\u0017B\u0001 8\u0005\u0019aunZ4fe\u00069An\\4hKJ\u00043cA\u0003,\u0003B\u0011\u0001FQ\u0005\u0003\u0007\n\u0012ABR3uG\"\u001cuN\u001c;fqR\fA\u0001^5nKV\ta\t\u0005\u0002H#6\t\u0001J\u0003\u0002J\u0015\u0006)Q\u000f^5mg*\u00111\nT\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015j%B\u0001(P\u0003\u0019\t\u0007/Y2iK*\t\u0001+A\u0002pe\u001eL!A\u0015%\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\fe\u0016\fX*\u001a;bI\u0006$\u0018-F\u0001W!\t9&,D\u0001Y\u0015\tI&*\u0001\u0005sKF,Xm\u001d;t\u0013\tY\u0006LA\u0007GKR\u001c\u0007.T3uC\u0012\fG/Y\u0001\re\u0016\fX*\u001a;bI\u0006$\u0018\rI\u0001\bg\u0016\u001c8/[8o+\u0005y\u0006C\u0001\u0015a\u0013\t\t'E\u0001\u0007GKR\u001c\u0007nU3tg&|g.\u0001\u0005tKN\u001c\u0018n\u001c8!\u0003)!x\u000e]5d\u001d\u0006lWm]\u000b\u0002KB\u0011a-\u001b\b\u0003Q\u001dL!\u0001\u001b\u0012\u0002\u0019\u0019+Go\u00195TKN\u001c\u0018n\u001c8\n\u0005)\\'A\u0004+P!&\u001buLT!N\u000b~k\u0015\t\u0015\u0006\u0003Q\n\n1\u0002^8qS\u000et\u0015-\\3tAQ)an\u001c9reB\u0011\u0001&\u0002\u0005\u0006\t:\u0001\rA\u0012\u0005\u0006):\u0001\rA\u0016\u0005\u0006;:\u0001\ra\u0018\u0005\u0006G:\u0001\r!Z\u0001\u000fO\u0016$h)\u001a;dQ>3gm]3u)\t)8\u0010E\u0002-mbL!a^\u0017\u0003\r=\u0003H/[8o!\ta\u00130\u0003\u0002{[\t!Aj\u001c8h\u0011\u0015a\b\u00031\u0001~\u0003\t!\b\u000f\u0005\u0002\u007f\u007f6\t!*C\u0002\u0002\u0002)\u0013\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0002!\u0019|'/Z1dQB\u000b'\u000f^5uS>tG\u0003BA\u0004\u0003\u001b\u00012\u0001LA\u0005\u0013\r\tY!\f\u0002\u0005+:LG\u000fC\u0004\u0002\u0010E\u0001\r!!\u0005\u0002\u0007\u0019,h\u000e\u0005\u0005-\u0003'i\u0018qCA\u0004\u0013\r\t)\"\f\u0002\n\rVt7\r^5p]J\u0002B!!\u0007\u0002 9\u0019q+a\u0007\n\u0007\u0005u\u0001,\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0003\u0002\"\u0005\r\"!\u0004)beRLG/[8o\t\u0006$\u0018MC\u0002\u0002\u001ea\u0013\u0011\u0003U1si&$\u0018n\u001c8Ji\u0016\u0014\u0018\r^8s'\u0015\u0011\u0012\u0011FA\u001d!\u0011\tY#!\u000e\u000e\u0005\u00055\"\u0002BA\u0018\u0003c\tA\u0001\\1oO*\u0011\u00111G\u0001\u0005U\u00064\u0018-\u0003\u0003\u00028\u00055\"AB(cU\u0016\u001cG\u000fE\u0002g\u0003wI1!!\u0010l\u00055\u0011Vi\u0015)`\u001b\u0006\u0003v,\u0013+F%\u0006!\u0011\u000e^3s+\t\tI$A\u0003ji\u0016\u0014\b%A\u0013va\u0012\fG/\u001a$fi\u000eD7i\u001c8uKb$\u0018I\u001c3SK6|g/Z+og\u0016dWm\u0019;fIV\u0011\u0011\u0011\n\t\u0004Y\u0005-\u0013bAA'[\t9!i\\8mK\u0006t\u0017AJ;qI\u0006$XMR3uG\"\u001cuN\u001c;fqR\fe\u000e\u001a*f[>4X-\u00168tK2,7\r^3eAQ1\u00111KA,\u00033\u00022!!\u0016\u0013\u001b\u0005)\u0001bBA /\u0001\u0007\u0011\u0011\b\u0005\b\u0003\u000b:\u0002\u0019AA%\u0003-qW\r\u001f;FY\u0016lWM\u001c;\u0016\u0005\u0005}\u0003cBA1\u0003cj\u0018q\u000f\b\u0005\u0003G\nYG\u0004\u0003\u0002f\u0005\u001dTBAA\u0019\u0013\u0011\tI'!\r\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003[\ny'A\u0002NCBTA!!\u001b\u00022%!\u00111OA;\u0005\u0015)e\u000e\u001e:z\u0015\u0011\ti'a\u001c\u0011\t\u0005e\u0014Q\u0011\b\u0005\u0003w\n\t)\u0004\u0002\u0002~)\u0019\u0011q\u0010&\u0002\u000f5,7o]1hK&!\u00111QA?\u0003E1U\r^2i%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0003C\t9I\u0003\u0003\u0002\u0004\u0006u\u0014a\u00048fqR,E.Z7f]R|F%Z9\u0015\t\u0005\u001d\u0011Q\u0012\u0005\n\u0003\u001fK\u0012\u0011!a\u0001\u0003?\n1\u0001\u001f\u00132\u00031qW\r\u001f;FY\u0016lWM\u001c;!\u0003\u001dA\u0017m\u001d(fqR$\"!!\u0013\u0002\t9,\u0007\u0010\u001e\u000b\u0003\u0003?\naA]3n_Z,GCAA\u0004\u0003=9W\r\u001e*fgB|gn]3TSj,GCBAR\u0003S\u000b\u0019\fE\u0002-\u0003KK1!a*.\u0005\rIe\u000e\u001e\u0005\b\u0003Ws\u0002\u0019AAW\u0003\u001d)\b\u000fZ1uKN\u00042AZAX\u0013\r\t\tl\u001b\u0002\t%\u0016\u001b\u0006kX'B!\"9\u0011Q\u0017\u0010A\u0002\u0005]\u0016!\u0003<feNLwN\\%e!\ra\u0013\u0011X\u0005\u0004\u0003wk#!B*i_J$\u0018!H;qI\u0006$X-\u00118e\u000f\u0016tWM]1uKJ+7\u000f]8og\u0016$\u0015\r^1\u0015\t\u0005\u0005\u0017q\u0019\t\u0004/\u0006\r\u0017bAAc1\nia)\u001a;dQJ+7\u000f]8og\u0016Dq!a+ \u0001\u0004\ti+\u0001\u000bhKR$\u0006N]8ui2,GMU3ta>t7/\u001a\u000b\u0005\u0003\u0003\fi\rC\u0004\u0002P\u0002\u0002\r!a)\u0002\u001dQD'o\u001c;uY\u0016$\u0016.\\3Ng\u0002")
public class IncrementalFetchContext
implements FetchContext {
    private Logger logger;
    private final Time time;
    private final FetchMetadata reqMetadata;
    private final FetchSession kafka$server$IncrementalFetchContext$$session;
    private final Map<Uuid, String> topicNames;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String partitionsToLogString(Collection<TopicIdPartition> partitions) {
        return FetchContext.partitionsToLogString$(this, partitions);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private FetchMetadata reqMetadata() {
        return this.reqMetadata;
    }

    public FetchSession kafka$server$IncrementalFetchContext$$session() {
        return this.kafka$server$IncrementalFetchContext$$session;
    }

    private Map<Uuid, String> topicNames() {
        return this.topicNames;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = IncrementalFetchContext$.MODULE$.kafka$server$IncrementalFetchContext$$logger();
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public Option<Object> getFetchOffset(TopicIdPartition tp) {
        return this.kafka$server$IncrementalFetchContext$$session().getFetchOffset(tp);
    }

    @Override
    public void foreachPartition(Function2<TopicIdPartition, FetchRequest.PartitionData, BoxedUnit> fun) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            this.kafka$server$IncrementalFetchContext$$session().partitionMap().forEach(part -> {
                if (this.kafka$server$IncrementalFetchContext$$session().usesTopicIds()) {
                    part.maybeResolveUnknownName(this.topicNames());
                }
                fun.apply((Object)new TopicIdPartition(part.topicId(), new TopicPartition(part.topic(), part.partition())), (Object)part.reqData());
            });
            return;
        }
    }

    @Override
    public int getResponseSize(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates, short versionId) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.reqMetadata().epoch());
            int n = this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch ? FetchResponse.sizeOf((short)versionId, new LinkedHashMap().entrySet().iterator()) : FetchResponse.sizeOf((short)versionId, (Iterator)new PartitionIterator(this, updates.entrySet().iterator(), false));
            return n;
        }
    }

    @Override
    public FetchResponse updateAndGenerateResponseData(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            FetchResponse fetchResponse;
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.reqMetadata().epoch());
            if (this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Incremental fetch session ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" expected epoch ").append(expectedEpoch).append(", but ").append("got ").append(this.kafka$server$IncrementalFetchContext$$session().epoch()).append(".  Possible duplicate request.").toString());
                fetchResponse = FetchResponse.of((Errors)Errors.INVALID_FETCH_SESSION_EPOCH, (int)0, (int)this.kafka$server$IncrementalFetchContext$$session().id(), new LinkedHashMap());
            } else {
                PartitionIterator partitionIter = new PartitionIterator(this, updates.entrySet().iterator(), true);
                while (partitionIter.hasNext()) {
                    partitionIter.next();
                }
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Incremental fetch context with session id ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" returning ").append(this.partitionsToLogString(updates.keySet())).toString());
                fetchResponse = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)this.kafka$server$IncrementalFetchContext$$session().id(), updates);
            }
            FetchResponse fetchResponse2 = fetchResponse;
            return fetchResponse2;
        }
    }

    @Override
    public FetchResponse getThrottledResponse(int throttleTimeMs) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            FetchResponse fetchResponse;
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.reqMetadata().epoch());
            if (this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Incremental fetch session ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" expected epoch ").append(expectedEpoch).append(", but ").append("got ").append(this.kafka$server$IncrementalFetchContext$$session().epoch()).append(".  Possible duplicate request.").toString());
                fetchResponse = FetchResponse.of((Errors)Errors.INVALID_FETCH_SESSION_EPOCH, (int)throttleTimeMs, (int)this.kafka$server$IncrementalFetchContext$$session().id(), new LinkedHashMap());
            } else {
                fetchResponse = FetchResponse.of((Errors)Errors.NONE, (int)throttleTimeMs, (int)this.kafka$server$IncrementalFetchContext$$session().id(), new LinkedHashMap());
            }
            FetchResponse fetchResponse2 = fetchResponse;
            return fetchResponse2;
        }
    }

    public IncrementalFetchContext(Time time, FetchMetadata reqMetadata, FetchSession session, Map<Uuid, String> topicNames) {
        this.time = time;
        this.reqMetadata = reqMetadata;
        this.kafka$server$IncrementalFetchContext$$session = session;
        this.topicNames = topicNames;
        Logging.$init$(this);
        FetchContext.$init$(this);
    }

    private class PartitionIterator
    implements Iterator<Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> {
        private final Iterator<Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> iter;
        private final boolean updateFetchContextAndRemoveUnselected;
        private Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> nextElement;
        public final /* synthetic */ IncrementalFetchContext $outer;

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> x$1) {
            Iterator.super.forEachRemaining(x$1);
        }

        public Iterator<Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> iter() {
            return this.iter;
        }

        public boolean updateFetchContextAndRemoveUnselected() {
            return this.updateFetchContextAndRemoveUnselected;
        }

        private Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> nextElement() {
            return this.nextElement;
        }

        private void nextElement_$eq(Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> x$1) {
            this.nextElement = x$1;
        }

        @Override
        public boolean hasNext() {
            while (this.nextElement() == null && this.iter().hasNext()) {
                Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> element = this.iter().next();
                TopicIdPartition topicPart = element.getKey();
                FetchResponseData.PartitionData respData = element.getValue();
                CachedPartition cachedPart = (CachedPartition)this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().find((ImplicitLinkedHashCollection.Element)new CachedPartition(topicPart));
                if (cachedPart.maybeUpdateResponseData(respData, this.updateFetchContextAndRemoveUnselected())) {
                    this.nextElement_$eq(element);
                    if (!this.updateFetchContextAndRemoveUnselected() || FetchResponse.recordsSize((FetchResponseData.PartitionData)respData) <= 0) continue;
                    this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().remove((Object)cachedPart);
                    this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().mustAdd((ImplicitLinkedHashCollection.Element)cachedPart);
                    continue;
                }
                if (!this.updateFetchContextAndRemoveUnselected()) continue;
                this.iter().remove();
            }
            return this.nextElement() != null;
        }

        @Override
        public Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> element = this.nextElement();
            this.nextElement_$eq(null);
            return element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public /* synthetic */ IncrementalFetchContext kafka$server$IncrementalFetchContext$PartitionIterator$$$outer() {
            return this.$outer;
        }

        public PartitionIterator(IncrementalFetchContext $outer, Iterator<Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> iter, boolean updateFetchContextAndRemoveUnselected) {
            this.iter = iter;
            this.updateFetchContextAndRemoveUnselected = updateFetchContextAndRemoveUnselected;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

