/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.store;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.config.store.ConfigFileStoreBuilder;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.config.store.WatcherSensitivity;
import org.apache.juneau.internal.FileUtils;
import org.apache.juneau.internal.StringUtils;

@ConfigurableContext
public class ConfigFileStore
extends ConfigStore {
    static final String PREFIX = "ConfigFileStore";
    public static final String FILESTORE_directory = "ConfigFileStore.directory.s";
    public static final String FILESTORE_charset = "ConfigFileStore.charset.s";
    public static final String FILESTORE_useWatcher = "ConfigFileStore.useWatcher.s";
    public static final String FILESTORE_watcherSensitivity = "ConfigFileStore.watcherSensitivity.s";
    public static final String FILESTORE_updateOnWrite = "ConfigFileStore.updateOnWrite.b";
    public static final String FILESTORE_extensions = "ConfigFileStore.extensions.s";
    public static final ConfigFileStore DEFAULT = ConfigFileStore.create().build();
    private final File dir;
    private final Charset charset;
    private final WatcherThread watcher;
    private final boolean updateOnWrite;
    private final ConcurrentHashMap<String, String> cache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> nameCache = new ConcurrentHashMap();
    private final String[] extensions;

    public static ConfigFileStoreBuilder create() {
        return new ConfigFileStoreBuilder();
    }

    @Override
    public ConfigFileStoreBuilder builder() {
        return new ConfigFileStoreBuilder(this.getPropertyStore());
    }

    protected ConfigFileStore(PropertyStore ps) {
        super(ps);
        try {
            this.dir = new File(this.getStringProperty(FILESTORE_directory, ".")).getCanonicalFile();
            this.dir.mkdirs();
            this.charset = this.getProperty(FILESTORE_charset, Charset.class, Charset.defaultCharset());
            this.updateOnWrite = this.getBooleanProperty(FILESTORE_updateOnWrite, false);
            this.extensions = this.getCdlProperty(FILESTORE_extensions, "cfg");
            WatcherSensitivity ws = this.getProperty(FILESTORE_watcherSensitivity, WatcherSensitivity.class, WatcherSensitivity.MEDIUM);
            WatcherThread watcherThread = this.watcher = this.getBooleanProperty(FILESTORE_useWatcher, false) != false ? new WatcherThread(this.dir, ws) : null;
            if (this.watcher != null) {
                this.watcher.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized String read(String name) throws IOException {
        OpenOption[] openOptionArray;
        name = this.resolveName(name);
        Path p = this.resolveFile(name);
        String s = this.cache.get(name = p.getFileName().toString());
        if (s != null) {
            return s;
        }
        this.dir.mkdirs();
        if (!Files.exists(p, new LinkOption[0])) {
            return "";
        }
        boolean isWritable = this.isWritable(p);
        if (isWritable) {
            OpenOption[] openOptionArray2 = new OpenOption[3];
            openOptionArray2[0] = StandardOpenOption.READ;
            openOptionArray2[1] = StandardOpenOption.WRITE;
            openOptionArray = openOptionArray2;
            openOptionArray2[2] = StandardOpenOption.CREATE;
        } else {
            OpenOption[] openOptionArray3 = new OpenOption[1];
            openOptionArray = openOptionArray3;
            openOptionArray3[0] = StandardOpenOption.READ;
        }
        OpenOption[] oo = openOptionArray;
        try (FileChannel fc = FileChannel.open(p, oo);
             FileLock lock = isWritable ? fc.lock() : null;){
            ByteBuffer buf = ByteBuffer.allocate(1024);
            StringBuilder sb = new StringBuilder();
            while (fc.read(buf) != -1) {
                sb.append(this.charset.decode(buf.flip()));
                buf.clear();
            }
            s = sb.toString();
            this.cache.put(name, s);
        }
        return this.cache.get(name);
    }

    @Override
    public synchronized String write(String name, String expectedContents, String newContents) throws IOException {
        name = this.resolveName(name);
        if (StringUtils.isEquals(expectedContents, newContents)) {
            return null;
        }
        this.dir.mkdirs();
        Path p = this.resolveFile(name);
        name = p.getFileName().toString();
        boolean exists = Files.exists(p, new LinkOption[0]);
        if (!exists && StringUtils.isNotEmpty(expectedContents)) {
            return "";
        }
        if (this.isWritable(p)) {
            if (newContents == null) {
                Files.delete(p);
            } else {
                try (FileChannel fc = FileChannel.open(p, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                     FileLock lock = fc.lock();){
                    String currentContents = "";
                    if (exists) {
                        ByteBuffer buf = ByteBuffer.allocate(1024);
                        StringBuilder sb = new StringBuilder();
                        while (fc.read(buf) != -1) {
                            sb.append(this.charset.decode(buf.flip()));
                            buf.clear();
                        }
                        currentContents = sb.toString();
                    }
                    if (expectedContents != null && !StringUtils.isEquals(currentContents, expectedContents)) {
                        if (currentContents == null) {
                            this.cache.remove(name);
                        } else {
                            this.cache.put(name, currentContents);
                        }
                        String string = currentContents;
                        return string;
                    }
                    fc.position(0L);
                    fc.write(this.charset.encode(newContents));
                }
            }
        }
        if (this.updateOnWrite) {
            this.update(name, newContents);
        } else {
            this.cache.remove(name);
        }
        return null;
    }

    @Override
    public synchronized boolean exists(String name) {
        return Files.exists(this.resolveFile(name), new LinkOption[0]);
    }

    private Path resolveFile(String name) {
        return this.dir.toPath().resolve(this.resolveName(name));
    }

    @Override
    protected String resolveName(String name) {
        if (!this.nameCache.containsKey(name)) {
            String n = null;
            if (FileUtils.exists(this.dir, name)) {
                n = name;
            }
            if (n == null) {
                for (String ext : this.extensions) {
                    if (!FileUtils.hasExtension(name, ext)) continue;
                    n = name;
                    break;
                }
            }
            if (n == null) {
                for (String ext : this.extensions) {
                    if (!FileUtils.exists(this.dir, name + '.' + ext)) continue;
                    n = name + '.' + ext;
                    break;
                }
            }
            if (n == null) {
                n = this.extensions.length == 0 ? name : name + "." + this.extensions[0];
            }
            this.nameCache.put(name, n);
        }
        return this.nameCache.get(name);
    }

    private synchronized boolean isWritable(Path p) {
        try {
            if (!Files.exists(p, new LinkOption[0])) {
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                if (!Files.exists(p, new LinkOption[0])) {
                    p.toFile().createNewFile();
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        return Files.isWritable(p);
    }

    @Override
    public synchronized ConfigFileStore update(String name, String newContents) {
        this.cache.put(name, newContents);
        super.update(name, newContents);
        return this;
    }

    @Override
    public synchronized void close() {
        if (this.watcher != null) {
            this.watcher.interrupt();
        }
    }

    protected synchronized void onFileEvent(WatchEvent<Path> e) throws IOException {
        String fn = e.context().getFileName().toString();
        String oldContents = this.cache.get(fn);
        this.cache.remove(fn);
        String newContents = this.read(fn);
        if (!StringUtils.isEquals(oldContents, newContents)) {
            this.update(fn, newContents);
        }
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap().append("charset", this.charset).append("extensions", this.extensions).append("updateOnWrite", this.updateOnWrite));
    }

    final class WatcherThread
    extends Thread {
        private final WatchService watchService = FileSystems.getDefault().newWatchService();

        WatcherThread(File dir, WatcherSensitivity s) throws Exception {
            WatchEvent.Kind[] kinds = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
            WatchEvent.Modifier modifier = this.lookupModifier(s);
            dir.toPath().register(this.watchService, kinds, modifier);
        }

        private WatchEvent.Modifier lookupModifier(WatcherSensitivity s) {
            try {
                switch (s) {
                    case LOW: {
                        return SensitivityWatchEventModifier.LOW;
                    }
                    case MEDIUM: {
                        return SensitivityWatchEventModifier.MEDIUM;
                    }
                    case HIGH: {
                        return SensitivityWatchEventModifier.HIGH;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void run() {
            try {
                WatchKey key;
                while ((key = this.watchService.take()) != null) {
                    for (WatchEvent<Path> watchEvent : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = watchEvent.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                        ConfigFileStore.this.onFileEvent(watchEvent);
                    }
                    if (key.reset()) continue;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        @Override
        public void interrupt() {
            try {
                this.watchService.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                super.interrupt();
            }
        }
    }
}

